/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.runner.worker;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.controlnode.framework.step.MRPMParallelExecuteStep;
import kd.mmc.mrp.controlnode.framework.step.MRPMRunEnd;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.exception.MRPManuStopException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.mq.rabbit.RabbitMQEnvProvider;
import kd.mmc.mrp.framework.runner.AbstractMRPRunner;
import kd.mmc.mrp.framework.runner.IMRPRunner;
import kd.mmc.mrp.framework.runner.MRPCalcManager;
import kd.mmc.mrp.framework.step.IMRPStep;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.utils.MRPCalcStateManager;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPRunner
implements Runnable {
    private AbstractMRPRunner runner;
    private IMRPEnvProvider ctx;
    private List<IMRPStep> steps;
    private static final Log logger = LogFactory.getLog(MRPRunner.class);
    private MRPCalcStateManager stateManager;

    public MRPRunner(IMRPEnvProvider ctx, List<IMRPStep> steps, AbstractMRPRunner runner) {
        this.ctx = ctx;
        this.steps = steps;
        this.runner = runner;
        MRPCalcStateManager.CallBack callback = this.createCallback();
        this.stateManager = new MRPCalcStateManager(ctx.getMRPContextId(), callback);
    }

    public MRPCalcStateManager getStateManager() {
        return this.stateManager;
    }

    private MRPCalcStateManager.CallBack createCallback() {
        return new MRPCalcStateManager.CallBack(){

            public void masterLost() {
            }

            public void masterTerminated() {
            }

            public void workerTerminated() {
                MRPRunner.this.doWorkerTerminated();
            }

            public void manuTerminated() {
                MRPRunner.this.doManuTerminated();
            }
        };
    }

    protected void doManuTerminated() {
        this.ctx.getMQManager().markManuTerminated();
    }

    protected void doWorkerTerminated() {
        this.ctx.getMQManager().markFailed(null, (Object)this.stateManager.getTerminatedException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int percent = 0;
        int i = 0;
        IMRPExecuteLogRecorder lr = this.ctx.createLogRecorder();
        try {
            this.stateManager.startMasterCheckThread();
            if (MRPUtil.isByMQ()) {
                this.runner.initMRPControllerMQ();
                try {
                    logger.warn(String.format("ctxid: %s, mrprunner-main-inst-mq-provider-info", this.ctx.getMRPContextId()));
                    new RabbitMQEnvProvider().clearUnRelatedQueues(((Integer)this.ctx.getCfgValue(EnvCfgItem.MQ_CLEAR_DAY_SPAN)).intValue(), true);
                    logger.warn(String.format("ctxid: %s, mrprunner-main-inst-clear-dead-mq-successed", this.ctx.getMRPContextId()));
                }
                catch (Throwable e) {
                    logger.error(String.format("ctxid: %s, mrprunner-main-inst-clear-dead-mq-failed", this.ctx.getMRPContextId()), e);
                }
            }
            MRPCalcManager.registRunner((String)this.ctx.getMRPContextId(), (IMRPRunner)this.runner);
            int n = new BigDecimal("100").divide(new BigDecimal(this.steps.size()), 0, RoundingMode.UP).intValue();
            if (n >= 100) {
                n = 90;
            }
            lr.initMRPRunLog();
            int stepSize = this.steps.size();
            Iterator<IMRPStep> iter = this.steps.iterator();
            while (iter.hasNext()) {
                MRPBizException exception;
                ++i;
                IMRPStep step = iter.next();
                if ((percent += n) > 100) {
                    percent = 100;
                }
                if (percent == 100 && i != stepSize && iter.hasNext()) {
                    percent = 99;
                }
                step.createStepLog(i, percent);
                this.ctx.testEnvStatus();
                step.execute();
                if (step instanceof MRPMParallelExecuteStep) {
                    int innerCount = ((MRPMParallelExecuteStep)step).getInnerStepCount() - 1;
                    stepSize = stepSize - i + innerCount;
                    i = innerCount;
                }
                if ((exception = (MRPBizException)ThreadCache.get((Object)"exception")) != null) {
                    ThreadCache.remove((Object)"exception");
                    throw exception;
                }
                iter.remove();
            }
        }
        catch (Throwable e) {
            logger.error("MRPRunner:", e);
            MRPExecuteStatus status = e instanceof MRPManuStopException ? MRPExecuteStatus.MANU_STOP : MRPExecuteStatus.ERROR_STOP;
            for (IMRPStep step : this.steps) {
                if (!(step instanceof MRPMParallelExecuteStep)) continue;
                i = ((MRPMParallelExecuteStep)step).getInnerStepCount() - 1;
                break;
            }
            MRPMRunEnd step = new MRPMRunEnd(this.ctx, e, status);
            if (percent > 100) {
                percent = 100;
            }
            try {
                step.createStepLog(i + 1, percent);
                step.execute();
            }
            catch (Throwable t) {
                logger.error("MRPRunner", t);
            }
        }
        finally {
            try {
                this.runner.releaseMutex();
            }
            catch (Throwable t) {
                logger.error("MRPRunner", t);
            }
            if (MRPUtil.isByMQ()) {
                try {
                    this.ctx.getMQManager().destroyMRPControllerMQ(this.ctx.getMRPContextId());
                }
                catch (Throwable t) {
                    logger.error("MRPRunner", t);
                }
            }
            MRPCacheManager.clearCache((CalEnv)this.ctx);
            try {
                MRPCalcManager.destroyRunner((String)this.ctx.getMRPContextId());
            }
            catch (Throwable t) {
                logger.error("MRPRunner", t);
            }
            try {
                lr.saveStepLog(true);
            }
            catch (Throwable t) {
                logger.error("MRPRunner", t);
            }
            try {
                this.ctx.tearDown();
            }
            catch (Throwable t) {
                logger.error("MRPRunner", t);
            }
            this.onTerminated();
            boolean isDynamicGC = (Boolean)this.ctx.getCfgValue(EnvCfgItem.DYNAMIC_GC_ENABLED);
            if (isDynamicGC) {
                MRPCalcStateManager.doFullGC();
            }
        }
    }

    private void onTerminated() {
        try {
            this.stateManager.setMasterTerminated();
        }
        catch (Throwable t) {
            logger.error("MRPRunner", t);
        }
        this.stateManager.stopMasterWorker();
        MRPCacheManager.clearCache((CalEnv)this.ctx);
        String mrpContextId = this.ctx.getMRPContextId();
        IMRPEnvProvider ctx = MRPCalcManager.getContext((String)mrpContextId);
        if (ctx != null) {
            ctx.setShutdown();
            MRPCalcManager.removeContext((String)mrpContextId);
        }
        logger.info("MRPRunner (ctxId=" + mrpContextId + ") terminated");
    }
}

