/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.calcnode.framework.mq.resolver.cps.CPSWIPSupply2RequireResolver;
import kd.mmc.mrp.calcnode.framework.mq.resolver.query.MRPRequireDataQueryResolver;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.event.CPSWIPSupply2RequireEvent;
import kd.mmc.mrp.framework.mq.event.MRPDataFetchEvent4Require;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.KDCloudCPSEnv;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.utils.MRPUtil;

public class CPSWIPSupply2Require
extends AbstractMRPStep {
    public CPSWIPSupply2Require(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public String getStepDesc(Locale locale) {
        return Tips.getSupply2Require();
    }

    public void innerExecute() {
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        if (planModel.getWipSupply2Require().isEmpty()) {
            return;
        }
        IMRPEventManager manager = (IMRPEventManager)this.ctx.getService(IMRPEventManager.class);
        String json = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillSizeKey((String)this.ctx.getMRPContextId()));
        boolean isSelectBillPlan = json != null && Integer.parseInt(json) > 0;
        HashMap<String, Set<String>> eventIds = new HashMap<String, Set<String>>(16);
        Set collect = planModel.getEnabledSupplys().stream().map(Long::valueOf).collect(Collectors.toSet());
        DynamicObjectCollection dqs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name,number,billfieldtransfer.srcbill srcbill", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
        List<String> supplyBills = Arrays.asList("pom_mftorder", "om_mftorder", "mrp_planorder", "pm_om_purorderbill");
        for (DynamicObject obj : dqs) {
            if (!supplyBills.contains(obj.getString("srcbill"))) continue;
            String id = obj.getString("id");
            String eventid = MRPCacheManager.getInst().getData((CalEnv)this.ctx, id);
            List list = JSON.parseArray((String)MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSeparateKey((String)eventid, (String)id)), String.class);
            for (String materialID : list) {
                MRPEvent evt = this.createEvent(materialID, isSelectBillPlan, obj.getString("srcbill"));
                Set set = eventIds.computeIfAbsent(obj.getString("srcbill"), k -> new HashSet());
                set.add(evt.getEventId());
                manager.publishCalcEvent(evt);
            }
        }
        manager.wait4Response();
        int idx = 0;
        if (this.ctx.getCustomParams("cps_resourceregister_pom_mftstock") != null) {
            this.loadRequireData(isSelectBillPlan, eventIds, "orderentryid", "pom_mftorder", this.ctx.getCustomParams("cps_resourceregister_pom_mftstock"), idx);
            ++idx;
        }
        if (this.ctx.getCustomParams("cps_resourceregister_om_mftstock") != null) {
            this.loadRequireData(isSelectBillPlan, eventIds, "orderentryid", "om_mftorder", this.ctx.getCustomParams("cps_resourceregister_om_mftstock"), idx);
            ++idx;
        }
        if (this.ctx.getCustomParams("cps_resourceregister_mrp_planorder") != null) {
            this.loadRequireData(isSelectBillPlan, eventIds, "id", "mrp_planorder", this.ctx.getCustomParams("cps_resourceregister_mrp_planorder"), idx);
            ++idx;
        }
        if (this.ctx.getCustomParams("cps_resourceregister_om_componentlist") != null) {
            this.loadRequireData(isSelectBillPlan, eventIds, "orderentryid", "pm_om_purorderbill", this.ctx.getCustomParams("cps_resourceregister_om_componentlist"), idx);
            ++idx;
        }
    }

    private void loadRequireData(boolean isSelectBillPlan, Map<String, Set<String>> eventIds, String field, String parentEntity, String registerId, int idx) {
        HashSet<Long> parentIds = new HashSet<Long>(eventIds.size());
        if (isSelectBillPlan && "A".equals(((KDCloudCPSEnv)this.ctx).getCPSType())) {
            Map jsonStr = MRPCacheManager.getInst().getSubDataMap((CalEnv)this.ctx, "selectbills");
            for (String value : jsonStr.values()) {
                List list = JSON.parseArray((String)value, Object[].class);
                for (Object[] obj : list) {
                    Long billEntryId;
                    if ("mrp_planorder".equals(parentEntity)) {
                        billEntryId = (Long)MRPUtil.convert((Object)obj[0], (Object)0L);
                        parentIds.add(billEntryId);
                        continue;
                    }
                    billEntryId = (Long)MRPUtil.convert((Object)obj[1], (Object)0L);
                    parentIds.add(billEntryId);
                }
            }
        } else {
            Set orDefault = eventIds.getOrDefault(parentEntity, new HashSet());
            for (String eventId : orDefault) {
                String orderIds = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getCPSOrderEntryIds((String)eventId));
                if (orderIds == null) continue;
                List parseArray = JSON.parseArray((String)orderIds, Object.class);
                parentIds.addAll(parseArray);
            }
        }
        QFilter qf = new QFilter(field, "in", parentIds);
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        planModel.getEnabledRequires().add(registerId);
        DynamicObject dataSourceObj = QueryServiceHelper.queryOne((String)"mrp_resource_dataconfig", (String)"id,name,number,billfieldtransfer.srcbill srcbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(registerId))});
        String number = dataSourceObj.getString("number");
        String name = dataSourceObj.getString("name");
        String tip = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u3010%1$s(%2$s)\u3011\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u6570\u636e", (String)"CPSWIPSupply2Require_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), name == null ? "" : name, number);
        this.lr.createSubStepLog(idx, tip, this.lr.getLogIdx());
        this.lr.saveStepLog(false);
        MRPRequireDataQueryResolver resolver = new MRPRequireDataQueryResolver();
        MRPDataFetchEvent4Require event = new MRPDataFetchEvent4Require();
        String id = dataSourceObj.getString("id");
        event.setParam(MultiThreadCacheKey.KEY_MODEL_ID, (Serializable)((Object)id));
        event.setSubStepIdx(idx);
        event.setRecorder(this.ctx.createLogRecorder());
        event.setParam(MultiThreadCacheKey.KEY_RES_CUSTOM_FILTER, (Serializable)((Object)qf.toSerializedString()));
        resolver.execute((MRPEvent)event, this.ctx);
        String rc = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getQueryModelRowCountKey((String)id));
        String endTs = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getQueryModelTimeCostKey((String)id));
        this.lr.updateSubStepLog(idx, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u884c\u6570\uff1a%s", (String)"CPSWIPSupply2Require_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), rc == null ? Integer.valueOf(0) : rc));
        this.lr.updateSubStepLog(idx, "entryoperatmin", (Object)endTs);
        this.lr.updateSubStepLog(idx, "entryresult", (Object)MRPExecuteStatus.FINISHED.getAlias());
        this.lr.saveStepLog(false);
    }

    private MRPEvent createEvent(String materialID, boolean isSelectBillPlan, String entity) {
        CPSWIPSupply2RequireEvent ret = new CPSWIPSupply2RequireEvent();
        ret.setMrpContextId(this.ctx.getMRPContextId());
        ret.setParam(MultiThreadCacheKey.KEY_MATERIAL_ID, (Serializable)((Object)materialID));
        ret.setParam(MultiThreadCacheKey.KEY_CUSTOM_CLASS_NAME, (Serializable)((Object)CPSWIPSupply2RequireResolver.class.getName()));
        ret.setParam(MultiThreadCacheKey.KEY_IS_SELECT_MATERIAL_PLAN, (Serializable)Boolean.valueOf(isSelectBillPlan));
        ret.setParam(MultiThreadCacheKey.KEY_ENTITY_NUMBER, (Serializable)((Object)entity));
        return ret;
    }
}

