/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.utils.DataSourceUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;

public class MRPGetRequireConfigList
extends AbstractMRPStep {
    public MRPGetRequireConfigList(IMRPEnvProvider ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerExecute() {
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        Set collect = planModel.getEnabledRequires().stream().map(Long::valueOf).collect(Collectors.toSet());
        String jsonStr = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillMaterialKey((String)this.ctx.getMRPContextId()));
        HashSet mIds = null;
        if (jsonStr != null) {
            mIds = new HashSet(JSON.parseArray((String)jsonStr, String.class));
        }
        HashSet<String> configs = new HashSet<String>(16);
        for (Long id : collect) {
            FetchDataQueryModule dataQueryModule = DataSourceUtil.getQueryModuleByModel((Long)id, null);
            DynamicObject mrpDs = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"mrp_resource_dataconfig");
            CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
            DataSet dataSet = null;
            try {
                String srcMaterial;
                if (cacheDatas.isSelectMaterialPlan() && mIds != null && StringUtils.isNotEmpty((String)(srcMaterial = DataSourceUtil.getSrcMaterialField((DynamicObject)mrpDs, (String)DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH))))) {
                    QFilter[] qFilters = dataQueryModule.getqFilters();
                    QFilter[] newFilters = new QFilter[qFilters.length + 1];
                    System.arraycopy(qFilters, 0, newFilters, 1, qFilters.length);
                    newFilters[0] = new QFilter(srcMaterial, "in", (Object)MRPUtil.setStringParseLong(mIds));
                    dataQueryModule.setqFilters(newFilters);
                }
                dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)dataQueryModule.getMt(), (String)dataQueryModule.getOql(), (QFilter[])dataQueryModule.getqFilters(), null);
                if ((dataSet = DataSourceUtil.getDataSetByModel((FetchDataQueryModule)dataQueryModule, (DataSet)dataSet)).getRowMeta().getFieldIndex(DefaultField.RequireField.CONFIGUREDCODE.getName().toLowerCase(Locale.ENGLISH), false) < 0 || dataSet.getRowMeta().getFieldIndex(DefaultField.RequireField.PRODUCTIONORGUNIT.getName().toLowerCase(Locale.ENGLISH), false) < 0) continue;
                for (Row row : dataSet) {
                    Long config = row.getLong(DefaultField.RequireField.CONFIGUREDCODE.getName().toLowerCase(Locale.ENGLISH));
                    Long org = row.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName().toLowerCase(Locale.ENGLISH));
                    if (config <= 0L || org <= 0L) continue;
                    configs.add(config.toString() + '-' + org.toString());
                }
            }
            finally {
                if (dataSet == null) continue;
                dataSet.close();
            }
        }
        if (!configs.isEmpty()) {
            MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, MRPRuntimeConsts.getRequireConfigKey((String)this.ctx.getMRPContextId()), MRPRuntimeConsts.getDataKey(null, null, (String)""), JSON.toJSONString(configs));
        }
        this.dataAmount += configs.size();
    }

    public String getStepDesc(Locale locale) {
        return Tips.getRequireConfigList();
    }
}

