/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.utils.DataSourceUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;

public class MRPGetSelectBillRequireList
extends AbstractMRPStep {
    public MRPGetSelectBillRequireList(IMRPEnvProvider ctx) {
        super(ctx);
    }

    protected void innerExecute() {
        String json;
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        boolean isReserve = planModel.isReserve();
        if (!isReserve) {
            this.lr.updateStepLog("entrydetailmsg", (Object)ResManager.loadKDString((String)"\u672a\u542f\u7528\u9884\u7559\u8fdb\u884c\u9009\u5355\u8ba1\u7b97\uff0c\u8ba1\u7b97\u7ed3\u679c\u53ef\u80fd\u4e0d\u51c6\u786e\u3002", (String)"MRPGetSelectBillRequireList_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            this.lr.saveStepLog(false);
        }
        if ((json = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillSizeKey((String)this.ctx.getMRPContextId()))) != null) {
            this.dataAmount += Integer.parseInt(json);
        }
        json = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillMaterialKey((String)this.ctx.getMRPContextId()));
        HashSet<String> mIds = new HashSet<String>(0);
        if (json != null) {
            mIds = new HashSet(JSON.parseArray((String)json, String.class));
        }
        HashSet<String> configs = new HashSet<String>(16);
        Set collect = planModel.getEnabledRequires().stream().map(Long::valueOf).collect(Collectors.toSet());
        for (Map.Entry entry : MRPCacheManager.getInst().getSubDataMap((CalEnv)this.ctx, "selectbills").entrySet()) {
            String jsonStr = (String)entry.getValue();
            if (jsonStr == null) continue;
            List list = JSON.parseArray((String)jsonStr, Object[].class);
            for (Object[] value : list) {
                if (value.length <= 5) continue;
                Long config = (Long)MRPUtil.convert((Object)value[4], (Object)0L);
                Long org = (Long)MRPUtil.convert((Object)value[5], (Object)0L);
                if (config <= 0L || org <= 0L) continue;
                configs.add(config.toString() + '-' + org);
            }
        }
        if (!configs.isEmpty()) {
            MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, MRPRuntimeConsts.getRequireConfigKey((String)this.ctx.getMRPContextId()), MRPRuntimeConsts.getDataKey(null, null, (String)""), JSON.toJSONString(configs));
        }
        if (cacheDatas.isSelectBillPlan() && !mIds.isEmpty()) {
            HashSet<String> ids = new HashSet<String>(collect.size());
            ArrayList<FetchDataQueryModule> queryModules = new ArrayList<FetchDataQueryModule>(collect.size());
            for (Long modelId : collect) {
                DynamicObject mrpDs = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"mrp_resource_dataconfig");
                if (!DataSourceUtil.isDependRequire((DynamicObject)mrpDs)) continue;
                String srcMaterialField = DataSourceUtil.getSrcMaterialField((DynamicObject)mrpDs, (String)DefaultField.RequireField.PRODUCT.getName().toLowerCase(Locale.ENGLISH));
                String materialField = DataSourceUtil.getSrcMaterialField((DynamicObject)mrpDs, (String)DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH));
                if (!StringUtils.isNotEmpty((String)srcMaterialField) || !StringUtils.isNotEmpty((String)materialField)) continue;
                ids.add(modelId.toString());
                FetchDataQueryModule queryMD = DataSourceUtil.getQueryModuleByModel((Long)mrpDs.getLong("id"), null);
                String oql = String.format("(%s) AS %s, (%s) AS %s", materialField, DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH), srcMaterialField, DefaultField.RequireField.PRODUCT.getName().toLowerCase(Locale.ENGLISH));
                queryMD.setOql(oql);
                ArrayList values = new ArrayList(16);
                QFilter qFilter = new QFilter(srcMaterialField, "in", values);
                QFilter[] qFilters = queryMD.getqFilters();
                QFilter[] newFilters = new QFilter[qFilters.length + 1];
                System.arraycopy(qFilters, 0, newFilters, 1, qFilters.length);
                newFilters[0] = qFilter;
                queryMD.setqFilters(newFilters);
                queryModules.add(queryMD);
            }
            int cll = 0;
            Set parentIds = MRPUtil.setStringParseLong(mIds);
            HashMap<String, Set> p2childs = new HashMap<String, Set>(16);
            do {
                if (cll >= 99) {
                    throw new MRPBizException(Errors.getOverflowMaxLlc());
                }
                ++cll;
                HashSet queryParentIds = new HashSet(parentIds);
                parentIds.clear();
                for (FetchDataQueryModule queryMD : queryModules) {
                    List values = (List)queryMD.getqFilters()[0].getValue();
                    values.clear();
                    values.addAll(queryParentIds);
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null).groupBy(new String[]{DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH), DefaultField.RequireField.PRODUCT.getName().toLowerCase(Locale.ENGLISH)}).finish();
                    Throwable throwable = null;
                    try {
                        for (Row row : dataSet) {
                            Long child = (Long)MRPUtil.convert((Object)row.get(DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH)), (Object)0L);
                            Long product = (Long)MRPUtil.convert((Object)row.get(DefaultField.RequireField.PRODUCT.getName().toLowerCase(Locale.ENGLISH)), (Object)0L);
                            if (child > 0L && mIds.add(child.toString())) {
                                parentIds.add(child);
                            }
                            if (child <= 0L || product <= 0L) continue;
                            Set childs = p2childs.computeIfAbsent(product.toString(), k -> new HashSet(4));
                            childs.add(child.toString());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dataSet == null) continue;
                        if (throwable != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dataSet.close();
                    }
                }
            } while (!parentIds.isEmpty());
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getDependRequireLLCRelationKey((String)this.ctx.getMRPContextId()), JSON.toJSONString(p2childs));
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillMaterialKey((String)this.ctx.getMRPContextId()), JSON.toJSONString(mIds));
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getIsDependRequireDataSourceKey((String)this.ctx.getMRPContextId()), JSON.toJSONString(ids));
        }
    }

    public String getStepDesc(Locale locale) {
        return Tips.getSelectBillRequireList();
    }
}

