/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.mrp.business.helper.MessageServiceHelper;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;

public class MRPMAutoAuditPlanOrderDatas
extends AbstractMRPStep {
    private static final Log logger = LogFactory.getLog(MRPMAutoAuditPlanOrderDatas.class);
    IMRPExecuteLogRecorder log;

    public MRPMAutoAuditPlanOrderDatas(IMRPEnvProvider ctx) {
        super(ctx);
        this.log = this.ctx.createLogRecorder();
    }

    public String getStepDesc(Locale locale) {
        return Tips.getGenPlanorders();
    }

    protected void innerExecute() {
        DynamicObject caculatelog = this.ctx.getRunLog();
        String number = caculatelog.getString("number");
        logger.info("\u83b7\u53d6\u81ea\u52a8\u63d0\u4ea4\u5ba1\u6838\u8fd0\u7b97\u53f7\u7f16\u7801\uff1a" + number);
        Boolean isautoauditplanbill = (Boolean)this.ctx.getPlanDataByParam("isautoauditplanbill");
        logger.info("\u83b7\u53d6\u53c2\u6570\u8ba1\u5212\u65b9\u6848\u81ea\u52a8\u5ba1\u6838\u8ba1\u5212\u8ba2\u5355\uff1a" + isautoauditplanbill);
        String auditordertype = (String)this.ctx.getPlanDataByParam("auditordertype");
        logger.info("\u83b7\u53d6\u53c2\u6570\u8ba1\u5212\u65b9\u6848\u8ba2\u5355\u7c7b\u578b\uff1a" + auditordertype);
        String dropOrderType = (String)this.ctx.getPlanDataByParam("dropordertype");
        logger.info("\u83b7\u53d6\u53c2\u6570\u8ba1\u5212\u65b9\u6848\u81ea\u52a8\u6295\u653e\u8ba2\u5355\u7c7b\u578b\uff1a{}", (Object)dropOrderType);
        boolean sendDropFailMsg = (Boolean)this.ctx.getPlanDataByParam("senddropfailmsg");
        logger.info("\u83b7\u53d6\u53c2\u6570\u8ba1\u5212\u65b9\u6848\u6295\u653e\u5931\u8d25\u53d1\u9001\u901a\u77e5\uff1a{}", (Object)sendDropFailMsg);
        HashSet<Long> sendMsgProgramIdSet = new HashSet<Long>(16);
        if (sendDropFailMsg) {
            Long planProgramId = (Long)this.ctx.getPlanDataByParam("id");
            sendMsgProgramIdSet.add(planProgramId);
        }
        Boolean isautoacollaborativebill = (Boolean)this.ctx.getPlanDataByParam("isautoacollaborativebill");
        logger.info("\u83b7\u53d6\u53c2\u6570\u8ba1\u5212\u65b9\u6848\u81ea\u52a8\u5ba1\u6838\u534f\u540c\u8ba1\u5212\u5355\uff1a" + isautoacollaborativebill);
        Integer droptimerange = (Integer)this.ctx.getPlanDataByParam("droptimerange");
        logger.info("\u83b7\u53d6\u53c2\u6570\u8ba1\u5212\u65b9\u6848\u6295\u653e\u65f6\u95f4\u8303\u56f4\uff1a" + droptimerange);
        Integer dropbatchcount = (Integer)this.ctx.getPlanDataByParam("dropbatchcount");
        if (dropbatchcount == null || dropbatchcount == 0) {
            dropbatchcount = 1000;
        }
        logger.info("\u83b7\u53d6\u53c2\u6570\u8ba1\u5212\u65b9\u6848\u6295\u653e\u5206\u6279\u53c2\u6570\uff1a" + dropbatchcount);
        Boolean isautodropplanbill = (Boolean)this.ctx.getPlanDataByParam("isautodropplanbill");
        logger.info("\u83b7\u53d6\u53c2\u6570\u8ba1\u5212\u65b9\u6848\u81ea\u52a8\u6295\u653e\uff1a" + isautodropplanbill);
        this.dataAmount += this.dealAutoAuditPlanOrders(isautoauditplanbill, isautodropplanbill, droptimerange, number, auditordertype, dropOrderType, sendMsgProgramIdSet, dropbatchcount);
        if (!isautoacollaborativebill.booleanValue()) {
            return;
        }
        this.dataAmount += this.dealAutoAuditCollaborativeBill(isautoacollaborativebill, number, auditordertype, dropbatchcount);
    }

    private int dealAutoAuditCollaborativeBill(Boolean isautoacollaborativebill, String number, String auditordertype, Integer dropbatchcount) {
        HashSet<Long> dataIds;
        if (!isautoacollaborativebill.booleanValue()) {
            return 0;
        }
        int successCount = 0;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"mrp_collaborativeorder");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)MRPMAutoAuditPlanOrderDatas.class.getName(), (String)"mrp_collaborativeorder", (String)"id", (QFilter[])new QFilter[]{new QFilter("planoperatenum", "=", (Object)number)}, null);){
            dataIds = new HashSet<Long>(1000);
            while (ds.hasNext()) {
                Row next = ds.next();
                dataIds.add(next.getLong("id"));
                if (dataIds.size() < dropbatchcount) continue;
                successCount += this.dealCollaborativeBill(dataIds, dataEntityType, isautoacollaborativebill);
                dataIds.clear();
            }
            if (dataIds.isEmpty()) {
                int n = successCount;
                return n;
            }
        }
        return successCount += this.dealCollaborativeBill(dataIds, dataEntityType, isautoacollaborativebill);
    }

    private int dealCollaborativeBill(Set<Long> dataIds, MainEntityType dataEntityType, Boolean isautoacollaborativebill) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Object[0]), (DynamicObjectType)dataEntityType)) {
            data.set("isautoaudit", (Object)isautoacollaborativebill);
        }
        OperateOption option = OperateOption.create();
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"submit", (String)"mrp_collaborativeorder", (DynamicObject[])datas, (OperateOption)option);
        int successCount = executeOperate.getSuccessPkIds().size();
        return successCount;
    }

    private int dealAutoAuditPlanOrders(Boolean isautoauditplanbill, Boolean isautodropplanbill, Integer droptimerange, String number, String auditordertype, String dropOrderType, Set<Long> sendMsgProgramIdSet, Integer dropbatchcount) {
        HashSet<Long> dataIds;
        if (!isautoauditplanbill.booleanValue()) {
            return 0;
        }
        int successCount = 0;
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(2);
        QFilter qf = this.getauditordertypeQfilter(auditordertype);
        if (qf != null) {
            qfs.add(qf);
        }
        qfs.add(new QFilter("planoperatenum", "=", (Object)number));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"mrp_planorder");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)MRPMAutoAuditPlanOrderDatas.class.getName(), (String)"mrp_planorder", (String)"id", (QFilter[])qfs.toArray(new QFilter[0]), null);){
            dataIds = new HashSet<Long>(dropbatchcount);
            while (ds.hasNext()) {
                Row next = ds.next();
                dataIds.add(next.getLong("id"));
                if (dataIds.size() < dropbatchcount) continue;
                successCount += this.dealData(dataIds, isautoauditplanbill, isautodropplanbill, droptimerange, dropOrderType, dropbatchcount, dataEntityType, sendMsgProgramIdSet);
                dataIds.clear();
            }
            if (dataIds.isEmpty()) {
                int n = successCount;
                return n;
            }
        }
        return successCount += this.dealData(dataIds, isautoauditplanbill, isautodropplanbill, droptimerange, dropOrderType, dropbatchcount, dataEntityType, sendMsgProgramIdSet);
    }

    private QFilter getauditordertypeQfilter(String auditordertypeGroup) {
        QFilter qf = null;
        if (StringUtils.isBlank((CharSequence)auditordertypeGroup)) {
            return qf;
        }
        String[] auditordertypes = auditordertypeGroup.split(",");
        if (auditordertypes == null || auditordertypes.length == 0) {
            return qf;
        }
        HashSet<String> auditordertypeSet = new HashSet<String>(16);
        for (String auditordertypStr : auditordertypes) {
            if (StringUtils.isBlank((CharSequence)auditordertypStr)) continue;
            auditordertypeSet.add(auditordertypStr);
        }
        if (!auditordertypeSet.isEmpty()) {
            qf = new QFilter("ordertype", "in", auditordertypeSet);
        }
        return qf;
    }

    private int dealData(Set<Long> dataIds, Boolean isautoauditplanbill, Boolean isautodropplanbill, Integer droptimerange, String dropOrderType, Integer dropbatchcount, MainEntityType dataEntityType, Set<Long> sendMsgProgramIdSet) {
        DynamicObject[] datas;
        int successCount = 0;
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(dropbatchcount);
        for (DynamicObject data : datas = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Object[0]), (DynamicObjectType)dataEntityType)) {
            if (!isautoauditplanbill.booleanValue()) continue;
            data.set("isautoaudit", (Object)isautoauditplanbill);
            this.dealAutoaDropPlanOrders(isautodropplanbill, droptimerange, data, isautoauditplanbill, dropOrderType);
            updates.add(data);
        }
        OperationResult executeOperatePlanOrder = this.executeOperatePlanOrder(updates, sendMsgProgramIdSet);
        if (executeOperatePlanOrder != null) {
            successCount = executeOperatePlanOrder.getSuccessPkIds().size();
        }
        return successCount;
    }

    private OperationResult executeOperatePlanOrder(List<DynamicObject> updates, Set<Long> sendMsgProgramIdSet) {
        OperateOption option = OperateOption.create();
        OperationResult executeOperate = null;
        try {
            executeOperate = OperationServiceHelper.executeOperate((String)"submit", (String)"mrp_planorder", (DynamicObject[])updates.toArray(new DynamicObject[0]), (OperateOption)option);
        }
        catch (Exception ex) {
            logger.error("\u8ba1\u5212\u8ba2\u5355\u81ea\u52a8\u63d0\u4ea4\u62a5\u9519:", (Throwable)ex);
            String sign = "%s";
            String error = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u81ea\u52a8\u63d0\u4ea4\u62a5\u9519\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%1$s\u201d\u63d0\u4ea4\u7cfb\u7edf\u7e41\u5fd9\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a%2$s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MRPMAutoAuditPlanOrderDatas_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), sign, ex.getMessage());
            Map<Long, String> errorMessageMaps = this.getErrorMap(updates, error);
            this.failInfoUpdate(updates, errorMessageMaps, sendMsgProgramIdSet);
            this.log.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u81ea\u52a8\u63d0\u4ea4\u62a5\u9519:%s", (String)"MRPMAutoAuditPlanOrderDatas_4", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), ex.getMessage()));
            this.log.saveStepLog(false);
            return executeOperate;
        }
        List successPkIds = executeOperate.getSuccessPkIds();
        if (!executeOperate.isSuccess()) {
            List allErrors;
            HashMap errorMessageMaps = Maps.newHashMapWithExpectedSize((int)executeOperate.getAllErrorOrValidateInfo().size());
            StringBuilder error = new StringBuilder();
            error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u81ea\u52a8\u63d0\u4ea4\u62a5\u9519\uff1a", (String)"MRPMAutoAuditPlanOrderDatas_5", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\uff1a%s\u3002", (String)"MRPMAutoAuditPlanOrderDatas_6", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)executeOperate.getMessage())) {
                error.append(executeOperate.getMessage());
            }
            if ((allErrors = executeOperate.getAllErrorOrValidateInfo()) == null || allErrors.size() == 0) {
                Map<Long, String> errorMaps = this.getErrorMap(updates, error.toString());
                this.failInfoUpdate(updates, errorMaps, sendMsgProgramIdSet);
            } else {
                for (IOperateInfo info : allErrors) {
                    Object pkValue = info.getPkValue();
                    if (pkValue == null || successPkIds.contains(pkValue)) continue;
                    Long planorderId = Long.valueOf(pkValue.toString());
                    StringBuilder infoerror = new StringBuilder();
                    String errorMessage = (String)errorMessageMaps.get(planorderId);
                    if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        errorMessageMaps.put(planorderId, infoerror.append(errorMessage).append(info.getMessage()).append("\n\r").toString());
                        continue;
                    }
                    errorMessageMaps.put(planorderId, infoerror.append((CharSequence)error).append(info.getMessage()).append("\n\r").toString());
                }
                this.failInfoUpdate(updates, errorMessageMaps, sendMsgProgramIdSet);
            }
        }
        return executeOperate;
    }

    private Map<Long, String> getErrorMap(List<DynamicObject> updates, String error) {
        if (updates == null || updates.isEmpty()) {
            return new HashMap<Long, String>(16);
        }
        HashMap<Long, String> errorMap = new HashMap<Long, String>(updates.size());
        for (DynamicObject update : updates) {
            Long planorderId = update.getLong("id");
            errorMap.put(planorderId, error);
        }
        return errorMap;
    }

    private void failInfoUpdate(List<DynamicObject> updates, Map<Long, String> errorMap, Set<Long> sendMsgProgram) {
        HashMap<Long, DynamicObject> orgs = new HashMap<Long, DynamicObject>(updates.size());
        HashSet<Long> orgIds = new HashSet<Long>(updates.size());
        HashMap<Long, Map> dropLogMap = new HashMap<Long, Map>(updates.size());
        String planoperatenum = null;
        HashMap<Long, Set> orgNotifiers = new HashMap<Long, Set>(16);
        for (DynamicObject update : updates) {
            long planProgramId;
            Long planorderId = update.getLong("id");
            String errorStr = errorMap.get(planorderId);
            if (errorStr == null) continue;
            if (errorStr.split("%s").length == 2) {
                errorStr = String.format(errorStr, update.getString("billno"));
            }
            if (errorStr.length() > 450) {
                errorStr = errorStr.substring(0, 450);
            }
            Map dropLog = dropLogMap.computeIfAbsent(planorderId, k -> new HashMap());
            dropLog.put("billno", update.getString("billno"));
            dropLog.put("planorderid", planorderId);
            dropLog.put("PROP_SOUREORDER", update.getDataEntityType().getName());
            dropLog.put("schedule", errorStr);
            dropLog.put("failtype", "B");
            PlanOrderHelper.updateDropLogInfo((Map)dropLog, (DynamicObject)update);
            planoperatenum = update.getString("planoperatenum");
            DynamicObject proorpurorg = update.getDynamicObject("proorpurorg");
            DynamicObject planPerson = update.getDynamicObject("planpersonid");
            DynamicObject planProgram = update.getDynamicObject("planprogram");
            if (planoperatenum == null || proorpurorg == null || planPerson == null || planProgram == null || !sendMsgProgram.contains(planProgramId = planProgram.getLong("id"))) continue;
            long proOrPurOrgId = proorpurorg.getLong("id");
            orgIds.add(proOrPurOrgId);
            orgs.put(proOrPurOrgId, proorpurorg);
            Set notifiers = orgNotifiers.computeIfAbsent(proOrPurOrgId, v -> new HashSet(16));
            notifiers.add(planPerson.getLong("id"));
        }
        PlanOrderHelper.recordDropPlanorderLog(dropLogMap, (String)" ", (String)"A");
        MessageServiceHelper.sendMessage(planoperatenum, orgIds, orgNotifiers, orgs, (String)"A");
    }

    private void dealAutoaDropPlanOrders(Boolean isAutoDropPlanBill, Integer droptimerange, DynamicObject data, Boolean isautoauditplanbill, String dropOrderType) {
        data.set("isautoaudit", (Object)isautoauditplanbill);
        if (!isAutoDropPlanBill.booleanValue()) {
            return;
        }
        if (StringUtils.isBlank((Object)droptimerange)) {
            droptimerange = 0;
        }
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(5, droptimerange);
        Date newNow = cal.getTime();
        String ordertype = data.getString("ordertype");
        if (!dropOrderType.contains(ordertype)) {
            return;
        }
        Date orderdate = data.getDate("orderdate");
        if (orderdate == null) {
            return;
        }
        if (orderdate.compareTo(newNow) > 0) {
            return;
        }
        data.set("isautodrop", (Object)isAutoDropPlanBill);
    }
}

