/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.common.simulationplan.ABCOrgAndDetailEntity;
import kd.mmc.mrp.common.simulationplan.ABCTreeEntity;
import kd.mmc.mrp.common.simulationplan.SimulationEntity;
import kd.mmc.mrp.common.simulationplan.SimulationGroupEntity;
import kd.mmc.mrp.common.util.SerializableUtils;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.select.LeadType;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPMCalcLongestPath
extends AbstractMRPStep {
    boolean isFlexPropMatch;

    public MRPMCalcLongestPath(IMRPEnvProvider ctx) {
        super(ctx);
        this.isFlexPropMatch = (Boolean)this.ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
    }

    public String getStepDesc(Locale locale) {
        return Tips.getLongestPath();
    }

    protected void innerExecute() {
        if (this.ctx.getCustomParams("simulationbillid") != null) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.ctx.getCustomParams("simulationbillid"), (String)"mrp_simulation");
            HashMap<String, Set<Long>> replaceMap = new HashMap<String, Set<Long>>(16);
            HashMap<String, BigDecimal[]> qtyMap = new HashMap<String, BigDecimal[]>(16);
            this.getReplaceData(replaceMap, qtyMap);
            this.lr.createSubStepLog(0, ResManager.loadKDString((String)"\u8ba1\u7b97\u6a21\u62df\u8be6\u60c5\u6570\u636e", (String)"MRPMCalcLongestPath_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.stepIdx);
            this.calcSimulationDetail(obj, replaceMap);
            this.lr.saveStepLog(false);
            this.lr.createSubStepLog(1, ResManager.loadKDString((String)"\u8ba1\u7b97\u7269\u6599\u6c47\u603b\u8be6\u60c5\u6570\u636e", (String)"MRPMCalcLongestPath_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.stepIdx);
            this.calcSimulationSummary(obj, qtyMap);
            this.lr.saveStepLog(false);
            obj.set("runlog", (Object)this.ctx.getRunLog());
            obj.set("simulationstatus", (Object)"B");
            obj.set("simulationuser", (Object)RequestContext.get().getCurrUserId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    /*
     * Exception decompiling
     */
    private void getReplaceData(Map<String, Set<Long>> replaceMap, Map<String, BigDecimal[]> qtyMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void calcSimulationSummary(DynamicObject obj, Map<String, BigDecimal[]> qtyMap) {
        DynamicObjectCollection entrys = obj.getDynamicObjectCollection("groupentryentity");
        entrys.clear();
        String selectFields = "entryentity.id entryid,entryentity.material material,entryentity.materialattr materialattr,entryentity.adjustsuggest adjustsuggest,entryentity.supplybillid supplybillid,entryentity.demandauxpty demandauxpty,entryentity.configuredcode configuredcode,entryentity.tracknumber tracknumber,entryentity.demandqty demandqty,entryentity.supplyqty supplyqty,entryentity.demandbillf7 demandbillf7,entryentity.supplybillf7 supplybillf7";
        QFilter logFilter = new QFilter("caculatelog", "=", (Object)this.ctx.getRunLogNumber());
        QFilter supplyFilter = new QFilter("entryentity.supplyqty", ">", (Object)0);
        QFilter typeFilter = new QFilter("entryentity.supplybilltype", "!=", (Object)Character.valueOf(' '));
        QFilter[] filters = new QFilter[]{logFilter, supplyFilter, typeFilter};
        Set detailSet = new HashSet();
        if (this.ctx.getCustomParams("calcentryid") != null) {
            detailSet = (Set)SerializableUtils.fromSerializedString((String)this.ctx.getCustomParams("calcentryid"), Set.class);
        }
        HashMap<String, SimulationGroupEntity> map = new HashMap<String, SimulationGroupEntity>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_simulationdetail", (String)selectFields, (QFilter[])filters, null);){
            HashSet<Long> materialSet = new HashSet<Long>();
            for (Row row2 : dataSet) {
                Long entryid = row2.getLong("entryid");
                if (detailSet.contains(entryid)) continue;
                Long material = row2.getLong("material");
                materialSet.add(material);
                String materialattr = row2.getString("materialattr");
                Long demandauxpty = row2.getLong("demandauxpty");
                Long configuredcode = row2.getLong("configuredcode");
                Long tracknumber = row2.getLong("tracknumber");
                String adjustsuggest = row2.getString("adjustsuggest");
                BigDecimal demandqty = row2.get("demandqty") == null ? BigDecimal.ZERO : row2.getBigDecimal("demandqty");
                BigDecimal supplyqty = row2.getBigDecimal("supplyqty");
                String demandbillf7 = row2.getString("demandbillf7");
                String supplybillf7 = row2.getString("supplybillf7");
                Long supplybillid = row2.getLong("supplybillid");
                String group = String.valueOf(material) + (this.isFlexPropMatch ? String.valueOf(demandauxpty) : "0");
                SimulationGroupEntity entity = map.computeIfAbsent(group, k -> new SimulationGroupEntity());
                if (qtyMap.get(group) != null) {
                    entity.setG_replacedqty(qtyMap.get(group)[0]);
                    entity.setG_replaceqty(qtyMap.get(group)[1]);
                }
                entity.setMaterial(material);
                entity.setMaterialattr(materialattr);
                entity.setDemandauxpty(demandauxpty);
                entity.setConfiguredcode(configuredcode);
                entity.setTracknumber(tracknumber);
                entity.getAdjustsuggest().add(adjustsuggest);
                if ("mds_safetystock".equals(demandbillf7)) {
                    entity.setG_safetyqty(entity.getG_safetyqty().add(demandqty));
                } else if ("sm_salorder".equals(demandbillf7) || "mds_data".equals(demandbillf7) || "mrp_simulation".equals(demandbillf7)) {
                    entity.setG_demandqty(entity.getG_demandqty().add(demandqty));
                } else {
                    entity.setG_dependentqty(entity.getG_dependentqty().add(demandqty));
                }
                if ("im_inv_realbalance".equals(supplybillf7)) {
                    entity.setG_invqty(entity.getG_invqty().add(supplyqty));
                    entity.setG_canuseqty(entity.getG_canuseqty().add(supplyqty));
                    entity.setG_currentqty(entity.getG_currentqty().add(demandqty));
                    continue;
                }
                if ("mrp_simulateorder".equals(supplybillf7) || "mrp_simcolorder".equals(supplybillf7)) {
                    entity.setG_planqty(entity.getG_planqty().add(supplyqty));
                    entity.setG_plancurrentqty(entity.getG_plancurrentqty().add(demandqty));
                    entity.getG_billcount().add(supplybillid);
                    continue;
                }
                entity.setG_allqty(entity.getG_allqty().add(supplyqty));
                entity.setG_waycanqty(entity.getG_waycanqty().add(supplyqty));
                entity.setG_waycurrentqty(entity.getG_waycurrentqty().add(demandqty));
            }
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,baseunit", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSet)}, null);
            HashMap unitMap = new HashMap(8);
            queryDataSet.forEach(row -> unitMap.put(row.getLong("id"), row.get("baseunit")));
            for (SimulationGroupEntity e : map.values()) {
                DynamicObject newEntry = entrys.addNew();
                newEntry.set("g_material", (Object)e.getMaterial());
                newEntry.set("g_materialarr", (Object)e.getMaterialattr());
                newEntry.set("g_unit", unitMap.get(e.getMaterial()));
                newEntry.set("g_auxpty", (Object)e.getDemandauxpty());
                newEntry.set("g_configuredcode", (Object)e.getConfiguredcode());
                newEntry.set("g_tracknumber", (Object)e.getTracknumber());
                newEntry.set("g_safetyqty", (Object)e.getG_safetyqty());
                newEntry.set("g_demandqty", (Object)e.getG_demandqty().subtract(e.getG_replaceqty()));
                newEntry.set("g_dependentqty", (Object)e.getG_dependentqty());
                newEntry.set("g_replaceqty", (Object)e.getG_replaceqty());
                newEntry.set("g_replacedqty", (Object)e.getG_replacedqty());
                newEntry.set("g_invqty", (Object)e.getG_invqty());
                newEntry.set("g_canuseqty", (Object)e.getG_canuseqty());
                newEntry.set("g_currentqty", (Object)e.getG_currentqty());
                newEntry.set("g_allqty", (Object)e.getG_allqty());
                newEntry.set("g_waycanqty", (Object)e.getG_waycanqty());
                newEntry.set("g_waycurrentqty", (Object)e.getG_waycurrentqty());
                newEntry.set("g_planqty", (Object)e.getG_planqty());
                newEntry.set("g_plancurrentqty", (Object)e.getG_plancurrentqty());
                newEntry.set("g_billcount", (Object)e.getG_billcount().size());
                newEntry.set("g_finishqty", (Object)e.getG_canuseqty().add(e.getG_waycanqty()).add(e.getG_planqty()).subtract(e.getG_safetyqty()).subtract(e.getG_demandqty().subtract(e.getG_replaceqty())).subtract(e.getG_dependentqty()).subtract(newEntry.getBigDecimal("g_replaceqty")));
                if (e.getAdjustsuggest().isEmpty()) {
                    newEntry.set("g_adjustsuggest", (Object)"");
                    continue;
                }
                String addjust = e.getAdjustsuggest().toString();
                addjust = addjust.replace('[', ',').replace(']', ',');
                newEntry.set("g_adjustsuggest", (Object)addjust);
            }
            this.lr.updateSubStepLog(1, "entryprocessdata", (Object)entrys.size());
            this.lr.updateSubStepLog(1, "entryresult", (Object)MRPExecuteStatus.FINISHED.getAlias());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void calcSimulationDetail(DynamicObject obj, Map<String, Set<Long>> replaceMap) {
        DynamicObjectCollection fieldEntry = obj.getDynamicObjectCollection("fieldentry");
        fieldEntry.clear();
        DynamicObjectCollection treeEntry = obj.getDynamicObjectCollection("treeentryentity");
        treeEntry.clear();
        String selectFields = "entryentity.id entryid,entryentity.material material,entryentity.materialattr materialattr,entryentity.billno billno,entryentity.billentryseq billentryseq,entryentity.demandauxpty demandauxpty,entryentity.configuredcode configuredcode,entryentity.tracknumber tracknumber,entryentity.demanddate demanddate,entryentity.supplydate supplydate,entryentity.demandqty demandqty,entryentity.supplyqty supplyqty,entryentity.supplybilltype supplybilltype,entryentity.reqsourcebillno reqsourcebillno,entryentity.billid billid,entryentity.billentryid billentryid,entryentity.llc llc,entryentity.supplyorg supplyorg,entryentity.parentbomid parentbomid,entryentity.bomid bomid,entryentity.orderdate orderdate,entryentity.demandbillf7 demandbillf7,entryentity.supplybillf7 supplybillf7,entryentity.requireorg requireorg,entryentity.leadtime leadtime,entryentity.dynamicscrapratio dynamicscrapratio,entryentity.fixscrap fixscrap,entryentity.entryqtytype entryqtytype,entryentity.entryqtynumerator entryqtynumerator,entryentity.entryqtydenominator entryqtydenominator,entryentity.wastagerateformula wastagerateformula";
        QFilter logFilter = new QFilter("caculatelog", "=", (Object)this.ctx.getRunLogNumber());
        QFilter demandFilter = new QFilter("entryentity.demandqty", ">", (Object)0);
        QFilter supplyFilter = new QFilter("entryentity.supplyqty", ">", (Object)0);
        QFilter typeFilter = new QFilter("entryentity.supplybilltype", "!=", (Object)Character.valueOf(' '));
        QFilter[] filters = new QFilter[]{logFilter, demandFilter, supplyFilter, typeFilter};
        QFilter[] abcFilter = new QFilter[]{logFilter, supplyFilter, typeFilter};
        String abcSelectFields = "entryentity.id entryid,entryentity.material material,entryentity.reqsourcebillno reqsourcebillno,entryentity.billid billid,entryentity.billentryid billentryid,entryentity.llc llc,entryentity.supplyorg supplyorg,entryentity.parentbomid parentbomid,entryentity.bomid bomid";
        HashMap<String, Map<String, SimulationEntity>> map = new HashMap<String, Map<String, SimulationEntity>>();
        try (DataSet allDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_simulationdetail", (String)selectFields, (QFilter[])filters, null);
             DataSet soucebillDataSet = allDataSet.copy().where("reqsourcebillno != ''");
             DataSet noSoucebillDataSet = allDataSet.copy().where("reqsourcebillno = ''");
             DataSet sDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_simulationdetail", (String)abcSelectFields, (QFilter[])abcFilter, null).where("reqsourcebillno != ''");
             DataSet nosDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_simulationdetail", (String)abcSelectFields, (QFilter[])abcFilter, null).where("reqsourcebillno = ''");){
            Map<Long, Set<Long>> invMap = this.getABCType(obj.getString("abctype"));
            HashSet<Long> abcDetailSet = new HashSet<Long>(16);
            if (invMap != null) {
                String reqsourcebillno;
                HashMap<String, Map<String, ABCTreeEntity>> abcMap = new HashMap<String, Map<String, ABCTreeEntity>>(16);
                for (Row row2 : sDataSet) {
                    reqsourcebillno = row2.getString("reqsourcebillno");
                    this.buildABCMap(abcMap, row2, reqsourcebillno);
                }
                for (Object row2 : nosDataSet) {
                    reqsourcebillno = row2.getString("billid") + row2.getString("billentryid");
                    this.buildABCMap(abcMap, (Row)row2, reqsourcebillno);
                }
                if (abcMap.get("") != null) {
                    Map map2 = (Map)abcMap.get("");
                    for (ABCTreeEntity abc2 : map2.values()) {
                        Long materialId = abc2.getMaterialId();
                        abc2.getList().forEach(k -> {
                            if (!invMap.containsKey(k.getOrgId()) || !((Set)invMap.get(k.getOrgId())).contains(materialId)) {
                                abcDetailSet.add(k.getDetailId());
                            }
                        });
                    }
                }
                List<List<ABCTreeEntity>> sortABCList = this.sortABCMap(abcMap);
                ArrayList<TreeNode> childNodeList = new ArrayList<TreeNode>(8);
                ArrayList allNode = new ArrayList(8);
                for (List list : sortABCList) {
                    TreeNode tree = this.buildABCTree(list);
                    childNodeList.clear();
                    tree.iterate(20, tr -> {
                        if (tr.getChildren() == null) {
                            childNodeList.add((TreeNode)tr);
                        }
                        allNode.add(tr);
                    });
                    this.filterABCMaterial(invMap, childNodeList, tree);
                    for (TreeNode tr2 : allNode) {
                        ABCTreeEntity abcTreeEntity = (ABCTreeEntity)tr2.getData();
                        abcTreeEntity.getList().forEach(abc -> {
                            if (!abc.isABC()) {
                                abcDetailSet.add(abc.getDetailId());
                            }
                        });
                    }
                }
            }
            HashMap<String, String> qtyFieldMap = new HashMap<String, String>();
            HashSet<Long> materialSet = new HashSet<Long>();
            Calendar instance = Calendar.getInstance();
            instance.setTime(this.ctx.getPlanDate());
            instance.add(5, 1);
            OrgBasedCalendarModel.nomalize((Calendar)instance);
            Date time = instance.getTime();
            Set<Long> detailSet = this.getDetailID(allDataSet);
            int n = this.mergeData(map, soucebillDataSet, noSoucebillDataSet, qtyFieldMap, materialSet, time, detailSet, abcDetailSet);
            detailSet.addAll(abcDetailSet);
            this.ctx.putCustomParams("calcentryid", SerializableUtils.toSerializedString(detailSet));
            List<List<SimulationEntity>> list = this.sortData(map);
            ArrayList<TreeNode> allTreeNode = new ArrayList<TreeNode>();
            List<TreeNode> treeList = this.buildTree(n, list, allTreeNode);
            this.calcLongest(obj, treeList, time);
            HashMap qtyMap = new HashMap(qtyFieldMap.size());
            boolean bl = true;
            for (Map.Entry entry : qtyFieldMap.entrySet()) {
                void var31_44;
                qtyMap.put(entry.getKey(), "d_qty" + (int)var31_44);
                DynamicObject addNew = fieldEntry.addNew();
                addNew.set("fieldname", entry.getKey());
                addNew.set("fieldkey", (Object)("d_qty" + (int)var31_44));
                addNew.set("fieldentity", entry.getValue());
                ++var31_44;
            }
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,baseunit", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSet)}, null);
            HashMap unitMap = new HashMap(8);
            queryDataSet.forEach(row -> unitMap.put(row.getLong("id"), row.get("baseunit")));
            for (TreeNode t : allTreeNode) {
                SimulationEntity row3 = (SimulationEntity)t.getData();
                DynamicObject entry = treeEntry.addNew();
                entry.set("id", (Object)t.getId());
                entry.set("pid", (Object)t.getParentid());
                entry.set("d_level", (Object)t.getText());
                entry.set("d_material", (Object)row3.getMaterial());
                entry.set("d_unit", unitMap.get(row3.getMaterial()));
                entry.set("d_materialarr", (Object)row3.getMaterialattr());
                entry.set("isexception", (Object)row3.isException());
                entry.set("d_billno", (Object)row3.getBillno());
                entry.set("d_rowno", (Object)row3.getBillentryseq());
                entry.set("d_auxpty", (Object)row3.getDemandauxpty());
                entry.set("d_configuredcode", (Object)row3.getConfiguredcode());
                entry.set("d_tracknumber", (Object)row3.getTracknumber());
                entry.set("d_requireqty", (Object)row3.getDemandqty());
                entry.set("d_supplyqty", (Object)row3.getSupplyqty());
                entry.set("d_longestpath", (Object)row3.getLongestpath());
                entry.set("d_isrequire", (Object)row3.getIsrequire());
                entry.set("d_reqsourcebillno", (Object)row3.getReqsourcebillno());
                entry.set("d_billid", (Object)row3.getBillid());
                entry.set("d_billentryid", (Object)row3.getBillentryid());
                entry.set("d_promisedate", (Object)row3.getPromiseDate());
                entry.set("d_begindate", (Object)row3.getPlanBeginDate());
                entry.set("d_finishdate", (Object)row3.getPlanFinishDate());
                entry.set("d_entryqtytype", (Object)row3.getQtyType());
                entry.set("entryqtynumerator", (Object)row3.getQtyNumerator());
                entry.set("entryqtydenominator", (Object)row3.getQtyDenominator());
                entry.set("dynamicscrapratio", (Object)row3.getDynamicScrapRatio());
                entry.set("fixscrap", (Object)row3.getFixScrap());
                entry.set("wastagerateformula", (Object)row3.getWastaGerateFormula());
                entry.set("d_isreplace", (Object)(replaceMap.containsKey(row3.getReqsourcebillno()) ? replaceMap.get(row3.getReqsourcebillno()).contains(row3.getMaterial()) : false));
                for (Map.Entry en : qtyMap.entrySet()) {
                    if (!row3.getSupplyMap().containsKey(en.getKey())) continue;
                    entry.set((String)en.getValue(), row3.getSupplyMap().get(en.getKey()));
                }
            }
            this.lr.updateSubStepLog(0, "entryprocessdata", (Object)treeEntry.size());
            this.lr.updateSubStepLog(0, "entryresult", (Object)MRPExecuteStatus.FINISHED.getAlias());
            this.dataAmount += allTreeNode.size();
        }
    }

    private void filterABCMaterial(Map<Long, Set<Long>> invMap, List<TreeNode> childNodeList, TreeNode tree) {
        for (TreeNode tr : childNodeList) {
            ABCTreeEntity abcTreeEntity = (ABCTreeEntity)tr.getData();
            Long materialId = abcTreeEntity.getMaterialId();
            List idList = abcTreeEntity.getList();
            idList.forEach(abc -> {
                if (invMap.containsKey(abc.getOrgId()) && ((Set)invMap.get(abc.getOrgId())).contains(materialId)) {
                    abcTreeEntity.setExistABC(true);
                    abc.setABC(true);
                }
            });
            String parentid = tr.getParentid();
            if (abcTreeEntity.isExistABC()) {
                while (tree.getTreeNode(parentid) != null) {
                    TreeNode treeNode = tree.getTreeNode(parentid);
                    ABCTreeEntity entity = (ABCTreeEntity)treeNode.getData();
                    entity.setExistABC(true);
                    entity.getList().forEach(abc -> abc.setABC(true));
                    parentid = treeNode.getParentid();
                }
                continue;
            }
            boolean flag = false;
            while (tree.getTreeNode(parentid) != null) {
                TreeNode treeNode = tree.getTreeNode(parentid);
                ABCTreeEntity entity = (ABCTreeEntity)treeNode.getData();
                Long childMaterial = entity.getMaterialId();
                if (flag) {
                    entity.setExistABC(true);
                    entity.getList().forEach(abc -> abc.setABC(true));
                } else {
                    List li = entity.getList();
                    for (ABCOrgAndDetailEntity abc2 : li) {
                        if (!invMap.containsKey(abc2.getOrgId()) || !invMap.get(abc2.getOrgId()).contains(childMaterial)) continue;
                        entity.setExistABC(true);
                        abc2.setABC(true);
                        flag = true;
                    }
                }
                parentid = treeNode.getParentid();
            }
        }
    }

    private TreeNode buildABCTree(List<ABCTreeEntity> list) {
        TreeNode tree = new TreeNode();
        for (int i = 0; i < list.size(); ++i) {
            String parentBomid;
            ABCTreeEntity abcTreeEntity = list.get(i);
            String bomid = abcTreeEntity.getBomid();
            if ("".equals(bomid)) {
                bomid = String.valueOf(i);
            }
            if ("".equals(parentBomid = abcTreeEntity.getParentbomid())) {
                parentBomid = "-" + i;
            }
            if (i == 0) {
                tree = new TreeNode(bomid, parentBomid, "", (Object)abcTreeEntity);
                continue;
            }
            if (tree.getTreeNode(bomid) == null) continue;
            TreeNode pTree = tree.getTreeNode(bomid);
            TreeNode cTree = new TreeNode(bomid, parentBomid, "", (Object)abcTreeEntity);
            pTree.addChild(cTree);
        }
        return tree;
    }

    private void buildABCMap(Map<String, Map<String, ABCTreeEntity>> abcMap, Row row, String reqsourcebillno) {
        Long entryid = row.getLong("entryid");
        Long supplyorg = row.getLong("supplyorg");
        Long material = row.getLong("material");
        int llc = "".equals(row.get("llc")) ? 0 : row.getInteger("llc");
        String parentbomid = row.getString("parentbomid");
        String bomid = row.getString("bomid");
        Map abc = abcMap.computeIfAbsent(reqsourcebillno, k -> new HashMap());
        String group = String.valueOf(material) + row.getString("bomid");
        ABCTreeEntity abcEntity = abc.computeIfAbsent(group, k -> new ABCTreeEntity(Integer.valueOf(llc), material, parentbomid, bomid));
        if (!"".equals(parentbomid)) {
            abcEntity.setParentbomid(parentbomid);
        }
        if (!"".equals(bomid)) {
            abcEntity.setBomid(bomid);
        }
        abcEntity.getList().add(new ABCOrgAndDetailEntity(supplyorg, entryid));
    }

    private Map<Long, Set<Long>> getABCType(String abcType) {
        HashMap<Long, Set<Long>> map = null;
        if (!"".equals(abcType)) {
            map = new HashMap<Long, Set<Long>>(16);
            QFilter logFilter = new QFilter("caculatelog", "=", (Object)this.ctx.getRunLogNumber());
            QFilter supplyFilter = new QFilter("entryentity.supplyqty", ">", (Object)0);
            QFilter typeFilter = new QFilter("entryentity.supplybilltype", "!=", (Object)Character.valueOf(' '));
            QFilter[] filters = new QFilter[]{logFilter, supplyFilter, typeFilter};
            String selectFields = "entryentity.id entryid,entryentity.material material,entryentity.supplyorg supplyorg";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_simulationdetail", (String)selectFields, (QFilter[])filters, null);
            HashMap<Long, Set> orgMap = new HashMap<Long, Set>(16);
            for (Row row : dataSet) {
                Set set = orgMap.computeIfAbsent(row.getLong("supplyorg"), k -> new HashSet());
                set.add(row.getLong("material"));
            }
            for (Map.Entry<Long, Set<Long>> entry : orgMap.entrySet()) {
                this.getMaterialInv(abcType, map, entry);
            }
        }
        return map;
    }

    private void getMaterialInv(String abcType, Map<Long, Set<Long>> map, Map.Entry<Long, Set<Long>> en) {
        QFilter statudQF = new QFilter("status", "=", (Object)"C");
        QFilter enableQF = new QFilter("enable", "=", (Object)"1");
        QFilter useOrgQF = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)en.getKey());
        QFilter masteridQF = new QFilter("masterid", "in", en.getValue());
        QFilter abcQF = new QFilter("abctype", "in", (Object)abcType.substring(1, abcType.length() - 1).split(","));
        DataSet invDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialinventoryinfo", (String)"createorg createorg,masterid material,abctype abctype,manustrategy", (QFilter[])new QFilter[]{statudQF, enableQF, useOrgQF, masteridQF, abcQF}, null);
        HashSet<Long> ownerSet = new HashSet<Long>(16);
        for (Row invRow : invDataSet) {
            String abc = invRow.getString("abctype");
            Long createorg = invRow.getLong("createorg");
            Long material = invRow.getLong("material");
            Set set = map.computeIfAbsent(en.getKey(), k -> new HashSet(16));
            if (createorg.equals(en.getKey())) {
                ownerSet.add(material);
                if (abcType.contains(abc)) {
                    set.add(material);
                    continue;
                }
                set.remove(material);
                continue;
            }
            if (ownerSet.contains(material) || !abcType.contains(abc)) continue;
            set.add(material);
        }
    }

    private void calcLongest(DynamicObject obj, List<TreeNode> treeList, Date time) {
        ArrayList subTreeList = new ArrayList(8);
        for (TreeNode tree : treeList) {
            subTreeList.clear();
            tree.iterate(20, tr -> {
                SimulationEntity en = (SimulationEntity)tr.getData();
                if (en.getOrderDate() != null) {
                    subTreeList.add(tr);
                }
            });
            String nodeId = "";
            Date date = null;
            for (TreeNode node : subTreeList) {
                SimulationEntity en = (SimulationEntity)node.getData();
                if (date == null) {
                    nodeId = node.getId();
                    date = en.getOrderDate();
                    continue;
                }
                if (en.getOrderDate() == null || !en.getOrderDate().before(date)) continue;
                nodeId = node.getId();
                date = en.getOrderDate();
            }
            if (!"".equals(nodeId)) {
                TreeNode treeNode = tree.getTreeNode(nodeId);
                SimulationEntity en = (SimulationEntity)treeNode.getData();
                en.setLongestpath(Boolean.TRUE);
                if (en.getSupplybillf7() != null && "mrp_planorder,mrp_simulateorder,mrp_collaborativeorder, mrp_simcolorder".contains(en.getSupplybillf7())) {
                    en.setOrderDate(this.ctx.getPlanDate());
                    this.calcDeliveryDate(obj, tree, treeNode);
                } else if (en.getSupplydate() == null || en.getSupplydate().before(time)) {
                    this.isPastSupply(obj, tree);
                } else {
                    if (en.getOrderDate() == null || en.getOrderDate().after(this.ctx.getPlanDate())) {
                        en.setOrderDate(this.ctx.getPlanDate());
                    }
                    this.calcDeliveryDate(obj, tree, treeNode);
                }
                while (!"0".equals(treeNode.getParentid())) {
                    treeNode = tree.getTreeNode(treeNode.getParentid());
                    en = (SimulationEntity)treeNode.getData();
                    en.setLongestpath(Boolean.TRUE);
                }
            } else {
                SimulationEntity en = (SimulationEntity)tree.getData();
                en.setLongestpath(Boolean.TRUE);
                if (en.getSupplybillf7() != null && "mrp_planorder,mrp_simulateorder,mrp_collaborativeorder, mrp_simcolorder".contains(en.getSupplybillf7())) {
                    en.setOrderDate(this.ctx.getPlanDate());
                    this.calcDeliveryDate(obj, tree, tree);
                } else if (en.getSupplydate() == null || en.getSupplydate().before(time)) {
                    this.isPastSupply(obj, tree);
                } else {
                    if (en.getOrderDate() == null || en.getOrderDate().after(this.ctx.getPlanDate())) {
                        en.setOrderDate(this.ctx.getPlanDate());
                    }
                    this.calcDeliveryDate(obj, tree, tree);
                }
            }
            this.calcSuggestDate(tree);
        }
    }

    private void isPastSupply(DynamicObject obj, TreeNode tree) {
        SimulationEntity row = (SimulationEntity)tree.getData();
        row.setPromiseDate(this.ctx.getPlanDate());
        DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
        col.forEach(entry -> {
            if (entry.getString("billid").equals(row.getBillid()) && entry.getString("billentryid").equals(row.getBillentryid())) {
                entry.set("deliverydate", (Object)this.ctx.getPlanDate());
                entry.set("promisedate", (Object)this.ctx.getPlanDate());
                entry.set("requiredate", (Object)row.getDemanddate());
            }
        });
    }

    private void calcSuggestDate(TreeNode tree) {
        HashMap<String, SimulationEntity> map = new HashMap<String, SimulationEntity>(8);
        SimulationEntity row = (SimulationEntity)tree.getData();
        this.positiveDate(row.getPromiseDate(), row);
        map.put(tree.getId(), row);
        this.loopTreeNode(map, tree.getChildren());
    }

    private void loopTreeNode(Map<String, SimulationEntity> map, List<TreeNode> list) {
        if (list.isEmpty()) {
            return;
        }
        ArrayList<TreeNode> returnList = new ArrayList<TreeNode>(list.size());
        Calendar instance = Calendar.getInstance();
        for (TreeNode node : list) {
            String parentid = node.getParentid();
            SimulationEntity row = (SimulationEntity)node.getData();
            SimulationEntity parentRow = map.get(parentid);
            int leadTime = row.getLeadTime();
            if ("10030".equals(row.getMaterialattr())) {
                instance.setTime(parentRow.getPlanBeginDate());
                instance.add(5, leadTime);
            } else {
                instance.setTime(parentRow.getOrderDate());
                instance.add(5, leadTime);
            }
            this.positiveDate(instance.getTime(), row);
            map.put(node.getId(), row);
            returnList.addAll(node.getChildren());
        }
        this.loopTreeNode(map, returnList);
    }

    private void positiveDate(Date orderDate, SimulationEntity row) {
        String materialattr = row.getMaterialattr();
        Long material = row.getMaterial();
        Long requireorg = row.getRequireorg();
        Long supplyorg = row.getSupplyorg();
        OrgBasedCalendarModel sOcm = this.ctx.dateManager().get(String.valueOf(supplyorg), String.valueOf(requireorg));
        SupplyStruct ss = (SupplyStruct)this.ctx.getPriorityRelations().get(String.valueOf(supplyorg));
        Map matPlanInfo = this.ctx.getMaterialPlanInfo(String.valueOf(material), String.valueOf(supplyorg));
        int bodtime = ss == null ? 0 : ss.getBodtime();
        Integer preprocessingtime = 0;
        String leadtimetype = LeadType.FIXED.getValue();
        Integer fixedleadtime = 0;
        Integer changeleadtime = 0;
        Integer postprocessingtime = 0;
        Integer inspectionleadtime = 0;
        BigDecimal dynamicBatch = BigDecimal.ZERO;
        if (matPlanInfo != null) {
            preprocessingtime = (Integer)MRPUtil.convert(matPlanInfo.get("preprocessingtime"), (Object)0);
            leadtimetype = (String)matPlanInfo.get("leadtimetype");
            if (leadtimetype == null) {
                leadtimetype = LeadType.FIXED.getValue();
            }
            fixedleadtime = (Integer)MRPUtil.convert(matPlanInfo.get("fixedleadtime"), (Object)0);
            changeleadtime = (Integer)MRPUtil.convert(matPlanInfo.get("changeleadtime"), (Object)0);
            postprocessingtime = (Integer)MRPUtil.convert(matPlanInfo.get("postprocessingtime"), (Object)0);
            inspectionleadtime = (Integer)MRPUtil.convert(matPlanInfo.get("inspectionleadtime"), (Object)0);
            dynamicBatch = (BigDecimal)MRPUtil.convert(matPlanInfo.get("changebatch"), (Object)BigDecimal.ZERO);
        } else {
            row.setException(true);
        }
        if ("10040".equals(materialattr)) {
            bodtime = 0;
            row.setCanUseDate(orderDate);
            Long finishTime = orderDate.getTime() - (long)(postprocessingtime + inspectionleadtime) * 86400000L;
            row.setPlanFinishDate(new Date(finishTime));
            Long beginTime = 0L;
            if (LeadType.FIXED.getValue().equals(leadtimetype)) {
                beginTime = finishTime - (long)fixedleadtime.intValue() * 86400000L;
            } else if (LeadType.DYNAMIC.getValue().equals(leadtimetype)) {
                if (dynamicBatch != null) {
                    changeleadtime = row.getCalQty().divide(dynamicBatch, 0, RoundingMode.CEILING).intValue() * changeleadtime;
                }
                beginTime = finishTime - (long)changeleadtime.intValue() * 86400000L;
            }
            row.setPlanBeginDate(new Date(beginTime));
            Long planTime = beginTime - (long)(preprocessingtime + bodtime) * 86400000L;
            row.setOrderDate(new Date(planTime));
        } else {
            row.setCanUseDate(orderDate);
            Long finishTime = sOcm.getDate(orderDate, true, postprocessingtime + inspectionleadtime).getTimeInMillis();
            row.setPlanFinishDate(new Date(finishTime));
            Long beginTime = 0L;
            if (LeadType.FIXED.getValue().equals(leadtimetype)) {
                beginTime = sOcm.getDate(new Date(finishTime), true, fixedleadtime.intValue()).getTimeInMillis();
            } else if (LeadType.DYNAMIC.getValue().equals(leadtimetype)) {
                if (dynamicBatch != null) {
                    changeleadtime = row.getCalQty().divide(dynamicBatch, 0, RoundingMode.CEILING).intValue() * changeleadtime;
                }
                beginTime = sOcm.getDate(new Date(finishTime), true, changeleadtime.intValue()).getTimeInMillis();
            }
            row.setPlanBeginDate(new Date(beginTime));
            Long planTime = sOcm.getDate(new Date(beginTime), true, preprocessingtime + bodtime).getTimeInMillis();
            row.setOrderDate(new Date(planTime));
        }
    }

    private void calcDeliveryDate(DynamicObject obj, TreeNode tree, TreeNode childTree) {
        if ("0".equals(childTree.getParentid())) {
            Date orderDate = this.reverseDate(tree, childTree);
            SimulationEntity row = (SimulationEntity)tree.getData();
            DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
            col.forEach(entry -> {
                if (entry.getString("billid").equals(row.getBillid()) && entry.getString("billentryid").equals(row.getBillentryid())) {
                    entry.set("deliverydate", (Object)orderDate);
                    if (orderDate.after(row.getDemanddate())) {
                        entry.set("promisedate", (Object)orderDate);
                        row.setPromiseDate(orderDate);
                    } else {
                        entry.set("promisedate", (Object)row.getDemanddate());
                        row.setPromiseDate(row.getDemanddate());
                    }
                    entry.set("requiredate", (Object)row.getDemanddate());
                }
            });
            if (row.getPromiseDate() == null) {
                row.setPromiseDate(orderDate);
            }
            return;
        }
        Date orderDate = this.reverseDate(tree, childTree);
        TreeNode treeNode = tree.getTreeNode(childTree.getParentid());
        SimulationEntity parentRow = (SimulationEntity)treeNode.getData();
        parentRow.setOrderDate(orderDate);
        this.calcDeliveryDate(obj, tree, treeNode);
    }

    private Date reverseDate(TreeNode tree, TreeNode childTree) {
        SimulationEntity row = (SimulationEntity)childTree.getData();
        Long material = row.getMaterial();
        Long requireorg = row.getRequireorg();
        Long supplyorg = row.getSupplyorg();
        OrgBasedCalendarModel sOcm = this.ctx.dateManager().get(String.valueOf(supplyorg), String.valueOf(requireorg));
        SupplyStruct ss = (SupplyStruct)this.ctx.getPriorityRelations().get(String.valueOf(supplyorg));
        Map matPlanInfo = this.ctx.getMaterialPlanInfo(String.valueOf(material), String.valueOf(supplyorg));
        Date orderDate = row.getOrderDate() == null ? this.ctx.getPlanDate() : row.getOrderDate();
        int bodtime = ss == null ? 0 : ss.getBodtime();
        Integer preprocessingtime = 0;
        String leadtimetype = LeadType.FIXED.getValue();
        Integer fixedleadtime = 0;
        Integer changeleadtime = 0;
        Integer postprocessingtime = 0;
        Integer inspectionleadtime = 0;
        BigDecimal dynamicBatch = BigDecimal.ZERO;
        if (matPlanInfo != null) {
            preprocessingtime = (Integer)MRPUtil.convert(matPlanInfo.get("preprocessingtime"), (Object)0);
            leadtimetype = (String)matPlanInfo.get("leadtimetype");
            if (leadtimetype == null) {
                leadtimetype = LeadType.FIXED.getValue();
            }
            fixedleadtime = (Integer)MRPUtil.convert(matPlanInfo.get("fixedleadtime"), (Object)0);
            changeleadtime = (Integer)MRPUtil.convert(matPlanInfo.get("changeleadtime"), (Object)0);
            postprocessingtime = (Integer)MRPUtil.convert(matPlanInfo.get("postprocessingtime"), (Object)0);
            inspectionleadtime = (Integer)MRPUtil.convert(matPlanInfo.get("inspectionleadtime"), (Object)0);
            dynamicBatch = (BigDecimal)MRPUtil.convert(matPlanInfo.get("changebatch"), (Object)BigDecimal.ZERO);
        } else {
            row.setException(true);
        }
        Integer leadTime = row.getLeadTime();
        if ("10040".equals(row.getMaterialattr())) {
            bodtime = 0;
            Long beginTime = orderDate.getTime() + (long)(bodtime + preprocessingtime) * 86400000L;
            Long finishTime = 0L;
            if (LeadType.FIXED.getValue().equals(leadtimetype)) {
                finishTime = beginTime + (long)fixedleadtime.intValue() * 86400000L;
            } else if (LeadType.DYNAMIC.getValue().equals(leadtimetype)) {
                if (dynamicBatch != null) {
                    changeleadtime = row.getCalQty().divide(dynamicBatch, 0, RoundingMode.CEILING).intValue() * changeleadtime;
                }
                finishTime = beginTime + (long)changeleadtime.intValue() * 86400000L;
            }
            Long canUseTime = finishTime + (long)(postprocessingtime + inspectionleadtime - leadTime) * 86400000L;
            return new Date(canUseTime);
        }
        Long beginTime = sOcm.getDate(orderDate, false, bodtime + preprocessingtime).getTimeInMillis();
        Long finishTime = 0L;
        if (LeadType.FIXED.getValue().equals(leadtimetype)) {
            finishTime = sOcm.getDate(new Date(beginTime), false, fixedleadtime.intValue()).getTimeInMillis();
        } else if (LeadType.DYNAMIC.getValue().equals(leadtimetype)) {
            if (dynamicBatch != null) {
                changeleadtime = row.getCalQty().divide(dynamicBatch, 0, RoundingMode.CEILING).intValue() * changeleadtime;
            }
            finishTime = sOcm.getDate(new Date(beginTime), false, changeleadtime.intValue()).getTimeInMillis();
        }
        Long canUseTime = sOcm.getDate(new Date(finishTime), false, postprocessingtime + inspectionleadtime).getTimeInMillis();
        if ("10030".equals(row.getMaterialattr()) && !"0".equals(childTree.getParentid())) {
            TreeNode treeNode = tree.getTreeNode(childTree.getParentid());
            if (treeNode == null) {
                return new Date(canUseTime - (long)leadTime.intValue() * 86400000L);
            }
            SimulationEntity parentRow = (SimulationEntity)treeNode.getData();
            matPlanInfo = this.ctx.getMaterialPlanInfo(String.valueOf(parentRow.getMaterial()), String.valueOf(parentRow.getSupplyorg()));
            ss = (SupplyStruct)this.ctx.getPriorityRelations().get(String.valueOf(parentRow.getSupplyorg()));
            int n = bodtime = ss == null ? 0 : ss.getBodtime();
            if (matPlanInfo != null) {
                preprocessingtime = (Integer)MRPUtil.convert(matPlanInfo.get("preprocessingtime"), (Object)0);
            } else {
                preprocessingtime = 0;
                parentRow.setException(true);
            }
            Long planTime = sOcm.getDate(new Date(canUseTime), true, bodtime + preprocessingtime).getTimeInMillis();
            return new Date(planTime - (long)parentRow.getLeadTime() * 86400000L);
        }
        return new Date(canUseTime - (long)leadTime.intValue() * 86400000L);
    }

    private List<List<SimulationEntity>> sortData(Map<String, Map<String, SimulationEntity>> map) {
        ArrayList<List<SimulationEntity>> list = new ArrayList<List<SimulationEntity>>(map.size());
        for (Map<String, SimulationEntity> value : map.values()) {
            ArrayList<SimulationEntity> li = new ArrayList<SimulationEntity>(value.size());
            li.addAll(value.values());
            list.add(li);
        }
        list.forEach(x -> x.sort(new Comparator<SimulationEntity>(){

            @Override
            public int compare(SimulationEntity o1, SimulationEntity o2) {
                int llc2;
                int llc1 = Integer.parseInt(o1.getLlc());
                if (llc1 > (llc2 = Integer.parseInt(o2.getLlc()))) {
                    return 1;
                }
                if (llc1 < llc2) {
                    return -1;
                }
                return 0;
            }
        }));
        return list;
    }

    private List<List<ABCTreeEntity>> sortABCMap(Map<String, Map<String, ABCTreeEntity>> abcMap) {
        ArrayList<List<ABCTreeEntity>> list = new ArrayList<List<ABCTreeEntity>>(abcMap.size());
        for (Map<String, ABCTreeEntity> value : abcMap.values()) {
            ArrayList<ABCTreeEntity> li = new ArrayList<ABCTreeEntity>(value.size());
            li.addAll(value.values());
            list.add(li);
        }
        list.forEach(x -> x.sort(new Comparator<ABCTreeEntity>(){

            @Override
            public int compare(ABCTreeEntity o1, ABCTreeEntity o2) {
                int llc2;
                int llc1 = o1.getLlc();
                if (llc1 > (llc2 = o2.getLlc().intValue())) {
                    return 1;
                }
                if (llc1 < llc2) {
                    return -1;
                }
                return 0;
            }
        }));
        return list;
    }

    private int mergeData(Map<String, Map<String, SimulationEntity>> map, DataSet soucebillDataSet, DataSet noSoucebillDataSet, Map<String, String> qtyFieldMap, Set<Long> materialSet, Date time, Set<Long> detailSet, Set<Long> abcDetailSet) {
        String reqsourcebillno;
        int i = 0;
        for (Row row : soucebillDataSet) {
            if (abcDetailSet.contains(row.getLong("entryid"))) continue;
            reqsourcebillno = row.getString("reqsourcebillno");
            this.merge(map, qtyFieldMap, materialSet, row, reqsourcebillno, Boolean.TRUE, time, detailSet);
            ++i;
        }
        for (Row row : noSoucebillDataSet) {
            if (abcDetailSet.contains(row.getLong("entryid"))) continue;
            reqsourcebillno = row.getString("billid") + row.getString("billentryid");
            this.merge(map, qtyFieldMap, materialSet, row, reqsourcebillno, Boolean.FALSE, time, detailSet);
            ++i;
        }
        return i;
    }

    private void merge(Map<String, Map<String, SimulationEntity>> map, Map<String, String> qtyFieldMap, Set<Long> materialSet, Row row, String reqsourcebillno, Boolean isrequire, Date time, Set<Long> detailSet) {
        Long material = row.getLong("material");
        Long auxpty = row.getLong("demandauxpty");
        String group = String.valueOf(material) + (this.isFlexPropMatch ? String.valueOf(auxpty) : "0") + row.getString("bomid");
        materialSet.add(material);
        Map mergerRowData = map.computeIfAbsent(reqsourcebillno, k -> new HashMap());
        SimulationEntity rowData = mergerRowData.computeIfAbsent(group, k -> new SimulationEntity(material, reqsourcebillno));
        if (!"mrp_planorder,mrp_simulateorder,mrp_collaborativeorder, mrp_simcolorder".contains(row.getString("supplybillf7"))) {
            if (row.getDate("supplydate").after(time)) {
                this.removeNotTodaySupply(row, rowData, detailSet);
            }
        } else {
            this.removeNotTodaySupply(row, rowData, detailSet);
        }
        rowData.setLeadTime(row.getInteger("leadtime").intValue());
        rowData.setRequireorg(row.getLong("requireorg"));
        rowData.setDemandbillf7(row.getString("demandbillf7"));
        rowData.setMaterialattr(row.getString("materialattr"));
        rowData.setBillno(row.getString("billno"));
        rowData.setBillentryseq(row.getString("billentryseq"));
        rowData.setDemandauxpty(row.getLong("demandauxpty"));
        rowData.setConfiguredcode(row.getLong("configuredcode"));
        rowData.setTracknumber(row.getLong("tracknumber"));
        rowData.setDemanddate(row.getDate("demanddate"));
        rowData.setSupplydate(row.getDate("supplydate"));
        rowData.setBillid(row.getString("billid"));
        rowData.setBillentryid(row.getString("billentryid"));
        rowData.setParentbomid(row.getString("parentbomid"));
        rowData.setBomid(row.getString("bomid"));
        rowData.setLlc(row.getString("llc"));
        rowData.setIsrequire(isrequire);
        rowData.setQtyType(row.getString("entryqtytype"));
        rowData.setQtyNumerator(row.getBigDecimal("entryqtynumerator"));
        rowData.setQtyDenominator(row.getBigDecimal("entryqtydenominator"));
        rowData.setDynamicScrapRatio(row.getBigDecimal("dynamicscrapratio"));
        rowData.setFixScrap(row.getBigDecimal("fixscrap"));
        rowData.setWastaGerateFormula(row.getString("wastagerateformula"));
        Long entryid = row.getLong("entryid");
        if (!detailSet.contains(entryid)) {
            rowData.setDemandqty(rowData.getDemandqty().add(row.getBigDecimal("demandqty")));
            rowData.setSupplyqty(rowData.getSupplyqty().add(row.getBigDecimal("supplyqty")));
            rowData.getSupplyMap().put(row.getString("supplybilltype"), rowData.getSupplyMap().containsKey(row.getString("supplybilltype")) ? ((BigDecimal)rowData.getSupplyMap().get(row.getString("supplybilltype"))).add(row.getBigDecimal("supplyqty")) : row.getBigDecimal("supplyqty"));
            qtyFieldMap.put(row.getString("supplybilltype"), row.getString("supplybillf7"));
        }
    }

    private void removeNotTodaySupply(Row row, SimulationEntity rowData, Set<Long> detailSet) {
        Long entryid = row.getLong("entryid");
        if (detailSet.contains(entryid)) {
            rowData.setOrderDate(row.getDate("orderdate"));
            rowData.setCalQty(BigDecimal.ZERO);
            rowData.setSupplybillf7(row.getString("supplybillf7"));
            rowData.setSupplyorg(row.getLong("supplyorg"));
        } else if (rowData.getOrderDate() == null || row.getDate("orderdate") != null && row.getDate("orderdate").before(rowData.getOrderDate())) {
            rowData.setOrderDate(row.getDate("orderdate"));
            rowData.setCalQty(row.getBigDecimal("demandqty"));
            rowData.setSupplybillf7(row.getString("supplybillf7"));
            rowData.setSupplyorg(row.getLong("supplyorg"));
        }
    }

    private List<TreeNode> buildTree(int i, List<List<SimulationEntity>> list, List<TreeNode> allTreeNode) {
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>();
        ORM orm = ORM.create();
        long[] genLongIds = orm.genLongIds("mrp_simulation.treeentryentity", i);
        i = 0;
        HashMap<String, String> idMap = new HashMap<String, String>(list.size());
        for (List<SimulationEntity> li : list) {
            TreeNode tree = new TreeNode();
            for (int j = 0; j < li.size(); ++j) {
                String nodeId;
                SimulationEntity row = li.get(j);
                if (row.getSupplyorg() == null) {
                    row.setSupplyorg(row.getRequireorg());
                }
                if (j == 0) {
                    if (StringUtils.isBlank((CharSequence)row.getParentbomid())) {
                        nodeId = String.valueOf(genLongIds[i]);
                        ++i;
                    } else {
                        nodeId = row.getParentbomid();
                        idMap.put(nodeId, String.valueOf(genLongIds[i]));
                        nodeId = String.valueOf(genLongIds[i]);
                        ++i;
                    }
                    tree = new TreeNode("0", nodeId, "1", (Object)row);
                    tree.setChildren(new ArrayList());
                    treeList.add(tree);
                    allTreeNode.add(tree);
                    continue;
                }
                if (row.getBomid() == null || idMap.get(row.getBomid()) == null || tree.getTreeNode((String)idMap.get(row.getBomid())) == null) continue;
                TreeNode pNode = tree.getTreeNode((String)idMap.get(row.getBomid()));
                if (StringUtils.isBlank((CharSequence)row.getParentbomid())) {
                    nodeId = String.valueOf(genLongIds[i]);
                    ++i;
                } else {
                    nodeId = row.getParentbomid();
                    idMap.put(nodeId, String.valueOf(genLongIds[i]));
                    nodeId = String.valueOf(genLongIds[i]);
                    ++i;
                }
                TreeNode cNode = new TreeNode(pNode.getId(), nodeId, String.valueOf(Integer.parseInt(pNode.getText()) + 1), (Object)row);
                cNode.setChildren(new ArrayList());
                pNode.addChild(cNode);
                allTreeNode.add(cNode);
            }
        }
        return treeList;
    }

    private Set<Long> getDetailID(DataSet filterDataSet) {
        HashMap<Long, Set> map = new HashMap<Long, Set>(16);
        HashSet<Long> set = new HashSet<Long>(16);
        for (Row row : filterDataSet) {
            Long material = row.getLong("material");
            String materialattr = row.getString("materialattr");
            String supplyOrg = row.getString("supplyorg");
            String supplybilltype = row.getString("supplybilltype");
            String loadKDString = ResManager.loadKDString((String)"\u65b0\u5efa\u534f\u540c\u8ba1\u5212\u5355", (String)"MRPMCalcLongestPath_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
            if ("10060".equals(materialattr) && loadKDString.equals(supplybilltype) && this.ctx.getRequirorgs().contains(supplyOrg)) {
                Set s = map.computeIfAbsent(material, k -> new HashSet());
                s.add(row.getLong("entryid"));
                continue;
            }
            set.add(material);
        }
        HashSet<Long> detailSet = new HashSet<Long>();
        for (Map.Entry entry : map.entrySet()) {
            Long key = (Long)entry.getKey();
            Set value = (Set)entry.getValue();
            if (!set.contains(key)) continue;
            detailSet.addAll(value);
        }
        return detailSet;
    }

    private static /* synthetic */ BigDecimal[] lambda$getReplaceData$4(String k) {
        return new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
    }

    private static /* synthetic */ BigDecimal[] lambda$getReplaceData$3(String k) {
        return new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
    }

    private static /* synthetic */ BigDecimal[] lambda$getReplaceData$2(String k) {
        return new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
    }
}

