/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.event.MRPCollaboratePlanBillClearEvent;
import kd.mmc.mrp.framework.mq.event.MRPPlanOrderClearEvent;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.InventoryModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.model.enums.status.PlanOrderStatus;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.utils.ExtPluginUtil;
import kd.mmc.mrp.utils.MRPClearDataUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;
import kd.sdk.mmc.mrp.extpoint.IMRPClearHistoryDataPlugin;

public class MRPMClearPlanOrder
extends AbstractMRPStep {
    private IMRPExecuteLogRecorder log;
    private String outputType;
    private String outputCollaborativeorder;
    private int clearCount;
    private int clearEntryCount;
    private int clearColCount;
    private boolean isDeleteAuditBill;
    private List<String> orderTypes;
    protected IMRPClearHistoryDataPlugin clearHistoryDataPlugin;
    protected boolean isInitClearPlugin;

    public MRPMClearPlanOrder(IMRPEnvProvider ctx) {
        super(ctx);
        this.log = this.ctx.createLogRecorder();
        this.clearCount = 0;
        this.clearEntryCount = 0;
        this.clearColCount = 0;
        this.isDeleteAuditBill = false;
        this.orderTypes = new ArrayList<String>(3);
        this.clearHistoryDataPlugin = null;
        this.isInitClearPlugin = false;
    }

    protected void innerExecute() {
        this.dataAmount = this.clearPrevDatas();
    }

    public String getStepDesc(Locale locale) {
        return Tips.getClearPlanorders();
    }

    public int clearPrevDatas() {
        InventoryModel inventoryModel;
        InvLevel invLevel;
        QFilter filterRequireOrg;
        String json = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillMaterialKey((String)this.ctx.getMRPContextId()));
        HashSet ms = null;
        if (json != null) {
            ms = new HashSet(JSON.parseArray((String)json, String.class));
        }
        if (ms != null && !ms.isEmpty()) {
            return 0;
        }
        RequireDataModel require = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        this.outputType = require.getOutputType();
        this.outputCollaborativeorder = require.getOutputCollaborativeorder();
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        RunLogModel runLogModel = (RunLogModel)this.ctx.getService(RunLogModel.class);
        IMRPEventManager mqManager = (IMRPEventManager)this.ctx.getService(IMRPEventManager.class);
        boolean isautodropplanbill = (Boolean)planModel.getPlanDataByParam("isautodropplanbill", (Object)false);
        String auditordertype = (String)planModel.getPlanDataByParam("auditordertype", (Object)"");
        for (String type : auditordertype.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)type)) continue;
            this.orderTypes.add(type);
        }
        this.isDeleteAuditBill = isautodropplanbill && !this.orderTypes.isEmpty();
        HashSet supplyOrgs = new HashSet(planModel.getSupplyorgs());
        if (require.isPlanOrderExtendEntity()) {
            Long planscope = runLogModel.getRunLogPlanScope();
            Long singleOrg = null;
            if (planscope > 0L) {
                for (String reqOrg : planModel.getRequirorgs()) {
                    SupplyStruct ss = (SupplyStruct)planModel.getPriorityRelations().get(reqOrg);
                    if (ss == null || !planscope.equals(ss.getPlanScope())) continue;
                    singleOrg = Long.parseLong(reqOrg);
                    break;
                }
            }
            filterRequireOrg = new QFilter("org", "in", singleOrg != null ? Collections.singletonList(singleOrg) : MRPUtil.setStringParseLong((Set)planModel.getRequirorgs()));
            QFilter filterSupplyOrg = new QFilter("proorpurorg", "in", (Object)MRPUtil.setStringParseLong(supplyOrgs));
            List qFilters = MRPClearDataUtil.getMRPClearHistoryDataFilter((IMRPEnvProvider)this.ctx, (QFilter)filterRequireOrg, (QFilter)filterSupplyOrg);
            this.clearOrder(qFilters, filterRequireOrg, filterSupplyOrg);
            if (this.clearCount + this.clearColCount > 0) {
                mqManager.wait4Response();
            }
        }
        if ((invLevel = (inventoryModel = (InventoryModel)this.ctx.getService(InventoryModel.class)).getInvLevel()) != null) {
            filterRequireOrg = new QFilter("org", "in", (Object)MRPUtil.setStringParseLong((Set)planModel.getRequirorgs()));
            List allBaseEntry = invLevel.getAllBaseEntry();
            HashMap<Object, Set> delMaterials = new HashMap<Object, Set>(8);
            List list = planModel.getAllPlanTags();
            QFilter dataSourceFilter = new QFilter("datasource", "=", (Object)"B");
            QFilter status = new QFilter("billstatus", "in", (Object)new String[]{PlanOrderStatus.SAVED.getValue(), PlanOrderStatus.SUBMITED.getValue()});
            for (InvLevelEntry invLevelEntry : allBaseEntry) {
                Object orgId;
                if (!invLevelEntry.isExistDimension("bos_org") || !supplyOrgs.contains((orgId = invLevelEntry.getDimensionValue("bos_org")).toString())) continue;
                Set mtIds = invLevel.getEntryMaterials(invLevelEntry);
                DynamicObject obj = invLevelEntry.getEntry().getDynamicObject("plantag");
                if (obj != null) {
                    if (!list.contains(obj.getLong("id"))) continue;
                    delMaterials.computeIfAbsent(orgId, k -> new HashSet(16)).addAll(mtIds);
                    continue;
                }
                if (!list.isEmpty()) continue;
                delMaterials.computeIfAbsent(orgId, k -> new HashSet(16)).addAll(mtIds);
            }
            for (Map.Entry entry : delMaterials.entrySet()) {
                Object org = entry.getKey();
                Set mts = (Set)entry.getValue();
                QFilter invfilterSupplyOrg = new QFilter("proorpurorg", "=", org);
                QFilter mtFilter = new QFilter("material", "in", (Object)mts);
                this.clearCount += DeleteServiceHelper.delete((String)this.outputType, (QFilter[])new QFilter[]{status, filterRequireOrg, invfilterSupplyOrg, dataSourceFilter, mtFilter});
                QFilter colMtFilter = new QFilter("materiel", "in", (Object)mts);
                QFilter colSupplyOrgFilter = new QFilter("supplyorg", "=", org);
                this.clearColCount += DeleteServiceHelper.delete((String)"mrp_collaborativeorder", (QFilter[])new QFilter[]{status, filterRequireOrg, colSupplyOrgFilter, dataSourceFilter, colMtFilter});
            }
        }
        String info = String.format(ResManager.loadKDString((String)"\u6e05\u7406\u8ba1\u5212\u8ba2\u5355%1$s\u6761\uff0c\u6e05\u7406\u8ba1\u5212\u8ba2\u5355\u5206\u5f55%2$s\u6761\uff0c\u6e05\u7406\u534f\u540c\u8ba1\u5212\u5355%3$s\u6761\u3002", (String)"MRPMClearPlanOrder_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.clearCount, this.clearEntryCount, this.clearColCount);
        this.log.updateStepLog("entrydetailmsg", (Object)info);
        this.log.saveStepLog(false);
        return this.clearCount + this.clearEntryCount + this.clearColCount;
    }

    private void clearOrder(List<QFilter> qFilters, QFilter filterRequireOrg, QFilter filterSupplyOrg) {
        int[] counts;
        filterRequireOrg.__setProperty("org");
        filterSupplyOrg.__setProperty("proorpurorg");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(qFilters);
        try (DataSet dataset = this.ctx.getORM().queryDataSet("MRP-PLANORDER-CLEANER", this.outputType, "id", this.getPlanOrderClearFilters(qFilterList), "");){
            counts = MRPClearDataUtil.clearHisData((DataSet)dataset, (IMRPEnvProvider)this.ctx, (String)this.outputType, (String)"po-clear", MRPPlanOrderClearEvent.class);
            this.clearCount += counts[0];
            this.clearEntryCount += counts[1];
        }
        if (this.isDeleteAuditBill) {
            dataset = this.ctx.getORM().queryDataSet("MRP-PLANORDER-CLEANER", this.outputType, "id", this.getPlanOrderClearFilters(MRPClearDataUtil.getDeleteAuditBillFilters(qFilters, qFilterList, this.orderTypes)), "");
            var6_6 = null;
            try {
                counts = MRPClearDataUtil.clearHisData((DataSet)dataset, (IMRPEnvProvider)this.ctx, (String)this.outputType, (String)"po-clear", MRPPlanOrderClearEvent.class);
                this.clearCount += counts[0];
                this.clearEntryCount += counts[1];
            }
            catch (Throwable counts2) {
                var6_6 = counts2;
                throw counts2;
            }
            finally {
                if (dataset != null) {
                    if (var6_6 != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable counts2) {
                            var6_6.addSuppressed(counts2);
                        }
                    } else {
                        dataset.close();
                    }
                }
            }
        }
        filterRequireOrg.__setProperty("org");
        filterSupplyOrg.__setProperty("supplyorg");
        MRPClearDataUtil.addCollaborativeorderBillStatusFilter(qFilterList);
        dataset = this.ctx.getORM().queryDataSet("MRP-PLANORDER-CLEANER", this.outputCollaborativeorder, "id", this.getCollaborativeOrderClearFilters(qFilterList), "");
        var6_6 = null;
        try {
            counts = MRPClearDataUtil.clearHisData((DataSet)dataset, (IMRPEnvProvider)this.ctx, (String)this.outputCollaborativeorder, (String)"colPlanBill-clear", MRPCollaboratePlanBillClearEvent.class);
            this.clearColCount += counts[0];
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (dataset != null) {
                if (var6_6 != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    dataset.close();
                }
            }
        }
    }

    protected IMRPClearHistoryDataPlugin getClearHistoryDataPlugin() {
        if (!this.isInitClearPlugin) {
            this.clearHistoryDataPlugin = (IMRPClearHistoryDataPlugin)ExtPluginUtil.getProxyPlugin(null, IMRPClearHistoryDataPlugin.class, (String)"MRP_CLEARHISTORYDATA_EXT", null);
            this.isInitClearPlugin = true;
        }
        return this.clearHistoryDataPlugin;
    }

    protected QFilter[] getPlanOrderClearFilters(List<QFilter> qFilterList) {
        IMRPClearHistoryDataPlugin clearHistoryDataPlugin = this.getClearHistoryDataPlugin();
        return clearHistoryDataPlugin == null ? qFilterList.toArray(new QFilter[0]) : clearHistoryDataPlugin.getPlanOrderClearFilters(this.ctx.getMrpSdkEnv(), qFilterList);
    }

    protected QFilter[] getCollaborativeOrderClearFilters(List<QFilter> qFilterList) {
        IMRPClearHistoryDataPlugin clearHistoryDataPlugin = this.getClearHistoryDataPlugin();
        return clearHistoryDataPlugin == null ? qFilterList.toArray(new QFilter[0]) : clearHistoryDataPlugin.getCollaborativeOrderClearFilters(this.ctx.getMrpSdkEnv(), qFilterList);
    }
}

