/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.model.enums.EnvCfgItem;

public class MRPMClearTable
extends AbstractMRPStep {
    private static final Log logger = LogFactory.getLog(MRPMClearTable.class);

    public MRPMClearTable(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public String getStepDesc(Locale locale) {
        return ResManager.loadKDString((String)"\u6e05\u7406\u8ba1\u7b97\u660e\u7ec6\u8868&\u6267\u884c\u7ed3\u679c\u8868\u5386\u53f2\u8bb0\u5f55", (String)"MRPMClearTable_5", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void innerExecute() {
        Throwable throwable;
        String planId = this.ctx.getPlanId();
        ORM orm = ORM.create();
        HashSet<Long> runLogIds = new HashSet<Long>();
        HashSet<String> runLogNums = new HashSet<String>();
        Date date = this.ctx.getPlanDate();
        int hours = (Integer)this.ctx.getCfgValue(EnvCfgItem.HISTORY_CLEAR_DATE_SPAN);
        date = new Date(date.getTime() - (long)hours * 60L * 60L * 1000L);
        IMRPExecuteLogRecorder log = this.ctx.createLogRecorder();
        log.updateStepLog("entrydetailmsg", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u7edf\u8ba1\u5386\u53f2\u6570\u636e...", (String)"MRPMClearTable_9", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
        log.saveStepLog(false);
        long logCollectime = System.currentTimeMillis();
        try (DataSet ds = orm.queryDataSet(MRPMClearTable.class.getName(), "mrp_calcdetail", "id,caculatelog number", new QFilter[]{new QFilter("mrpplan", "=", (Object)Long.valueOf(planId)), new QFilter("createtime", "<", (Object)date)});){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("id");
                runLogIds.add(id);
                String number = row.getString("number");
                runLogNums.add(number);
            }
        }
        logCollectime = System.currentTimeMillis() - logCollectime;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = simpleDateFormat.format(date);
        log.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u6e05\u7406[%1$s]\u4ee5\u524d\u7684\u5386\u53f2\u6570\u636e\uff0c\u7edf\u8ba1\u5386\u53f2\u6570\u636e\u8017\u65f6\uff1a%2$s(MS)\uff0c\u6b63\u5728\u6e05\u7406\u5386\u53f2\u660e\u7ec6\u6570\u636e...", (String)"MRPMClearTable_6", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), dateStr, logCollectime));
        log.updateStepLog("entrydetailmsg_tag", (Object)("logs: " + JSON.toJSONString(runLogNums)));
        log.saveStepLog(false);
        long delDetailTime = System.currentTimeMillis();
        DBRoute scmRoute = new DBRoute("scm");
        int detailEntrySize = 0;
        String querySql = "select fentryid from t_mrp_caldetailentry where fid = ?";
        int clearBatch = (Integer)this.ctx.getCfgValue(EnvCfgItem.PLAN_ORDER_CLEAR_BATCH);
        ArrayList<Object[]> params = new ArrayList<Object[]>(clearBatch);
        Iterator iterator = runLogIds.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"T_MRP_CALCDETAIL", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, (Object)id)});
            throwable = null;
            try {
                try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (DBRoute)scmRoute, (String)querySql, (Object[])new Object[]{id});){
                    for (Row row : dataSet) {
                        params.add(new Object[]{row.getLong(0)});
                        ++detailEntrySize;
                        if (params.size() != clearBatch) continue;
                        DB.executeBatch((DBRoute)scmRoute, (String)"DELETE FROM T_MRP_CALDETAILENTRY WHERE FENTRYID = ?", params);
                        params.clear();
                        log.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u6e05\u7406[%1$s]\u4ee5\u524d\u7684\u5386\u53f2\u6570\u636e\uff0c\u7edf\u8ba1\u5386\u53f2\u6570\u636e\u8017\u65f6\uff1a%2$s(MS)\uff0c\u6e05\u7406\u5386\u53f2\u660e\u7ec6\u6570\u636e\u5206\u5f55\u884c\u6570\uff1a %3$s", (String)"MRPMClearTable_7", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), dateStr, logCollectime, detailEntrySize));
                        log.saveStepLog(false);
                    }
                }
                if (!params.isEmpty()) {
                    DB.executeBatch((DBRoute)scmRoute, (String)"DELETE FROM T_MRP_CALDETAILENTRY WHERE FENTRYID = ?", params);
                    params.clear();
                }
                DB.execute((DBRoute)scmRoute, (String)("DELETE FROM T_MRP_CALCDETAIL WHERE FID = " + id));
            }
            catch (Throwable dataSet) {
                throwable = dataSet;
                throw dataSet;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable dataSet) {
                        throwable.addSuppressed(dataSet);
                    }
                    continue;
                }
                ctx.close();
            }
        }
        delDetailTime = System.currentTimeMillis() - delDetailTime;
        log.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u6e05\u7406[%1$s]\u4ee5\u524d\u7684\u5386\u53f2\u6570\u636e\uff0c\u7edf\u8ba1\u5386\u53f2\u6570\u636e\u8017\u65f6\uff1a%2$s(MS)\uff0c\u6e05\u7406\u5386\u53f2\u660e\u7ec6\u6570\u636e\u5206\u5f55\u884c\u6570\uff1a %3$s, \u6e05\u7406\u5386\u53f2\u660e\u7ec6\u6570\u636e\u8017\u65f6\uff1a%4$s(MS)\uff0c\u6b63\u5728\u6e05\u7406\u6267\u884c\u7ed3\u679c\u8868\u5386\u53f2\u6570\u636e...", (String)"MRPMClearTable_8", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), dateStr, logCollectime, detailEntrySize, delDetailTime));
        log.saveStepLog(false);
        long delPegTime = System.currentTimeMillis();
        querySql = "select fentryid from t_mrp_peginfodataentry where fid = ?";
        int pageEntrySize = 0;
        throwable = null;
        try (DataSet ds = orm.queryDataSet(MRPMClearTable.class.getName(), "mrp_peginfodata", "id", new QFilter[]{new QFilter("billno", "in", runLogNums), new QFilter("createtime", "<", (Object)date)});){
            while (ds.hasNext()) {
                ShardingHintContext ctx;
                block77: {
                    Row row = ds.next();
                    Long id = row.getLong(0);
                    ctx = ShardingHintContext.createAndSet((String)"T_MRP_PEGINFODATA", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, (Object)id)});
                    Throwable throwable2 = null;
                    try {
                        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (DBRoute)scmRoute, (String)querySql, (Object[])new Object[]{id});){
                            for (Row pageRow : dataSet) {
                                params.add(new Object[]{pageRow.getLong(0)});
                                ++pageEntrySize;
                                if (params.size() != clearBatch) continue;
                                DB.executeBatch((DBRoute)scmRoute, (String)"DELETE FROM T_MRP_PEGINFODATAENTRY WHERE FENTRYID = ?", params);
                                params.clear();
                                log.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u6e05\u7406[%1$s]\u4ee5\u524d\u7684\u5386\u53f2\u6570\u636e\uff0c\u7edf\u8ba1\u5386\u53f2\u6570\u636e\u8017\u65f6\uff1a%2$s(MS)\uff0c\u6e05\u7406\u5386\u53f2\u660e\u7ec6\u6570\u636e\u5206\u5f55\u884c\u6570\uff1a %3$s, \u6e05\u7406\u5386\u53f2\u660e\u7ec6\u6570\u636e\u8017\u65f6\uff1a%4$s(MS)\uff0c\u6e05\u7406\u6267\u884c\u7ed3\u679c\u8868\u5386\u53f2\u6570\u636e\u5206\u5f55\u884c\u6570\uff1a %5$s", (String)"MRPMClearTable_10", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), dateStr, logCollectime, detailEntrySize, delDetailTime, pageEntrySize));
                                log.saveStepLog(false);
                            }
                        }
                        if (!params.isEmpty()) {
                            DB.executeBatch((DBRoute)scmRoute, (String)"DELETE FROM T_MRP_PEGINFODATAENTRY WHERE FENTRYID = ?", params);
                            params.clear();
                        }
                        DB.execute((DBRoute)scmRoute, (String)("DELETE FROM T_MRP_PEGINFODATA WHERE FID = " + id));
                        if (ctx == null) continue;
                        if (throwable2 == null) break block77;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (ctx == null) throw throwable4;
                            if (throwable2 == null) {
                                ctx.close();
                                throw throwable4;
                            }
                            try {
                                ctx.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable2.addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                    try {
                        ctx.close();
                        continue;
                    }
                    catch (Throwable throwable6) {
                        throwable2.addSuppressed(throwable6);
                        continue;
                    }
                }
                ctx.close();
            }
        }
        catch (Throwable throwable7) {
            throwable = throwable7;
            throw throwable7;
        }
        delPegTime = System.currentTimeMillis() - delPegTime;
        log.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u6e05\u7406[%1$s]\u4ee5\u524d\u7684\u5386\u53f2\u6570\u636e\uff0c\u7edf\u8ba1\u5386\u53f2\u6570\u636e\u8017\u65f6\uff1a%2$s(MS)\uff0c\u6e05\u7406\u5386\u53f2\u660e\u7ec6\u6570\u636e\u5206\u5f55\u884c\u6570\uff1a %3$s, \u6e05\u7406\u5386\u53f2\u660e\u7ec6\u6570\u636e\u8017\u65f6\uff1a%4$s(MS)\uff0c\u6e05\u7406\u6267\u884c\u7ed3\u679c\u8868\u5386\u53f2\u6570\u636e\u5206\u5f55\u884c\u6570\uff1a %5$s\uff0c\u6e05\u7406\u6267\u884c\u7ed3\u679c\u8868\u5386\u53f2\u6570\u636e\u8017\u65f6\uff1a%6$s(MS)", (String)"MRPMClearTable_11", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), dateStr, logCollectime, detailEntrySize, delDetailTime, pageEntrySize, delPegTime));
        log.saveStepLog(false);
        this.dataAmount = runLogIds.size();
    }
}

