/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.util.Date;
import java.util.Locale;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.mmc.mrp.algox.job.MRPCreatePegInfoJob;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;

public class MRPMCreatePegInfo
extends AbstractMRPStep {
    private static final Log logger = LogFactory.getLog(MRPMCreatePegInfo.class);
    private boolean isRunning = false;
    private boolean isSuccess = false;
    private Object lock;
    private String errorMsg = "";
    private String stackTrace = "";

    public MRPMCreatePegInfo(IMRPEnvProvider ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerExecute() {
        final String runLogNumber = this.ctx.getRunLogNumber();
        Date planDate = this.ctx.getPlanDate();
        final MRPCreatePegInfoJob job = new MRPCreatePegInfoJob(planDate);
        this.isRunning = true;
        this.isSuccess = false;
        this.lock = new Object();
        this.errorMsg = "";
        this.stackTrace = "";
        ThreadPools.executeOnceIncludeRequestContext((String)"mrp-peginfo-create-task", (Runnable)new Runnable(){

            @Override
            public void run() {
                logger.warn(String.format("mrprunner-create-peginfo-datas-start: %s, %s, %s", MRPMCreatePegInfo.this.ctx.getMRPContextId(), runLogNumber, new Date().toLocaleString()));
                try {
                    MRPMCreatePegInfo.this.dataAmount = job.execute(MRPMCreatePegInfo.this.ctx.getMRPContextId(), runLogNumber);
                    MRPMCreatePegInfo.this.isSuccess = true;
                }
                catch (CommitTimeoutException e) {
                    MRPMCreatePegInfo.this.updateErrorStepLog(e, "commit algox task timeout");
                }
                catch (RunningTimeoutException e) {
                    MRPMCreatePegInfo.this.updateErrorStepLog(e, "running algox task timeout");
                }
                catch (Throwable e) {
                    MRPMCreatePegInfo.this.updateErrorStepLog(e, "algox task executed failed");
                }
                finally {
                    MRPMCreatePegInfo.this.isRunning = false;
                }
            }
        }, (String)"mrp");
        long cnt = 0L;
        do {
            try {
                Thread.sleep(3000L);
                String progress = "...";
                if (cnt % 3L == 1L) {
                    progress = "......";
                } else if (cnt % 3L == 2L) {
                    progress = ".........";
                }
                Object object = this.lock;
                synchronized (object) {
                    if (!this.isRunning) {
                        break;
                    }
                    ++cnt;
                    logger.warn(String.format("mrprunner-create-peginfo-datas-waiting: %s, %s, %s", this.ctx.getMRPContextId(), runLogNumber, new Date().toLocaleString()));
                    this.lr.updateStepLog("entrydetailmsg", (Object)("calc peginfo datas" + progress));
                    this.lr.saveStepLog(false);
                }
            }
            catch (InterruptedException e) {
                logger.error((Throwable)e);
            }
        } while (this.isRunning);
        if (this.isSuccess) {
            logger.warn(String.format("mrprunner-create-peginfo-datas-end: %s, %s, %s, %s", this.ctx.getMRPContextId(), runLogNumber, new Date().toLocaleString(), this.dataAmount));
            this.lr.updateStepLog("entrydetailmsg", (Object)ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\u8868\u521b\u5efa\u6210\u529f\u3002", (String)"MRPMCreatePegInfo_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            this.lr.saveStepLog(false);
        } else if (StringUtils.isNotBlank((CharSequence)this.errorMsg)) {
            this.lr.updateStepLog("entrydetailmsg", (Object)this.errorMsg);
            this.lr.updateStepLog("entrydetailmsg_tag", (Object)this.stackTrace);
            this.lr.saveStepLog(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateErrorStepLog(Throwable e, String msg) {
        Object object = this.lock;
        synchronized (object) {
            logger.error(e);
            this.errorMsg = String.format("%s: %s", msg, e.getMessage());
            this.stackTrace = ExceptionUtil.getStackTrace((Throwable)e);
            this.isRunning = false;
        }
    }

    public String getStepDesc(Locale locale) {
        return Tips.getCreatePeginfo();
    }

    public String getAssociateForm() {
        return "mrp_peginfo";
    }
}

