/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.mmc.mrp.common.util.SerializableUtils;
import kd.mmc.mrp.controlnode.framework.step.AbstractPMRPMDataInitStep;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.table.DiffZipMemoryGrid;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.utils.ExtPluginUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.sdk.mmc.mrp.extpoint.IMRPInitBomDataPlugin;
import kd.sdk.mmc.mrp.framework.res.IResModelDataTable;

public class MRPMGetBOMData
extends AbstractPMRPMDataInitStep<BOMStructDataTable> {
    public MRPMGetBOMData(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public String getStepDesc(Locale locale) {
        return Tips.getGetBomDatas();
    }

    @Override
    protected BOMStructDataTable pumpDatas() {
        long start = System.currentTimeMillis();
        BOMStructDataTable table = this.ctx.createBOMDatas(this.lr);
        long dataPrepareTS = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        String json = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillMaterialKey((String)this.ctx.getMRPContextId()));
        HashSet mIds = new HashSet();
        if (json != null) {
            mIds = new HashSet(JSON.parseArray((String)json, String.class));
        }
        table.batchRefreshShareSettings();
        table.genOrderBomByConfig();
        if (!"mrp_cps_runner".equals(this.ctx.getRunMode())) {
            table.refreshLLC(this.ctx.isReplace(), mIds);
        } else {
            table.refreshLLC(this.ctx.isReplace(), null);
        }
        if (!mIds.isEmpty()) {
            RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
            for (Set l : table.getLLC()) {
                mIds.addAll(l);
            }
            if (!requireDataModel.isIs_single_calc()) {
                MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillMaterialKey((String)this.ctx.getMRPContextId()), JSON.toJSONString(mIds));
            }
            MtPlanInfoModel planInfo = (MtPlanInfoModel)this.ctx.getService(MtPlanInfoModel.class);
            planInfo.createMaterialTableByMid(mIds);
        }
        this.ctx.getFlexDataTable().loadFlexDatasByBOM();
        long loadLLCTS = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        this.ctx.loadBOMMaterialExtProps();
        long loadExtTS = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        boolean isFlexPropMatch = (Boolean)this.ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
        table.initReplaceInfo(isFlexPropMatch);
        boolean isReplace = this.ctx.isReplace();
        if (isReplace) {
            table.initDependentReqStruct(this.ctx);
        }
        this.updateBomData(table);
        long loadReplaceTS = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        this.dataAmount = table.getSrcDatas().getDatas().size();
        if (MRPUtil.isByMQ()) {
            MRPCacheManager.getInst().setBOMTableColIdx((CalEnv)this.ctx, table.getColIdx(), MRPUtil.getCacheSplitSize());
            boolean isDynamicBOM = (Boolean)this.ctx.getCfgValue(EnvCfgItem.DYNAMIC_BOM_RESTORE);
            if (isDynamicBOM && !"mrp_cps_runner".equals(this.ctx.getRunMode())) {
                MRPCacheManager.getInst().setBOMTableSrcDataByGroup((CalEnv)this.ctx, table);
                table.clear();
            } else {
                MRPCacheManager.getInst().setBOMTableSrcData((CalEnv)this.ctx, table.getSrcDatas().getDatas().iterator());
            }
            HashMap replaceGroupCache = new HashMap(table.getMainMaterialGroup().size());
            for (Map.Entry entry : table.getMainMaterialGroup().entrySet()) {
                replaceGroupCache.put(entry.getKey(), SerializableUtils.toSerializedString(entry.getValue()));
            }
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getReplaceStructTable((String)this.ctx.getMRPContextId()), JSON.toJSONString(replaceGroupCache));
            if (!table.getShareCache().isEmpty()) {
                MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getBOMShareCacheKey((String)this.ctx.getMRPContextId()), JSON.toJSONString((Object)table.getShareCache()));
            }
        }
        long setRedisCacheTS = System.currentTimeMillis() - start;
        if (table.getSrcDatas().getDatas() instanceof DiffZipMemoryGrid) {
            this.lr.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u83b7\u53d6BOM\u6570\u636e\u8017\u65f6: %1$s(ms), \u4f4e\u4f4d\u7801\u603b\u5c42\u7ea7\uff1a%2$s, \u4f4e\u4f4d\u7801\u8ba1\u7b97\u8017\u65f6\uff1a%3$s(ms), \u52a0\u8f7d\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u8017\u65f6: %4$s(ms), \u52a0\u8f7d\u66ff\u4ee3\u7ed3\u6784\u8017\u65f6: %5$s(ms), \u5199\u5165redis\u7f13\u5b58\u8017\u65f6: %6$s(ms), BOM%7$s", (String)"MRPMGetBOMData_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), dataPrepareTS, table.getLLC().size(), loadLLCTS, loadExtTS, loadReplaceTS, setRedisCacheTS, table.getSrcDatas().getDatas().toString()));
        } else {
            this.lr.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u83b7\u53d6BOM\u6570\u636e\u8017\u65f6: %1$s(ms), \u4f4e\u4f4d\u7801\u603b\u5c42\u7ea7\uff1a%2$s, \u4f4e\u4f4d\u7801\u8ba1\u7b97\u8017\u65f6\uff1a%3$s(ms), \u52a0\u8f7d\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u8017\u65f6: %4$s(ms), \u52a0\u8f7d\u66ff\u4ee3\u7ed3\u6784\u8017\u65f6: %5$s(ms), \u5199\u5165redis\u7f13\u5b58\u8017\u65f6: %6$s(ms)", (String)"MRPMGetBOMData_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), dataPrepareTS, table.getLLC().size(), loadLLCTS, loadExtTS, loadReplaceTS, setRedisCacheTS));
        }
        return table;
    }

    protected void updateBomData(BOMStructDataTable table) {
        IMRPInitBomDataPlugin imrpInitBomDataPlugin = (IMRPInitBomDataPlugin)ExtPluginUtil.getProxyPlugin(null, IMRPInitBomDataPlugin.class, (String)"MRP_INITBOMDATA_EXT", null);
        if (imrpInitBomDataPlugin != null) {
            imrpInitBomDataPlugin.updateBomData((IResModelDataTable)table);
        }
    }
}

