/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.enums.MaterialAttrEnum;
import kd.mmc.mrp.common.util.SnapshotDataUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.rpt.enmus.RptTypeEnum;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;
import kd.mmc.mrp.rpt.util.CalcProductionForecastUtils;
import kd.mmc.mrp.rpt.util.RptUtils;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPSaveProductionForecast
extends AbstractMRPStep {
    private static final Log logger = LogFactory.getLog(MRPSaveProductionForecast.class);
    protected static final String[] fixFields = new String[]{"offeringid", "offeringno", "offeringname", "supplyorg", "demandmodel", "operator", "qty", "isdemandmaterial"};
    protected static final DataType[] fixTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.BigDecimalType, DataType.BooleanType};
    protected static final String[] calcResultFields = new String[]{"entryentity.material", "entryentity.supplyorg", "entryentity.demanddate", "entryentity.demandqty", "entryentity.adjustdate", "entryentity.requireoperator", "entryentity.billentryseq", "entryentity.demandbilltype", "entryentity.billno", "entryentity.llc", "entryentity.reqsourcebillno", "entryentity.adjustqty"};
    protected static final DataType[] calcResultTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.DateType, DataType.BigDecimalType, DataType.DateType, DataType.LongType, DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType};
    protected static final String[] materialPlanFields = new String[]{"masterid", "createorg", "operator", "demandmodel"};
    protected static final DataType[] materialPlanTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType};
    protected static final String[] invFields = new String[]{"id", "material", "qty"};
    protected static final DataType[] invFieldsType = new DataType[]{DataType.LongType, DataType.LongType, DataType.BigDecimalType};
    private static final String algoKey = MRPSaveProductionForecast.class.getName();
    private final Long versionId;
    private Set<Long> materialIds = new HashSet<Long>(8);
    private Set<Long> supplyorgIds = new HashSet<Long>(8);

    public MRPSaveProductionForecast(IMRPEnvProvider ctx) {
        super(ctx);
        this.versionId = SnapshotDataUtils.getVersionIdByRunLogNumber((String)ctx.getRunLogNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerExecute() {
        long planId = Long.parseLong(this.ctx.getPlanId());
        String planNo = this.ctx.getRunLog().getString("number");
        try {
            RptSchemeInfo rptSchemeInfo = RptUtils.getRptSchemeInfo((long)0L, (String)RptTypeEnum.PRODUCTION_FORECAST.getValue());
            if (rptSchemeInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u62a5\u8868\u65b9\u6848\u3002", (String)"MRPSaveProductionForecast_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            }
            List plan = rptSchemeInfo.getPlan();
            if (plan.size() > 0 && !plan.contains(planId)) {
                return;
            }
            Set<String> materialIds = this.getAllMaterialIds();
            List source = rptSchemeInfo.getSource();
            DataSet detailDataSet = this.queryMrpCalcDetail(materialIds, rptSchemeInfo);
            Date historyEarlyDate = null;
            Date lastestDate = null;
            for (Row row2 : detailDataSet.copy()) {
                Date date = row2.getDate("entryentity.demanddate");
                if (historyEarlyDate == null) {
                    historyEarlyDate = date;
                }
                if (lastestDate == null) {
                    lastestDate = date;
                }
                if (date != null && date.compareTo(historyEarlyDate) <= 0) {
                    historyEarlyDate = date;
                }
                if (date == null || date.compareTo(lastestDate) <= 0) continue;
                lastestDate = date;
            }
            Map params = RptUtils.createParams((RptSchemeInfo)rptSchemeInfo, historyEarlyDate, lastestDate);
            DataSet materialBaseDataSet = CalcProductionForecastUtils.queryMaterialBaseInfo((String)algoKey, (Long)this.versionId, this.materialIds);
            DataSet materialPlanDataSet = CalcProductionForecastUtils.queryMaterialPlanInfo((String)algoKey, this.stringToLong(materialIds), this.supplyorgIds);
            Map planInfo = CalcProductionForecastUtils.getPlanInfos((Long)this.versionId, (long)planId);
            DataSet materialInvDataSet = CalcProductionForecastUtils.queryMaterialInventory((String)algoKey, (Long)this.versionId, this.materialIds, (Set)((Set)planInfo.get("storageorg")), (Set)((Set)planInfo.get("warehouse")), (Set)((Set)planInfo.get("location")), (RptSchemeInfo)rptSchemeInfo);
            DataSet dataSet = CalcProductionForecastUtils.createRefrenceDataSet((DataSet)detailDataSet, (DataSet)materialBaseDataSet, (DataSet)materialPlanDataSet, (DataSet)materialInvDataSet);
            dataSet = CalcProductionForecastUtils.createNewDataSet((String)algoKey, (Map)params, (DataSet)dataSet, (List)source);
            dataSet.copy().forEach(row -> ++this.dataAmount);
            CalcProductionForecastUtils.createForecastDatas((DataSet)dataSet, (String)planNo, (Map)params);
        }
        catch (Exception e) {
            logger.error("\u751f\u4ea7\u9884\u6d4b\u751f\u4ea7\u5f02\u5e38", (Throwable)e);
            this.lr.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u9884\u6d4b\u751f\u6210\u5f02\u5e38\uff1a%s", (String)"MRPSaveProductionForecast_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), e.getMessage()));
            this.lr.updateStepLog("entrydetailmsg_tag", (Object)MRPUtil.getStackTrace((Throwable)e));
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    private Set<String> getAllMaterialIds() {
        List llcMaterialIds = this.ctx.bomDatas().getLLC();
        Set requireMaterialIds = this.ctx.bomDatas().getRequireMaterials();
        HashSet<String> materialIds = new HashSet<String>(requireMaterialIds);
        for (Set ids : llcMaterialIds) {
            materialIds.addAll(ids);
        }
        return materialIds;
    }

    private DataSet queryMrpCalcDetail(Set<String> materialIds, RptSchemeInfo rptSchemeInfo) {
        List source = rptSchemeInfo.getSource();
        ArrayList billType = new ArrayList(8);
        if (source != null && !source.isEmpty()) {
            DynamicObjectCollection dataConfigs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)source)});
            dataConfigs.forEach(dataConfig -> billType.add(dataConfig.getString("name")));
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])calcResultFields, (DataType[])calcResultTypes);
        Algo algo = Algo.create((String)algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        for (String materialId : materialIds) {
            List materialDetails = MRPCacheManager.getInst().getMaterialDetails((CalEnv)this.ctx, materialId);
            for (Map materialDetail : materialDetails) {
                BigDecimal demandqty;
                BigDecimal supplyqty;
                String supplybillf7;
                String[] materialattr = String.valueOf(materialDetail.get("materialattr"));
                if (!StringUtils.equals((CharSequence)MaterialAttrEnum.FABRICATEDPART.getValue(), (CharSequence)materialattr)) continue;
                String adjustsuggest = (String)materialDetail.get("adjustsuggest");
                if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u5efa\u8bae\u53d6\u6d88", (String)"MRPSaveProductionForecast_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), (CharSequence)adjustsuggest) || (supplybillf7 = (String)materialDetail.get("supplybillf7")) != null && supplybillf7.contains("inv") || (supplyqty = (BigDecimal)materialDetail.get("supplyqty")) == null || BigDecimal.ZERO.compareTo(supplyqty) == 0 || (demandqty = (BigDecimal)materialDetail.get("demandqty")) == null || BigDecimal.ZERO.compareTo(demandqty) == 0) continue;
                String demandbilltype = (String)materialDetail.get("demandbilltype");
                if (!billType.isEmpty() && !billType.contains(demandbilltype)) continue;
                Long material = (Long)materialDetail.get("material");
                Object supplyorg = materialDetail.get("supplyorg");
                supplyorg = supplyorg == null ? Long.valueOf(0L) : (supplyorg instanceof Integer ? Long.valueOf(String.valueOf(supplyorg)) : supplyorg);
                Long demanddate = (Long)materialDetail.get("demanddate");
                Date demandDate = demanddate == null ? null : new Date(demanddate);
                Long adjustdate = (Long)materialDetail.get("adjustdate");
                Long requireoperator = (Long)materialDetail.get("requireoperator");
                Integer billentryseq = (Integer)materialDetail.get("billentryseq");
                String billno = (String)materialDetail.get("billno");
                String llc = (String)materialDetail.get("llc");
                String reqsourcebillno = (String)materialDetail.get("reqsourcebillno");
                BigDecimal adjustqty = (BigDecimal)materialDetail.get("adjustqty");
                Object[] value = new Object[]{material, supplyorg, demandDate, demandqty, adjustdate == null ? null : new Date(adjustdate), requireoperator == null ? Long.valueOf(0L) : requireoperator, billentryseq == null ? Integer.valueOf(0) : billentryseq, demandbilltype, billno, llc, reqsourcebillno, adjustqty == null ? BigDecimal.ZERO : adjustqty};
                dataSetBuilder.append(value);
                this.materialIds.add(material);
                this.supplyorgIds.add((Long)supplyorg);
            }
        }
        DataSet dataSet = dataSetBuilder.build();
        DataSet noResourceDataSet = dataSet.copy().filter("entryentity.reqsourcebillno ==null or entryentity.reqsourcebillno ==''");
        DataSet filterMinSet = noResourceDataSet.groupBy(new String[]{"entryentity.billentryseq", "entryentity.demandbilltype", "entryentity.billno"}).min("cast(entryentity.llc as Integer)", "llc").finish();
        filterMinSet = filterMinSet.addField("'1'", "isdemandmaterial");
        filterMinSet = filterMinSet.addField("cast(llc as String)", "llcStr");
        noResourceDataSet = noResourceDataSet.leftJoin(filterMinSet).on("entryentity.billentryseq", "entryentity.billentryseq").on("entryentity.demandbilltype", "entryentity.demandbilltype").on("entryentity.billno", "entryentity.billno").on("entryentity.llc", "llcStr").select(noResourceDataSet.getRowMeta().getFieldNames(), new String[]{" isdemandmaterial"}).finish();
        String[] fieldNames = noResourceDataSet.getRowMeta().getFieldNames();
        StringBuilder select = new StringBuilder();
        for (String fieldName : fieldNames) {
            if ("isdemandmaterial".equals(fieldName)) continue;
            select.append(fieldName).append(',');
        }
        select.append(" case when isdemandmaterial !=null then isdemandmaterial else  '0' end as isdemandmaterial");
        noResourceDataSet = noResourceDataSet.select(select.toString());
        DataSet resourceDataSet = dataSet.copy().filter("entryentity.reqsourcebillno != null and entryentity.reqsourcebillno != ''");
        DataSet reqSourceFilterSet = resourceDataSet.groupBy(new String[]{"entryentity.reqsourcebillno"}).min("cast(entryentity.llc as Integer)", "llc").finish();
        reqSourceFilterSet = reqSourceFilterSet.addField("'1'", "isdemandmaterial");
        reqSourceFilterSet = reqSourceFilterSet.addField("cast(llc as String)", "llcStr");
        resourceDataSet = resourceDataSet.leftJoin(reqSourceFilterSet).on("entryentity.reqsourcebillno", "entryentity.reqsourcebillno").on("entryentity.llc", "llcStr").select(resourceDataSet.getRowMeta().getFieldNames(), new String[]{" isdemandmaterial"}).finish();
        fieldNames = resourceDataSet.getRowMeta().getFieldNames();
        select = new StringBuilder();
        for (String fieldName : fieldNames) {
            if ("isdemandmaterial".equals(fieldName)) continue;
            select.append(fieldName).append(',');
        }
        select.append(" case when isdemandmaterial !=null then isdemandmaterial else  '0' end as isdemandmaterial");
        resourceDataSet = resourceDataSet.select(select.toString());
        dataSet = noResourceDataSet.union(resourceDataSet);
        return dataSet;
    }

    private Set<Long> stringToLong(Set<String> strings) {
        HashSet<Long> sets = new HashSet<Long>(strings.size());
        for (String str : strings) {
            sets.add(Long.valueOf(str));
        }
        return sets;
    }

    public String getStepDesc(Locale locale) {
        return Tips.getSaveProductionforecast();
    }
}

