/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.param.AppParam;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mmc.mrp.common.entity.forecast.PurParam;
import kd.mmc.mrp.common.enums.DataType;
import kd.mmc.mrp.common.enums.DateType;
import kd.mmc.mrp.common.operate.PurForecastOperate;
import kd.mmc.mrp.common.result.PurForecastOperationPram;
import kd.mmc.mrp.common.result.PurForecastOperationResult;
import kd.mmc.mrp.common.util.DateUtils;
import kd.mmc.mrp.common.util.ForecastUtils;
import kd.mmc.mrp.common.util.SnapshotDataUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.model.enums.strategy.BillAdjustStrategy;
import kd.mmc.mrp.model.enums.strategy.BillSplitStrategy;
import kd.mmc.mrp.model.struct.PurForecastSumKey;
import kd.mmc.mrp.mservice.api.fcast.PurForecastReleaseService;
import kd.mmc.mrp.mservice.fcast.PurForecastReleaseServiceImpl;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPSavePurForecast
extends AbstractMRPStep {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final Log log = LogFactory.getLog(MRPSavePurForecast.class);
    private final ORM orm;
    private final Calendar calendar;
    private final DBRoute dbRoute;
    private final String calculatelog;
    private final Long versionId;
    protected boolean isSumOnlyByMaterial;
    protected boolean isConsiderLeadTime;
    protected boolean isauto_release;
    private Long dataset;
    private Long startDate;
    private boolean ispurchasedpart;
    private boolean isexternalprocessinpart;
    private static final int DAY = 28;
    private static final int WEEK = 75;

    public MRPSavePurForecast(IMRPEnvProvider ctx) {
        super(ctx);
        this.calculatelog = ctx.getRunLogNumber();
        this.versionId = SnapshotDataUtils.getVersionIdByRunLogNumber((String)ctx.getRunLogNumber());
        this.orm = ORM.create();
        this.dbRoute = DBRoute.of((String)"scm");
        this.calendar = Calendar.getInstance();
    }

    protected void innerExecute() {
        long planId = Long.parseLong(this.ctx.getPlanId());
        String sumdim = "A";
        String forecast_inputtype = "A";
        this.isauto_release = false;
        this.dataset = 0L;
        QFilter qFilter = new QFilter("createorg", "=", (Object)Long.parseLong(this.ctx.getPlanOrgId()));
        qFilter.and("mrpplanprogram", "=", (Object)planId);
        qFilter.and("enable", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"mrp_dateset", (String)"id,sumdim,forecast_inputtype,isauto_release", (QFilter[])new QFilter[]{qFilter}, null, (int)1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                sumdim = row.getString("sumdim");
                forecast_inputtype = row.getString("forecast_inputtype");
                this.dataset = row.getLong("id");
                this.isauto_release = row.getBoolean("isauto_release");
            }
        }
        this.isSumOnlyByMaterial = !StringUtils.equals((CharSequence)sumdim, (CharSequence)"B");
        this.isConsiderLeadTime = !StringUtils.equals((CharSequence)forecast_inputtype, (CharSequence)"B");
        AppParam appParam = new AppParam("0MBBBZ1L5IAW", Long.valueOf(this.ctx.getPlanOrgId()));
        Map mrpParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        this.ispurchasedpart = (Boolean)mrpParam.get("ispurchasedpart");
        this.isexternalprocessinpart = (Boolean)mrpParam.get("isexternalprocessinpart");
        Set<String> materialIds = this.getAllMaterialIds();
        List<Object> values = Lists.newArrayListWithCapacity((int)materialIds.size());
        Map<String, Long> id2Unit = this.loadUnit(materialIds);
        for (String string : materialIds) {
            this.getStartDate(string);
        }
        PurParam purParam = this.wrapperPurParam(planId);
        for (String mid : materialIds) {
            this.executeHandle(mid, purParam, (List<Object[]>)values, id2Unit);
        }
        if (values.isEmpty()) {
            return;
        }
        long l = this.orm.genLongId("mrp_pur_fctdata");
        String insertSql = this.getInsertSql();
        this.savePurHead(purParam, l, planId, sumdim);
        ArrayList<Object> entryIds = new ArrayList<Object>(values.size() * 2);
        values = this.mergeValue((List<Object[]>)values, l, entryIds);
        ForecastUtils.batchSave((DBRoute)this.dbRoute, (String)insertSql, (List)values);
        if (this.isauto_release) {
            PurForecastOperationPram pram = PurForecastOperationPram.initPram((String)"release");
            PurForecastOperationResult result = PurForecastOperate.execute((String)"release", new HashMap(0), entryIds, (PurForecastOperationPram)pram);
            SaveServiceHelper.update((DynamicObject[])result.getData().toArray(new DynamicObject[0]));
            PurForecastReleaseService purForecastReleaseService = this.getPurForecastReleaseService();
            purForecastReleaseService.releaseForecast2pm(result.getOperationResult().getSuccessPkIds());
        }
        this.dataAmount += values.size();
    }

    protected PurForecastReleaseService getPurForecastReleaseService() {
        return new PurForecastReleaseServiceImpl();
    }

    private void getStartDate(String materialId) {
        Iterator materialDetails = MRPCacheManager.getInst().getMaterialDetails2((CalEnv)this.ctx, materialId);
        while (materialDetails.hasNext()) {
            Map materialDetail = (Map)materialDetails.next();
            if (!this.isEffectData(materialDetail, materialId)) continue;
            Long adjustDate = (Long)MRPUtil.convert(materialDetail.get("adjustdate"), (Object)0L);
            Long supplyDate = (Long)MRPUtil.convert(materialDetail.get("supplydate"), (Object)0L);
            Long l = supplyDate = adjustDate > 0L ? adjustDate : supplyDate;
            if (!this.isConsiderLeadTime) {
                supplyDate = (Long)MRPUtil.convert(materialDetail.get("top_require_date"), (Object)0L);
            }
            if (this.startDate == null) {
                this.startDate = supplyDate;
                continue;
            }
            if (this.startDate <= supplyDate) continue;
            this.startDate = supplyDate;
        }
    }

    private boolean isEffectData(Map<String, Object> materialDetail, String materialId) {
        Object orgId = materialDetail.get("supplyorg");
        if (orgId == null) {
            return false;
        }
        Object[] mPlanInfo = this.getMaterialPlan(materialId, orgId.toString(), this.ctx.getAllPlanTags());
        if (mPlanInfo == null) {
            return false;
        }
        String adjust = (String)kd.bos.algo.DataType.convertValue((kd.bos.algo.DataType)kd.bos.algo.DataType.StringType, (Object)materialDetail.get("adjustsuggest"));
        if (StringUtils.equals((CharSequence)BillAdjustStrategy.CANCEL.getAlias(), (CharSequence)adjust)) {
            return false;
        }
        String supplyType = (String)kd.bos.algo.DataType.convertValue((kd.bos.algo.DataType)kd.bos.algo.DataType.StringType, (Object)materialDetail.get("supplybillf7"));
        boolean isCommonSupplyType = "mrp_planorder".equals(supplyType) || "pm_purorderbill".equals(supplyType) || "pm_purapplybill".equals(supplyType) || "om_mftorder".equals(supplyType);
        String materialAttr = (String)kd.bos.algo.DataType.convertValue((kd.bos.algo.DataType)kd.bos.algo.DataType.StringType, (Object)materialDetail.get("materialattr"));
        boolean isPur = "10040".equals(materialAttr) && isCommonSupplyType;
        boolean isExt = "10050".equals(materialAttr) && isCommonSupplyType;
        return isPur && this.ispurchasedpart || isExt && this.isexternalprocessinpart;
    }

    private void executeHandle(String materialId, PurParam purParam, List<Object[]> values, Map<String, Long> id2Unit) {
        Iterator materialDetails = MRPCacheManager.getInst().getMaterialDetails2((CalEnv)this.ctx, materialId);
        if (!materialDetails.hasNext()) {
            return;
        }
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        HashMap<String, Object[]> adviseMap = new HashMap<String, Object[]>(16);
        Long unitId = id2Unit.getOrDefault(materialId, 0L);
        HashMap sumKey2filteredDetails = Maps.newHashMapWithExpectedSize((int)8);
        HashMap sumKey2idx2Plan = Maps.newHashMapWithExpectedSize((int)8);
        while (materialDetails.hasNext()) {
            String orgId;
            Object[] mPlanInfo;
            Map materialDetail = (Map)materialDetails.next();
            if (!this.isEffectData(materialDetail, materialId) || (mPlanInfo = this.getMaterialPlan(materialId, orgId = String.valueOf(materialDetail.get("supplyorg")), this.ctx.getAllPlanTags())) == null) continue;
            mPlanInfo[3] = unitId;
            String supplyType = (String)kd.bos.algo.DataType.convertValue((kd.bos.algo.DataType)kd.bos.algo.DataType.StringType, materialDetail.get("supplybillf7"));
            BillSplitStrategy adjustType = this.ctx.strategys().getOrDefault(supplyType, BillSplitStrategy.PART);
            Long aux = (Long)MRPUtil.convert(materialDetail.get("supplyauxpty"), (Object)0L);
            long org = (Long)MRPUtil.convert(materialDetail.get("requireorg"), (Object)0L);
            if (org <= 0L) {
                org = (Long)MRPUtil.convert(materialDetail.get("supplyorg"), (Object)0L);
            }
            long purOrg = cacheDatas.getPurOrgBySupplyOrg(Long.valueOf(org));
            long supplier = this.isSumOnlyByMaterial ? 0L : this.getSupplier(materialDetail);
            PurForecastSumKey purForecastSumKey = new PurForecastSumKey(this.isSumOnlyByMaterial);
            purForecastSumKey.setAux(aux);
            purForecastSumKey.setOrg(Long.valueOf(org));
            purForecastSumKey.setPurOrg(Long.valueOf(purOrg));
            purForecastSumKey.setSupplier(Long.valueOf(supplier));
            List filteredDetails = sumKey2filteredDetails.computeIfAbsent(purForecastSumKey, k -> new ArrayList());
            Map idx2Plan = sumKey2idx2Plan.computeIfAbsent(purForecastSumKey, k -> new HashMap());
            filteredDetails.add(materialDetail);
            idx2Plan.put(filteredDetails.size() - 1, mPlanInfo);
            String adjust = (String)kd.bos.algo.DataType.convertValue((kd.bos.algo.DataType)kd.bos.algo.DataType.StringType, materialDetail.get("adjustsuggest"));
            if (BillSplitStrategy.WHOLE != adjustType || !StringUtils.equals((CharSequence)BillAdjustStrategy.ADVANCE.getAlias(), (CharSequence)adjust) && !StringUtils.equals((CharSequence)BillAdjustStrategy.DELAY.getAlias(), (CharSequence)adjust)) continue;
            BigDecimal adjustQty = MRPUtil.toBigDecimal(materialDetail.get("adjustqty"));
            Long adjustDate = (Long)MRPUtil.convert(materialDetail.get("adjustdate"), (Object)0L);
            Object[] objects = new Object[]{adjustQty, adjustDate};
            adviseMap.put(this.getAdviseKey(materialDetail), objects);
        }
        if (sumKey2filteredDetails.isEmpty()) {
            return;
        }
        for (Map.Entry entry : sumKey2filteredDetails.entrySet()) {
            PurForecastSumKey key = (PurForecastSumKey)entry.getKey();
            List filteredDetails = (List)entry.getValue();
            Map idx2Plan = (Map)sumKey2idx2Plan.get(key);
            values.add(this.handle(materialId, idx2Plan, filteredDetails, purParam, adviseMap, key));
        }
    }

    protected Long getSupplier(Map<String, Object> materialDetail) {
        return (Long)MRPUtil.convert((Object)materialDetail.get("supplysupplier"), (Object)0L);
    }

    private String getAdviseKey(Map<String, Object> materialDetail) {
        String supplyType = (String)kd.bos.algo.DataType.convertValue((kd.bos.algo.DataType)kd.bos.algo.DataType.StringType, (Object)materialDetail.get("supplybillf7"));
        String billId = String.valueOf(materialDetail.get("supplybillid"));
        String billEntryId = String.valueOf(materialDetail.get("supplybillentryid"));
        return String.format("%s@@##%s@@##%s", supplyType, billId, billEntryId);
    }

    private Object[] handle(String materialId, Map<Integer, Object[]> idx2Plan, List<Map<String, Object>> filteredDetails, PurParam purParam, Map<String, Object[]> adviseMap, PurForecastSumKey key) {
        Object[] value = this.initValue(materialId, key);
        this.setDateQty(filteredDetails, idx2Plan, value, purParam, adviseMap);
        this.setWasteQty(value, purParam, key.getAux());
        return value;
    }

    private void setWasteQty(Object[] value, PurParam purParam, Long aux) {
        QFilter materialFilter = new QFilter("material", "=", value[3]);
        QFilter auxFilter = new QFilter("auxpty", "=", (Object)aux);
        QFilter warehouseFilter = new QFilter("warehouse", "in", (Object)purParam.getWarehouseIds());
        QFilter orgFilter = new QFilter("org", "in", (Object)purParam.getOrgIds());
        Long dataVersionId = purParam.getVersionId();
        try (DataSet dataSet = SnapshotDataUtils.queryDataSet((String)this.algoKey, (Long)dataVersionId, (String)"im_inv_realbalance", (String)"baseqty", (QFilter[])new QFilter[]{materialFilter, auxFilter, warehouseFilter, orgFilter});){
            for (Row row : dataSet) {
                value[8] = ((BigDecimal)value[8]).add(row.getBigDecimal("baseqty"));
            }
        }
    }

    private void setDateQty(List<Map<String, Object>> materialDetails, Map<Integer, Object[]> idx2Plan, Object[] value, PurParam purParam, Map<String, Object[]> adviseMap) {
        HashMap<String, BigDecimal> summaryDateQtyMap = new HashMap<String, BigDecimal>(16);
        HashSet<String> adviseKeySet = new HashSet<String>(adviseMap.size());
        for (int i = 0; i < materialDetails.size(); ++i) {
            Map<String, Object> materialDetail = materialDetails.get(i);
            Object[] materialPlan = idx2Plan.get(i);
            if (i == 0) {
                value[4] = materialPlan[3];
                value[5] = materialPlan[2];
                value[12] = materialPlan[4];
            }
            this.summaryQtyByDate(materialPlan, summaryDateQtyMap, materialDetail, purParam, adviseMap, adviseKeySet);
            this.updateValue(value, materialDetail);
        }
        BigDecimal totalQty = this.getTotalQty(summaryDateQtyMap);
        value[10] = SerializationUtils.toJsonString(summaryDateQtyMap);
        value[9] = totalQty;
    }

    protected void updateValue(Object[] value, Map<String, Object> materialDetail) {
    }

    private BigDecimal getTotalQty(Map<String, BigDecimal> summaryDateQtyMap) {
        BigDecimal totalQty = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : summaryDateQtyMap.entrySet()) {
            BigDecimal qty = entry.getValue();
            totalQty = totalQty.add(qty);
        }
        return totalQty;
    }

    private void summaryQtyByDate(Object[] materialPlan, Map<String, BigDecimal> summaryDateQtyMap, Map<String, Object> materialDetail, PurParam purParam, Map<String, Object[]> adviseMap, Set<String> adviseKeySet) {
        String supplyType = (String)kd.bos.algo.DataType.convertValue((kd.bos.algo.DataType)kd.bos.algo.DataType.StringType, (Object)materialDetail.get("supplybillf7"));
        BillSplitStrategy adjustType = this.ctx.strategys().getOrDefault(supplyType, BillSplitStrategy.PART);
        String adjust = (String)materialDetail.get("adjustsuggest");
        BigDecimal supplyQty = MRPUtil.toBigDecimal((Object)materialDetail.get("supplyqty"));
        Long supplyDate = (Long)MRPUtil.convert((Object)materialDetail.get("supplydate"), (Object)0L);
        BigDecimal adjustQty = MRPUtil.toBigDecimal((Object)materialDetail.get("adjustqty"));
        Long adjustDate = (Long)MRPUtil.convert((Object)materialDetail.get("adjustdate"), (Object)0L);
        Long date = supplyDate;
        BigDecimal qty = supplyQty;
        switch (adjustType) {
            case PART: {
                date = BillAdjustStrategy.ADVANCE.getAlias().equalsIgnoreCase(adjust) || BillAdjustStrategy.DELAY.getAlias().equalsIgnoreCase(adjust) ? adjustDate : supplyDate;
                qty = supplyQty;
                break;
            }
            case WHOLE: {
                String key = this.getAdviseKey(materialDetail);
                Object[] data = adviseMap.get(key);
                if (data != null) {
                    if (adviseKeySet.add(key)) {
                        date = (Long)data[1];
                        qty = (BigDecimal)data[0];
                        break;
                    }
                    date = 0L;
                    qty = null;
                    break;
                }
                date = supplyDate;
                qty = supplyQty;
                break;
            }
        }
        if (qty == null || qty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (this.isConsiderLeadTime) {
            this.calendar.setTimeInMillis(date);
            int afterProgressCount = (Integer)materialPlan[1];
            this.calendar.add(5, -afterProgressCount);
        } else {
            date = (Long)MRPUtil.convert((Object)materialDetail.get("top_require_date"), (Object)0L);
            this.calendar.setTimeInMillis(date);
        }
        Date processedDate = this.calendar.getTime();
        String operateDateStr = DateUtils.formatDate((Date)processedDate);
        List dateCols = purParam.getDateCols();
        Map firstDay2DateCol = purParam.getFirstDay2DateCol();
        boolean isFind = false;
        for (int i = 1; i < dateCols.size(); ++i) {
            String startDate = (String)dateCols.get(i - 1);
            String endDate = (String)dateCols.get(i);
            if (operateDateStr.compareTo(startDate) < 0 || operateDateStr.compareTo(endDate) >= 0) continue;
            isFind = true;
            operateDateStr = (String)firstDay2DateCol.get(startDate);
            break;
        }
        if (!isFind) {
            operateDateStr = operateDateStr.compareTo((String)dateCols.get(0)) <= 0 ? (String)firstDay2DateCol.get(dateCols.get(0)) : (String)firstDay2DateCol.get(dateCols.get(dateCols.size() - 1));
        }
        BigDecimal summary = summaryDateQtyMap.computeIfAbsent(operateDateStr, k -> BigDecimal.ZERO);
        summaryDateQtyMap.put(operateDateStr, summary.add(qty));
    }

    private Object[] initValue(String materialId, PurForecastSumKey key) {
        Object[] value = this.getNewEntryValue();
        value[3] = Long.valueOf(materialId);
        value[13] = key.getAux();
        value[14] = key.getOrg();
        value[15] = key.getPurOrg();
        value[16] = key.getSupplier();
        value[6] = false;
        value[7] = "N";
        value[9] = BigDecimal.ZERO;
        value[8] = BigDecimal.ZERO;
        return value;
    }

    private Object[] getMaterialPlan(String materialId, String orgId, List<Long> allPlanTags) {
        Map info = this.ctx.getMaterialPlanInfo(materialId, orgId);
        if (info == null) {
            log.warn(String.format("mrprunner-PurForecast-get-null-material-planinfo, ctxid: %s, mid: %s", this.ctx.getMRPContextId(), materialId));
            return null;
        }
        Long tag = MRPUtil.getLong((Map)info, (String)"plantags");
        if (allPlanTags.isEmpty() ? tag != null && tag > 0L : !allPlanTags.contains(tag)) {
            return null;
        }
        Object[] value = new Object[]{MRPUtil.getInt((Map)info, (String)"fixedleadtime"), MRPUtil.getInt((Map)info, (String)"postprocessingtime"), MRPUtil.getLong((Map)info, (String)"operator"), 0L, tag};
        return value;
    }

    private Map<String, Long> loadUnit(Set<String> materials) {
        HashMap id2Unit = Maps.newHashMapWithExpectedSize((int)materials.size());
        Set<Long> mids = this.stringToLong(materials);
        QFilter qFilter = new QFilter("id", "in", mids);
        try (DataSet dataSet = SnapshotDataUtils.queryDataSet((String)this.algoKey, (Long)this.versionId, (String)"bd_material", (String)"id,baseunit", (QFilter[])new QFilter[]{qFilter});){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String id = row.getString("id");
                Long unit = row.getLong("baseunit");
                id2Unit.put(id, unit);
            }
        }
        return id2Unit;
    }

    private Set<Long> stringToLong(Set<String> strings) {
        HashSet<Long> sets = new HashSet<Long>(strings.size());
        for (String str : strings) {
            sets.add(Long.valueOf(str));
        }
        return sets;
    }

    private PurParam wrapperPurParam(long planId) {
        PurParam purParam = new PurParam();
        Date startDateTime = this.ctx.createLogRecorder().getLogStartDate();
        this.calendar.setTime(startDateTime);
        Date mondayDate = DateUtils.getMondayDateOfWeek((Date)startDateTime);
        Tuple<List<String>, Map<String, String>> tuple1 = this.getDateInfoAndDayMap(this.startDate == null ? mondayDate : new Date(this.startDate));
        Tuple tuple2 = ForecastUtils.getWasteStockIdsAndOrgIds((ORM)this.orm, (long)planId);
        purParam.setStartDateTime(startDateTime);
        purParam.setDateCols((List)tuple1.item1);
        purParam.setFirstDay2DateCol((Map)tuple1.item2);
        purParam.setWarehouseIds((Set)tuple2.item1);
        purParam.setOrgIds((Set)tuple2.item2);
        purParam.setVersionId(this.versionId);
        purParam.setDateInfo(this.getDateInfo(tuple1));
        return purParam;
    }

    private List<String> getDateInfo(Tuple<List<String>, Map<String, String>> tuple1) {
        List dateCols = (List)tuple1.item1;
        Map firstDay2DateCol = (Map)tuple1.item2;
        ArrayList dateInfo = Lists.newArrayListWithCapacity((int)dateCols.size());
        for (String date : dateCols) {
            String value = (String)firstDay2DateCol.get(date);
            if (value == null) continue;
            dateInfo.add(value);
        }
        return dateInfo;
    }

    private Tuple<List<String>, Map<String, String>> getDateInfoAndDayMap(Date mondayDate) {
        HashMap dayMap = Maps.newHashMapWithExpectedSize((int)103);
        ArrayList dateInfoList = Lists.newArrayListWithCapacity((int)103);
        Object setId = ForecastUtils.getDateSetId((Long)this.dataset);
        int day = 0;
        int week = 0;
        int month = 0;
        boolean isWeek = false;
        boolean isMonth = false;
        if (setId == null) {
            day = 28;
            week = 75;
        } else {
            QFilter qFilter = new QFilter("id", "=", setId);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"mrp_dateset", (String)"entryentity.type type, entryentity.num num, entryentity.isnatural isnatural", (QFilter[])new QFilter[]{qFilter}, null);){
                boolean isNull = true;
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String type = row.getString("type");
                    int num = row.getInteger("num");
                    boolean isnatural = row.getBoolean("isnatural");
                    if (StringUtils.equals((CharSequence)type, (CharSequence)DateType.DAY.getValue())) {
                        day = num;
                        isNull = false;
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)type, (CharSequence)DateType.MONTH.getValue())) {
                        month = num;
                        isMonth = isnatural;
                        isNull = false;
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)type, (CharSequence)DateType.WEEK.getValue())) continue;
                    week = num;
                    isWeek = isnatural;
                    isNull = false;
                }
                if (isNull) {
                    day = 28;
                    week = 75;
                }
            }
        }
        this.calendar.setTime(mondayDate);
        this.addDay(dateInfoList, dayMap, this.calendar, day);
        if (week > 0 && isWeek) {
            int index = this.calendar.get(7);
            if (index == 1) {
                index = 8;
            }
            index = (9 - index) % 7;
            this.addDay(dateInfoList, dayMap, this.calendar, index);
        }
        this.addWeek(dateInfoList, dayMap, this.calendar, week, false);
        if (month > 0 && isMonth && this.calendar.get(5) != 1) {
            Date lastDayOfMonth = DateUtils.getLastDayOfMonth((Date)this.calendar.getTime());
            Date firstDayOfMonth = DateUtils.getFirstDayOfMonth((Date)this.calendar.getTime());
            if (week > 0) {
                this.addWeek(dateInfoList, dayMap, this.calendar, 0, true);
            } else if (day > 0) {
                long l = lastDayOfMonth.getTime() - this.calendar.getTime().getTime();
                int dayOfMonth = (int)(l / 86400000L);
                this.addDay(dateInfoList, dayMap, this.calendar, dayOfMonth);
            } else {
                String startStr = DateUtils.formatDate((Date)firstDayOfMonth);
                String endStr = DateUtils.formatDate((Date)lastDayOfMonth);
                dateInfoList.add(startStr);
                dayMap.put(startStr, DateUtils.formatMonthDate((Date)firstDayOfMonth));
                this.calendar.setTime(lastDayOfMonth);
                this.calendar.add(5, 1);
            }
        }
        this.addMonth(dateInfoList, dayMap, this.calendar, month);
        return Tuple.create((Object)dateInfoList, (Object)dayMap);
    }

    private void addDay(List<String> dateInfoList, Map<String, String> dayMap, Calendar calendar, int day) {
        for (int i = 0; i < day; ++i) {
            String dateStr = DateUtils.formatDate((Date)calendar.getTime());
            dateInfoList.add(dateStr);
            dayMap.put(dateStr, dateStr);
            calendar.add(5, 1);
        }
    }

    private void addWeek(List<String> dateInfoList, Map<String, String> dayMap, Calendar calendar, int week, boolean isUnitToEndMonth) {
        Date start = null;
        Date end = null;
        String startStr = null;
        String endStr = null;
        boolean isBreak = false;
        Date lastDayOfMonth = DateUtils.getLastDayOfMonth((Date)calendar.getTime());
        for (int i = 0; i < week || isUnitToEndMonth; ++i) {
            start = calendar.getTime();
            end = DateUtils.getSundayDateOfWeek((Date)start);
            if (isUnitToEndMonth && end.compareTo(lastDayOfMonth) >= 0) {
                end = lastDayOfMonth;
                isBreak = true;
            }
            startStr = DateUtils.formatDate((Date)start);
            endStr = DateUtils.formatDate((Date)end);
            dateInfoList.add(startStr);
            if (i == 0) {
                String startStrWeek = DateUtils.formatDate((Date)DateUtils.getMondayDateOfWeek((Date)start));
                dayMap.put(startStr, this.appendDateStr(startStrWeek, endStr));
            } else {
                dayMap.put(startStr, this.appendDateStr(startStr, endStr));
            }
            calendar.setTime(end);
            calendar.add(5, 1);
            if (isBreak) break;
        }
    }

    private void addMonth(List<String> dateInfoList, Map<String, String> dayMap, Calendar calendar, int month) {
        Date start = null;
        Date end = null;
        String startStr = null;
        String endStr = null;
        for (int i = 0; i < month; ++i) {
            start = calendar.getTime();
            end = DateUtils.getLastDayOfMonth((Date)start);
            startStr = DateUtils.formatDate((Date)start);
            endStr = DateUtils.formatDate((Date)end);
            dateInfoList.add(startStr);
            dayMap.put(startStr, DateUtils.formatMonthDate((Date)start));
            calendar.setTime(end);
            calendar.add(5, 1);
        }
    }

    private String appendDateStr(String startStr, String endStr) {
        return String.format("%s-%s", startStr, endStr);
    }

    private Set<String> getAllMaterialIds() {
        List llcMaterialIds = this.ctx.bomDatas().getLLC();
        Set requireMaterialIds = this.ctx.bomDatas().getRequireMaterials();
        HashSet<String> materialIds = new HashSet<String>(requireMaterialIds);
        for (Set ids : llcMaterialIds) {
            materialIds.addAll(ids);
        }
        return materialIds;
    }

    private String getInsertSql() {
        int i;
        StringBuilder sb = new StringBuilder("insert into t_mrp_pur_fctentry (");
        List<String> fields = this.getInsertEntryFields();
        for (i = 0; i < fields.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(fields.get(i));
        }
        sb.append(") values (");
        for (i = 0; i < fields.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    protected List<String> getInsertEntryFields() {
        ArrayList<String> fields = new ArrayList<String>(18);
        fields.add("fid");
        fields.add("fentryid");
        fields.add("fseq");
        fields.add("fmaterialid");
        fields.add("funitid");
        fields.add("foperator");
        fields.add("fpublished");
        fields.add("fsplited");
        fields.add("fwasteqty");
        fields.add("ftotalqty");
        fields.add("fdateqty_tag");
        fields.add("fdatatype");
        fields.add("fplantag");
        fields.add("fauxpty");
        fields.add("forg");
        fields.add("fpurorg");
        fields.add("fsupplier");
        return fields;
    }

    protected Object[] getNewEntryValue() {
        return new Object[17];
    }

    private void savePurHead(PurParam purParam, long headId, long planId, String sumdim) {
        DynamicObject dynamicObject = this.orm.newDynamicObject("mrp_pur_fctdata");
        dynamicObject.set("id", (Object)headId);
        dynamicObject.set("caculatelog", (Object)this.calculatelog);
        dynamicObject.set("createdate", (Object)purParam.getStartDateTime());
        dynamicObject.set("dateinfo_tag", (Object)SerializationUtils.toJsonString((Object)purParam.getDateInfo()));
        dynamicObject.set("plangram", (Object)planId);
        dynamicObject.set("sumdim", (Object)sumdim);
        dynamicObject.set("dataset", (Object)this.dataset);
        dynamicObject.set("planstartdate", (Object)new Date(this.startDate));
        dynamicObject.set("is_latest_data", (Object)true);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private List<Object[]> mergeValue(List<Object[]> values, long headId, List<Object> entryIds) {
        int totalCount = values.size() << 1;
        long[] newEntryIds = ID.genLongIds((int)totalCount);
        int seq = 0;
        ArrayList allValues = Lists.newArrayListWithExpectedSize((int)totalCount);
        for (Object[] value : values) {
            value[0] = headId;
            value[1] = newEntryIds[seq++];
            entryIds.add(value[1]);
            value[2] = seq;
            value[11] = DataType.SYSOUTPUT.getValue();
            allValues.add(value);
            Object[] copyValue = this.getNewEntryValue();
            System.arraycopy(value, 3, copyValue, 3, value.length - 3);
            copyValue[0] = headId;
            copyValue[1] = newEntryIds[seq++];
            entryIds.add(copyValue[1]);
            copyValue[2] = seq;
            copyValue[11] = DataType.PUBLISHQTY.getValue();
            allValues.add(copyValue);
        }
        return allValues;
    }

    public String getStepDesc(Locale locale) {
        return Tips.getSavePurforecast();
    }

    public String getAssociateForm() {
        return "mrp_pur_forecast_rpt";
    }
}

