/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step.allocat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.runner.AbstractMRPRunner;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.BillAdjustStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.enums.strategy.OORBillResolveStrategy;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public class AllocSaveDetailsToCache {
    private IMRPEnvProvider ctx;

    public void saveDetails(IMRPEnvProvider actx, String materialId, String eventId) {
        this.ctx = actx;
        int llc = 0;
        LinkedList<Map<String, Object>> details = new LinkedList<Map<String, Object>>();
        this.saveRSMappings(details, materialId, llc, eventId);
        this.cancelSupplys(details, materialId, llc, eventId);
        MRPCacheManager.getInst().setMaterialDetails((CalEnv)this.ctx, materialId, details);
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getBalanceSplitKey((String)this.ctx.getMRPContextId(), (String)materialId), String.valueOf(details.size()));
    }

    protected void saveRSMappings(List<Map<String, Object>> details, String materialId, int llc, Object eventid) {
        for (DataBalanceTable.RSMapping mapping : this.ctx.calcBalanceDetails().getMappings()) {
            RequireRowData require = mapping.getRequire();
            List supplys = mapping.getSupplys();
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("material", materialId);
            int mAttr = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
            entry.put("materialattr", mAttr);
            this.putRequire(entry, require, mapping.isExceptionData(), llc);
            entry.put("demandqty", mapping.getrQty());
            String bt = this.ctx.getRelatedSupplyBillType(mAttr);
            entry.put("supplybilltype", bt == null ? ResManager.loadKDString((String)"\u65b0\u521b\u5efa\u8ba1\u5212\u8ba2\u5355", (String)"AllocSaveDetailsToCache_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]) : bt);
            entry.put("supmaterial", materialId);
            entry.put("supplybillf7", "mrp_planorder");
            Long date = (Long)require.getValue(DefaultField.RequireField.DATE.getName());
            MRPWorkCalendarManager wcm = this.ctx.dateManager();
            String supplyOrgId = String.valueOf(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
            String requireProductOrgUnitID = String.valueOf(require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
            date = this.getDate(date, wcm, supplyOrgId, requireProductOrgUnitID);
            entry.put("supplydate", date);
            entry.put("adjustsuggest", BillAdjustStrategy.NONE.getAlias());
            entry.put("supplybillentryseq", 0);
            entry.put("eventid", eventid);
            entry.put("resolverip", AbstractMRPRunner.getIP());
            details.add(entry);
            if (supplys != null) {
                BigDecimal rQty = (BigDecimal)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.__MERGE_REQQTY_.getName()), (Object)BigDecimal.ZERO);
                for (RowData supply : supplys) {
                    entry = new HashMap();
                    entry.put("material", materialId);
                    mAttr = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
                    entry.put("materialattr", mAttr);
                    this.putRequire(entry, require, mapping.isExceptionData(), llc);
                    BigDecimal sQty = (BigDecimal)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO);
                    if (rQty.compareTo(sQty) >= 0) {
                        rQty = rQty.subtract(sQty);
                    } else {
                        sQty = rQty;
                    }
                    if (sQty.compareTo(BigDecimal.ZERO) == 0) {
                        sQty = (BigDecimal)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO);
                    }
                    entry.put("demandqty", sQty);
                    this.putSupply(entry, supply, llc);
                    entry.put("eventid", eventid);
                    entry.put("resolverip", AbstractMRPRunner.getIP());
                    details.add(entry);
                }
            }
            if (mapping.getPoList() != null || supplys != null && !supplys.isEmpty()) continue;
            entry = new HashMap();
            entry.put("material", materialId);
            mAttr = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
            entry.put("materialattr", mAttr);
            this.putRequire(entry, require, mapping.isExceptionData(), llc);
            Object isMergeReq = require.getValue(DefaultField.RequireField.__IS_MERGE_.getName());
            if (isMergeReq != null && isMergeReq == Boolean.TRUE) {
                entry.put("ismerge", require.getValue(DefaultField.RequireField.__IS_MERGE_.getName()));
                entry.put("mergebillno", require.getValue(DefaultField.RequireField.__MERGE_REQBILL_NUM_.getName()));
                entry.put("mergebillentryseq", require.getValue(DefaultField.RequireField.__MERGE_REQBILL_ENTRYSEQ_.getName()));
                entry.put("mergebillid", require.getValue(DefaultField.RequireField.__MERGE_REQBILL_ID_.getName()));
                entry.put("mergebillentryid", require.getValue(DefaultField.RequireField.__MERGE_REQBILL_ENTRYID_.getName()));
            }
            entry.put("eventid", eventid);
            entry.put("resolverip", AbstractMRPRunner.getIP());
            details.add(entry);
        }
    }

    private Long getDate(Long date, MRPWorkCalendarManager wcm, String supplyOrgId, String requireProductOrgUnitID) {
        try {
            OrgBasedCalendarModel sOcm = wcm.get(supplyOrgId, requireProductOrgUnitID);
            date = sOcm.getDate(new Date(date), true).getTimeInMillis();
            return date;
        }
        catch (Exception e) {
            return new Date().getTime();
        }
    }

    protected void cancelSupplys(List<Map<String, Object>> details, String materialId, int llc, Object eventid) {
        SupplymentDataTable supplys = this.ctx.supplyDatas();
        for (int i = 0; i < supplys.size(); ++i) {
            boolean isRecordOOR;
            RowData supply = supplys.fetchRow(i);
            Object isLocked = supply.getValue(DefaultField.SupplyField.__IS_OCCUPIED__.name());
            Object isReplace = supply.getValue(DefaultField.SupplyField.__IS_REPLACE__.getName());
            if (isLocked != null && ((Boolean)isLocked).booleanValue() || isReplace != null && ((Boolean)isReplace).booleanValue()) continue;
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("material", materialId);
            int mAttr = (Integer)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
            entry.put("materialattr", mAttr);
            this.putSupply(entry, supply, llc);
            entry.put("configuredcode", supply.getValue(DefaultField.SupplyField.CONFIGUREDCODE.getName()));
            if (supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()) != null) {
                entry.put("adjustsuggest", BillAdjustStrategy.NONE.getAlias());
            } else {
                entry.put("adjustsuggest", BillAdjustStrategy.CANCEL.getAlias());
            }
            entry.put("eventid", eventid);
            entry.put("resolverip", AbstractMRPRunner.getIP());
            boolean bl = isRecordOOR = this.ctx.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
            if (String.valueOf(supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName())).contains("93") && !isRecordOOR) continue;
            details.add(entry);
        }
    }

    private void putRequire(HashMap<String, Object> entry, RequireRowData require, boolean isExceptionData, int llc) {
        entry.put("demandbilltype", require.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name()));
        entry.put("demandbillf7", require.getValue(DefaultField.RequireField.BILL_ENTITY.getName()));
        entry.put("bomversion", require.getValue(DefaultField.RequireField.__BOM_VERSION__.getName()));
        entry.put("demandqty", require.getValue(DefaultField.RequireField.QTY.getName()));
        entry.put("billid", require.getValue(DefaultField.RequireField.BILLID.getName()));
        entry.put("billno", require.getValue(DefaultField.RequireField.BILLNUMBER.getName()));
        entry.put("ishandle", Boolean.FALSE);
        Object date = require.getValue(DefaultField.RequireField.__SRC_DATE__.getName());
        if (date == null) {
            date = require.getValue(DefaultField.RequireField.DATE.getName());
        }
        if ("SYSDATE".equalsIgnoreCase((String)this.ctx.getCfgValue(EnvCfgItem.REQUIRE_BILL_DATE_ADJUST_TYPE)) && (Long)date < this.ctx.getPlanDate().getTime()) {
            date = this.ctx.getPlanDate().getTime();
        }
        entry.put("demanddate", date);
        entry.put("billentryid", require.getValue(DefaultField.RequireField.BILLENTRYID.getName()));
        entry.put("billentryseq", require.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()));
        entry.put("srcdemandqty", require.getValue(DefaultField.RequireField.__MERGE_REQQTY_.getName()));
        entry.put("requireorg", require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        entry.put("reqpriority", require.getValue(DefaultField.RequireField.__PRIORITY_LEVEL__.getName()));
        entry.put("materialattr", require.getValue(DefaultField.RequireField.MATERIALATTR.getName()));
        if (isExceptionData || require.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()) != null) {
            entry.put("exception", MRPUtil.subExceptionMsg((String)String.valueOf(require.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()))));
        }
        entry.put("exceptionnumber", require.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
        entry.put("reqsourcebillno", require.getValue(DefaultField.RequireField.__REQUIRE_SOURCE__.getName()));
        entry.put("llc", String.valueOf(llc));
        entry.put("requireoperator", require.getValue(DefaultField.RequireField.REQUIREOPERAOTR.getName()));
        entry.put("parentbomid", require.getValue(DefaultField.RequireField.__BOMID__.getName()));
        entry.put("bomid", require.getValue(DefaultField.RequireField.__PARENT_BOMID__.getName()));
        entry.put("yieldratio", require.getValue(DefaultField.RequireField.YIELD.getName()));
        entry.put("scrapratio", require.getValue(DefaultField.RequireField.__SCRAPRATIO__.getName()));
        entry.put("dynamicscrapratio", require.getValue(DefaultField.RequireField.__DYNAMICSCRAPRATIO__.getName()));
        entry.put("fixscrap", require.getValue(DefaultField.RequireField.__FIXSCRAP__.getName()));
        entry.put("dynamicscrapformula", require.getValue(DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName()));
        entry.put("plantag", this.setPlanTag(require.getValue(DefaultField.RequireField.__PLAN_TAG__.getName())));
        entry.put("supplyoperator", require.getValue(DefaultField.RequireField.REQUIREOPERAOTR.getName()));
        entry.put("supplantag", this.setPlanTag(require.getValue(DefaultField.RequireField.__PLAN_TAG__.getName())));
        entry.put("configuredcode", require.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()));
        entry.put("tracknumber", require.getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
    }

    private Object setPlanTag(Object obj) {
        String[] strs = this.ctx.getPlanTagInfo(String.valueOf(obj));
        return strs[1];
    }

    private void putSupply(HashMap<String, Object> entry, RowData supply, int llc) {
        entry.put("supplybilltype", supply.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name()));
        if (supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName()) != null) {
            entry.put("supplybillf7", supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName()));
        } else {
            entry.put("supplybillf7", "mrp_planorder");
        }
        entry.put("ishandle", Boolean.FALSE);
        entry.put("supmaterial", supply.getValue(DefaultField.SupplyField.MATERIAL.getName()));
        entry.put("suppriority", supply.getValue(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName()));
        entry.put("supplyqty", supply.getValue(DefaultField.SupplyField.QTY.getName()));
        entry.put("supplybillid", supply.getValue(DefaultField.SupplyField.BILLID.getName()));
        entry.put("supplybillno", supply.getValue(DefaultField.SupplyField.BILLNUMBER.getName()));
        entry.put("supplydate", supply.getValue(DefaultField.SupplyField.DATE.getName()));
        entry.put("supplybillentryid", supply.getValue(DefaultField.SupplyField.BILLENTRYID.getName()));
        entry.put("adjustqty", supply.getValue(DefaultField.SupplyField.__ADJUST_QTY__.name()));
        entry.put("adjustdate", supply.getValue(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name()));
        int flag = (Integer)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.__ADJUST_FLAG__.name()), (Object)BillAdjustStrategy.NONE.getValue());
        entry.put("adjustsuggest", BillAdjustStrategy.parseInt((int)flag).getAlias());
        entry.put("supplybillentryseq", supply.getValue(DefaultField.SupplyField.BILLENTRYSEQ.getName()));
        entry.put("sexpmsg", supply.getValue(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName()));
        entry.put("sexpnumber", supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()));
        entry.put("supplydetail", this.buildSupplyDetail(supply));
        entry.put("warehouse", supply.getValue(DefaultField.SupplyField.WAREHOUSE.getName()));
        entry.put("location", supply.getValue(DefaultField.SupplyField.STOCKLOT.getName()));
        entry.put("invpriority", supply.getValue(DefaultField.SupplyField.__SUPPLY_PRIORITY__.getName()));
        entry.put("supplyorg", supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        entry.put("llc", String.valueOf(llc));
        entry.put("supplyoperator", supply.getValue(DefaultField.SupplyField.SUPPLYOPERATOR.getName()));
        entry.put("supplantag", this.setPlanTag(supply.getValue(DefaultField.SupplyField.SUPPLANTAG.getName())));
    }

    private String buildSupplyDetail(RowData supply) {
        String bt = String.valueOf(supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName()));
        StringBuilder sb = new StringBuilder();
        if ("pm_purapplybill".equals(bt)) {
            sb.append("PR");
            this.appendValue(supply, DefaultField.SupplyField.BILLNUMBER, sb);
            this.appendValue(supply, DefaultField.SupplyField.BILLENTRYSEQ, sb);
        }
        if ("pm_purorderbill".equals(bt)) {
            sb.append("PO");
            this.appendValue(supply, DefaultField.SupplyField.BILLNUMBER, sb);
            this.appendValue(supply, DefaultField.SupplyField.BILLENTRYSEQ, sb);
        }
        if ("im_inv_realbalance".equals(bt)) {
            sb.append("OH");
            this.appendValue(supply, DefaultField.SupplyField.WAREHOUSENAME, sb);
            this.appendValue(supply, DefaultField.SupplyField.LOCATIONNAME, sb);
        }
        if ("pom_mftorder".equals(bt)) {
            sb.append("WIP");
            this.appendValue(supply, DefaultField.SupplyField.BILLNUMBER, sb);
            this.appendValue(supply, DefaultField.SupplyField.BILLENTRYSEQ, sb);
        }
        return sb.toString();
    }

    private void appendValue(RowData supply, DefaultField.SupplyField field, StringBuilder sb) {
        sb.append('_');
        if (supply.getValue(field.getName()) != null) {
            sb.append(supply.getValue(field.getName()));
        } else {
            sb.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"AllocSaveDetailsToCache_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
        }
    }
}

