/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step.allocat;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AllocUtil {
    public static BigDecimal getUnitRateConvert(Long materialId, Long srcUnitId, Long desUnitId) {
        String de = "denominator";
        String nu = "numerator";
        if (desUnitId == null || desUnitId == 0L) {
            return BigDecimal.ZERO;
        }
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null) {
            unitRate = new BigDecimal("0");
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = new BigDecimal("1");
        } else {
            int type;
            String precisionAccount;
            DynamicObject measureUnits = BusinessDataServiceHelper.loadSingleFromCache((Object)desUnitId, (String)"bd_measureunits");
            switch (precisionAccount = measureUnits.getString("precisionaccount")) {
                case "1": {
                    type = 4;
                    break;
                }
                case "2": {
                    type = 1;
                    break;
                }
                case "3": {
                    type = 0;
                    break;
                }
                default: {
                    type = 4;
                }
            }
            try {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt(de) != 0) {
                    unitRate = new BigDecimal(muConv.getInt(nu)).divide(new BigDecimal(muConv.getInt(de)), measureUnits.getInt("precision"), type);
                }
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AllocUtil_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            }
        }
        if (unitRate == null) {
            unitRate = new BigDecimal("0");
        }
        return unitRate;
    }

    static Long getAccountOrgByProduceOrg(long produceOrg) {
        List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)produceOrg, (String)"10");
        return fromOrgs.isEmpty() ? null : (Long)fromOrgs.get(0);
    }
}

