/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step.allocat;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mrp.calcnode.framework.step.MRPMDataBalanceStep;
import kd.mmc.mrp.calcnode.framework.step.MRPReqOrgMergeRule;
import kd.mmc.mrp.calcnode.framework.step.result.MRPDataBalanceResult;
import kd.mmc.mrp.controlnode.framework.step.allocat.AllocIssueSave;
import kd.mmc.mrp.controlnode.framework.step.allocat.AllocSaveDetailsToCache;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.mq.resolver.IEventResolver;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPAllocDataBalanceResolver
implements IEventResolver {
    protected IMRPEnvProvider ctx;

    public void execute(MRPEvent event, IMRPEnvProvider actx) {
        if (this.setup(event, actx)) {
            this.exe(event, actx);
        }
    }

    private void exe(MRPEvent event, IMRPEnvProvider actx) {
        this.ctx = MRPUtil.clone((IMRPEnvProvider)actx);
        this.fillSupOrgByReqOrg(this.ctx);
        this.fillSupWareByReqWare(this.ctx);
        this.ctx.loadSupplyMaterialExtProps();
        this.ctx.loadRequireMaterialExtProps();
        new MRPReqOrgMergeRule(this.ctx).execute();
        this.orderByDateExcludeStage(this.ctx);
        this.executeBalanceStep(this.ctx);
        this.saveData(actx);
        this.saveDetails(this.ctx, event);
    }

    private void saveData(IMRPEnvProvider ctx) {
        String countstr = MRPCacheManager.getInst().getData((CalEnv)ctx, "allocationplans");
        int count = 0;
        if (!StringUtils.isBlank((CharSequence)countstr)) {
            count = (Integer)JSON.parseObject((String)countstr, Integer.class);
        }
        MRPCacheManager.getInst().putData((CalEnv)ctx, "allocationplans", JSON.toJSONString((Object)(count += this.saveProcessDatas(ctx))));
    }

    protected int saveProcessDatas(IMRPEnvProvider ctx) {
        AllocIssueSave save = new AllocIssueSave(ctx, true);
        save.addMappings(ctx.calcBalanceDetails().getUnVisitedMappings());
        int count = save.save();
        ctx.calcBalanceDetails().finish();
        return count;
    }

    protected int saveDetails(IMRPEnvProvider ctx, MRPEvent event) {
        String materialId = event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID).toString();
        String eventid = event.getEventId();
        new AllocSaveDetailsToCache().saveDetails(ctx, materialId, eventid);
        return 0;
    }

    private void orderByDateExcludeStage(IMRPEnvProvider ctx) {
        RequirementDataTable reqData = ctx.requireDatas();
        Map colIdx = reqData.getColIdx();
        GridData.Grid datas = reqData.getSrcDatas().getDatas();
        ArrayList<RequireRowData> requires = new ArrayList<RequireRowData>(reqData.size());
        if (!datas.isEmpty()) {
            RequireRowData rd;
            int i;
            int qtyi = (Integer)reqData.getColIdx().get(DefaultField.RequireField.QTY.getName());
            int datei = (Integer)reqData.getColIdx().get(DefaultField.RequireField.DATE.getName());
            int allocsrci = (Integer)reqData.getColIdx().get("ENTRYENTITY.ALLOCSRC");
            int priorityi = (Integer)reqData.getColIdx().get(DefaultField.RequireField.__PRIORITY_LEVEL__.getName());
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            ArrayList<Object[]> swlist = new ArrayList<Object[]>();
            for (i = 0; i < datas.size(); ++i) {
                Object[] data = datas.get(i);
                Object date = data[datei];
                if (((BigDecimal)data[qtyi]).compareTo(BigDecimal.ZERO) <= 0) continue;
                if ("0".equals(data[allocsrci])) {
                    swlist.add(new Object[]{date, i});
                    continue;
                }
                list.add(new Object[]{date, i});
            }
            if (!swlist.isEmpty()) {
                for (Object[] o : swlist) {
                    int idex = (Integer)o[1];
                    rd = new RequireRowData(ctx.requireDatas().getSrcDatas(), Integer.valueOf(idex), colIdx, datas.get(idex));
                    requires.add(rd);
                }
            }
            if (!list.isEmpty()) {
                list.sort((o1, o2) -> {
                    long x = (Long)o1[0] - (Long)o2[0];
                    if (x > 0L) {
                        return 1;
                    }
                    if (x < 0L) {
                        return -1;
                    }
                    return 0;
                });
                for (i = 0; i < list.size(); ++i) {
                    Object[] o;
                    o = (Object[])list.get(i);
                    int idex = (Integer)o[1];
                    datas.get((int)idex)[priorityi] = 98 - i;
                    rd = new RequireRowData(ctx.requireDatas().getSrcDatas(), Integer.valueOf(idex), colIdx, datas.get(idex));
                    requires.add(rd);
                }
            }
        }
        reqData.clear();
        reqData.fill(requires.toArray(new RowData[0]));
    }

    private boolean setup(MRPEvent event, IMRPEnvProvider ctx) {
        List datas;
        String json;
        String[] splits;
        ctx.calcBalanceDetails().clear();
        ctx.requireDatas().clear();
        String materialId = event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID).toString();
        String val = MRPCacheManager.getInst().getData((CalEnv)ctx, MRPRuntimeConsts.getMaterialKey4Require((String)ctx.getMRPContextId(), (String)materialId));
        List dataKeys = JSON.parseArray((String)val, String.class);
        if (dataKeys != null) {
            for (String dataKey : dataKeys) {
                splits = MRPRuntimeConsts.splitDataKey((String)dataKey);
                json = MRPCacheManager.getInst().getSubData((CalEnv)ctx, "require-" + materialId, MRPRuntimeConsts.getDataKey((String)splits[0], (String)splits[1], (String)""));
                datas = JSON.parseArray((String)json, Object[].class);
                ctx.restoreTableDatas(splits[0], splits[1], materialId, datas, true);
            }
        }
        ctx.supplyDatas().clear();
        val = MRPCacheManager.getInst().getData((CalEnv)ctx, MRPRuntimeConsts.getMaterialKey4Supply((String)ctx.getMRPContextId(), (String)materialId));
        dataKeys = JSON.parseArray((String)val, String.class);
        if (dataKeys != null) {
            for (String dataKey : dataKeys) {
                splits = MRPRuntimeConsts.splitDataKey((String)dataKey);
                json = MRPCacheManager.getInst().getSubData((CalEnv)ctx, "supply-" + materialId, MRPRuntimeConsts.getDataKey((String)splits[0], (String)splits[1], (String)""));
                datas = JSON.parseArray((String)json, Object[].class);
                ctx.restoreTableDatas(splits[0], splits[1], materialId, datas, false);
            }
        }
        return ctx.requireDatas().size() != 0 && ctx.supplyDatas().size() != 0;
    }

    protected MRPDataBalanceResult executeBalanceStep(IMRPEnvProvider ctx) {
        return (MRPDataBalanceResult)new MRPMDataBalanceStep(ctx).execute();
    }

    private void fillSupOrgByReqOrg(IMRPEnvProvider ctx) {
        for (int i = 0; i < ctx.requireDatas().size(); ++i) {
            RequireRowData row = ctx.requireDatas().fetchRow(i);
            row.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), row.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        }
    }

    protected void fillSupWareByReqWare(IMRPEnvProvider ctx) {
    }
}

