/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step.allocat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.botp.ConvertDataService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.RunLogModel;

public class MRPMAllocClearAllocationPlan
extends AbstractMRPStep {
    public MRPMAllocClearAllocationPlan(IMRPEnvProvider ctx) {
        super(ctx);
    }

    protected void innerExecute() {
        this.dataAmount = this.clearAllocPlan();
    }

    private int clearAllocPlan() {
        DynamicObject[] bills;
        RunLogModel runLogModel = (RunLogModel)this.ctx.getService(RunLogModel.class);
        String planEntity = runLogModel.getPlanEntity();
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)this.ctx.getPlanId(), (String)planEntity);
        DynamicObjectCollection dync = plan.getDynamicObjectCollection("orgentryentity");
        ArrayList<Object> orgList = new ArrayList<Object>(4);
        for (DynamicObject oe : dync) {
            Object orgid = oe.getDynamicObject("entrydemandorg").getPkValue();
            orgList.add(orgid);
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgList), new QFilter("status", "=", (Object)"A")};
        ArrayList<Long> allocPlanIds = new ArrayList<Long>(4);
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"pom_allocationplan", (String)String.join((CharSequence)",", "id", "status", "closer", "closetime"), (QFilter[])filters)) {
            allocPlanIds.add(bill.getLong("id"));
        }
        ArrayList<Long> unCloseIds = new ArrayList<Long>(4);
        ConvertDataService reader = new ConvertDataService();
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"pom_allocationplan", (Long[])allocPlanIds.toArray(new Long[0]));
        block2: for (Map.Entry entry : dirtTargetBills.entrySet()) {
            Long srcId = (Long)entry.getKey();
            for (BFRow bfRow : (List)entry.getValue()) {
                String entityNumber;
                Long mainTableId = bfRow.getId().getMainTableId();
                TableDefine tableDefine = reader.loadTableDefine(mainTableId);
                if (tableDefine == null || !"im_transdirbill".equals(entityNumber = tableDefine.getEntityNumber())) continue;
                unCloseIds.add(srcId);
                continue block2;
            }
        }
        List<DynamicObject> closeDyns = Arrays.stream(bills).filter(x -> !unCloseIds.contains(x.getLong("id"))).collect(Collectors.toList());
        for (DynamicObject dyn : closeDyns) {
            dyn.set("status", (Object)"D");
            dyn.set("closer", (Object)RequestContext.get().getCurrUserId());
            dyn.set("closetime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])closeDyns.toArray(new DynamicObject[0]));
        return closeDyns.size();
    }

    public String getStepDesc(Locale locale) {
        return Tips.getClearPlanorders();
    }
}

