/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step.cps;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.calcnode.framework.mq.resolver.balance.MRPDataBalanceResolver;
import kd.mmc.mrp.calcnode.framework.mq.resolver.cps.CPSRequireStatNode;
import kd.mmc.mrp.calcnode.framework.mq.resolver.cps.CPSSupplyStatNode;
import kd.mmc.mrp.calcnode.framework.step.MRPMDependentReqNewStep;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.KDCloudCPSEnv;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.struct.ReplaceMaterialStruct;
import kd.mmc.mrp.model.struct.ReplaceStruct;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.utils.CPSUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.ReserveUtil;

public class CalcShortage
extends AbstractMRPStep {
    protected Map<String, List<RequireRowData>> cache = new WeakHashMap<String, List<RequireRowData>>();
    private static Log logger = LogFactory.getLog(CalcShortage.class);

    public CalcShortage(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public String getStepDesc(Locale locale) {
        return ResManager.loadKDString((String)"\u7f3a\u6599\u660e\u7ec6\u8ba1\u7b97", (String)"CalcShortage_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
    }

    protected void innerExecute() {
        try (TXHandle h = TX.notSupported((String)"CalcShortage.execute");){
            boolean isLet = ((KDCloudCPSEnv)this.ctx).isLet();
            if (!isLet) {
                this.dataAmount += Integer.parseInt(this.ctx.getCustomParams("shortageCount"));
                return;
            }
            PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
            DynamicObject shortageObj = BusinessDataServiceHelper.newDynamicObject((String)"mrp_cps_shortage");
            shortageObj.set("caculatelog", (Object)this.ctx.getRunLogNumber());
            shortageObj.set("mrpplan", (Object)planModel.getPlanId());
            shortageObj.set("createtime", (Object)System.currentTimeMillis());
            shortageObj.set("runtype", (Object)this.ctx.getRunLog().getString("runtype"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{shortageObj});
            ArrayList<Map<String, Object>> details = new ArrayList<Map<String, Object>>(this.ctx.requireDatas().size());
            ArrayList<Map<String, Object>> reserveList = new ArrayList<Map<String, Object>>(16);
            this.calcShortage((KDCloudCPSEnv)this.ctx, details, this.stepIdx, shortageObj, reserveList);
            if (!details.isEmpty()) {
                this.dataAmount += CPSUtil.batchExecuteSql(details, (Long)shortageObj.getLong("id"), (String)"mrp_cps_shortage.entryentity", (boolean)false);
                this.dataAmount += Integer.parseInt(this.ctx.getCustomParams("shortageCount"));
            }
            if (!reserveList.isEmpty()) {
                HashMap<String, BigDecimal> reserveMap = new HashMap<String, BigDecimal>();
                Map rowDataMap = ReserveUtil.getReserveRecordByMaterials((IMRPEnvProvider)this.ctx, (Set)this.ctx.getEnableMaterialIds());
                Map reserveColIndex = ReserveUtil.getReserveColIndex();
                for (Map.Entry entry : rowDataMap.entrySet()) {
                    for (Object[] obj : (List)entry.getValue()) {
                        Integer requireIdIdx = (Integer)reserveColIndex.get("bill_id");
                        Integer requireEntryIdIdx = (Integer)reserveColIndex.get("billentry_id");
                        Integer supplyIdIdx = (Integer)reserveColIndex.get("bal_id");
                        Integer supplyEntryIdIdx = (Integer)reserveColIndex.get("bal_entryid");
                        Integer qtyIdx = (Integer)reserveColIndex.get("base_qty");
                        String key = String.format("%s\u0001%s\u0001%s\u0001%s", obj[requireIdIdx], obj[requireEntryIdIdx], obj[supplyIdIdx], obj[supplyEntryIdIdx]);
                        reserveMap.put(key, (BigDecimal)obj[qtyIdx]);
                    }
                }
                Iterator it = reserveList.iterator();
                while (it.hasNext()) {
                    Map map = (Map)it.next();
                    String key = String.format("%s\u0001%s\u0001%s\u0001%s", map.get("bill_id"), map.get("billentry_id"), map.get("bal_id"), map.get("bal_entryid"));
                    BigDecimal reserveQty = (BigDecimal)reserveMap.get(key);
                    if (reserveQty == null) continue;
                    BigDecimal qty = (BigDecimal)map.get("qty");
                    if (qty.compareTo(reserveQty) > 0) {
                        map.put("qty", qty.subtract(reserveQty));
                        map.put("base_qty", qty.subtract(reserveQty));
                        map.put("ori_qty", qty.subtract(reserveQty));
                        continue;
                    }
                    it.remove();
                }
                if (!reserveList.isEmpty()) {
                    List subList;
                    int batch = (Integer)this.ctx.getCfgValue(EnvCfgItem.MRP_MATERIAL_PLANINFO_BATCH);
                    int idx = 0;
                    int listSize = reserveList.size();
                    while (idx + batch < listSize) {
                        subList = reserveList.subList(idx, idx += batch);
                        ReserveUtil.createReserveRecord((IMRPEnvProvider)this.ctx, subList, new HashSet());
                    }
                    if (listSize > idx) {
                        subList = reserveList.subList(idx, listSize);
                        ReserveUtil.createReserveRecord((IMRPEnvProvider)this.ctx, subList, new HashSet());
                    }
                }
            }
        }
    }

    private void calcShortage(KDCloudCPSEnv ctx, List<Map<String, Object>> details, int stepIdx, DynamicObject shortageObj, List<Map<String, Object>> reserveList) {
        long start = System.currentTimeMillis();
        IMRPExecuteLogRecorder lr = ctx.createLogRecorder();
        lr.createSubStepLog(0, ResManager.loadKDString((String)"\u9f50\u5957\u7f3a\u6599\u8ba1\u7b97", (String)"CalcShortage_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), stepIdx);
        lr.saveStepLog(false);
        List requireIndexs = JSON.parseArray((String)ctx.getCustomParams("cps\u0001require\u0001list"), Integer.class);
        Map existKeyPartMap = (Map)JSON.parseObject((String)ctx.getCustomParams("cps\u0001keypart\u0001map"), Map.class);
        HashMap<Integer, CPSSupplyStatNode> allUsedSupplys = new HashMap<Integer, CPSSupplyStatNode>();
        int count = 0;
        for (Integer reqRowIdx : requireIndexs) {
            ctx.testEnvStatus();
            CalcShortage.calcRequireShortage(ctx, details, reqRowIdx, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
            lr.updateSubStepLog(0, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u7b97\u9700\u6c42\u6570\u636e\uff1a%1$s\u884c\uff0c\u5269\u4f59\u9700\u6c42\u6570\u636e:%2$s\u884c\u3002", (String)"CalcShortage_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), ++count, requireIndexs.size() - count));
            lr.saveStepLog(false);
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0 / 60.0;
        lr.updateSubStepLog(0, "entryoperatmin", (Object)time);
    }

    public static synchronized void calcRequireShortage(KDCloudCPSEnv ctx, List<Map<String, Object>> details, Integer reqRowIdx, DynamicObject shortageObj, Map<Integer, Boolean> existKeyPartMap, List<Map<String, Object>> reserveList, Map<Integer, CPSSupplyStatNode> allUsedSupplys) {
        try (TraceSpan ts = Tracer.create((String)"CalcShortage.calcRequireShortage", (String)"calcRequireShortage");){
            CalcShortage.calcRequireShortageImpl(ctx, details, reqRowIdx, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
            ctx.requireDatas().updateValue(DefaultField.RequireField.QTY.getName(), reqRowIdx, (Object)BigDecimal.ZERO);
        }
    }

    private static void calcRequireShortageImpl(KDCloudCPSEnv ctx, List<Map<String, Object>> details, Integer reqRowIdx, DynamicObject shortageObj, Map<Integer, Boolean> existKeyPartMap, List<Map<String, Object>> reserveList, Map<Integer, CPSSupplyStatNode> allUsedSupplys) {
        RequirementDataTable requireTbl = ctx.requireDatas();
        RequireRowData reqData = requireTbl.fetchRow(reqRowIdx.intValue());
        BigDecimal netDemand = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
        if (netDemand.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        reqData.update(DefaultField.RequireField.__MERGE_REQQTY_.getName(), (Object)netDemand);
        BigDecimal srcDemandQty = netDemand;
        List<RequireRowData> bomEntrys = CalcShortage.findSubEntrys(ctx, reqData, netDemand, reqData, ctx.supplyDatas(), existKeyPartMap);
        if (bomEntrys.isEmpty()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            MRPDataBalanceResolver.putRequire((IMRPEnvProvider)ctx, row, (RequireRowData)reqData, (boolean)false, (int)0);
            row.put("origindemanddate", reqData.getValue(DefaultField.RequireField.CPSDATE.getName()));
            row.put("adjustqty", netDemand);
            row.put("originsupplyqty", srcDemandQty);
            row.put("iskeypart", reqData.get(DefaultField.RequireField.__IS_KEYPART__.getName()));
            row.put("existkeypart", reqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
            row.put("replaceplan", reqData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
            row.put("replacepriority", reqData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
            row.put("ismianreplace", reqData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
            row.put("isreplace", reqData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
            details.add(row);
            reqData.update(DefaultField.RequireField.QTY.getName(), (Object)BigDecimal.ZERO);
            return;
        }
        if (ctx.isYield()) {
            Object myield = reqData.getValue(DefaultField.RequireField.YIELD.getName());
            BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
            netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)reqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)netDemand, (IMRPEnvProvider)ctx, (boolean)false);
            reqData.update(DefaultField.RequireField.__MERGE_REQQTY_.getName(), (Object)netDemand);
        }
        HashMap<String, Object> row = new HashMap<String, Object>();
        MRPDataBalanceResolver.putRequire((IMRPEnvProvider)ctx, row, (RequireRowData)reqData, (boolean)false, (int)0);
        row.put("adjustqty", netDemand);
        row.put("origindemanddate", reqData.getValue(DefaultField.RequireField.CPSDATE.getName()));
        row.put("originsupplyqty", srcDemandQty);
        row.put("iskeypart", reqData.get(DefaultField.RequireField.__IS_KEYPART__.getName()));
        row.put("existkeypart", reqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
        row.put("replaceplan", reqData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
        row.put("replacepriority", reqData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
        row.put("ismianreplace", reqData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
        row.put("isreplace", reqData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
        details.add(row);
        reqData.update(DefaultField.RequireField.QTY.getName(), (Object)BigDecimal.ZERO);
        CalcShortage.createSubEntryShortage(ctx, details, netDemand, bomEntrys, 0, reqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
    }

    private static BigDecimal createSubEntryShortage(KDCloudCPSEnv ctx, List<Map<String, Object>> details, BigDecimal parentNetDemand, List<RequireRowData> bomEntrys, int llc, RequireRowData topReqData, DynamicObject shortageObj, Map<Integer, Boolean> existKeyPartMap, List<Map<String, Object>> reserveList, Map<Integer, CPSSupplyStatNode> allUsedSupplys) {
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        ++llc;
        BigDecimal shortage = parentNetDemand;
        if (bomEntrys.isEmpty()) {
            return BigDecimal.ZERO;
        }
        if (parentNetDemand.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        ArrayList<Map<String, Object>> replaceDetails = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> replaceReserveList = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> onWorkDetail = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> onWorkReserveDetail = new ArrayList<Map<String, Object>>(16);
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        HashMap<String, String> reserveType = new HashMap<String, String>(8);
        DynamicObjectCollection col = planModel.getPlan().getDynamicObjectCollection("scentryentity");
        for (DynamicObject entry : col) {
            reserveType.put(entry.getString("resourceregisters.id"), entry.getString("reservetype"));
        }
        Map replaceMap = CPSUtil.getReplaceMap((IMRPEnvProvider)ctx, bomEntrys);
        CPSSupplyStatNode node = null;
        for (RequireRowData subReqData : bomEntrys) {
            BigDecimal min;
            if (ctx.isKeyPart() && !MRPUtil.convert((Object)subReqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE).booleanValue()) continue;
            BigDecimal unitUseQty = (BigDecimal)MRPUtil.convert((Object)subReqData.getBigDecimal(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName()), (Object)BigDecimal.ZERO);
            if (BigDecimal.ZERO.compareTo(unitUseQty) == 0) {
                subReqData.update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)BigDecimal.ZERO);
                continue;
            }
            BigDecimal fixScrap = BigDecimal.ZERO;
            if (ctx.isScrapRation()) {
                fixScrap = (BigDecimal)MRPUtil.convert((Object)subReqData.getBigDecimal(DefaultField.RequireField.__CHILDFIXSCRAP__.getName()), (Object)BigDecimal.ZERO);
            }
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mmc-cps-mrprunner, CPSRequireStatNode,unitQty:%s,isScrapRation:%s,reqData:%s", unitUseQty, ctx.isScrapRation(), subReqData));
            }
            String qtyType = subReqData.getValue(DefaultField.RequireField.__CHILDAMTTYPE__.getName()) == null ? "A" : (String)subReqData.getValue(DefaultField.RequireField.__CHILDAMTTYPE__.getName());
            BigDecimal netDemand = BigDecimal.ZERO;
            if ("B".equals(qtyType)) {
                netDemand = unitUseQty.add(fixScrap);
            } else {
                Object unit = subReqData.getValue(DefaultField.RequireField.BASEUNIT.getName());
                netDemand = MRPUtil.multiply2((IMRPEnvProvider)ctx, (Object)unit, (BigDecimal)parentNetDemand, (BigDecimal)unitUseQty).add(fixScrap);
            }
            subReqData.update(DefaultField.RequireField.__MERGE_REQQTY_.getName(), (Object)netDemand);
            if (subReqData.getValue(DefaultField.RequireField.__SUPPLY_IDX__.getName()) != null) {
                RowData supply = supplyTbl.fetchRow(subReqData.getInteger(DefaultField.RequireField.__SUPPLY_IDX__.getName()).intValue());
                BigDecimal recQty = (BigDecimal)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO);
                node = allUsedSupplys.get(subReqData.getInteger(DefaultField.RequireField.__SUPPLY_IDX__.getName()));
                if (node != null) {
                    recQty = recQty.subtract(node.getConsumeQty4BOM());
                    recQty = recQty.subtract(node.getConsumeQty4DepSupply());
                }
                if (recQty.compareTo(BigDecimal.ZERO) > 0) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    MRPDataBalanceResolver.putRequire((IMRPEnvProvider)ctx, row, (RequireRowData)subReqData, (boolean)false, (int)llc);
                    row.put("operation", subReqData.getValue(DefaultField.RequireField.OPERATION.getName()));
                    row.put("operationno", subReqData.getValue(DefaultField.RequireField.OPERATIONNO.getName()));
                    row.put("operationdesc", subReqData.getValue(DefaultField.RequireField.OPERATIONDESC.getName()));
                    row.put("iskeypart", subReqData.get(DefaultField.RequireField.__IS_KEYPART__.getName()));
                    row.put("existkeypart", subReqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
                    row.put("replaceplan", subReqData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
                    row.put("replacepriority", subReqData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
                    row.put("ismianreplace", subReqData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
                    row.put("isreplace", subReqData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
                    row.put("origindemanddate", subReqData.getValue(DefaultField.RequireField.CPSDATE.getName()));
                    row.put("ishandle", Boolean.TRUE);
                    row.put("supplybilltype", ResManager.loadKDString((String)"\u7ec4\u4ef6\u5728\u5236", (String)"CalcNetDemand_11", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
                    row.put("supplydate", ctx.getPlanDate().getTime());
                    row.put("isvirtual", supply.getValue(DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName()));
                    row.put("idx", subReqData.getInteger(DefaultField.RequireField.__SUPPLY_IDX__.getName()));
                    if (netDemand.compareTo(recQty) > 0) {
                        row.put("supplyqty", recQty);
                        row.put("srcdemandqty", recQty);
                        row.put("originsupplyqty", recQty);
                        supply.update(DefaultField.SupplyField.QTY.getName(), (Object)BigDecimal.ZERO);
                        netDemand = netDemand.subtract(recQty);
                        replaceDetails.add(row);
                        if (node != null) {
                            node.setMaxQty(node.getMaxQty().subtract(recQty));
                        }
                    } else {
                        row.put("supplyqty", netDemand);
                        row.put("srcdemandqty", netDemand);
                        row.put("originsupplyqty", netDemand);
                        supply.update(DefaultField.SupplyField.QTY.getName(), (Object)recQty.subtract(netDemand));
                        details.add(row);
                        if (node == null) continue;
                        node.setMaxQty(node.getMaxQty().subtract(netDemand));
                        continue;
                    }
                }
            }
            if (((String)MRPUtil.convert((Object)subReqData.getString(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (Object)"")).contains("87")) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                MRPDataBalanceResolver.putRequire((IMRPEnvProvider)ctx, row, (RequireRowData)subReqData, (boolean)false, (int)llc);
                row.put("operation", subReqData.getValue(DefaultField.RequireField.OPERATION.getName()));
                row.put("operationno", subReqData.getValue(DefaultField.RequireField.OPERATIONNO.getName()));
                row.put("operationdesc", subReqData.getValue(DefaultField.RequireField.OPERATIONDESC.getName()));
                row.put("iskeypart", subReqData.get(DefaultField.RequireField.__IS_KEYPART__.getName()));
                row.put("existkeypart", subReqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
                row.put("replaceplan", subReqData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
                row.put("replacepriority", subReqData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
                row.put("ismianreplace", subReqData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
                row.put("isreplace", subReqData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
                row.put("origindemanddate", subReqData.getValue(DefaultField.RequireField.CPSDATE.getName()));
                row.put("srcdemandqty", netDemand);
                details.add(row);
                continue;
            }
            BigDecimal qty = netDemand;
            List supplys = DataMatchUtils.findSupplysUtil((boolean)false, (RowData)subReqData, (IMRPEnvProvider)ctx);
            MRPUtil.isUseEnableOrder((IMRPEnvProvider)ctx, (SupplymentDataTable)supplyTbl, (List)supplys, (RequireRowData)subReqData);
            Object strategyId = subReqData.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
            Boolean isFastEnable = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_FAST_SUPLLY_SEARCH_MODE);
            if (!isFastEnable.booleanValue()) {
                supplys = supplyTbl.sortByPriority(subReqData.getString(DefaultField.RequireField.SUPPLYORGUNIT.getName()), supplys, strategyId == null ? null : String.valueOf(strategyId));
                supplys.sort(new DataMatchUtils.SupplySortComparator((IMRPEnvProvider)ctx));
            }
            supplys = ctx.supplyDatas().sortSupplyByReserve((IMRPEnvProvider)ctx, supplys, subReqData);
            for (Integer supplyIdx : supplys) {
                Boolean isVirtual;
                RowData supply = supplyTbl.fetchRow(supplyIdx.intValue());
                BigDecimal supplyQty = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.QTY.getName(), supplyIdx.intValue()), (Object)BigDecimal.ZERO);
                if (supplyQty.compareTo(BigDecimal.ZERO) <= 0 || (isVirtual = MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName()), (Boolean)Boolean.FALSE)).booleanValue()) continue;
                BigDecimal oriSupplyQty = supplyQty;
                node = allUsedSupplys.get(supplyIdx);
                if (node != null && (supplyQty = supplyQty.subtract(node.getConsumeQty4BOM()).subtract(node.getConsumeQty4DepSupply()).subtract(node.getConsumeQty4Dep())).compareTo(BigDecimal.ZERO) <= 0) continue;
                Boolean isOnWork = MRPUtil.convert((Object)supply.getBoolean(DefaultField.SupplyField.ISONWORK.getName()), (Boolean)Boolean.FALSE);
                if (isOnWork.booleanValue()) {
                    Integer findSupOrReqIndex = MRPUtil.findSupOrReqIndex((IMRPEnvProvider)ctx, (boolean)false, (Integer)supplyIdx);
                    List<RequireRowData> subBomEntrys = CalcShortage.findSubEntrys(ctx, ctx.requireDatas().fetchRow(findSupOrReqIndex.intValue()), supplyQty, topReqData, supplyTbl, existKeyPartMap);
                    if (netDemand.compareTo(supplyQty) < 0) {
                        supplyQty = netDemand;
                    }
                    supplyQty = CalcShortage.createSubEntryShortage(ctx, onWorkDetail, supplyQty, subBomEntrys, llc, topReqData, shortageObj, existKeyPartMap, onWorkReserveDetail, allUsedSupplys);
                    CalcShortage.rollBack(ctx, onWorkDetail, onWorkReserveDetail, allUsedSupplys);
                    if (supplyQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    supplyQty = CalcShortage.createSubEntryShortage(ctx, onWorkDetail, supplyQty, subBomEntrys, llc, topReqData, shortageObj, existKeyPartMap, onWorkReserveDetail, allUsedSupplys);
                    if (node != null) {
                        node.setMaxQty(node.getMaxQty().subtract(supplyQty));
                    }
                    BigDecimal requireQty = (BigDecimal)MRPUtil.convert((Object)ctx.requireDatas().getValue(DefaultField.RequireField.QTY.getName(), findSupOrReqIndex.intValue()), (Object)BigDecimal.ZERO);
                    ctx.requireDatas().updateValue(DefaultField.RequireField.QTY.getName(), findSupOrReqIndex, (Object)requireQty.subtract(supplyQty));
                    replaceDetails.addAll(onWorkDetail);
                    onWorkDetail.clear();
                    replaceReserveList.addAll(onWorkReserveDetail);
                    onWorkReserveDetail.clear();
                }
                HashMap<String, Object> row = new HashMap<String, Object>();
                MRPDataBalanceResolver.putRequire((IMRPEnvProvider)ctx, row, (RequireRowData)subReqData, (boolean)false, (int)llc);
                MRPDataBalanceResolver.putSupply((IMRPEnvProvider)ctx, row, (RowData)supply, (int)llc);
                row.put("origindemanddate", subReqData.getValue(DefaultField.RequireField.CPSDATE.getName()));
                row.put("ishandle", MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Boolean)Boolean.FALSE));
                row.put("operation", subReqData.getValue(DefaultField.RequireField.OPERATION.getName()));
                row.put("operationno", subReqData.getValue(DefaultField.RequireField.OPERATIONNO.getName()));
                row.put("operationdesc", subReqData.getValue(DefaultField.RequireField.OPERATIONDESC.getName()));
                row.put("iskeypart", subReqData.get(DefaultField.RequireField.__IS_KEYPART__.getName()));
                row.put("existkeypart", subReqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
                row.put("replaceplan", subReqData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
                row.put("replacepriority", subReqData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
                row.put("ismianreplace", subReqData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
                row.put("isreplace", subReqData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
                row.put("isvirtual", supply.getValue(DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName()));
                if (netDemand.compareTo(supplyQty) >= 0) {
                    netDemand = netDemand.subtract(supplyQty);
                    row.put("supplyqty", supplyQty);
                    row.put("srcdemandqty", supplyQty);
                    row.put("originsupplyqty", supplyQty);
                    supplyTbl.updateValue(DefaultField.SupplyField.QTY.getName(), supplyIdx, (Object)oriSupplyQty.subtract(supplyQty));
                } else {
                    row.put("supplyqty", netDemand);
                    row.put("srcdemandqty", netDemand);
                    row.put("originsupplyqty", netDemand);
                    supplyTbl.updateValue(DefaultField.SupplyField.QTY.getName(), supplyIdx, (Object)oriSupplyQty.subtract(netDemand));
                    netDemand = BigDecimal.ZERO;
                }
                row.put("idx", supplyIdx);
                replaceDetails.add(row);
                ReserveUtil.createCPSReserveDatas((PlanModel)planModel, replaceReserveList, reserveType, (RequireRowData)subReqData, (RowData)supply, row, (RequireRowData)topReqData);
                if (netDemand.compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            subReqData.update(DefaultField.RequireField.__MERGE_REQQTY_.getName(), (Object)netDemand);
            if (netDemand.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal childQty;
                HashMap<String, Object> row = new HashMap<String, Object>();
                MRPDataBalanceResolver.putRequire((IMRPEnvProvider)ctx, row, (RequireRowData)subReqData, (boolean)false, (int)llc);
                row.put("adjustsuggest", ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355", (String)"CalcShortage_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
                row.put("originsupplyqty", netDemand);
                row.put("origindemanddate", subReqData.getValue(DefaultField.RequireField.CPSDATE.getName()));
                row.put("operation", subReqData.getValue(DefaultField.RequireField.OPERATION.getName()));
                row.put("operationno", subReqData.getValue(DefaultField.RequireField.OPERATIONNO.getName()));
                row.put("operationdesc", subReqData.getValue(DefaultField.RequireField.OPERATIONDESC.getName()));
                row.put("iskeypart", subReqData.get(DefaultField.RequireField.__IS_KEYPART__.getName()));
                row.put("existkeypart", subReqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
                row.put("replaceplan", subReqData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
                row.put("replacepriority", subReqData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
                row.put("ismianreplace", subReqData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
                row.put("isreplace", subReqData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
                List<RequireRowData> subEntrys = CalcShortage.findSubEntrys(ctx, subReqData, netDemand, topReqData, supplyTbl, existKeyPartMap);
                if (!subEntrys.isEmpty() && ctx.isYield()) {
                    Object myield = subReqData.getValue(DefaultField.RequireField.YIELD.getName());
                    BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
                    netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)subReqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)netDemand, (IMRPEnvProvider)ctx, (boolean)false);
                    subReqData.update(DefaultField.RequireField.__MERGE_REQQTY_.getName(), (Object)netDemand);
                    row.put("srcdemandqty", netDemand);
                }
                if ((childQty = CalcShortage.createSubEntryShortage(ctx, replaceDetails, netDemand, subEntrys, llc, topReqData, shortageObj, existKeyPartMap, replaceReserveList, allUsedSupplys)).compareTo(BigDecimal.ZERO) > 0) {
                    row.put("supplydate", ctx.getPlanDate().getTime());
                }
                netDemand = netDemand.subtract(childQty);
                row.put("adjustqty", netDemand);
                replaceDetails.add(row);
            }
            if (ctx.isReplace()) {
                netDemand = CalcShortage.getReplaceQty(ctx, topReqData, subReqData, replaceMap, replaceDetails, shortageObj, existKeyPartMap, reserveList, qty, netDemand, llc, parentNetDemand, allUsedSupplys);
            }
            details.addAll(replaceDetails);
            replaceDetails.clear();
            reserveList.addAll(replaceReserveList);
            replaceReserveList.clear();
            if (ctx.isReplace() && subReqData.getRowIdx() != -1) {
                if ("B".equals(qtyType)) {
                    if (netDemand.compareTo(BigDecimal.ZERO) > 0) {
                        shortage = BigDecimal.ZERO;
                    }
                } else {
                    min = parentNetDemand.subtract(netDemand);
                    shortage = shortage.compareTo(min) >= 0 ? min : shortage;
                }
            } else if ("B".equals(qtyType)) {
                if (netDemand.compareTo(BigDecimal.ZERO) > 0) {
                    shortage = BigDecimal.ZERO;
                }
            } else {
                min = parentNetDemand.subtract(netDemand.subtract(fixScrap).divide(unitUseQty, 10, RoundingMode.HALF_UP));
                BigDecimal bigDecimal = shortage = shortage.compareTo(min) >= 0 ? min : shortage;
            }
            if (shortageObj == null || details.size() <= CPSUtil.getDetailSaveBatch((IMRPEnvProvider)ctx)) continue;
            if (ctx.getCustomParams("shortageCount") == null) {
                ctx.putCustomParams("shortageCount", String.valueOf(details.size()));
            } else {
                ctx.putCustomParams("shortageCount", String.valueOf(Integer.parseInt(ctx.getCustomParams("shortageCount")) + details.size()));
            }
            CPSUtil.batchExecuteSql(details, (Long)shortageObj.getLong("id"), (String)"mrp_cps_shortage.entryentity", (boolean)false);
        }
        return shortage;
    }

    private static BigDecimal getReplaceQty(KDCloudCPSEnv ctx, RequireRowData topReqData, RequireRowData subReqData, Map<String, ReplaceStruct> replaceMap, List<Map<String, Object>> details, DynamicObject shortageObj, Map<Integer, Boolean> existKeyPartMap, List<Map<String, Object>> reserveList, BigDecimal originQty, BigDecimal netDemand, int llc, BigDecimal parentNetDemand, Map<Integer, CPSSupplyStatNode> allUsedSupplys) {
        String replacePlanId = String.valueOf(subReqData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
        ReplaceStruct struct = replaceMap.get(replacePlanId);
        --llc;
        if (struct != null && subReqData.getRowIdx() == -1) {
            netDemand = CalcShortage.calcReplace4BOM(ctx, topReqData, subReqData, details, shortageObj, existKeyPartMap, reserveList, originQty, netDemand, llc, struct, allUsedSupplys);
        }
        return netDemand;
    }

    private static BigDecimal calcReplace4BOM(KDCloudCPSEnv ctx, RequireRowData topReqData, RequireRowData subReqData, List<Map<String, Object>> details, DynamicObject shortageObj, Map<Integer, Boolean> existKeyPartMap, List<Map<String, Object>> reserveList, BigDecimal originQty, BigDecimal netDemand, int llc, ReplaceStruct struct, Map<Integer, CPSSupplyStatNode> allUsedSupplys) {
        String key = String.format("%s\u0001%s\u0001%s\u0001%s\u0001%s", struct.getMainReplaceM().getRequireRowData().getString(DefaultField.RequireField.BILLID.getName()), struct.getMainReplaceM().getRequireRowData().getString(DefaultField.RequireField.BILLENTRYID.getName()), struct.getMainReplaceM().getRequireRowData().getString(DefaultField.RequireField.REPLACEPLAN.getName()), struct.getMainReplaceM().getMaterial(), llc);
        String replaceStra = struct.getReplaceStra();
        if ("1001".equals(replaceStra)) {
            if (ctx.getCustomParams(key) != null) {
                String priority = ctx.getCustomParams(key);
                for (ReplaceMaterialStruct rpStruct : struct.getReplaceMs()) {
                    if (!priority.equals(rpStruct.getPriority().toString())) continue;
                    CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
                    ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>();
                    bomEntrys.add(rpStruct.getRequireRowData());
                    bomEntrys.addAll(rpStruct.getRepMaterials().values());
                    ctx.forceChangeReplace(Boolean.valueOf(false));
                    BigDecimal qty = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
                    ctx.forceChangeReplace(Boolean.valueOf(true));
                    netDemand = originQty.subtract(qty);
                    break;
                }
            } else {
                netDemand = netDemand.compareTo(BigDecimal.ZERO) > 0 ? CalcShortage.getBatchReplaceQty(ctx, details, llc, topReqData, shortageObj, existKeyPartMap, reserveList, originQty, struct, allUsedSupplys) : CalcShortage.getMainReplaceQty(ctx, details, originQty, llc, topReqData, shortageObj, existKeyPartMap, reserveList, struct, allUsedSupplys);
            }
        } else if ("1003".equals(replaceStra)) {
            if (ctx.getCustomParams(key) != null) {
                String priority = ctx.getCustomParams(key);
                for (ReplaceMaterialStruct rpStruct : struct.getReplaceMs()) {
                    if (!priority.equals(rpStruct.getPriority().toString())) continue;
                    CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
                    ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>();
                    bomEntrys.add(rpStruct.getRequireRowData());
                    bomEntrys.addAll(rpStruct.getRepMaterials().values());
                    ctx.forceChangeReplace(Boolean.valueOf(false));
                    BigDecimal qty = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
                    ctx.forceChangeReplace(Boolean.valueOf(true));
                    netDemand = originQty.subtract(qty);
                }
            } else {
                netDemand = netDemand.compareTo(BigDecimal.ZERO) > 0 ? CalcShortage.getMixReplaceQty(ctx, details, llc, topReqData, shortageObj, existKeyPartMap, reserveList, originQty, struct, allUsedSupplys) : CalcShortage.getMainReplaceQty(ctx, details, originQty, llc, topReqData, shortageObj, existKeyPartMap, reserveList, struct, allUsedSupplys);
            }
        } else {
            netDemand = subReqData.getRowIdx() == -1 ? CalcShortage.getMixReplaceQty(ctx, details, llc, topReqData, shortageObj, existKeyPartMap, reserveList, originQty, struct, allUsedSupplys) : CalcShortage.getMainReplaceQty(ctx, details, originQty, llc, topReqData, shortageObj, existKeyPartMap, reserveList, struct, allUsedSupplys);
        }
        return netDemand;
    }

    private static BigDecimal getMainReplaceQty(KDCloudCPSEnv ctx, List<Map<String, Object>> details, BigDecimal originQty, int llc, RequireRowData topReqData, DynamicObject shortageObj, Map<Integer, Boolean> existKeyPartMap, List<Map<String, Object>> reserveList, ReplaceStruct struct, Map<Integer, CPSSupplyStatNode> allUsedSupplys) {
        ReplaceMaterialStruct mainReplaceM = struct.getMainReplaceM();
        BigDecimal qty = BigDecimal.ZERO;
        if (!mainReplaceM.getRepMaterials().isEmpty()) {
            CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
            ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>();
            BigDecimal rate = (BigDecimal)MRPUtil.convert((Object)mainReplaceM.getRequireRowData().get(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName()), (Object)BigDecimal.ONE);
            mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)BigDecimal.ONE);
            bomEntrys.add(mainReplaceM.getRequireRowData());
            bomEntrys.addAll(mainReplaceM.getRepMaterials().values());
            ctx.forceChangeReplace(Boolean.valueOf(false));
            qty = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
            ctx.forceChangeReplace(Boolean.valueOf(true));
            mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)rate);
        } else {
            qty = originQty;
        }
        return originQty.subtract(qty);
    }

    private static BigDecimal getMixReplaceQty(KDCloudCPSEnv ctx, List<Map<String, Object>> details, int llc, RequireRowData topReqData, DynamicObject shortageObj, Map<Integer, Boolean> existKeyPartMap, List<Map<String, Object>> reserveList, BigDecimal originQty, ReplaceStruct struct, Map<Integer, CPSSupplyStatNode> allUsedSupplys) {
        CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
        ReplaceMaterialStruct mainReplaceM = struct.getMainReplaceM();
        String replaceMethod = struct.getReplaceMethod();
        ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>();
        List replaceMs = struct.getReplaceMs();
        String replaceStra = struct.getReplaceStra();
        if ("1003".equals(replaceStra)) {
            ReplaceMaterialStruct rp = null;
            for (ReplaceMaterialStruct rpStruct : replaceMs) {
                bomEntrys.clear();
                bomEntrys.add(rpStruct.getRequireRowData());
                ctx.forceChangeReplace(Boolean.valueOf(false));
                BigDecimal calcTargetQty = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
                ctx.forceChangeReplace(Boolean.valueOf(true));
                if (calcTargetQty.compareTo(originQty) < 0) {
                    CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
                    continue;
                }
                rp = rpStruct;
                break;
            }
            BigDecimal netDemand = BigDecimal.ZERO;
            CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
            bomEntrys.clear();
            if (rp != null) {
                bomEntrys.add(rp.getRequireRowData());
                bomEntrys.addAll(rp.getRepMaterials().values());
                ctx.forceChangeReplace(Boolean.valueOf(false));
                BigDecimal calcTargetQty = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
                ctx.forceChangeReplace(Boolean.valueOf(true));
                netDemand = originQty.subtract(calcTargetQty);
                return netDemand;
            }
        }
        CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
        BigDecimal netDemand = originQty;
        BigDecimal mainQty = originQty;
        ArrayList<Map<String, Object>> copyDetails = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> copyReserveList = new ArrayList<Map<String, Object>>();
        BigDecimal rate = (BigDecimal)MRPUtil.convert((Object)mainReplaceM.getRequireRowData().get(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName()), (Object)BigDecimal.ONE);
        mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)BigDecimal.ONE);
        bomEntrys.clear();
        bomEntrys.add(mainReplaceM.getRequireRowData());
        ctx.forceChangeReplace(Boolean.valueOf(false));
        BigDecimal calcTargetQty = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
        ctx.forceChangeReplace(Boolean.valueOf(true));
        mainQty = mainQty.subtract(calcTargetQty);
        bomEntrys.addAll(mainReplaceM.getRepMaterials().values());
        CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
        ctx.forceChangeReplace(Boolean.valueOf(false));
        calcTargetQty = CalcShortage.createSubEntryShortage(ctx, details, calcTargetQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
        ctx.forceChangeReplace(Boolean.valueOf(true));
        netDemand = netDemand.subtract(calcTargetQty);
        mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)rate);
        for (ReplaceMaterialStruct rpStruct : replaceMs) {
            bomEntrys.clear();
            bomEntrys.add(rpStruct.getRequireRowData());
            ctx.forceChangeReplace(Boolean.valueOf(false));
            calcTargetQty = CalcShortage.createSubEntryShortage(ctx, copyDetails, mainQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, copyReserveList, allUsedSupplys);
            ctx.forceChangeReplace(Boolean.valueOf(true));
            mainQty = mainQty.subtract(calcTargetQty);
            CalcShortage.rollBack(ctx, copyDetails, copyReserveList, allUsedSupplys);
            bomEntrys.addAll(rpStruct.getRepMaterials().values());
            ctx.forceChangeReplace(Boolean.valueOf(false));
            calcTargetQty = CalcShortage.createSubEntryShortage(ctx, copyDetails, calcTargetQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, copyReserveList, allUsedSupplys);
            ctx.forceChangeReplace(Boolean.valueOf(true));
            netDemand = netDemand.subtract(calcTargetQty);
            details.addAll(copyDetails);
            copyDetails.clear();
            reserveList.addAll(copyReserveList);
            copyReserveList.clear();
            if (mainQty.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        if (mainQty.compareTo(BigDecimal.ZERO) > 0) {
            if ("A".equals(replaceMethod)) {
                mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)BigDecimal.ONE);
                bomEntrys.clear();
                bomEntrys.add(mainReplaceM.getRequireRowData());
                bomEntrys.addAll(mainReplaceM.getRepMaterials().values());
                ctx.forceChangeReplace(Boolean.valueOf(false));
                calcTargetQty = CalcShortage.createSubEntryShortage(ctx, copyDetails, mainQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, copyReserveList, allUsedSupplys);
                ctx.forceChangeReplace(Boolean.valueOf(true));
                mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)rate);
            } else {
                bomEntrys.clear();
                bomEntrys.add(((ReplaceMaterialStruct)replaceMs.get(0)).getRequireRowData());
                bomEntrys.addAll(((ReplaceMaterialStruct)replaceMs.get(0)).getRepMaterials().values());
                ctx.forceChangeReplace(Boolean.valueOf(false));
                calcTargetQty = CalcShortage.createSubEntryShortage(ctx, copyDetails, mainQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, copyReserveList, allUsedSupplys);
                ctx.forceChangeReplace(Boolean.valueOf(true));
            }
            netDemand = netDemand.subtract(calcTargetQty);
            details.addAll(copyDetails);
            copyDetails.clear();
            reserveList.addAll(copyReserveList);
            copyReserveList.clear();
        }
        return netDemand;
    }

    private static BigDecimal getBatchReplaceQty(KDCloudCPSEnv ctx, List<Map<String, Object>> details, int llc, RequireRowData topReqData, DynamicObject shortageObj, Map<Integer, Boolean> existKeyPartMap, List<Map<String, Object>> reserveList, BigDecimal originQty, ReplaceStruct struct, Map<Integer, CPSSupplyStatNode> allUsedSupplys) {
        BigDecimal calcTargetQty;
        CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
        ReplaceMaterialStruct mainReplaceM = struct.getMainReplaceM();
        String replaceMethod = struct.getReplaceMethod();
        ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>(16);
        List replaceMs = struct.getReplaceMs();
        ReplaceMaterialStruct rp = null;
        for (ReplaceMaterialStruct rpStruct : replaceMs) {
            bomEntrys.clear();
            bomEntrys.add(rpStruct.getRequireRowData());
            ctx.forceChangeReplace(Boolean.valueOf(false));
            BigDecimal calcTargetQty2 = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
            ctx.forceChangeReplace(Boolean.valueOf(true));
            if (calcTargetQty2.compareTo(originQty) < 0) {
                CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
                continue;
            }
            rp = rpStruct;
            break;
        }
        BigDecimal netDemand = BigDecimal.ZERO;
        CalcShortage.rollBack(ctx, details, reserveList, allUsedSupplys);
        bomEntrys.clear();
        if (rp != null) {
            bomEntrys.add(rp.getRequireRowData());
            bomEntrys.addAll(rp.getRepMaterials().values());
            ctx.forceChangeReplace(Boolean.valueOf(false));
            calcTargetQty = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
            ctx.forceChangeReplace(Boolean.valueOf(true));
            netDemand = originQty.subtract(calcTargetQty);
        } else if ("A".equals(replaceMethod)) {
            bomEntrys.add(mainReplaceM.getRequireRowData());
            bomEntrys.addAll(mainReplaceM.getRepMaterials().values());
            ctx.forceChangeReplace(Boolean.valueOf(false));
            calcTargetQty = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
            ctx.forceChangeReplace(Boolean.valueOf(true));
            netDemand = originQty.subtract(calcTargetQty);
        } else {
            bomEntrys.add(((ReplaceMaterialStruct)replaceMs.get(0)).getRequireRowData());
            bomEntrys.addAll(((ReplaceMaterialStruct)replaceMs.get(0)).getRepMaterials().values());
            ctx.forceChangeReplace(Boolean.valueOf(false));
            calcTargetQty = CalcShortage.createSubEntryShortage(ctx, details, originQty, bomEntrys, llc, topReqData, shortageObj, existKeyPartMap, reserveList, allUsedSupplys);
            ctx.forceChangeReplace(Boolean.valueOf(true));
            netDemand = originQty.subtract(calcTargetQty);
        }
        return netDemand;
    }

    private static void rollBack(KDCloudCPSEnv ctx, List<Map<String, Object>> details, List<Map<String, Object>> reserveList, Map<Integer, CPSSupplyStatNode> allUsedSupplys) {
        reserveList.clear();
        RequirementDataTable requireTbl = ctx.requireDatas();
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        for (Map<String, Object> entry : details) {
            Integer idx = (Integer)MRPUtil.convert((Object)entry.get("idx"), (Object)-1);
            if (idx == -1) continue;
            BigDecimal qty = (BigDecimal)MRPUtil.convert((Object)entry.get("supplyqty"), (Object)BigDecimal.ZERO);
            BigDecimal supplyQty = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.QTY.getName(), idx.intValue()), (Object)BigDecimal.ZERO);
            supplyTbl.updateValue(DefaultField.SupplyField.QTY.getName(), idx, (Object)qty.add(supplyQty));
            if (MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISONWORK.getName(), idx.intValue()), (Boolean)Boolean.FALSE).booleanValue()) {
                Integer findSupOrReqIndex = MRPUtil.findSupOrReqIndex((IMRPEnvProvider)ctx, (boolean)false, (Integer)idx);
                BigDecimal requireQty = (BigDecimal)MRPUtil.convert((Object)requireTbl.getValue(DefaultField.RequireField.QTY.getName(), findSupOrReqIndex.intValue()), (Object)BigDecimal.ZERO);
                requireTbl.updateValue(DefaultField.RequireField.QTY.getName(), findSupOrReqIndex, (Object)requireQty.add(qty));
            }
            if (allUsedSupplys.get(idx) == null) continue;
            CPSSupplyStatNode node = allUsedSupplys.get(idx);
            node.setMaxQty(node.getMaxQty().add(qty));
        }
        details.clear();
    }

    private static List<RequireRowData> findSubEntrys(KDCloudCPSEnv ctx, RequireRowData reqData, BigDecimal netDemand, RequireRowData topReqData, SupplymentDataTable supplyTbl, Map<Integer, Boolean> existKeyPartMap) {
        ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>(5);
        Boolean isOnWork = reqData.getBoolean(DefaultField.RequireField.__ISONWORK__.getName());
        if (isOnWork == null) {
            isOnWork = false;
        }
        if (isOnWork.booleanValue()) {
            Long billEntryId = reqData.getLong(DefaultField.RequireField.BILLENTRYID.getName());
            CalcShortage.fillOnWorkSubEntrys((IMRPEnvProvider)ctx, billEntryId, ctx.requireDatas(), bomEntrys, topReqData, supplyTbl);
        }
        if (bomEntrys.isEmpty()) {
            String exceptionNum = reqData.getString(DefaultField.RequireField.EXCEPTIONNUMBER.getName());
            if (exceptionNum != null && exceptionNum.contains("30")) {
                return bomEntrys;
            }
            if (reqData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()) == null) {
                return bomEntrys;
            }
            MRPMDependentReqNewStep dateUtil = new MRPMDependentReqNewStep((IMRPEnvProvider)ctx);
            int bomIdx = dateUtil.findBOM((RowData)reqData, netDemand);
            if (MaterialAttribute.PURCHASEDPART.getValue() == ((Integer)MRPUtil.convert((Object)reqData.get(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue())).intValue()) {
                return bomEntrys;
            }
            if (bomIdx < 0) {
                if (!"A".equals(ctx.getCPSType())) {
                    CPSUtil.tagBOMNotFound((RequireRowData)reqData);
                }
                return bomEntrys;
            }
            BOMStructDataTable bomTbl = ctx.bomDatas();
            reqData.update(DefaultField.RequireField.__BOM_IDX__.getName(), (Object)bomIdx);
            String bomFID = String.valueOf(bomTbl.getValue(DefaultField.BOMField.BOMID.getName(), bomIdx));
            List bomIdxs = DataMatchUtils.findBOMChildren((IMRPEnvProvider)ctx, new HashMap(), (String)bomFID);
            if (bomIdxs.isEmpty()) {
                CPSUtil.tagBOMEntrysNotFound((RequireRowData)reqData);
                return bomEntrys;
            }
            HashMap repStructs = new HashMap(16);
            dateUtil.calcDate(reqData, netDemand);
            HashMap parentBalancePeriod = new HashMap(16);
            HashMap parentQuota = new HashMap(16);
            HashMap rQtyMap = new HashMap(16);
            for (int j = 0; j < bomIdxs.size(); ++j) {
                CPSRequireStatNode.createChildrenStruct((MRPMDependentReqNewStep)dateUtil, bomEntrys, (IMRPEnvProvider)ctx, (RequireRowData)reqData, rQtyMap, parentQuota, parentBalancePeriod, repStructs, (List)bomIdxs, (int)((Integer)bomIdxs.get(j)), (String)bomFID, (int)j, (boolean)false, existKeyPartMap);
            }
        }
        return bomEntrys;
    }

    private static void fillOnWorkSubEntrys(IMRPEnvProvider ctx, Long billEntryId, RequirementDataTable requireTbl, List<RequireRowData> bomEntrys, RequireRowData topReqData, SupplymentDataTable supplyTbl) {
        List subRows = requireTbl.getCol(DefaultField.RequireField.SUPPLYBILLID.getName()).get((Object)billEntryId);
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mmc-cps-mrprunner, CalcShortage,billid:%s,subRows:%s", billEntryId, subRows));
        }
        for (Integer depRowIdx : subRows) {
            RequireRowData tmpBomEntry = requireTbl.fetchRow(depRowIdx.intValue());
            tmpBomEntry.update(DefaultField.RequireField.ORIGIN_BILLENTITY.getName(), tmpBomEntry.getValue(DefaultField.RequireField.BILL_ENTITY.getName()));
            tmpBomEntry.update(DefaultField.RequireField.ORIGIN_BILLID.getName(), tmpBomEntry.getValue(DefaultField.RequireField.BILLID.getName()));
            tmpBomEntry.update(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName(), tmpBomEntry.getValue(DefaultField.RequireField.BILLNUMBER.getName()));
            tmpBomEntry.update(DefaultField.RequireField.ORIGIN_BILLENTRYID.getName(), tmpBomEntry.getValue(DefaultField.RequireField.BILLENTRYID.getName()));
            tmpBomEntry.update(DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName(), tmpBomEntry.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()));
            tmpBomEntry.update(DefaultField.RequireField.BILLID.getName(), topReqData.getValue(DefaultField.RequireField.BILLID.getName()));
            tmpBomEntry.update(DefaultField.RequireField.BILLENTRYID.getName(), topReqData.getValue(DefaultField.RequireField.BILLENTRYID.getName()));
            tmpBomEntry.update(DefaultField.RequireField.BILLNUMBER.getName(), topReqData.getValue(DefaultField.RequireField.BILLNUMBER.getName()));
            tmpBomEntry.update(DefaultField.RequireField.BILLENTRYSEQ.getName(), topReqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()));
            tmpBomEntry.update(DefaultField.RequireField.BILL_ENTITY.getName(), topReqData.getValue(DefaultField.RequireField.BILL_ENTITY.getName()));
            tmpBomEntry.update(DefaultField.CommonField.__MODEL_NUMBER__.name(), topReqData.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name()));
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mmc-cps-mrprunner, depRowIdx:%s,require:%s", depRowIdx, tmpBomEntry));
            }
            bomEntrys.add(tmpBomEntry);
        }
    }
}

