/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.mservice.mrp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.mmc.mrp.business.helper.GlobalPlanHelper;
import kd.mmc.mrp.controlnode.framework.runner.MRPRunner4SPlan;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.KDCloudCPSEnv;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.mservice.api.cps.IRunCPSService;
import kd.mmc.mrp.utils.DataSourceUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;

public class RunCPSServiceImpl
implements IRunCPSService {
    public Long startCPS(Long planId, String entity, List<Long[]> ids) {
        QFilter qFilter = new QFilter("id", "=", (Object)planId);
        DynamicObject plangram = QueryServiceHelper.queryOne((String)"mrp_cps_planpro", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (plangram == null) {
            throw new KDException(new ErrorCode("PLAN_NUMBER_NOT_EXIST", String.format(ResManager.loadKDString((String)"ID\u4e3a:[%s]\u7684\u9f50\u5957\u8ba1\u5212\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"RunCPSServiceImpl_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), planId)), new Object[0]);
        }
        if ((plangram = BusinessDataServiceHelper.loadSingle((Object)plangram.get("id"), (String)"mrp_cps_planpro")).getDynamicObject("wipbillfields") == null) {
            throw new KDException(new ErrorCode("WIP_FIELDS_NOT_NULL", String.format(ResManager.loadKDString((String)"\u9f50\u5957\u8ba1\u5212\u65b9\u6848[%s]\u4e2d\u4f9b\u5e94\u8f6c\u9700\u6c42\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (String)"RunCPSServiceImpl_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), plangram.getString("number"))), new Object[0]);
        }
        DynamicObject log = this.createLog(plangram);
        KDCloudCPSEnv env = new KDCloudCPSEnv(log);
        HashSet<String> mIds = new HashSet<String>(16);
        HashMap<Long, List<Object[]>> map = new HashMap<Long, List<Object[]>>(8);
        this.getRunData((IMRPEnvProvider)env, plangram, entity, ids, mIds, map);
        new MRPRunner4SPlan(map, mIds).run((IMRPEnvProvider)env);
        return log.getLong("id");
    }

    private void getRunData(IMRPEnvProvider env, DynamicObject plangram, String entity, List<Long[]> ids, Set<String> mIds, Map<Long, List<Object[]>> map) {
        CacheDatas cache = (CacheDatas)env.getService(CacheDatas.class);
        cache.init();
        PlanModel planModel = (PlanModel)env.getService(PlanModel.class);
        planModel.init();
        HashSet enabledRequires = planModel.getEnabledRequires();
        DynamicObjectCollection col = plangram.getDynamicObjectCollection("scentryentity");
        DynamicObject source = null;
        List<String> supplyBills = Arrays.asList("pom_mftorder", "om_mftorder", "mrp_planorder");
        for (DynamicObject entry : col) {
            if (!supplyBills.contains(entry.getString("entrysupplyres.id"))) continue;
            if (entity.equals(entry.getString("entrysupplyres.id"))) {
                source = entry.getDynamicObject("resourceregisters");
                planModel.getEnabledSupplys().add(entry.getString("resourceregisters.id"));
                if (entry.getBoolean("entryisscmrpoperat")) continue;
                env.putCustomParams("is_use_" + entry.getString("entrysupplyres.id"), "1");
                continue;
            }
            planModel.getEnabledSupplys().remove(entry.getString("resourceregisters.id"));
        }
        if (source == null) {
            throw new KDException(new ErrorCode("SUPPLY_BILL_NOT_EXISTS", String.format(ResManager.loadKDString((String)"\u9f50\u5957\u8ba1\u5212\u65b9\u6848\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u5b9e\u4f53\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u7684\u4f9b\u5e94\u6570\u636e\u6e90\u3002", (String)"RunCPSServiceImpl_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), plangram.getString("number"), entity)), new Object[0]);
        }
        col = plangram.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : col) {
            if (!entry.getBoolean("entryismrpoperat")) continue;
            if (entity.equals("pom_mftorder") && "pom_mftstock".equals(entry.getString("entrydemandsrc.id"))) {
                enabledRequires.remove(entry.getString("resourceregister.id"));
                env.putCustomParams("cps_resourceregister_" + entry.getString("entrydemandsrc.id"), entry.getString("resourceregister.id"));
                break;
            }
            if (entity.equals("om_mftorder") && "om_mftstock".equals(entry.getString("entrydemandsrc.id"))) {
                enabledRequires.remove(entry.getString("resourceregister.id"));
                env.putCustomParams("cps_resourceregister_" + entry.getString("entrydemandsrc.id"), entry.getString("resourceregister.id"));
                break;
            }
            if (!entity.equals("mrp_planorder") || !"mrp_planorder".equals(entry.getString("entrydemandsrc.id"))) continue;
            enabledRequires.remove(entry.getString("resourceregister.id"));
            env.putCustomParams("cps_resourceregister_" + entry.getString("entrydemandsrc.id"), entry.getString("resourceregister.id"));
            break;
        }
        QFilter qf = null;
        String billEntryKey = "treeentryentity";
        if (ids != null && !ids.isEmpty()) {
            HashSet<Long> billSet = new HashSet<Long>(ids.size());
            HashSet<Long> entrySet = new HashSet<Long>(ids.size());
            for (Long[] arr : ids) {
                billSet.add(arr[0]);
                if (arr[1] == null) continue;
                entrySet.add(arr[1]);
            }
            if (entity.equals("mrp_planorder")) {
                qf = new QFilter("id", "in", billSet);
                billEntryKey = "entryentity";
            } else {
                billEntryKey = "treeentryentity";
                qf = entrySet.isEmpty() ? new QFilter("id", "in", billSet) : new QFilter("treeentryentity.id", "in", entrySet);
            }
        }
        FetchDataQueryModule queryMD = DataSourceUtil.getQueryModuleByModelFilter((Long)source.getLong("id"), qf);
        DataSet dataSet = DataSourceUtil.getDataSetByModel((FetchDataQueryModule)queryMD, (DataSet)QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null));
        RowMeta rowMeta = dataSet.getRowMeta();
        for (Row row : dataSet) {
            Long entrymaterial;
            Long l = entrymaterial = this.havProperty(rowMeta, "entryentity.material") ? (Long)MRPUtil.convert((Object)row.get("entryentity.material"), (Object)0L) : Long.valueOf(0L);
            Long requireorg = this.havProperty(rowMeta, "entryentity.productionorgunit") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.productionorgunit"), (Object)0L) : (this.havProperty(rowMeta, "entryentity.supplyorgunit") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.supplyorgunit"), (Object)0L) : Long.valueOf(0L));
            Long configuredcode = this.havProperty(rowMeta, "entryentity.configuredcode") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.configuredcode"), (Object)0L) : Long.valueOf(0L);
            Long id = this.havProperty(rowMeta, "entryentity.billid") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.billid"), (Object)0L) : Long.valueOf(0L);
            Long entryid = this.havProperty(rowMeta, "entryentity.billentryid") ? (Long)MRPUtil.convert((Object)row.getLong("entryentity.billentryid"), (Object)0L) : Long.valueOf(0L);
            List list = map.computeIfAbsent(source.getLong("id"), k -> new ArrayList(16));
            Object[] values = new Object[]{id, entryid, billEntryKey, 0L, configuredcode, requireorg};
            list.add(values);
            mIds.add(Long.toString(entrymaterial));
        }
    }

    private boolean havProperty(RowMeta rowMeta, String field) {
        return rowMeta.getFieldIndex(field, false) >= 0;
    }

    private DynamicObject createLog(DynamicObject plangram) {
        DynamicObject caculateLog = ORM.create().newDynamicObject("mrp_caculate_log");
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", plangram.get("createorg.number"))});
        String plantype = PlanModel.getPlanType((DynamicObject)plangram);
        Long id = ORM.create().genLongId("mrp_caculate_log");
        String number = CodeRuleServiceHelper.getNumber((String)"mrp_caculate_log", (DynamicObject)caculateLog, (String)org.getPkValue().toString());
        if (StringUtils.isBlank((CharSequence)number)) {
            throw new KDException(new ErrorCode("CAL_LOG_NUMBER_NOT_EXIST", ResManager.loadKDString((String)"\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"RunCPSServiceImpl_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0])), new Object[0]);
        }
        caculateLog.set("id", (Object)id);
        caculateLog.set("number", (Object)number);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("runtype", (Object)"B");
        caculateLog.set("plantype", (Object)plantype);
        caculateLog.set("clearstatus", (Object)Character.valueOf('A'));
        caculateLog.set("status", (Object)Character.valueOf('C'));
        caculateLog.set("enable", (Object)Character.valueOf('1'));
        caculateLog.set("plangram", (Object)plangram.getLong("id"));
        caculateLog.set("programnumber", (Object)plangram.getString("number"));
        caculateLog.set("programname", (Object)plangram.getString("name"));
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("iscommon", plangram.get("iscommon"));
        caculateLog.set("iscustomize", plangram.get("iscustomize"));
        caculateLog.set("isselection", plangram.get("isselection"));
        caculateLog.set("isnotsetup", plangram.get("isnotsetup"));
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("operatmode", (Object)ResManager.loadKDString((String)"\u9f50\u5957\u5206\u6790", (String)"RunCPSServiceImpl_4", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
        caculateLog.set("operatmodekey", (Object)"mrp_cps_runner");
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("isllc", (Object)false);
        caculateLog.set("isbomcheck", (Object)false);
        caculateLog.set("isallowdateinpast", (Object)false);
        caculateLog.set("plangramentity", (Object)"mrp_cps_planpro");
        DynamicObjectCollection plantags = plangram.getDynamicObjectCollection("plantags");
        DynamicObjectCollection calctags = caculateLog.getDynamicObjectCollection("plantags");
        calctags.clear();
        for (DynamicObject tag : plantags) {
            DynamicObject cal = calctags.addNew();
            cal.set("fbasedataid", tag.get("fbasedataid"));
        }
        if (GlobalPlanHelper.isExistMRPRunning((Long)plangram.getLong("id"))) {
            throw new KDException(new ErrorCode("PLAN_NUMBER_IS_RUNING", String.format(ResManager.loadKDString((String)"[%s]\u8be5\u8ba1\u5212\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"RunCPSServiceImpl_5", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), plangram.getString("number"))), new Object[0]);
        }
        ORM.create().save(caculateLog);
        BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        return caculateLog;
    }
}

