/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.helper;

import java.time.LocalDate;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.mmc.mrp.business.helper.AdjustSuggestHelper;
import kd.mmc.mrp.common.util.LocalDateUtil;

public class AdjustFilterHelper {
    private static final String ID = "id";
    private static final String BASEDATAID = "fbasedataid";

    public static QFilter getFilters(IFormView view) {
        long caculateLogId = 0L;
        QFilter filter = null;
        boolean isShowHistory = false;
        if (view.getModel().getValue("isshowhistory") != null) {
            isShowHistory = (Boolean)view.getModel().getValue("isshowhistory");
        }
        if (view.getModel().getValue("planno") != null) {
            long lastId;
            DynamicObject caculateLog = (DynamicObject)view.getModel().getValue("planno");
            caculateLogId = caculateLog.getLong(ID);
            if (!isShowHistory && caculateLogId != (lastId = AdjustSuggestHelper.getLastCaculateLog(caculateLogId))) {
                view.getPageCache().put("isShowHistory", "false");
                return new QFilter("1", "!=", (Object)1);
            }
            filter = new QFilter("plannum", "=", (Object)caculateLogId);
        } else {
            filter = isShowHistory ? new QFilter("1", "=", (Object)1) : new QFilter("plannum", "in", (Object)AdjustSuggestHelper.getLastCaculateLogs());
        }
        if (view.getFormShowParameter().getCustomParam("formId") != null) {
            String formId = (String)view.getFormShowParameter().getCustomParam("formId");
            if ("mrp_adjust_manu".equals(formId)) {
                filter = filter.and(new QFilter("materialattr", "=", (Object)"10030"));
            } else if ("mrp_adjust_pur".equals(formId)) {
                filter = filter.and(new QFilter("materialattr", "=", (Object)"10040"));
            } else if ("mrp_adjust_out".equals(formId)) {
                filter = filter.and(new QFilter("materialattr", "=", (Object)"10050"));
            } else if ("mrp_adjust_view".equals(formId)) {
                AdjustFilterHelper.addMaterialAttrFilter(view, filter);
            } else {
                AdjustFilterHelper.addMaterialAttrFilter(view, filter);
            }
        } else {
            AdjustFilterHelper.addMaterialAttrFilter(view, filter);
        }
        AdjustFilterHelper.addFilters(filter, view);
        return filter;
    }

    private static void addMaterialAttrFilter(IFormView view, QFilter filter) {
        boolean isAssitant;
        boolean isOut;
        boolean isPur;
        boolean isManu = (Boolean)view.getModel().getValue("ismanuattr");
        if (!isManu) {
            filter = filter.and(new QFilter("materialattr", "!=", (Object)"10030"));
        }
        if (!(isPur = ((Boolean)view.getModel().getValue("ispurattr")).booleanValue())) {
            filter = filter.and(new QFilter("materialattr", "!=", (Object)"10040"));
        }
        if (!(isOut = ((Boolean)view.getModel().getValue("isoutattr")).booleanValue())) {
            filter = filter.and(new QFilter("materialattr", "!=", (Object)"10050"));
        }
        if (!(isAssitant = ((Boolean)view.getModel().getValue("isassitant")).booleanValue())) {
            filter = filter.and(new QFilter("materialattr", "!=", (Object)"10060"));
        }
    }

    private static void addFilters(QFilter filter, IFormView view) {
        AdjustFilterHelper.addMaterialFilter(filter, view);
        AdjustFilterHelper.addSchdulerFilter(filter, view);
        AdjustFilterHelper.addOrinDateFilter(filter, view);
        AdjustFilterHelper.addAdjustDateFilter(filter, view);
        AdjustFilterHelper.addSupplierFilter(filter, view);
        AdjustFilterHelper.addPurchasersFilter(filter, view);
        AdjustFilterHelper.addAdjustTypeFilter(filter, view);
        AdjustFilterHelper.addAdjustReasonFilter(filter, view);
        AdjustFilterHelper.addReleaseStatusFilter(filter, view);
        AdjustFilterHelper.addSupplyTypeFilter(filter, view);
        AdjustFilterHelper.addSupplyBillNoFilter(filter, view);
        AdjustFilterHelper.addTrackNumberFilter(filter, view);
        AdjustFilterHelper.addConfigureCodeFilter(filter, view);
    }

    private static void addTrackNumberFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("tracknumbers") != null) {
            DynamicObjectCollection tracks = (DynamicObjectCollection)view.getModel().getValue("tracknumbers");
            HashSet<Long> tracksSet = new HashSet<Long>(tracks.size());
            for (DynamicObject track : tracks) {
                DynamicObject basedataObj = track.getDynamicObject(BASEDATAID);
                tracksSet.add(basedataObj.getLong(ID));
            }
            if (!tracksSet.isEmpty()) {
                filter.and(new QFilter("tracknumber", "in", tracksSet));
            }
        }
    }

    private static void addConfigureCodeFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("configuredcodes") != null) {
            DynamicObjectCollection tracks = (DynamicObjectCollection)view.getModel().getValue("configuredcodes");
            HashSet<Long> tracksSet = new HashSet<Long>(tracks.size());
            for (DynamicObject track : tracks) {
                DynamicObject basedataObj = track.getDynamicObject(BASEDATAID);
                tracksSet.add(basedataObj.getLong(ID));
            }
            if (!tracksSet.isEmpty()) {
                filter.and(new QFilter("configuredcode", "in", tracksSet));
            }
        }
    }

    private static void addMaterialFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("materials") != null) {
            DynamicObjectCollection materiels = (DynamicObjectCollection)view.getModel().getValue("materials");
            HashSet<Long> materialSet = new HashSet<Long>(materiels.size());
            for (DynamicObject materiel : materiels) {
                DynamicObject basedataObj = materiel.getDynamicObject(BASEDATAID);
                materialSet.add(basedataObj.getLong(ID));
            }
            if (!materialSet.isEmpty()) {
                filter.and(new QFilter("materiel", "in", materialSet));
            }
        }
    }

    private static void addSchdulerFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("schdulers") != null) {
            DynamicObjectCollection schdulers = (DynamicObjectCollection)view.getModel().getValue("schdulers");
            HashSet<Long> schdulerSet = new HashSet<Long>(schdulers.size());
            for (DynamicObject schduler : schdulers) {
                DynamicObject basedataObj = schduler.getDynamicObject(BASEDATAID);
                schdulerSet.add(basedataObj.getLong(ID));
            }
            if (!schdulerSet.isEmpty()) {
                filter.and(new QFilter("schduler", "in", schdulerSet));
            }
        }
    }

    private static void addOrinDateFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("origindates_start") != null && view.getModel().getValue("origindates_end") != null) {
            Date startDate = (Date)view.getModel().getValue("origindates_start");
            Date endDate = (Date)view.getModel().getValue("origindates_end");
            LocalDate start = LocalDateUtil.date2LocalDate((Date)startDate);
            LocalDate end = LocalDateUtil.date2LocalDate((Date)endDate);
            filter.and(new QFilter("origindate", ">=", (Object)LocalDateUtil.localDate2Date((LocalDate)start)));
            filter.and(new QFilter("origindate", "<=", (Object)LocalDateUtil.localDate2Date((LocalDate)end)));
        }
    }

    private static void addAdjustDateFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("adjustdates_start") != null && view.getModel().getValue("adjustdates_end") != null) {
            Date startDate = (Date)view.getModel().getValue("adjustdates_start");
            Date endDate = (Date)view.getModel().getValue("adjustdates_end");
            LocalDate start = LocalDateUtil.date2LocalDate((Date)startDate);
            LocalDate end = LocalDateUtil.date2LocalDate((Date)endDate);
            filter.and(new QFilter("suggestdate", ">=", (Object)LocalDateUtil.localDate2Date((LocalDate)start)));
            filter.and(new QFilter("suggestdate", "<=", (Object)LocalDateUtil.localDate2Date((LocalDate)end)));
        }
    }

    private static void addSupplierFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("suppliers") != null) {
            DynamicObjectCollection supplier = (DynamicObjectCollection)view.getModel().getValue("suppliers");
            HashSet<Long> supplierSet = new HashSet<Long>(supplier.size());
            for (DynamicObject purchaser : supplier) {
                DynamicObject basedataObj = purchaser.getDynamicObject(BASEDATAID);
                supplierSet.add(basedataObj.getLong(ID));
            }
            if (!supplierSet.isEmpty()) {
                filter.and(new QFilter("supplier", "in", supplierSet));
            }
        }
    }

    private static void addPurchasersFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("purchasers") != null) {
            DynamicObjectCollection purchasers = (DynamicObjectCollection)view.getModel().getValue("purchasers");
            HashSet<Long> purchaserSet = new HashSet<Long>(purchasers.size());
            for (DynamicObject purchaser : purchasers) {
                DynamicObject basedataObj = purchaser.getDynamicObject(BASEDATAID);
                purchaserSet.add(basedataObj.getLong(ID));
            }
            if (!purchaserSet.isEmpty()) {
                filter.and(new QFilter("purchaser", "in", purchaserSet));
            }
        }
    }

    private static void addAdjustTypeFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("adjustsuggests") != null) {
            String[] adjusts;
            String adjustSuggests = (String)view.getModel().getValue("adjustsuggests");
            HashSet<String> set = new HashSet<String>(4);
            for (String adjust : adjusts = adjustSuggests.split(",")) {
                if (StringUtils.isBlank((CharSequence)adjust)) continue;
                set.add(adjust);
            }
            filter.and(new QFilter("adjustsuggest", "in", set));
        }
    }

    private static void addAdjustReasonFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("isadjustreason") != null) {
            String isadjust = (String)view.getModel().getValue("isadjustreason");
            if ("1".equals(isadjust)) {
                filter.and(new QFilter("adjustcause", "!=", (Object)""));
                filter.and(QFilter.isNotNull((String)"adjustcause"));
            } else if ("0".equals(isadjust)) {
                filter.and(new QFilter("adjustcause", "=", (Object)""));
            }
        }
    }

    private static void addReleaseStatusFilter(QFilter filter, IFormView view) {
        if (view.getModel().getValue("isrelease") != null) {
            String isRelease = (String)view.getModel().getValue("isrelease");
            if ("1".equals(isRelease)) {
                filter.and(new QFilter("releasestatus", "=", (Object)Boolean.TRUE));
            } else if ("0".equals(isRelease)) {
                filter.and(new QFilter("releasestatus", "=", (Object)Boolean.FALSE));
            }
        }
    }

    private static void addSupplyTypeFilter(QFilter filter, IFormView view) {
        String supplyType;
        if (view.getModel().getValue("supplytype") != null && !StringUtils.isBlank((CharSequence)(supplyType = (String)view.getModel().getValue("supplytype")))) {
            filter.and(QFilter.like((String)"billtype.name", (String)supplyType));
        }
    }

    private static void addSupplyBillNoFilter(QFilter filter, IFormView view) {
        String supplyBillNo;
        if (view.getModel().getValue("supplybillno") != null && !StringUtils.isBlank((CharSequence)(supplyBillNo = (String)view.getModel().getValue("supplybillno")))) {
            filter.and(QFilter.like((String)"billno", (String)supplyBillNo));
        }
    }
}

