/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AdjustSuggestHelper {
    private static final Logger logger = Logger.getLogger("kd.mmc.mrp.business.helper.AdjustSuggestHelper");
    private static final String CACULATELOG = "mrp_caculate_log";
    private static final String ID = "id";

    public static void colseDataSetCache(String dataSetCacheId) {
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)dataSetCacheId);
        cacheDataSet.close();
    }

    public static String bulidDataSetCache(QFilter filterInfo) {
        long startTime = System.currentTimeMillis();
        String algoKey = "kd.mmc.mrp.business.helper.AdjustSuggestHelper";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_adjustsuggest", (String)AdjustSuggestHelper.getSelectFields(), (QFilter[])new QFilter[]{filterInfo}, null, (int)350000);){
            CacheHint hint = new CacheHint();
            hint.setTimeout(86400000L);
            CachedDataSet cache = dataSet.cache(hint);
            long endTime = System.currentTimeMillis();
            logger.info("\u8c03\u6574\u5efa\u8bae\u6570\u636e\u67e5\u8be2dataset\u8017\u65f6:" + (endTime - startTime) + "ms");
            String string = cache.getCacheId();
            return string;
        }
    }

    public static String bulidExportDataSetCache(QFilter filterInfo) {
        long startTime = System.currentTimeMillis();
        String algoKey = "kd.mmc.mrp.business.helper.AdjustSuggestHelper";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_adjustsuggest", (String)AdjustSuggestHelper.getExportFields(), (QFilter[])new QFilter[]{filterInfo}, null, (int)350000);){
            CacheHint hint = new CacheHint();
            hint.setTimeout(86400000L);
            CachedDataSet cache = dataSet.cache(hint);
            long endTime = System.currentTimeMillis();
            logger.info("\u8c03\u6574\u5efa\u8bae\u6570\u636e\u67e5\u8be2dataset\u8017\u65f6:" + (endTime - startTime) + "ms");
            String string = cache.getCacheId();
            return string;
        }
    }

    public static String getSelectFields() {
        StringBuilder fields = new StringBuilder();
        fields.append(ID).append(',');
        fields.append("adjustcause").append(',');
        fields.append("adjustdate").append(',');
        fields.append("releasestatus").append(',');
        fields.append("adjustsuggest").append(',');
        fields.append("origindate").append(',');
        fields.append("materiel").append(',');
        fields.append("plannum").append(',');
        fields.append("entryseq").append(',');
        fields.append("purchaser").append(',');
        fields.append("schduler").append(',');
        fields.append("supplier").append(',');
        fields.append("baseunit").append(',');
        fields.append("billno").append(',');
        fields.append("billtype").append(',');
        fields.append("billtype.name").append(',');
        fields.append("createtime").append(',');
        fields.append("creator").append(',');
        fields.append("dealdate").append(',');
        fields.append("dealer").append(',');
        fields.append("lineno").append(',');
        fields.append("materialattr").append(',');
        fields.append("qty").append(',');
        fields.append("suggestdate").append(',');
        fields.append("supplyorg").append(',');
        fields.append("adjustdatetype").append(',');
        fields.append("tracknumber").append(',');
        fields.append("configuredcode").append(',');
        fields.append("adjuststrategy").append(',');
        fields.append("project").append(',');
        fields.append("auxprop");
        return fields.toString();
    }

    public static String getExportFields() {
        StringBuilder fields = new StringBuilder();
        fields.append(ID).append(',');
        fields.append("adjustcause").append(',');
        fields.append("adjustdate").append(',');
        fields.append("releasestatus").append(',');
        fields.append("adjustsuggest").append(',');
        fields.append("origindate").append(',');
        fields.append("materiel").append(',');
        fields.append("materiel.number").append(',');
        fields.append("materiel.name").append(',');
        fields.append("auxprop").append(',');
        fields.append("plannum.number").append(',');
        fields.append("entryseq").append(',');
        fields.append("purchaser.operatorname").append(',');
        fields.append("schduler.number").append(',');
        fields.append("schduler.name").append(',');
        fields.append("supplier.name").append(',');
        fields.append("baseunit.name").append(',');
        fields.append("billno").append(',');
        fields.append("billtype.name").append(',');
        fields.append("createtime").append(',');
        fields.append("creator.name").append(',');
        fields.append("adjustdatetype").append(',');
        fields.append("adjuststrategy").append(',');
        fields.append("dealdate").append(',');
        fields.append("dealer.name").append(',');
        fields.append("lineno").append(',');
        fields.append("materialattr").append(',');
        fields.append("qty").append(',');
        fields.append("suggestdate").append(',');
        fields.append("tracknumber.number").append(',');
        fields.append("configuredcode.number").append(',');
        fields.append("supplyorg.name");
        return fields.toString();
    }

    public static int loadDataByCache(String cacheId, TableValueSetter vs, int rowNumber, int pageNum, int pageSize) {
        int count = 0;
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
        count = cacheDataSet.getRowCount();
        if (count == 0 || pageNum == 0) {
            return 0;
        }
        int fromIndex = (pageNum - 1) * pageSize;
        List pageRows = cacheDataSet.getList(fromIndex, pageSize);
        for (Row dyn : pageRows) {
            vs.set("adjustcause", (Object)dyn.getString("adjustcause"), rowNumber);
            vs.set(ID, (Object)dyn.getLong(ID), rowNumber);
            Boolean release = dyn.getBoolean("releasestatus");
            vs.set("releasestatus", (Object)release, rowNumber);
            if (release.booleanValue()) {
                vs.set("releases", (Object)Character.valueOf('1'), rowNumber);
            } else {
                vs.set("releases", (Object)Character.valueOf('0'), rowNumber);
            }
            vs.set("adjustsuggest", (Object)dyn.getString("adjustsuggest"), rowNumber);
            vs.set("origindate", (Object)dyn.getDate("origindate"), rowNumber);
            vs.set("materiel", (Object)dyn.getLong("materiel"), rowNumber);
            vs.set("auxprop", (Object)dyn.getLong("auxprop"), rowNumber);
            vs.set("plannum", (Object)dyn.getLong("plannum"), rowNumber);
            vs.set("purchaser", (Object)dyn.getLong("purchaser"), rowNumber);
            vs.set("schduler", (Object)dyn.getLong("schduler"), rowNumber);
            vs.set("supplier", (Object)dyn.getLong("supplier"), rowNumber);
            vs.set("baseunit", (Object)dyn.getLong("baseunit"), rowNumber);
            vs.set("billno", (Object)dyn.getString("billno"), rowNumber);
            vs.set("billtype", (Object)dyn.getString("billtype"), rowNumber);
            vs.set("createtime", (Object)dyn.getDate("createtime"), rowNumber);
            vs.set("creator", (Object)dyn.getLong("creator"), rowNumber);
            vs.set("dealdate", (Object)dyn.getDate("dealdate"), rowNumber);
            vs.set("dealer", (Object)dyn.getLong("dealer"), rowNumber);
            vs.set("lineno", (Object)dyn.getInteger("lineno"), rowNumber);
            vs.set("materialattr", (Object)dyn.getString("materialattr"), rowNumber);
            vs.set("qty", (Object)dyn.getBigDecimal("qty"), rowNumber);
            vs.set("suggestdate", (Object)dyn.getDate("suggestdate"), rowNumber);
            vs.set("adjustdate", (Object)dyn.getDate("adjustdate"), rowNumber);
            vs.set("supplyorg", (Object)dyn.getLong("supplyorg"), rowNumber);
            vs.set("entryseq", (Object)dyn.getString("entryseq"), rowNumber);
            vs.set("adjustdatetype", (Object)dyn.getString("adjustdatetype"), rowNumber);
            vs.set("adjuststrategy", (Object)dyn.getString("adjuststrategy"), rowNumber);
            vs.set("tracknumber", (Object)dyn.getLong("tracknumber"), rowNumber);
            vs.set("configuredcode", (Object)dyn.getLong("configuredcode"), rowNumber);
            vs.set("project", (Object)dyn.getLong("project"), rowNumber);
            vs.set("entryseq", (Object)dyn.getString("entryseq"), rowNumber);
            ++rowNumber;
        }
        return count;
    }

    public static Date getFormDate(Date date, String formStr) {
        SimpleDateFormat sim = new SimpleDateFormat(formStr);
        Date formDate = null;
        try {
            String forms = sim.format(date);
            formDate = sim.parse(forms);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return formDate;
    }

    public static Date getFormDate(String dateStr, String formStr) {
        SimpleDateFormat sim = new SimpleDateFormat(formStr);
        Date formDate = null;
        try {
            formDate = sim.parse(dateStr);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return formDate;
    }

    public static String getLongDateStr(Date date) {
        String format = "";
        if (date != null) {
            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format = sim.format(date);
        }
        return format;
    }

    public static String getShortDateStr(Date date) {
        String format = "";
        if (date != null) {
            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
            format = sim.format(date);
        }
        return format;
    }

    public static DynamicObject loadSingelBillData(IDataModel model, int rowIndex, String fields) {
        long billId = (Long)model.getValue(ID, rowIndex);
        DynamicObject adjust = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"mrp_adjustsuggest", (String)fields);
        return adjust;
    }

    public static void loadDealInfo(IDataModel model, int rowIndex, DynamicObject adjust) {
        Date currentTime = new Date();
        adjust.set("dealer", (Object)RequestContext.get().getCurrUserId());
        adjust.set("dealdate", (Object)currentTime);
        model.setValue("dealer", (Object)RequestContext.get().getCurrUserId(), rowIndex);
        model.setValue("dealdate", (Object)currentTime, rowIndex);
    }

    public static String getFieldString(Row model, String field) {
        String value = "";
        if (model.get(field) != null && model.get(field) instanceof String) {
            value = model.getString(field);
        } else if (model.get(field) != null && model.get(field) instanceof BigDecimal) {
            value = model.getBigDecimal(field).stripTrailingZeros().toPlainString();
        } else if (model.get(field) != null && model.get(field) instanceof Long) {
            value = String.valueOf(model.getLong(field));
        } else if (model.get(field) != null && model.get(field) instanceof Integer) {
            value = String.valueOf(model.getInteger(field));
        }
        return value;
    }

    public static QFilter getLastCaculateLogQFilter() {
        QFilter qf1 = new QFilter("runtype", "=", (Object)"A");
        qf1.and("calculatestatus", "=", (Object)"A");
        qf1.and("clearstatus", "!=", (Object)Character.valueOf('B'));
        qf1.and("operatmodekey", "!=", (Object)"mrp_simulation");
        return qf1;
    }

    public static long getLastCaculateLog() {
        DynamicObjectCollection caculateLogColl = QueryServiceHelper.query((String)CACULATELOG, (String)ID, (QFilter[])new QFilter[]{AdjustSuggestHelper.getLastCaculateLogQFilter()}, (String)"startdate desc", (int)1);
        if (caculateLogColl != null && !caculateLogColl.isEmpty()) {
            DynamicObject caculateLog = (DynamicObject)caculateLogColl.get(0);
            return caculateLog.getLong(ID);
        }
        return 0L;
    }

    public static long getLastCaculateLog(long currentId) {
        QFilter planprogramFilter;
        long plangramId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdjustSuggestHelper", (String)CACULATELOG, (String)"plangram", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)currentId)}, null);){
            Row row;
            if (dataSet != null && dataSet.hasNext() && (row = dataSet.next()).get("plangram") != null) {
                plangramId = row.getLong("plangram");
            }
        }
        QFilter planTypeFilter = AdjustSuggestHelper.getLastCaculateLogQFilter();
        DynamicObjectCollection caculateLogColl = QueryServiceHelper.query((String)CACULATELOG, (String)ID, (QFilter[])new QFilter[]{planTypeFilter, planprogramFilter = new QFilter("plangram", "=", (Object)plangramId)}, (String)"startdate desc", (int)1);
        if (caculateLogColl != null && !caculateLogColl.isEmpty()) {
            DynamicObject caculateLog = (DynamicObject)caculateLogColl.get(0);
            return caculateLog.getLong(ID);
        }
        return 0L;
    }

    public static Long[] getLastCaculateLogs() {
        ArrayList<Long> lastCaculateLogs = new ArrayList<Long>(16);
        HashSet<Long> plangrams = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdjustSuggestHelper", (String)CACULATELOG, (String)"id, plangram, startdate", (QFilter[])new QFilter[]{AdjustSuggestHelper.getLastCaculateLogQFilter()}, (String)"startdate desc");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long plangram = 0L;
                if (row.get("plangram") != null) {
                    plangram = row.getLong("plangram");
                }
                if (!plangrams.add(plangram)) continue;
                lastCaculateLogs.add(row.getLong(ID));
            }
        }
        return lastCaculateLogs.toArray(new Long[0]);
    }

    public static DynamicObject getlastCaculateLogNum(long currentId) {
        QFilter planprogramFilter;
        long plangramId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdjustSuggestHelper", (String)CACULATELOG, (String)"plangram", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)currentId)}, null);){
            Row row;
            if (dataSet != null && dataSet.hasNext() && (row = dataSet.next()).get("plangram") != null) {
                plangramId = row.getLong("plangram");
            }
        }
        QFilter planTypeFilter = AdjustSuggestHelper.getLastCaculateLogQFilter();
        DynamicObjectCollection caculateLogColl = QueryServiceHelper.query((String)CACULATELOG, (String)"id, number, createorg, creator", (QFilter[])new QFilter[]{planTypeFilter, planprogramFilter = new QFilter("plangram", "=", (Object)plangramId)}, (String)"startdate desc", (int)1);
        if (caculateLogColl != null && !caculateLogColl.isEmpty()) {
            DynamicObject caculateLog = (DynamicObject)caculateLogColl.get(0);
            return caculateLog;
        }
        return null;
    }
}

