/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.mrp.business.synnetchange.NetChangeSynHelper;
import kd.mmc.mrp.common.consts.InitDataConst;
import kd.mmc.mrp.common.consts.QTInitConst;
import kd.mmc.mrp.common.enums.InitContextEnum;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class MRPInitHelper {
    private static final Log log = LogFactory.getLog(MRPInitHelper.class);
    private static final String MRP_INITDATA = "mrp_initdata";
    private static final String algoKey = "MRPInitHelper";
    private static final String CREATEORG = "createorg";
    private static final String ISREDLIGHT = "isredlight";
    private static final String ISYELLOWLIGHT = "isyellowlight";
    private static final String ISGREENLIGHT = "isgreenlight";
    private static final String ISSHOW = "isshow";
    private static final String PRIORITY = "priority";
    private static final String MRP_EXCEPTIONGROUP = "mrp_exceptiongroup";
    private static final String MRP_DEFINITIONEXCEPTION = "mrp_definitionexception";
    private static final String NUMBER = "number";
    private static final String STATUS = "status";
    private static final String NAME = "name";
    private static final String ENABLE = "enable";
    private static final String CREATOR = "creator";
    private static final String CREATETIME = "createtime";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String ISVISIBLE = "isvisible";
    private static final String GROUP = "group";
    private static final Map<String, String> cellsdatas = new HashMap<String, String>(2);
    private static final Map<String, String> xmls = new HashMap<String, String>(2);
    private static final Set<String> initializedEntity = new HashSet<String>(2);

    public static void initConfigData(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(5);
        ArrayList<InitContextEnum> values = new ArrayList<InitContextEnum>(Arrays.asList(InitContextEnum.values()));
        values.remove(InitContextEnum.MTOStrategy);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)MRP_INITDATA, (String)"inittype", (QFilter[])new QFilter[]{qFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                InitContextEnum num = InitContextEnum.fromName((String)row.getString("inittype"));
                if (num == null) continue;
                values.remove(num);
            }
        }
        for (InitContextEnum num : values) {
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)MRP_INITDATA);
            data.set("org", (Object)orgId);
            data.set(CREATETIME, (Object)new Date());
            data.set(CREATOR, (Object)RequestContext.get().getCurrUserId());
            data.set("initstatus", (Object)"0");
            data.set("inittype", (Object)num.getName());
            data.set("inittext", (Object)num.getValue());
            list.add(data);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    public static synchronized void initMrpData(long useOrgId, List<Long> ids, long calcId, String appId) {
        if (ids.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "mrp";
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        ArrayList<InitContextEnum> initEnums = new ArrayList<InitContextEnum>(ids.size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)MRP_INITDATA, (String)"id,inittype", (QFilter[])new QFilter[]{qFilter}, null);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                InitContextEnum initEnum = InitContextEnum.fromName((String)row.getString("inittype"));
                if (initEnum == null) continue;
                initEnums.add(initEnum);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (InitContextEnum initEnum : initEnums) {
            switch (initEnum) {
                case ResModule: {
                    initializedEntity.clear();
                    MRPInitHelper.initData(useOrgId, "mrp_resourceregister_cf", true, appId, true);
                    MRPInitHelper.clearCache("mrp_resourceregister_cf", useOrgId);
                    MRPInitHelper.clearCache("mrp_billfieldtransfer", useOrgId);
                    break;
                }
                case AlgoModule: {
                    initializedEntity.clear();
                    MRPInitHelper.initLargeFile();
                    Set<String> removes = MRPInitHelper.getNotInitCalcPlanNumbers(useOrgId);
                    if (!removes.isEmpty()) {
                        MRPInitHelper.initData(useOrgId, "mrp_businessplan", true, appId, true);
                    }
                    MRPInitHelper.initData(useOrgId, "mrp_calplanconfig", true, removes, appId, true);
                    MRPInitHelper.clearCache("mrp_calplanconfig", useOrgId);
                    MRPInitHelper.clearCache("mrp_businessplan", useOrgId);
                    MRPInitHelper.clearCache("mrp_algoregister", useOrgId);
                    break;
                }
                case QTResModule: {
                    initializedEntity.clear();
                    MRPInitHelper.initData(useOrgId, "mrp_resourceregister_cf", true, appId, (InitDataConst)new QTInitConst());
                    MRPInitHelper.clearCache("mrp_resourceregister_cf", useOrgId);
                    MRPInitHelper.clearCache("mrp_billfieldtransfer", useOrgId);
                    break;
                }
                case QTAlgoModule: {
                    initializedEntity.clear();
                    MRPInitHelper.initLargeFile();
                    Set<String> removes = MRPInitHelper.getQTNotInitCalcPlanNumbers(useOrgId);
                    if (!removes.isEmpty()) {
                        MRPInitHelper.initData(useOrgId, "mrp_businessplan", true, appId, (InitDataConst)new QTInitConst());
                    }
                    MRPInitHelper.initData(useOrgId, "mrp_calplanconfig", true, removes, appId, (InitDataConst)new QTInitConst(), true);
                    MRPInitHelper.clearCache("mrp_calplanconfig", useOrgId);
                    MRPInitHelper.clearCache("mrp_businessplan", useOrgId);
                    MRPInitHelper.clearCache("mrp_algoregister", useOrgId);
                    break;
                }
                case GrossDemand: {
                    MRPInitHelper.initData(useOrgId, "mrp_grossdemand_define", true, appId, true);
                    MRPInitHelper.clearCache("mrp_grossdemand_define", useOrgId);
                    break;
                }
                case ExceptionMsg: {
                    MRPInitHelper.initException(useOrgId);
                    break;
                }
                case ReserveService: {
                    NetChangeSynHelper.doNetChangeSynWork();
                    break;
                }
                case PlanProgramModule: {
                    initializedEntity.clear();
                    MRPInitHelper.initData(useOrgId, "mrp_planprogram", true, appId, false);
                    MRPInitHelper.clearCache("mrp_planprogram", useOrgId);
                    MRPInitHelper.clearCache("mrp_resourceregister_cf", useOrgId);
                    MRPInitHelper.clearCache("mrp_billfieldtransfer", useOrgId);
                    MRPInitHelper.clearCache("mrp_stocksupply_policy", useOrgId);
                    MRPInitHelper.clearCache("mrp_definitionsupply", useOrgId);
                    break;
                }
            }
        }
        long userId = RequestContext.get().getCurrUserId();
        Timestamp timestamp = new Timestamp(new Date().getTime());
        String updateSql = "update t_mrp_initdata set finitstatus = '1',fmodifierid = ?, fmodifytime = ? where fid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
        for (Long id : ids) {
            Object[] p = new Object[3];
            p[2] = id;
            p[0] = userId;
            p[1] = timestamp;
            params.add(p);
        }
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updateSql, params);
    }

    private static void initLargeFile() {
        cellsdatas.clear();
        cellsdatas.put("YWFA-Orignal", MRPInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-data"));
        cellsdatas.put("YWFA-SP", MRPInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-data1"));
        cellsdatas.put("YWFA-SelectPlan", MRPInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-data2"));
        cellsdatas.put("YWFA-SelectMaterial", MRPInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-data3"));
        cellsdatas.put("YWFA-QT", MRPInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-data4"));
        xmls.clear();
        xmls.put("YWFA-Orignal", MRPInitHelper.XmlToString("bizXml"));
        xmls.put("YWFA-SP", MRPInitHelper.XmlToString("bizXml1"));
        xmls.put("YWFA-SelectPlan", MRPInitHelper.XmlToString("bizXml2"));
        xmls.put("YWFA-SelectMaterial", MRPInitHelper.XmlToString("bizXml3"));
        xmls.put("YWFA-QT", MRPInitHelper.XmlToString("bizXml4"));
    }

    private static Set<String> getNotInitCalcPlanNumbers(long orgId) {
        HashSet<String> removeNumbers = new HashSet<String>(4);
        QFilter globalFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_globalplan");
        QFilter simulationFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_simulation");
        QFilter selectPlanFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_selectbillplan");
        QFilter selectMaterialFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_selectmaterialplan");
        QFilter qFilter = new QFilter(CREATEORG, "=", (Object)orgId);
        qFilter.and(new QFilter(STATUS, "=", (Object)"C"));
        qFilter.and(new QFilter(ENABLE, "=", (Object)"1"));
        if (QueryServiceHelper.exists((String)"mrp_calplanconfig", (QFilter[])new QFilter[]{qFilter, globalFilter})) {
            removeNumbers.add("JSFA-Orignal");
        }
        if (QueryServiceHelper.exists((String)"mrp_calplanconfig", (QFilter[])new QFilter[]{qFilter, simulationFilter})) {
            removeNumbers.add("JSFA-SP");
        }
        if (QueryServiceHelper.exists((String)"mrp_calplanconfig", (QFilter[])new QFilter[]{qFilter, selectPlanFilter})) {
            removeNumbers.add("JSFA-SelectPlan");
        }
        if (QueryServiceHelper.exists((String)"mrp_calplanconfig", (QFilter[])new QFilter[]{qFilter, selectMaterialFilter})) {
            removeNumbers.add("JSFA-SelectMaterial");
        }
        return removeNumbers;
    }

    private static Set<String> getQTNotInitCalcPlanNumbers(long orgId) {
        HashSet<String> removeNumbers = new HashSet<String>(4);
        QFilter cpsFilter = new QFilter("entryentity.runtype", "=", (Object)"mrp_cps_runner");
        QFilter qFilter = new QFilter(CREATEORG, "=", (Object)orgId);
        qFilter.and(new QFilter(STATUS, "=", (Object)"C"));
        qFilter.and(new QFilter(ENABLE, "=", (Object)"1"));
        if (QueryServiceHelper.exists((String)"mrp_calplanconfig", (QFilter[])new QFilter[]{qFilter, cpsFilter})) {
            removeNumbers.add("JSFA-QT");
        }
        return removeNumbers;
    }

    public static void initData(long orgId, String entity, boolean isReload, String appId, boolean isVersion) {
        MRPInitHelper.initData(orgId, entity, isReload, Collections.emptySet(), appId, isVersion);
    }

    public static void initData(long orgId, String entity, boolean isReload, String appId, InitDataConst initDataConst) {
        MRPInitHelper.initData(orgId, entity, isReload, Collections.emptySet(), appId, initDataConst, true);
    }

    private static void initData(long orgId, String entity, boolean isReload, Set<String> removeNumbers, String appId, boolean isVersion) {
        MRPInitHelper.initData(orgId, entity, isReload, removeNumbers, appId, new InitDataConst(), isVersion);
    }

    private static void initData(long orgId, String entity, boolean isReload, Set<String> removeNumbers, String appId, InitDataConst initDataConst, boolean isVersion) {
        if (StringUtils.isBlank((CharSequence)entity)) {
            return;
        }
        String defaultctrlstrategy = MRPInitHelper.getDefaultCtrlStrategy(entity);
        Map initSql = initDataConst.getSql(entity, Long.valueOf(orgId), defaultctrlstrategy, cellsdatas, xmls, appId);
        for (String num : removeNumbers) {
            initSql.remove(num);
        }
        if (initSql.isEmpty()) {
            return;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        HashMap exeSqls = new HashMap(initSql.size());
        boolean isPrivate = StringUtils.equals((CharSequence)defaultctrlstrategy, (CharSequence)"7");
        Map<String, Long> oldPrivateDataId = null;
        if (isReload) {
            if (isPrivate) {
                oldPrivateDataId = MRPInitHelper.getPrivateOldData(entity, initSql.keySet(), orgId, isVersion);
            }
            exeSqls.putAll(initSql);
        } else {
            for (Map.Entry entry : initSql.entrySet()) {
                QFilter qFilter = new QFilter(NUMBER, "=", entry.getKey());
                if (isPrivate) {
                    qFilter.and(new QFilter(CREATEORG, "=", (Object)orgId));
                }
                if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qFilter})) continue;
                exeSqls.put(entry.getKey(), entry.getValue());
            }
        }
        Map idMap = initDataConst.getDataIds(entity);
        LinkedHashMap<String, List<Object[]>> allSqls = new LinkedHashMap<String, List<Object[]>>();
        for (Map.Entry entry : exeSqls.entrySet()) {
            Long id = idMap.getOrDefault(entry.getKey(), 0L);
            Long oldId = oldPrivateDataId != null ? oldPrivateDataId.get(entry.getKey()) : null;
            MRPInitHelper.insertData(isPrivate, isReload, entity, id, (String)entry.getKey(), (Map)entry.getValue(), org, user, oldId, false, allSqls, appId, initDataConst);
        }
        MRPInitHelper.executeSql(new DBRoute(MRPInitHelper.getDbKey(entity)), allSqls, entity);
    }

    private static void clearCache(String entity, Long useorgId) {
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache(entity, useorgId);
        ArrayList<Long> orgIDList = new ArrayList<Long>(1);
        orgIDList.add(useorgId);
        BaseDataServiceHelper.refreshBaseDataUseRange((String)entity, orgIDList);
    }

    private static Map<String, Long> getPrivateOldData(String entity, Set<String> nums, Long orgId) {
        return MRPInitHelper.getPrivateOldData(entity, nums, orgId, true);
    }

    private static Map<String, Long> getPrivateOldData(String entity, Set<String> nums, Long orgId, boolean isVersion) {
        HashMap<String, Long> oldPrivateDataId = new HashMap<String, Long>(nums.size());
        QFilter qFilter = new QFilter(NUMBER, "in", nums);
        qFilter.and(new QFilter(CREATEORG, "=", (Object)orgId));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(qFilter);
        if (isVersion) {
            QFilter qFilterVersion = new QFilter("version", "=", (Object)"V1.0");
            qFilters.add(qFilterVersion);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)"number,id", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                oldPrivateDataId.put(row.getString(NUMBER), row.getLong("id"));
            }
        }
        return oldPrivateDataId;
    }

    private static Long insertData(boolean isPrivate, boolean isReload, String entity, Long id, String num, Map<String, List<Object[]>> sql, DynamicObject org, DynamicObject user, Long oldId, boolean execute, Map<String, List<Object[]>> allSql, String appId, InitDataConst initDataConst) {
        Long result = id;
        if (isPrivate && QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})) {
            result = MRPInitHelper.insertPrivateData(entity, id, num, org, user, oldId, isReload, appId, initDataConst);
        } else if (MRPInitHelper.insertSharedData(entity, id, org, user, isReload, appId, initDataConst)) {
            if (execute) {
                MRPInitHelper.executeSql(new DBRoute(MRPInitHelper.getDbKey(entity)), sql, entity, execute);
            } else {
                for (Map.Entry<String, List<Object[]>> entry : sql.entrySet()) {
                    List list = allSql.computeIfAbsent(entry.getKey(), k -> new ArrayList(16));
                    list.addAll((Collection)entry.getValue());
                }
            }
        }
        return result;
    }

    private static boolean insertSharedData(String entity, Long id, DynamicObject org, DynamicObject user, boolean isReload, String appId, InitDataConst initDataConst) {
        if (!isReload && QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})) {
            return false;
        }
        switch (entity) {
            case "mrp_calplanconfig": {
                MRPInitHelper.loopInsertValue("mrp_businessplan", "7", org, user, isReload, appId, initDataConst);
                break;
            }
            case "mrp_businessplan": {
                MRPInitHelper.loopInsertValue("mrp_algoregister", "5", org, user, isReload, appId, initDataConst);
                break;
            }
            case "mrp_resourceregister_cf": {
                MRPInitHelper.loopInsertValue("mrp_billfieldtransfer", "5", org, user, isReload, appId, initDataConst);
                break;
            }
            case "mpdm_manustrategy_group": {
                MRPInitHelper.loopInsertValue("mpdm_manustrategy", "5", org, user, isReload, appId, initDataConst);
                break;
            }
            case "mrp_planprogram": {
                MRPInitHelper.loopInsertValue("mrp_resourceregister_cf", "5", org, user, isReload, appId, initDataConst);
                MRPInitHelper.loopInsertValue("mrp_stocksupply_policy", "5", org, user, isReload, appId, initDataConst);
                MRPInitHelper.loopInsertValue("mrp_definitionsupply", "5", org, user, isReload, appId, initDataConst);
                break;
            }
        }
        return true;
    }

    private static void executeSql(DBRoute dbRoute, Map<String, List<Object[]>> sql, String entity) {
        MRPInitHelper.executeSql(dbRoute, sql, entity, false);
    }

    private static void executeSql(DBRoute dbRoute, Map<String, List<Object[]>> sql, String entity, boolean execute) {
        if (initializedEntity.add(entity) || execute) {
            for (Map.Entry<String, List<Object[]>> entry : sql.entrySet()) {
                DB.executeBatch((DBRoute)dbRoute, (String)entry.getKey(), entry.getValue());
            }
        }
    }

    private static void loopInsertValue(String entity, String ctrl, DynamicObject org, DynamicObject user, boolean isReload, String appId, InitDataConst initDataConst) {
        Long orgId = org == null ? 0L : org.getLong("id");
        Map bizSqls = initDataConst.getSql(entity, orgId, ctrl, cellsdatas, xmls, appId);
        Map bizIds = initDataConst.getDataIds(entity);
        boolean isPrivate = StringUtils.equals((CharSequence)"7", (CharSequence)ctrl);
        Map<Object, Object> oldPrivateDataId = null;
        oldPrivateDataId = isPrivate ? MRPInitHelper.getPrivateOldData(entity, bizSqls.keySet(), orgId) : new HashMap(0);
        LinkedHashMap<String, List<Object[]>> allSqls = new LinkedHashMap<String, List<Object[]>>();
        for (Map.Entry entry : bizSqls.entrySet()) {
            MRPInitHelper.insertData(isPrivate, isReload, entity, (Long)bizIds.get(entry.getKey()), (String)entry.getKey(), (Map)entry.getValue(), org, user, (Long)oldPrivateDataId.get(entry.getKey()), false, allSqls, appId, initDataConst);
        }
        MRPInitHelper.executeSql(new DBRoute(MRPInitHelper.getDbKey(entity)), allSqls, entity);
    }

    private static Long insertPrivateData(String entity, Long id, String num, DynamicObject org, DynamicObject user, Long oldId, boolean isReload, String appId, InitDataConst initDataConst) {
        LocaleString name;
        Long newId = 0L;
        if (id == null || id <= 0L) {
            return newId;
        }
        Long orgId = org == null ? 0L : org.getLong("id");
        Long userId = user == null ? 0L : user.getLong("id");
        String base64 = "";
        switch (entity) {
            case "mrp_calplanconfig": {
                base64 = MRPInitHelper.getInitDataCache("calcPlanBase64Cache", MRPInitHelper.getDataFileName4EntityNumber(num));
                break;
            }
            case "mrp_businessplan": {
                base64 = MRPInitHelper.getInitDataCache("bizBase64Cache", MRPInitHelper.getDataFileName4EntityNumber(num));
                break;
            }
            case "mrp_grossdemand_define": {
                base64 = MRPInitHelper.getInitDataCache("grossCache", "/init-data");
                break;
            }
            case "mrp_planprogram": {
                base64 = MRPInitHelper.getInitDataCache("planprogramCache", "/init-data");
                break;
            }
            default: {
                return newId;
            }
        }
        ORM orm = ORM.create();
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entity);
        Object[] deserialize = DynamicObjectSerializeUtil.deserialize((String)base64, (DynamicObjectType)dt);
        DynamicObject newData = (DynamicObject)OrmUtils.clone((Object)deserialize[0], (IDataEntityType)dt, (boolean)true, (boolean)true);
        boolean isSave = false;
        if (oldId != null && oldId > 0L) {
            newId = oldId;
        } else {
            newId = orm.genLongId((IDataEntityType)dt);
            isSave = true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)entity, (CharSequence)"mrp_calplanconfig")) {
            name = initDataConst.getName4EntityNumber(num);
            newData.set(NAME, (Object)name);
            Map bizIds = initDataConst.getDataIds("mrp_businessplan");
            Map bizSqls = initDataConst.getSql("mrp_businessplan", orgId, "7", cellsdatas, xmls, appId);
            String bizNum = MRPInitHelper.getBizNum4CalcNum(num);
            HashSet<String> bizNums = new HashSet<String>(1);
            bizNums.add(bizNum);
            Map<String, Long> oldPrivateDataId = MRPInitHelper.getPrivateOldData("mrp_businessplan", bizNums, orgId);
            Long bizId = MRPInitHelper.insertData(true, isReload, "mrp_businessplan", (Long)bizIds.get(bizNum), bizNum, (Map)bizSqls.get(bizNum), org, user, oldPrivateDataId.get(bizNum), true, Collections.emptyMap(), appId, initDataConst);
            newData.set("fieldtype", (Object)appId);
            DynamicObjectCollection entryentity = newData.getDynamicObjectCollection("entryentity");
            if (entryentity.size() > 0) {
                DynamicObject entry = (DynamicObject)entryentity.get(0);
                entry.set("bizplan", (Object)BusinessDataServiceHelper.loadSingle((Object)bizId, (String)"mrp_businessplan"));
                entry.set("bizplan_id", (Object)bizId);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)entity, (CharSequence)"mrp_businessplan")) {
            String cellsdata;
            name = initDataConst.getName4EntityNumber(num);
            newData.set(NAME, (Object)name);
            newData.set("fieldtype", (Object)appId);
            String xml = xmls.get(newData.getString(NUMBER));
            if (StringUtils.isNotBlank((CharSequence)xml)) {
                newData.set("xml_tag", (Object)xml);
            }
            if (StringUtils.isNotBlank((CharSequence)(cellsdata = cellsdatas.get(newData.getString(NUMBER))))) {
                newData.set("cellsdata_tag", (Object)cellsdata);
            }
            MRPInitHelper.loopInsertValue("mrp_algoregister", "5", org, user, isReload, appId, initDataConst);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)entity, (CharSequence)"mrp_planprogram")) {
            MRPInitHelper.loopInsertValue("mrp_resourceregister_cf", "5", org, user, isReload, appId, initDataConst);
            MRPInitHelper.loopInsertValue("mrp_stocksupply_policy", "5", org, user, isReload, appId, initDataConst);
            MRPInitHelper.loopInsertValue("mrp_definitionsupply", "5", org, user, isReload, appId, initDataConst);
        }
        Date nowTime = new Date();
        newData.set("masterid", (Object)newId);
        newData.set("id", (Object)newId);
        newData.set("createorg_id", (Object)orgId);
        newData.set("org_id", (Object)orgId);
        newData.set("org", (Object)org);
        newData.set(CREATEORG, (Object)org);
        newData.set(CTRLSTRATEGY, (Object)"7");
        newData.set("creator_id", (Object)userId);
        newData.set("modifier_id", (Object)userId);
        newData.set(CREATOR, (Object)user);
        newData.set("modifier", (Object)user);
        newData.set(CREATETIME, (Object)nowTime);
        newData.set("modifytime", (Object)nowTime);
        if (isReload || isSave) {
            DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)newId)});
            Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newData});
            if (objs.length > 0 && objs[0] instanceof DynamicObject) {
                newId = ((DynamicObject)objs[0]).getLong("id");
            }
        }
        return newId;
    }

    private static String getBizNum4CalcNum(String calcNum) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"JSFA-Orignal", (CharSequence)calcNum)) {
            return "YWFA-Orignal";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"JSFA-SP", (CharSequence)calcNum)) {
            return "YWFA-SP";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"JSFA-SelectPlan", (CharSequence)calcNum)) {
            return "YWFA-SelectPlan";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"JSFA-SelectMaterial", (CharSequence)calcNum)) {
            return "YWFA-SelectMaterial";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"JSFA-QT", (CharSequence)calcNum)) {
            return "YWFA-QT";
        }
        return "YWFA-Orignal";
    }

    private static String getDataFileName4EntityNumber(String num) {
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"JSFA-Orignal") || StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"YWFA-Orignal")) {
            return "/init-data";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"JSFA-SP") || StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"YWFA-SP")) {
            return "/init-data1";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"JSFA-SelectPlan") || StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"YWFA-SelectPlan")) {
            return "/init-data2";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"JSFA-SelectMaterial") || StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"YWFA-SelectMaterial")) {
            return "/init-data3";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"JSFA-QT") || StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"YWFA-QT")) {
            return "/init-data4";
        }
        return "/init-data";
    }

    private static String getDefaultCtrlStrategy(String entity) {
        String defaultctrlstrategy;
        switch (entity) {
            case "mrp_businessplan": 
            case "mrp_calplanconfig": 
            case "mrp_grossdemand_define": 
            case "mrp_planprogram": {
                defaultctrlstrategy = "7";
                break;
            }
            default: {
                defaultctrlstrategy = "5";
            }
        }
        return defaultctrlstrategy;
    }

    private static String getDbKey(String entity) {
        return ORM.create().getDataEntityType(entity).getDBRouteKey();
    }

    private static String getInitDataCache(String key, String filePatch) {
        InputStream in = MRPInitHelper.class.getResourceAsStream(filePatch);
        ArrayList<String> strs = new ArrayList<String>(6);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                strs.add(line);
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        for (int i = 0; i < strs.size() - 1; ++i) {
            if (!StringUtils.equals((CharSequence)key, (CharSequence)((CharSequence)strs.get(i)))) continue;
            return (String)strs.get(i + 1);
        }
        return null;
    }

    private static String XmlToString(String fileName) {
        SAXReader saxReader = new SAXReader();
        String xmlString = "";
        try (InputStream input = MRPInitHelper.class.getResourceAsStream(InitDataConst.isEn_US() ? "/" + fileName + "_en.xml" : "/" + fileName + ".xml");){
            Document document = saxReader.read(input);
            xmlString = document.asXML();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            xmlString = "";
        }
        return xmlString;
    }

    public static void initException(Object createOrgId) {
        DeleteServiceHelper.delete((String)MRP_EXCEPTIONGROUP, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", createOrgId)});
        DeleteServiceHelper.delete((String)MRP_DEFINITIONEXCEPTION, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", createOrgId)});
        ArrayList<LocaleString> groupList = new ArrayList<LocaleString>();
        groupList.add(ResManager.getLocaleString((String)"\u8fc7\u53bb\u65e5\u671f\u5f00\u59cb", (String)"MRPInitHelper_0", (String)"mmc-mrp-business"));
        groupList.add(ResManager.getLocaleString((String)"\u8fc7\u53bb\u65e5\u671f\u7ed3\u675f", (String)"MRPInitHelper_1", (String)"mmc-mrp-business"));
        groupList.add(ResManager.getLocaleString((String)"BOM\u4f8b\u5916", (String)"MRPInitHelper_2", (String)"mmc-mrp-business"));
        groupList.add(ResManager.getLocaleString((String)"\u5e93\u5b58\u4f8b\u5916", (String)"MRPInitHelper_3", (String)"mmc-mrp-business"));
        groupList.add(ResManager.getLocaleString((String)"\u7269\u6599\u66ff\u4ee3", (String)"MRPInitHelper_4", (String)"mmc-mrp-business"));
        groupList.add(ResManager.getLocaleString((String)"\u6392\u7a0b\u4f8b\u5916", (String)"MRPInitHelper_5", (String)"mmc-mrp-business"));
        groupList.add(ResManager.getLocaleString((String)"\u65b0\u521b\u5efa\u8ba1\u5212", (String)"MRPInitHelper_6", (String)"mmc-mrp-business"));
        groupList.add(ResManager.getLocaleString((String)"\u6570\u636e\u4f8b\u5916", (String)"MRPInitHelper_7", (String)"mmc-mrp-business"));
        DynamicObject[] groupEntities = new DynamicObject[groupList.size()];
        for (int i = 0; i < groupList.size(); ++i) {
            DynamicObject groupObj = BusinessDataServiceHelper.newDynamicObject((String)MRP_EXCEPTIONGROUP);
            groupObj.set(NUMBER, (Object)(i + 1));
            groupObj.set(NAME, groupList.get(i));
            groupObj.set(STATUS, (Object)"C");
            groupObj.set(ENABLE, (Object)"1");
            groupObj.set(CREATOR, (Object)RequestContext.get().getUserId());
            groupObj.set(CREATETIME, (Object)new Date());
            groupObj.set(CREATEORG, createOrgId);
            groupObj.set(CTRLSTRATEGY, (Object)"7");
            groupEntities[i] = groupObj;
        }
        SaveServiceHelper.save((DynamicObject[])groupEntities);
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String key = MRP_EXCEPTIONGROUP + createOrgId;
        BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
        DynamicObject[] exceptionEntities = new DynamicObject[39];
        for (int i = 0; i < exceptionEntities.length; ++i) {
            DynamicObject exceptionObj = BusinessDataServiceHelper.newDynamicObject((String)MRP_DEFINITIONEXCEPTION);
            exceptionObj.set(CREATEORG, createOrgId);
            exceptionObj.set(ISVISIBLE, (Object)"1");
            exceptionObj.set(STATUS, (Object)"C");
            exceptionObj.set(CREATOR, (Object)RequestContext.get().getUserId());
            exceptionObj.set(ENABLE, (Object)"1");
            exceptionObj.set(CREATETIME, (Object)new Date());
            exceptionObj.set(CTRLSTRATEGY, (Object)"7");
            switch (i) {
                case 0: {
                    exceptionObj.set(GROUP, (Object)groupEntities[0]);
                    exceptionObj.set(NUMBER, (Object)"10");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u65b0\u589e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5728\u8fc7\u53bb\u3002", (String)"MRPInitHelper_8", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)1);
                    break;
                }
                case 1: {
                    exceptionObj.set(GROUP, (Object)groupEntities[0]);
                    exceptionObj.set(NUMBER, (Object)"11");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u8fc7\u53bb\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"MRPInitHelper_9", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)2);
                    break;
                }
                case 2: {
                    exceptionObj.set(GROUP, (Object)groupEntities[1]);
                    exceptionObj.set(NUMBER, (Object)"20");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u65b0\u589e\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5728\u8fc7\u53bb\u3002", (String)"MRPInitHelper_10", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)3);
                    break;
                }
                case 3: {
                    exceptionObj.set(GROUP, (Object)groupEntities[1]);
                    exceptionObj.set(NUMBER, (Object)"21");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u8fc7\u53bb\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"MRPInitHelper_11", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)4);
                    break;
                }
                case 4: {
                    exceptionObj.set(GROUP, (Object)groupEntities[2]);
                    exceptionObj.set(NUMBER, (Object)"30");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u4e0d\u5b58\u5728\u5236\u9020BOM\u3002", (String)"MRPInitHelper_12", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)5);
                    break;
                }
                case 5: {
                    exceptionObj.set(GROUP, (Object)groupEntities[2]);
                    exceptionObj.set(NUMBER, (Object)"31");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u6ca1\u6709\u5236\u9020BOM\u88ab\u7cfb\u7edf\u9009\u5b9a\uff0c\u68c0\u67e5BOM\u7684\u5f53\u524d\u65f6\u95f4\u662f\u5426\u6709\u6548\u3002", (String)"MRPInitHelper_13", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)6);
                    break;
                }
                case 6: {
                    exceptionObj.set(GROUP, (Object)groupEntities[3]);
                    exceptionObj.set(NUMBER, (Object)"40");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u8d85\u51fa\u6700\u9ad8\u5e93\u5b58\u91cf\u3002", (String)"MRPInitHelper_14", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)7);
                    break;
                }
                case 7: {
                    exceptionObj.set(GROUP, (Object)groupEntities[3]);
                    exceptionObj.set(NUMBER, (Object)"41");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u4f4e\u4e8e\u5b89\u5168\u5e93\u5b58\u3002", (String)"MRPInitHelper_15", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)8);
                    break;
                }
                case 8: {
                    exceptionObj.set(GROUP, (Object)groupEntities[3]);
                    exceptionObj.set(NUMBER, (Object)"42");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u5b89\u5168\u5e93\u5b58\u51cf\u5c11\u3002", (String)"MRPInitHelper_16", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)9);
                    break;
                }
                case 9: {
                    exceptionObj.set(GROUP, (Object)groupEntities[4]);
                    exceptionObj.set(NUMBER, (Object)"50");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u4e2d\u6b62\u7269\u6599\u90e8\u5206\u88ab\u540e\u7eed\u7269\u6599\u66ff\u4ee3\u3002", (String)"MRPInitHelper_17", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)10);
                    break;
                }
                case 10: {
                    exceptionObj.set(GROUP, (Object)groupEntities[5]);
                    exceptionObj.set(NUMBER, (Object)"60");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u5efa\u8bae\u63d0\u524d\u3002", (String)"MRPInitHelper_18", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)11);
                    break;
                }
                case 11: {
                    exceptionObj.set(GROUP, (Object)groupEntities[5]);
                    exceptionObj.set(NUMBER, (Object)"61");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u5efa\u8bae\u5ef6\u540e\u3002", (String)"MRPInitHelper_19", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)12);
                    break;
                }
                case 12: {
                    exceptionObj.set(GROUP, (Object)groupEntities[5]);
                    exceptionObj.set(NUMBER, (Object)"62");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u5efa\u8bae\u53d6\u6d88\u3002", (String)"MRPInitHelper_20", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)13);
                    break;
                }
                case 13: {
                    exceptionObj.set(GROUP, (Object)groupEntities[5]);
                    exceptionObj.set(NUMBER, (Object)"63");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u4f9d\u8ba1\u5212\u6392\u7a0b\u3002", (String)"MRPInitHelper_21", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"1");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)14);
                    break;
                }
                case 14: {
                    exceptionObj.set(GROUP, (Object)groupEntities[5]);
                    exceptionObj.set(NUMBER, (Object)"64");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u8ba2\u5355\u5efa\u8bae\u88ab\u4fee\u6539\u3002", (String)"MRPInitHelper_22", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)15);
                    break;
                }
                case 15: {
                    exceptionObj.set(GROUP, (Object)groupEntities[6]);
                    exceptionObj.set(NUMBER, (Object)"70");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u65b0\u521b\u5efa\u8ba1\u5212\u3002", (String)"MRPInitHelper_46", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"1");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)16);
                    break;
                }
                case 16: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"80");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u5c06\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u4e3a\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"MRPInitHelper_23", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)17);
                    break;
                }
                case 17: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"81");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u9700\u6c42\u7ec4\u7ec7\u4e0d\u5339\u914d\u5f02\u5e38\u3002", (String)"MRPInitHelper_24", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)18);
                    break;
                }
                case 18: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"82");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\uff0c\u4ec5\u4ea7\u751f\u534f\u540c\u8ba1\u5212\u8ba2\u5355\u4f9b\u5e94\u3002", (String)"MRPInitHelper_25", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)19);
                    break;
                }
                case 19: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"83");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u9700\u6c42\u5355\u636e\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"MRPInitHelper_26", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)20);
                    break;
                }
                case 20: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"84");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u9700\u6c42\u65f6\u95f4\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"MRPInitHelper_27", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)21);
                    break;
                }
                case 21: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"85");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u4f9b\u5e94\u5355\u636e\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"MRPInitHelper_28", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)22);
                    break;
                }
                case 22: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"86");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u4f9b\u5e94\u65f6\u95f4\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"MRPInitHelper_29", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)23);
                    break;
                }
                case 23: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"87");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"BOM\u5df2\u7ecf\u5931\u6548\u3002", (String)"MRPInitHelper_30", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)24);
                    break;
                }
                case 24: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"88");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u76f8\u5173\u9700\u6c42\u7269\u6599\u5c5e\u6027\u4e0d\u5b58\u5728\u3002", (String)"MRPInitHelper_31", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)25);
                    break;
                }
                case 25: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"89");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u5185\u534f\u7ec4\u7ec7\u6b7b\u5faa\u73af\u3002", (String)"MRPInitHelper_32", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)26);
                    break;
                }
                case 26: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"90");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u672a\u627e\u5230\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"MRPInitHelper_33", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)27);
                    break;
                }
                case 27: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"91");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u5185\u534f\u4ef6\u9700\u6c42\u7ec4\u7ec7\u4e0d\u80fd\u7b49\u4e8e\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"MRPInitHelper_34", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)28);
                    break;
                }
                case 28: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"92");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u4f9b\u5e94\u6570\u636e\u56e0\u4e3a\u5b89\u5168\u5e93\u5b58\u8c03\u6574\u3002", (String)"MRPInitHelper_35", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"1");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)29);
                    break;
                }
                case 29: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"93");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u672a\u8bbe\u7f6e\u8f6c\u6362\u7387\u7684\u4e09\u54c1\u4ed3\u5e93\u7269\u6599\u3002", (String)"MRPInitHelper_36", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"1");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)30);
                    break;
                }
                case 30: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"94");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u9700\u6c42\u65e5\u671f\u56e0\u4e3a\u5b89\u5168\u5e93\u5b58\u63d0\u524d\u3002", (String)"MRPInitHelper_37", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"1");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)31);
                    break;
                }
                case 31: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"95");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u672a\u627e\u5230\u5236\u9020\u7b56\u7565\u3002", (String)"MRPInitHelper_38", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)32);
                    break;
                }
                case 32: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"96");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u672a\u627e\u5230\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u3002", (String)"MRPInitHelper_39", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)33);
                    break;
                }
                case 33: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"97");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u8ba1\u5212\u65b9\u5f0f\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"MRPInitHelper_40", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)34);
                    break;
                }
                case 34: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"98");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u5e93\u5b58\u6c34\u4f4d\u5360\u7528\u3002", (String)"MRPInitHelper_41", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"1");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)35);
                    break;
                }
                case 35: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"99");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u6574\u5355\u8c03\u6574\u7b56\u7565\uff0c\u4e0d\u8c03\u6574\u7684\u4f9b\u5e94\u5bcc\u4f59\u91cf\u3002", (String)"MRPInitHelper_42", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"1");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)36);
                    break;
                }
                case 36: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"100");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u9700\u6c42\u88ab\u8ba1\u7b97\u8303\u56f4\u5916\u4f9b\u5e94\u5360\u7528\u3002", (String)"MRPInitHelper_43", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"0");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"1");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)37);
                    break;
                }
                case 37: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"101");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u4ed3\u5e93\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"MRPInitHelper_44", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)38);
                    break;
                }
                case 38: {
                    exceptionObj.set(GROUP, (Object)groupEntities[7]);
                    exceptionObj.set(NUMBER, (Object)"102");
                    exceptionObj.set(NAME, (Object)ResManager.getLocaleString((String)"\u8ba1\u5212\u8303\u56f4\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"MRPInitHelper_45", (String)"mmc-mrp-business"));
                    exceptionObj.set(ISREDLIGHT, (Object)"1");
                    exceptionObj.set(ISYELLOWLIGHT, (Object)"0");
                    exceptionObj.set(ISGREENLIGHT, (Object)"0");
                    exceptionObj.set(ISSHOW, (Object)"1");
                    exceptionObj.set(PRIORITY, (Object)39);
                    break;
                }
            }
            exceptionEntities[i] = exceptionObj;
        }
        SaveServiceHelper.save((DynamicObject[])exceptionEntities);
        key = MRP_DEFINITIONEXCEPTION + createOrgId;
        BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
    }
}

