/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class MessageServiceHelper {
    public static void sendMessage(String planoperatenum, Set<Long> orgIds, Map<Long, Set<Long>> orgNotifiers, Map<Long, DynamicObject> orgs, String failtype) {
        for (Map.Entry<Long, Set<Long>> orgNotifierEntry : orgNotifiers.entrySet()) {
            Map<String, String> queryParams;
            Long orgId = orgNotifierEntry.getKey();
            Set<Long> notifiers = orgNotifierEntry.getValue();
            DynamicObject org = orgs.get(orgId);
            if (notifiers == null || notifiers.isEmpty() || (queryParams = MessageServiceHelper.dealContentAndUrl(planoperatenum, org, failtype, notifiers)) == null) continue;
            String queryFilter = queryParams.get("MessageContent");
            String queryURL = queryParams.get("ContentUrl");
            MessageInfo message = new MessageInfo();
            LocaleString title = new LocaleString();
            title.setLocaleValue_zh_CN(ResManager.loadKDString((String)"MRP\u8ba1\u5212\u8ba2\u5355\u81ea\u52a8\u6295\u653e\u5931\u8d25\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u3002", (String)"MessageServiceHelper_0", (String)"mmc-mrp-business", (Object[])new Object[0]));
            title.setLocaleValue_zh_TW(ResManager.loadKDString((String)"MRP\u8ba1\u5212\u8ba2\u5355\u81ea\u52a8\u6295\u653e\u5931\u8d25\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u3002", (String)"MessageServiceHelper_0", (String)"mmc-mrp-business", (Object[])new Object[0]));
            message.setMessageTitle((ILocaleString)title);
            LocaleString content = new LocaleString();
            content.setLocaleValue_en("");
            if (queryFilter != null && queryFilter.length() > 0 && !StringUtils.isBlank((CharSequence)queryFilter)) {
                content.setLocaleValue_zh_CN(queryFilter);
            } else {
                content.setLocaleValue_zh_CN("");
            }
            content.setLocaleValue_zh_TW("");
            message.setMessageContent((ILocaleString)content);
            LocaleString tag = new LocaleString();
            tag.setLocaleValue(ResManager.loadKDString((String)"\u7d27\u6025", (String)"MessageServiceHelper_1", (String)"mmc-mrp-business", (Object[])new Object[0]));
            message.setMessageTag((ILocaleString)tag);
            ArrayList<Long> receivers = new ArrayList<Long>(notifiers);
            message.setUserIds(receivers);
            message.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
            message.setType("message");
            message.setEntityNumber("mrp_dropplanorderlog");
            if (queryURL != null && queryURL.length() > 0 && !StringUtils.isBlank((CharSequence)queryURL)) {
                message.setContentUrl(queryURL);
            }
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        }
    }

    private static Map<String, String> dealContentAndUrl(String planoperatenum, DynamicObject org, String failtype, Set<Long> notifiers) {
        String name;
        HashMap<String, String> msgContent = new HashMap<String, String>(16);
        msgContent.put("MessageContent", null);
        msgContent.put("ContentUrl", null);
        StringBuilder queryFilter = new StringBuilder();
        StringBuilder queryURL = new StringBuilder();
        queryURL.append(UrlService.getDomainContextUrl());
        queryURL.append("/index.html?formId=mrp_dropplanorderlog&type=list");
        queryURL.append("&param1=FromMsgCenter");
        if (planoperatenum != null) {
            queryFilter.append(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\uff1a", (String)"MessageServiceHelper_2", (String)"mmc-mrp-business", (Object[])new Object[0]));
            queryFilter.append(planoperatenum).append('\uff1b');
            queryURL.append("&q_caculatelog.number=");
            queryURL.append(planoperatenum);
        }
        if (org != null) {
            queryFilter.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\uff1a", (String)"MessageServiceHelper_3", (String)"mmc-mrp-business", (Object[])new Object[0]));
            name = org.getLocaleString("name").getLocaleValue();
            queryFilter.append(name).append('\uff1b');
            queryURL.append("&q_proorpurorg=");
            queryURL.append(org.getLong("id"));
        }
        if (StringUtils.isNotBlank((CharSequence)failtype)) {
            queryFilter.append(ResManager.loadKDString((String)"\u5931\u8d25\u7c7b\u578b\uff1a", (String)"MessageServiceHelper_4", (String)"mmc-mrp-business", (Object[])new Object[0]));
            name = "";
            if ("A".equals(failtype)) {
                name = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a", (String)"MessageServiceHelper_5", (String)"mmc-mrp-business", (Object[])new Object[0]);
            } else if ("B".equals(failtype)) {
                name = ResManager.loadKDString((String)"\u6295\u653e\u5931\u8d25\uff1a", (String)"MessageServiceHelper_6", (String)"mmc-mrp-business", (Object[])new Object[0]);
            }
            queryFilter.append(name).append('\uff1b');
            queryURL.append("&q_failtype=");
            queryURL.append(failtype);
        }
        if (notifiers != null && !notifiers.isEmpty()) {
            String notifierStr = SerializationUtils.toJsonString(notifiers);
            queryURL.append("&notifiers=");
            queryURL.append(notifierStr);
        }
        queryFilter.append(ResManager.loadKDString((String)"MRP\u8ba1\u5212\u8ba2\u5355\u81ea\u52a8\u6295\u653e\u5931\u8d25\uff0c\u8bf7\u5904\u7406\u3002", (String)"MessageServiceHelper_7", (String)"mmc-mrp-business", (Object[])new Object[0]));
        if (queryFilter != null && queryFilter.length() > 0) {
            msgContent.put("MessageContent", queryFilter.toString());
        }
        if (queryURL != null && queryURL.length() > 0) {
            msgContent.put("ContentUrl", queryURL.toString());
        }
        return msgContent;
    }
}

