/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mrp.business.helper.XPlanOrderChangehelper;
import kd.mmc.mrp.common.consts.XPlanOrderLogConst;

public class XPlanOrderChangeLoghelper {
    private static final Log log = LogFactory.getLog(XPlanOrderChangeLoghelper.class);

    public static DynamicObject makeUpXPlanorderChangeLog(String changeStatus, DynamicObject planorderChangeBill, DynamicObject planOrder) {
        DynamicObject xplanOrderlog = BusinessDataServiceHelper.newDynamicObject((String)"mrp_xplanorderlog");
        String changetype = planorderChangeBill.getString("changetype");
        if (StringUtils.isEmpty((CharSequence)changetype)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u53d8\u66f4\u5355\u53d8\u66f4\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"XPlanOrderChangeLoghelper_0", (String)"mmc-mrp-business", (Object[])new Object[0]));
        }
        XPlanOrderChangeLoghelper.dealXPlanOrderChangeLog(changeStatus, xplanOrderlog, planorderChangeBill);
        XPlanOrderChangeLoghelper.dealXPlanOrderChangeLogEntry(xplanOrderlog, planorderChangeBill, planOrder);
        return xplanOrderlog;
    }

    private static void dealXPlanOrderChangeLogEntry(DynamicObject xplanOrderlog, DynamicObject planorderChangeBill, DynamicObject planOrder) {
        BigDecimal changeQty = planorderChangeBill.getBigDecimal("changeqty");
        BigDecimal orderQty = planOrder.getBigDecimal("orderqty");
        BigDecimal dropQty = planOrder.getBigDecimal("dropqty");
        String changetype = planorderChangeBill.getString("changetype");
        Boolean isSplit = XPlanOrderChangehelper.judgeIsSplit(changetype, orderQty.subtract(dropQty), changeQty, dropQty);
        DynamicObjectCollection entryentity = xplanOrderlog.getDynamicObjectCollection("entryentity");
        Boolean isSplitOrder = false;
        XPlanOrderChangeLoghelper.xPlanOrderChangeLogEntryMod(entryentity, planorderChangeBill, planOrder, isSplit, isSplitOrder);
    }

    private static void xPlanOrderChangeLogEntryMod(DynamicObjectCollection entryentity, DynamicObject planorderChangeBill, DynamicObject planOrder, boolean isSplit, Boolean isSplitOrder) {
        DynamicObject addNew = entryentity.addNew();
        XPlanOrderChangeLoghelper.xPlanOrderChangeLogFixEntry(addNew, planorderChangeBill, isSplitOrder);
        XPlanOrderChangeLoghelper.xPlanOrderChangeLogchangeEntry(addNew, planorderChangeBill, planOrder, isSplit, isSplitOrder);
        if (isSplit && !isSplitOrder.booleanValue()) {
            XPlanOrderChangeLoghelper.xPlanOrderChangeLogEntryMod(entryentity, planorderChangeBill, planOrder, isSplit, true);
        }
    }

    public static void xPlanOrderChangeLogchangeEntry(DynamicObject addNew, DynamicObject planorderChangeBill, DynamicObject planOrder, boolean isSplit, Boolean isSplitOrder) {
        String changetype = planorderChangeBill.getString("changetype");
        Map xPlanLogMap = XPlanOrderLogConst.getXPlanLogMap((String)changetype);
        Map xPlanLogValue = XPlanOrderLogConst.getXPlanLogValue((String)changetype);
        for (Map.Entry xPlanLogEntry : xPlanLogMap.entrySet()) {
            String srcValueTag = (String)xPlanLogEntry.getValue();
            String changeValueTag = (String)xPlanLogEntry.getKey();
            Boolean isChange = (Boolean)xPlanLogValue.get(changeValueTag);
            Object changeValue = null;
            changeValue = isChange == false ? planOrder.get(srcValueTag) : planorderChangeBill.get(changeValueTag);
            Object srcValue = planOrder.get(srcValueTag);
            String combinValue = XPlanOrderChangeLoghelper.dealCombineValue(srcValue, changeValue, isSplit, isSplitOrder, changetype);
            addNew.set(changeValueTag, (Object)combinValue);
        }
    }

    private static void xPlanOrderChangeLogFixEntry(DynamicObject addNew, DynamicObject planorderChangeBill, Boolean isSplitOrder) {
        DynamicObject material = planorderChangeBill.getDynamicObject("material");
        addNew.set("material", (Object)material);
        if (!isSplitOrder.booleanValue()) {
            addNew.set("srcbillnoentry", planorderChangeBill.get("sourceno"));
        } else {
            addNew.set("srcbillnoentry", (Object)ResManager.loadKDString((String)"\u62c6\u5206\u8ba2\u5355", (String)"XPlanOrderChangeLoghelper_1", (String)"mmc-mrp-business", (Object[])new Object[0]));
        }
        addNew.set("configuredcode", planorderChangeBill.get("configuredcode"));
        addNew.set("unit", planorderChangeBill.get("unit"));
    }

    public static void xPlanOrderChangeLog(DynamicObject addNew, DynamicObject planOrder) {
        DynamicObject material = planOrder.getDynamicObject("material");
        addNew.set("material", (Object)material);
        addNew.set("srcbillnoentry", planOrder.get("billno"));
        addNew.set("configuredcode", planOrder.get("configuredcode"));
        addNew.set("unit", planOrder.get("unit"));
    }

    private static String dealCombineValue(Object srcValue, Object changeValue, Boolean isSplit, Boolean isSplitOrder, String changetype) {
        String combineValue = ResManager.loadKDString((String)"\u65e0", (String)"XPlanOrderChangeLoghelper_2", (String)"mmc-mrp-business", (Object[])new Object[0]);
        if (srcValue == null && changeValue == null) {
            return combineValue;
        }
        String oldValueStr = "";
        String newValueStr = "";
        String changeFlag = "";
        if (changeValue instanceof Date) {
            if (!isSplit.booleanValue() || isSplitOrder.booleanValue()) {
                if (srcValue != null) {
                    oldValueStr = XPlanOrderChangeLoghelper.transDate(srcValue);
                }
                newValueStr = XPlanOrderChangeLoghelper.transDate(changeValue);
            } else {
                oldValueStr = newValueStr = XPlanOrderChangeLoghelper.transDate(srcValue);
            }
        } else if (changeValue instanceof DynamicObject) {
            if (!isSplit.booleanValue() || isSplitOrder.booleanValue()) {
                if (srcValue != null) {
                    oldValueStr = XPlanOrderChangeLoghelper.transDynamicObject(srcValue);
                }
                newValueStr = XPlanOrderChangeLoghelper.transDynamicObject(changeValue);
            } else {
                oldValueStr = newValueStr = XPlanOrderChangeLoghelper.transDynamicObject(srcValue);
            }
        } else if (changeValue instanceof BigDecimal && srcValue instanceof BigDecimal) {
            BigDecimal newValueBigDecimal = BigDecimal.ZERO;
            BigDecimal oldValueBigDecimal = BigDecimal.ZERO;
            if (isSplitOrder.booleanValue()) {
                newValueBigDecimal = (BigDecimal)changeValue;
            } else if (((BigDecimal)changeValue).compareTo((BigDecimal)srcValue) == 0 && !"C".equals(changetype)) {
                oldValueBigDecimal = newValueBigDecimal = (BigDecimal)changeValue;
            } else {
                oldValueBigDecimal = (BigDecimal)srcValue;
                newValueBigDecimal = ((BigDecimal)srcValue).subtract((BigDecimal)changeValue);
            }
            if (oldValueBigDecimal.compareTo(newValueBigDecimal) != 0) {
                int compareResult = oldValueBigDecimal.compareTo(newValueBigDecimal);
                if (compareResult < 0) {
                    changeFlag = "\u2191";
                } else if (compareResult > 0) {
                    changeFlag = "\u2193";
                }
            }
            oldValueStr = oldValueBigDecimal.stripTrailingZeros().toPlainString();
            newValueStr = newValueBigDecimal.stripTrailingZeros().toPlainString();
        } else {
            if (srcValue != null) {
                oldValueStr = srcValue.toString();
            }
            if (changeValue != null) {
                newValueStr = changeValue.toString();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)oldValueStr) || StringUtils.isNotEmpty((CharSequence)newValueStr)) {
            combineValue = StringUtils.equals((CharSequence)newValueStr, (CharSequence)oldValueStr) ? XPlanOrderChangeLoghelper.transEmpty(oldValueStr) : XPlanOrderChangeLoghelper.transEmpty(oldValueStr) + " -> " + XPlanOrderChangeLoghelper.transEmpty(newValueStr) + changeFlag;
        }
        return combineValue;
    }

    private static String transDynamicObject(Object value) {
        String number = "";
        if (value instanceof DynamicObject) {
            DynamicObject baseData = (DynamicObject)value;
            number = baseData.getString("number");
        }
        return number;
    }

    private static String transEmpty(String value) {
        return StringUtils.isEmpty((CharSequence)value) ? ResManager.loadKDString((String)"\u65e0", (String)"XPlanOrderChangeLoghelper_2", (String)"mmc-mrp-business", (Object[])new Object[0]) : value;
    }

    private static String transDate(Object value) {
        return new SimpleDateFormat("yyyy/MM/dd").format((Date)value);
    }

    public static String getSelectXPlanOrderRLogFields() {
        StringBuilder fields = new StringBuilder();
        fields.append("id").append(',');
        fields.append("srcbillid").append(',');
        fields.append("srcbillno").append(',');
        fields.append("xbillid").append(',');
        fields.append("xbillno").append(',');
        fields.append("creator").append(',');
        fields.append("createtime").append(',');
        fields.append("modifier").append(',');
        fields.append("modifytime").append(',');
        fields.append("auditdate").append(',');
        fields.append("auditor").append(',');
        fields.append("xreason").append(',');
        fields.append("changetype").append(',');
        fields.append("changestatus").append(',');
        fields.append("org").append(',');
        fields.append("proorpurorg").append(',');
        fields.append("entryentity").append(',').append("seqfield").append(',');
        fields.append("entryentity").append(',').append("material").append(',');
        fields.append("entryentity").append('.').append("seqfield").append(',');
        fields.append("entryentity").append('.').append("srcbillnoentry").append(',');
        fields.append("entryentity").append('.').append("changeqty").append(',');
        fields.append("entryentity").append('.').append("changedate").append(',');
        fields.append("entryentity").append('.').append("changtracknumber").append(',');
        fields.append("entryentity").append('.').append("changsupplier").append(',');
        fields.append("entryentity").append('.').append("configuredcode").append(',');
        fields.append("entryentity").append('.').append("unit");
        return fields.toString();
    }

    public static void dealXPlanOrderChangeLog(String changeStatus, DynamicObject xplanOrderlog, DynamicObject planorderChangeBill) {
        xplanOrderlog.set("changestatus", (Object)changeStatus);
        xplanOrderlog.set("changetype", (Object)planorderChangeBill.getString("changetype"));
        xplanOrderlog.set("xbillid", planorderChangeBill.getPkValue());
        xplanOrderlog.set("xbillno", planorderChangeBill.get("billno"));
        xplanOrderlog.set("xreason", planorderChangeBill.get("reason"));
        xplanOrderlog.set("org", planorderChangeBill.get("org"));
        xplanOrderlog.set("proorpurorg", planorderChangeBill.get("proorpurorg"));
        xplanOrderlog.set("srcbillid", planorderChangeBill.get("sourceid"));
        xplanOrderlog.set("srcbillno", planorderChangeBill.get("sourceno"));
        xplanOrderlog.set("creator", planorderChangeBill.get("creator"));
        xplanOrderlog.set("createtime", planorderChangeBill.get("createtime"));
        xplanOrderlog.set("modifier", planorderChangeBill.get("auditor"));
        xplanOrderlog.set("modifytime", planorderChangeBill.get("modifytime"));
        xplanOrderlog.set("auditor", planorderChangeBill.get("auditor"));
        xplanOrderlog.set("auditdate", planorderChangeBill.get("auditdate"));
    }

    public static DynamicObject getXPlanOrderLogEntry(DynamicObject newPlanOrder, DynamicObject xplanorderLog, Boolean isSplitOrder) {
        DynamicObject result = null;
        String splitNumber = ResManager.loadKDString((String)"\u62c6\u5206\u8ba2\u5355", (String)"XPlanOrderChangeLoghelper_1", (String)"mmc-mrp-business", (Object[])new Object[0]);
        String billNo = newPlanOrder.getString("billno");
        DynamicObjectCollection entryentity = xplanorderLog.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            String srcbillNo = entry.getString("srcbillnoentry");
            if (billNo.equals(srcbillNo)) {
                return entry;
            }
            if (!isSplitOrder.booleanValue() || !splitNumber.equals(srcbillNo)) continue;
            return entry;
        }
        return result;
    }
}

