/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.integrate.utils.SnapshotDataIntegrateUtils;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;

public class MRPWorkCalendarManager {
    private Map<String, OrgBasedCalendarModel> calendars = new HashMap<String, OrgBasedCalendarModel>();
    private CalEnv ctx;

    public MRPWorkCalendarManager(CalEnv ctx) {
        this.ctx = ctx;
        ctx.addService(MRPWorkCalendarManager.class, this);
    }

    public void setCalendarUtil(String orgId, OrgBasedCalendarModel manager) {
        this.calendars.put(orgId, manager);
    }

    @Deprecated
    public OrgBasedCalendarModel get(String firstOrg) {
        return this.get(firstOrg, null);
    }

    public OrgBasedCalendarModel get(String firstOrg, String secondOrg) {
        return this.get(firstOrg, secondOrg, null);
    }

    public OrgBasedCalendarModel get(String firstOrg, String secondOrg, String materialId) {
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        MtPlanInfoModel planInfoModel = (MtPlanInfoModel)this.ctx.getService(MtPlanInfoModel.class);
        OrgBasedCalendarModel cal = this.calendars.get(firstOrg);
        if (cal == null && (cal = this.calendars.get(secondOrg)) == null) {
            int idx0 = 0;
            int idx1 = 1;
            String[] org = cacheDatas.getOrgById(firstOrg);
            String[] org2 = cacheDatas.getOrgById(secondOrg);
            String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u7ec4\u7ec7\u201c%1$s(%2$s)\u201d\uff0cid\uff1a\u201c%3$s\u201d\u6216\u7ec4\u7ec7\u201c%4$s(%5$s)\u201d\uff0cid\uff1a\u201c%6$s\u201d\u7684\u8ba1\u5212\u65e5\u5386\u3002", (String)"MRPWorkCalendarManager_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)materialId)) {
                msg = ResManager.loadKDString((String)"\u9700\u6c42\u7269\u6599\u201c%1$s(%2$s)\u201d, id: \u201c%3$s\u201d\u672a\u627e\u5230\u7ec4\u7ec7\u201c%4$s(%5$s)\u201d, id: \u201c%6$s\u201d\u6216\u7ec4\u7ec7\u201c%7$s(%8$s)\u201d, id:\u201c%9$s\u201d\u7684\u8ba1\u5212\u65e5\u5386\u3002", (String)"MRPWorkCalendarManager_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
                String[] minfo = planInfoModel.getMaterialDataById(materialId);
                throw new KDBizException(new ErrorCode("CALENDAR_NOT_FOUND", msg), new Object[]{minfo[0], minfo[1], materialId, org[idx1], org[idx0], firstOrg, org2[idx1], org2[idx0], secondOrg});
            }
            throw new KDBizException(new ErrorCode("CALENDAR_NOT_FOUND", msg), new Object[]{org[idx1], org[idx0], firstOrg, org2[idx1], org2[idx0], secondOrg});
        }
        return cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initWorkCalendars() {
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        RunLogModel runLogModel = (RunLogModel)this.ctx.getService(RunLogModel.class);
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        int dataAmount = 0;
        Iterator<String> it = planModel.getRequirorgs().iterator();
        StringBuilder message = new StringBuilder();
        ArrayList<Long> idList = new ArrayList<Long>(16);
        while (it.hasNext()) {
            String id = it.next();
            OrgBasedCalendarModel cUtil = new OrgBasedCalendarModel(id);
            if (!cUtil.isEmpty()) {
                cUtil.setRequireStartDate(runLogModel.getPlanDate(), planModel.requireDelayPeriod());
                cUtil.setSupplyStartDate(runLogModel.getPlanDate(), planModel.supplyDelayPeriod());
                cUtil.setEndDate(runLogModel.getPlanDate(), planModel.getPlanOutLook());
                this.setCalendarUtil(id, cUtil);
                ++dataAmount;
                continue;
            }
            idList.add(Long.valueOf(id));
        }
        if (!idList.isEmpty()) {
            String selectFields = "id,name,number";
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", idList)};
            DataSet cds = cacheDatas.loadCacheDatas("bos_org", selectFields, filters);
            try (DataSet c = null;){
                c = cds != null ? SnapshotDataIntegrateUtils.wrap(cds) : ORM.create().queryDataSet(this.getClass().getName(), "bos_org", selectFields, filters);
                while (c.hasNext()) {
                    Row row = c.next();
                    if (message.length() != 0) {
                        message.append(',');
                    }
                    message.append(row.getString("name")).append('(').append(row.getString("number")).append(')');
                }
            }
            message.insert(0, ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u672a\u6b63\u786e\u8bbe\u7f6e\u8ba1\u5212\u65e5\u5386\uff1a", (String)"MRPWorkCalendarManager_4", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
            throw new MRPBizException(Errors.getNoWorkCalendar(), message);
        }
        return dataAmount;
    }

    @Deprecated
    public int getPlanDatePeriod(String firstOrg) {
        return this.getPlanDatePeriod(firstOrg, null);
    }

    public int getPlanDatePeriod(String firstOrg, String secondOrg) {
        RunLogModel runLogModel = (RunLogModel)this.ctx.getService(RunLogModel.class);
        return this.get(firstOrg, secondOrg).getWorkDaySeq(runLogModel.getPlanDate());
    }

    @Deprecated
    public Date getBeginDateRequire(String firstOrg) {
        return this.getBeginDateRequire(firstOrg, null);
    }

    public Date getBeginDateRequire(String firstOrg, String secondOrg) {
        return this.get(firstOrg, secondOrg).getRequireStartDate();
    }

    @Deprecated
    public Date getBeginDateSupply(String firstOrg) {
        return this.getBeginDateSupply(firstOrg, null);
    }

    public Date getBeginDateSupply(String firstOrg, String secondOrg) {
        return this.get(firstOrg, secondOrg).getSupplyStartDate();
    }

    @Deprecated
    public Date getEndDateOutLook(String firstOrg) {
        return this.getEndDateOutLook(firstOrg, null);
    }

    public Date getEndDateOutLook(String firstOrg, String secondOrg) {
        return this.get(firstOrg, secondOrg).getEndDate();
    }
}

