/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import kd.bos.algo.Algo;
import kd.bos.threads.ThreadPools;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;

public class MultiThreadCacheManager {
    public static final ThreadLocal<String> allDetails = new ThreadLocal();
    public static final ThreadLocal<String> allMFTStocks = new ThreadLocal();
    private static final ThreadLocal<Map<MultiThreadCacheKey, Object>> THREAD_CACHE = new ThreadLocal();
    private static CompletionService<IMRPResult> PMRP_M_ECS;
    private static ExecutorService exec;

    public static synchronized void setCacheData(MultiThreadCacheKey key, Object cacheData) {
        Map<MultiThreadCacheKey, Object> cache = MultiThreadCacheManager.initCache();
        cache.put(key, cacheData);
    }

    private static Map<MultiThreadCacheKey, Object> initCache() {
        Map<MultiThreadCacheKey, Object> cache = THREAD_CACHE.get();
        if (cache == null) {
            cache = new HashMap<MultiThreadCacheKey, Object>();
            THREAD_CACHE.set(cache);
        }
        return cache;
    }

    public static <T> T getCacheData(MultiThreadCacheKey key) {
        Map<MultiThreadCacheKey, Object> cache = THREAD_CACHE.get();
        if (cache != null) {
            return (T)cache.get((Object)key);
        }
        return null;
    }

    public static synchronized CompletionService<IMRPResult> getMultiThreadService(IMRPEnvProvider ctx) {
        if (exec != null && !exec.isShutdown()) {
            return PMRP_M_ECS;
        }
        String poolName = "mmp_inst_pool";
        Integer poolSize = (Integer)ctx.getCfgValue(EnvCfgItem.MRP_CALC_PROCESSOR);
        exec = ThreadPools.newExecutorService((String)poolName, (int)poolSize);
        PMRP_M_ECS = new ExecutorCompletionService<IMRPResult>(exec);
        return PMRP_M_ECS;
    }

    public static synchronized void shutdown() {
        if (exec != null) {
            exec.shutdown();
        }
        exec = null;
        PMRP_M_ECS = null;
    }

    public static int loop(int loopCount) {
        int cycleCount = 0;
        try {
            for (int i = 0; i < loopCount; ++i) {
                IMRPResult v = PMRP_M_ECS.take().get();
                if (!(v instanceof Integer)) continue;
                cycleCount += ((Integer)((Object)v)).intValue();
            }
        }
        catch (Exception e) {
            throw new MRPBizException(e, Errors.getThreadCycleError());
        }
        return cycleCount;
    }

    public static void releaseDataSet() {
        String cacheId = allDetails.get();
        if (cacheId != null) {
            allDetails.set(null);
            Algo.removeCacheDataSet((String)cacheId);
        }
        if ((cacheId = allMFTStocks.get()) != null) {
            allMFTStocks.set(null);
            Algo.removeCacheDataSet((String)cacheId);
        }
    }
}

