/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.cache;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MRPRedisStore {
    private Log log = LogFactory.getLog(MRPRedisStore.class);
    private HashMap<String, Object> fake = new HashMap();
    private final int msetSplitMinSize = 0x100000;
    private static int timeout = 7200;
    private final AtomicBoolean cleared = new AtomicBoolean();
    private ConcurrentHashMap<String, Item> keyToItem = new ConcurrentHashMap();
    private static final byte[] empty_bs = new byte[0];
    private final String region;
    protected final String keyPrefix;
    private String ctxId;
    private Timer autoExtendCacheTimer = null;
    private static int autoExtendCacheLoopPeriod = timeout / 2;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private TimerTask autoExtendCacheTask = new TimerTask(){

        @Override
        public void run() {
            MRPRedisStore.this.extendCacheTask();
        }
    };

    public MRPRedisStore(String region, String ctxId) {
        this.region = region;
        this.ctxId = ctxId;
        this.keyPrefix = "mrpcalc-" + ctxId;
        this.autoExtendCacheTimer = new Timer();
        this.autoExtendCacheTimer.scheduleAtFixedRate(this.autoExtendCacheTask, timeout / 2, (long)autoExtendCacheLoopPeriod);
    }

    protected final byte[] encodeKey(String key) {
        return this.toBytes(this.keyPrefix + key);
    }

    protected final String decodeKey(byte[] bs) {
        return new String(bs).substring(this.keyPrefix.length());
    }

    protected final byte[] toBytes(String key) {
        return key.getBytes();
    }

    public final JedisClient getJedis() {
        this.getUrl();
        return RedisFactory.getJedisClient((String)this.getUrl());
    }

    private String getUrl() {
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)this.region);
        String url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey((String)null);
            url = System.getProperty(configKey);
        }
        return url;
    }

    /*
     * Exception decompiling
     */
    public static final byte[] encode(Object object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static final Object decode(byte[] bs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <T> T get(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeItem(String key) {
        this.keyToItem.remove(key);
    }

    private void updateItem(String key) {
        Item item = this.keyToItem.get(key);
        if (item == null) {
            item = new Item(key);
            this.keyToItem.putIfAbsent(key, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void set(String key, T value) {
        if (Instance.isLightWeightDeploy()) {
            HashMap<String, Object> hashMap = this.fake;
            synchronized (hashMap) {
                this.fake.put(key, value);
                return;
            }
        }
        try (JedisClient jedis = this.getJedis();
             TraceSpan ts = Tracer.create((String)"MRPRedisStore.set", (String)"set");){
            jedis.setex(this.encodeKey(key), timeout, MRPRedisStore.encode(value));
            this.updateItem(key);
        }
    }

    /*
     * Exception decompiling
     */
    public long inc(String key, long inc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long getInc(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        if (Instance.isLightWeightDeploy()) {
            HashMap<String, Object> hashMap = this.fake;
            synchronized (hashMap) {
                this.fake.remove(key);
            }
            return;
        }
        try (JedisClient jedis = this.getJedis();
             TraceSpan ts = Tracer.create((String)"MRPRedisStore.remove", (String)"remove");){
            jedis.del(this.encodeKey(key));
            this.removeItem(key);
            StringWriter sw = new StringWriter();
            new Exception().printStackTrace(new PrintWriter(sw));
            this.log.info("remove key:" + key + ", " + sw.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void mapSet(String type, String field, T value) {
        if (Instance.isLightWeightDeploy()) {
            HashMap<String, Object> hashMap = this.fake;
            synchronized (hashMap) {
                HashMap<String, T> sub = (HashMap<String, T>)this.fake.get(type);
                if (sub == null) {
                    sub = new HashMap<String, T>();
                    this.fake.put(type, sub);
                }
                sub.put(field, value);
            }
            return;
        }
        try (JedisClient jedis = this.getJedis();
             TraceSpan ts = Tracer.create((String)"MRPRedisStore.mapSet", (String)"mapSet");){
            byte[] bs = this.encodeKey(type);
            jedis.hset(bs, this.encodeKey(field), MRPRedisStore.encode(value));
            jedis.expire(bs, timeout);
            this.updateItem(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void mapMSet(String type, Map<String, T> valueMap) {
        if (Instance.isLightWeightDeploy()) {
            HashMap<String, Object> hashMap = this.fake;
            synchronized (hashMap) {
                Map sub = (Map)this.fake.get(type);
                if (sub == null) {
                    this.fake.put(type, valueMap);
                } else {
                    sub.putAll(valueMap);
                }
            }
            return;
        }
        try (JedisClient jedis = this.getJedis();
             TraceSpan ts = Tracer.create((String)"MRPRedisStore.mapMSet", (String)"mapMSet");){
            byte[] bs = this.encodeKey(type);
            HashMap<byte[], byte[]> map = new HashMap<byte[], byte[]>(256);
            int size = 0;
            for (Map.Entry<String, T> entry : valueMap.entrySet()) {
                byte[] key = this.encodeKey(entry.getKey());
                byte[] value = MRPRedisStore.encode(entry.getValue());
                map.put(key, value);
                if ((size += key.length + value.length) < 0x100000) continue;
                jedis.hmset(bs, map);
                map.clear();
                size = 0;
            }
            if (!map.isEmpty()) {
                jedis.hmset(bs, map);
            }
            jedis.expire(bs, timeout);
            this.updateItem(type);
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T mapGet(String type, String field) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <T> Map<String, T> mapMGet(String type, String ... fields) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <T> Map<String, T> mapGetAll(String type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapRemove(String type, String field) {
        if (Instance.isLightWeightDeploy()) {
            HashMap<String, Object> hashMap = this.fake;
            synchronized (hashMap) {
                Map vals = (Map)this.fake.get(type);
                if (vals != null) {
                    vals.remove(field);
                }
            }
            return;
        }
        try (JedisClient jedis = this.getJedis();
             TraceSpan ts = Tracer.create((String)"MRPRedisStore.mapRemove", (String)"mapRemove");){
            jedis.hdel(this.encodeKey(type), (byte[][])new byte[][]{this.encodeKey(field)});
            this.removeItem(type);
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.autoExtendCacheTimer.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        if (Instance.isLightWeightDeploy()) {
            HashMap<String, Object> hashMap = this.fake;
            synchronized (hashMap) {
                this.fake.clear();
            }
            return;
        }
        if (this.cleared.compareAndSet(false, true)) {
            try (JedisClient jc = this.getJedis();
                 TraceSpan ts = Tracer.create((String)"MRPRedisStore", (String)"clearOnce");){
                ArrayList keys = new ArrayList(this.keyToItem.keySet());
                this.keyToItem.clear();
                for (String key : keys) {
                    jc.del(this.encodeKey(key));
                }
                this.log.info("MRPCalc" + this.ctxId + " redis store clear " + keys.size() + " keys, keys:" + Arrays.toString(keys.toArray()));
            }
        }
    }

    private void extendCacheTask() {
        ArrayList<Item> list = new ArrayList<Item>();
        list.addAll(this.keyToItem.values());
        if (Instance.isLightWeightDeploy()) {
            return;
        }
        try (JedisClient jedis = this.getJedis();){
            for (Item item : list) {
                if (this.closed.get()) {
                    return;
                }
                try {
                    byte[] bs = this.encodeKey(item.key);
                    jedis.expire(bs, timeout);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static class Item
    implements Comparable<Item> {
        String key;
        long timestamp;

        Item(String key) {
            this.key = key;
            this.timestamp = System.currentTimeMillis();
        }

        @Override
        public int compareTo(Item o) {
            return (int)(this.timestamp - o.timestamp);
        }
    }
}

