/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.consts;

import java.math.BigDecimal;
import kd.bos.id.ID;

public class MRPRuntimeConsts {
    public static final String NODE_ID = ID.longTo36Radix((long)ID.genLongId());
    public static final String MRP_INST_THREAD_POOL_NAME = "mmp_inst_pool";
    public static final int MQ_EVENT_MAX_FAILED_COUNT = 3;
    public static final String RELATION_FORMULA_CACHE_KEY = "__RELATION_FORMULA_CACHE__";
    public static final String MRP_MQ_REGION_NAME = "mmc";
    public static final String MRP_MQ_APP_ID = "mrp";
    public static final String MRP_MQ_QUEUE_NAME = "kd.mmc.mrp.calcnode.mrp_queue";
    public static final String MRP_CACHE_REGION_NAME = "mmc_fmm_mrp_region";
    public static final String MRP_MUTEX_GROUP_ID = "mmc.mrp";
    public static final String MRP_MUTEX_OPERATION_KEY = "edit";
    public static final int FAILED_REASON_MEMORY = 1;
    public static final int FAILED_REASON_DB = 2;
    public static final int FAILED_REASON_PRO = 3;
    public static final int MAX_BATCH = 100;
    public static final Integer I_ONE = 1;
    public static final Integer I_ZERO = 0;
    public static final Integer I_4 = 0;
    public static final Integer I_8 = 0;
    public static final BigDecimal D_ZERO = BigDecimal.ZERO;
    public static final BigDecimal D_100 = new BigDecimal(100);
    public static final BigDecimal D_20 = new BigDecimal(20);
    public static final BigDecimal D_MAX = new BigDecimal(Integer.MAX_VALUE);
    public static final long ONE_DAY_MILLISECONDS = 86400000L;
    public static final String PREDEFINED_PARAM_WORKCALENDARS = "calendars";
    public static final String PREDEFINED_PARAM_REQUIREDATA = "requireData";
    public static final String PREDEFINED_PARAM_SUPPLYDATA = "supplyData";
    public static final String PREDEFINED_PARAM_BOMDATA = "bomData";

    public static String getMetaKey(String eventId, String modelId) {
        return eventId + "\u0001" + modelId + "\u0001-meta";
    }

    public static String getResModelQueryKey(String modelId) {
        return modelId + "-CachedDataSet";
    }

    public static String getQueryModelRowCountKey(String modelId) {
        return modelId + "-QueryModelRowCount";
    }

    public static String getQueryModelTimeCostKey(String modelId) {
        return modelId + "-QueryModelTimeCost";
    }

    public static String getSeparateKey(String eventId, String modelId) {
        return eventId + "--" + modelId + "--keys";
    }

    public static String getSummarizeKey(String ctxId) {
        return ctxId + "--summarizekeys";
    }

    public static String getDataKey(String eventId, String modelId, String resKey) {
        return eventId + "\u0001" + modelId + "\u0001" + resKey;
    }

    public static String[] splitDataKey(String dataKey) {
        return dataKey.split("\u0001");
    }

    public static String getRowCountKey(String eventId, String modelId) {
        return eventId + "\u0001" + modelId + "\u0001-rc";
    }

    public static String getMaterialKey4Require(String mrpContextId, String materialId) {
        return mrpContextId + "\u0001" + materialId + "\u0001-require";
    }

    public static String getMaterialKey4Supply(String mrpContextId, String materialId) {
        return mrpContextId + "\u0001" + materialId + "\u0001-supply";
    }

    public static String getMaterialKey4Reserve(String mrpContextId, String materialId) {
        return mrpContextId + "\u0001" + materialId + "\u0001-reserveCache";
    }

    public static String getMaterialKey4ReserveRemovePo(String mrpContextId, String materialId) {
        return mrpContextId + "\u0001" + materialId + "\u0001-reserveRemovePo";
    }

    public static String getReserveSplitKey(String mrpContextId, String materialId) {
        return materialId + "\u0001" + mrpContextId + "\u0001-reserveCache-split-keys";
    }

    public static String getBOMDataKey(String mrpContextId) {
        return mrpContextId + "\u0001-bomdatas";
    }

    public static String getSelectBillDataKey(String mrpContextId, Object resId) {
        return mrpContextId + "\u0001" + resId + "\u0001-selectbilldatas";
    }

    public static String getSelectBillMaterialKey(String mrpContextId) {
        return mrpContextId + "\u0001-selectbillmaterial";
    }

    public static String getOriginSelectBillMaterialKey(String mrpContextId) {
        return mrpContextId + "\u0001-originselectbillmaterial";
    }

    public static String getSelectBillSizeKey(String mrpContextId) {
        return mrpContextId + "\u0001-selectbillsize";
    }

    public static String getSelectMaterialSizeKey(String mrpContextId) {
        return mrpContextId + "\u0001-selectmaterialsize";
    }

    public static String getSelectMaterialIsSingleCalcKey(String mrpContextId) {
        return mrpContextId + "\u0001-selectmaterial_is_single_calc";
    }

    public static String getSelectMaterialOrgKey(String mrpContextId) {
        return mrpContextId + "\u0001-selectmaterial_org";
    }

    public static String getBOMMetaKey(String mrpContextId) {
        return mrpContextId + "\u0001-bommetas";
    }

    public static String getBOMSizeKey(String mrpContextId) {
        return mrpContextId + "\u0001-bomsize";
    }

    public static String getMaterial2PlanOrderKey(String mrpContextId, String materialId) {
        return materialId + "\u0001" + mrpContextId + "\u0001-po";
    }

    public static String getMaterial2PlanOrderNumDictKey(String mrpContextId, String materialId) {
        return materialId + "\u0001" + mrpContextId + "\u0001-poNumDict";
    }

    public static String getMaterialKey4Balance(String mrpContextId, String materialId) {
        return mrpContextId + "\u0001" + materialId + "\u0001-balance";
    }

    public static String getBalanceSplitKey(String mrpContextId, String materialId) {
        return materialId + "\u0001" + mrpContextId + "\u0001-balance-split-keys";
    }

    public static String getGroupKey(String[] groupKeys) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < groupKeys.length; ++i) {
            if (sb.length() != 0) {
                sb.append('\u0001');
            }
            sb.append(groupKeys[i]);
        }
        return sb.toString();
    }

    public static String getMetaColsKey(String eventId, String modelId) {
        return eventId + "\u0001" + modelId + "\u0001-metaCols";
    }

    public static String getMaterialTableKey(String mrpContextId) {
        return mrpContextId + "\u0001-materialTable";
    }

    public static String getOriMaterialTableKey(String mrpContextId) {
        return mrpContextId + "\u0001-oriMaterialTable";
    }

    public static String getMaterialPlanTableKey(String mrpContextId) {
        return mrpContextId + "\u0001-materialPlanTable";
    }

    public static String getReplaceKey(String bomId, String replaceId) {
        return bomId + "\u0001" + replaceId + "\u0001-Replace";
    }

    public static String getReplacePlanOrderKey(String parentMaterial) {
        return "replace_planorder-" + parentMaterial;
    }

    public static String getReplacePlanOrderSubKey(String mrpContextId, String replaceKey, String parentBomId, String replaceplan) {
        return mrpContextId + "\u0001" + replaceKey + "\u0001" + parentBomId + "\u0001" + replaceplan + "\u0001-replace-planorder-key";
    }

    public static String getPlanOrderSplitKey(String mrpContextId, String materialId) {
        return materialId + "\u0001" + mrpContextId + "\u0001-po-split-keys";
    }

    public static String getMetaDynamicInfoKey(String mrpContextId, String key) {
        return mrpContextId + "\u0001" + key + "\u0001metaKey";
    }

    public static String getReplaceStructTable(String mrpContextId) {
        return mrpContextId + "\u0001-repalce-Struct-Table";
    }

    public static String getBOMShareCacheKey(String mrpContextId) {
        return mrpContextId + "\u0001-bom-share-cache";
    }

    public static String getRequireMaterialKey(String mrpContextId) {
        return mrpContextId + "\u0001-require-material-key";
    }

    public static String getReserveRecordSplitKey(String mrpContextId, String materialId) {
        return materialId + "\u0001" + mrpContextId + "\u0001-reserve-record";
    }

    public static String getRequireConfigKey(String mrpContextId) {
        return mrpContextId + "\u0001-require-config-key";
    }

    public static String getRequireTrackKey(String mrpContextId) {
        return mrpContextId + "\u0001-require-track-key";
    }

    public static String getInvMaterialKey(String mrpContextId) {
        return mrpContextId + "\u0001-inv-material-key";
    }

    public static String getDependSupplyKey(String mrpContextId, String material) {
        return mrpContextId + "\u0001" + material + "\u0001-depend-supply-key";
    }

    public static String getIsDependRequireDataSourceKey(String mrpContextId) {
        return mrpContextId + "\u0001-depend-datasource-key";
    }

    public static String getDependRequireLLCRelationKey(String mrpContextId) {
        return mrpContextId + "\u0001-depend-llc-relation-key";
    }

    public static String getSelectMaterialPlanScopeKey(String mrpContextId, String material) {
        return mrpContextId + "\u0001" + material + "\u0001-select-material-planscope-key";
    }

    public static String getDependRequireMaterialKey(String mrpContextId, String material) {
        return mrpContextId + "\u0001" + material + "\u0001-depend-material-key";
    }

    public static String getDependRequireMaterialPlanScopeKey(String mrpContextId, String material) {
        return mrpContextId + "\u0001" + material + "\u0001-depend-material-planscope-key";
    }

    public static String getSelectPlanDeleteOrderIdsKey(String mrpContextId, String material) {
        return mrpContextId + "\u0001" + material + "\u0001-select-plan-delete-order-key";
    }

    public static String getSelectPlanDeleteCollIdsKey(String mrpContextId, String material) {
        return mrpContextId + "\u0001" + material + "\u0001-select-plan-delete-coll-key";
    }

    public static String getDynamicDeleteDataKey(String mrpContextId, int llc, String billEntity) {
        return mrpContextId + "\u0001" + billEntity + "\u0001" + llc + "\u0001-dynamic-deleteData-key";
    }

    public static String getCPSOrderEntryIds(String modelId) {
        return modelId + "-GetCPSOrderEntryIds";
    }
}

