/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.fomula;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.framework.fomula.IToken;
import kd.mmc.mrp.framework.fomula.Lexer;
import kd.mmc.mrp.framework.fomula.ParseException;
import kd.mmc.mrp.framework.fomula.enums.TokenType;
import kd.mmc.mrp.framework.fomula.node.IFTokenNode;
import kd.mmc.mrp.framework.fomula.node.MethodTokenNode;
import kd.mmc.mrp.framework.fomula.node.TokenNode;
import kd.mmc.mrp.framework.fomula.token.ConstToken;
import kd.mmc.mrp.framework.fomula.token.OperatorToken;
import kd.mmc.mrp.framework.fomula.token.PlaceHoldToken;

public class Expr {
    private TokenNode root;
    private Lexer lexer;
    private HashSet<String> awaredCols;

    public Expr(String exprStr) throws ParseException {
        this.lexer = new Lexer(exprStr);
        this.root = this.parseTokens(this.lexer.parse());
    }

    public boolean isWellFormatted() {
        return this.root != null;
    }

    public synchronized HashSet<String> getAwaredColumns() {
        this.awaredCols = new HashSet();
        for (IToken token : this.lexer.getTokens()) {
            if (token.getType() != TokenType.COLUMN) continue;
            String[] tmp = token.toString().split("@");
            this.awaredCols.add(tmp[1]);
        }
        return this.awaredCols;
    }

    public TokenNode getRootTokenNode() {
        return this.root;
    }

    private TokenNode parseTokens(List<IToken> tokens) throws ParseException {
        Stack<TokenNode> bracketStack = new Stack<TokenNode>();
        Stack<TokenNode> middleBracketStack = new Stack<TokenNode>();
        Stack<TokenNode> logicStack = new Stack<TokenNode>();
        TokenNode operatorNode = null;
        TokenNode operandNode = null;
        TokenNode connectNode = null;
        TokenNode returnNode = null;
        MethodTokenNode methodNode = null;
        TokenNode ifNode = null;
        ArrayList<IToken> returnSubTokens = new ArrayList<IToken>(0);
        block16: for (IToken token : tokens) {
            TokenNode node = new TokenNode(token);
            if (returnNode != null) {
                if (token.getType() != TokenType.SEMICOLON) {
                    returnSubTokens.add(token);
                    continue;
                }
                TokenNode ret = this.parseTokens(returnSubTokens);
                if (returnSubTokens.size() > 1) {
                    ret.addFirst((IToken)returnSubTokens.get(0));
                    ret.addOperand((IToken)returnSubTokens.get(returnSubTokens.size() - 1));
                }
                ret.addOperand(new ConstToken(";", TokenType.SEMICOLON));
                returnNode.setRight(ret);
                returnNode = null;
                returnSubTokens = new ArrayList(0);
                continue;
            }
            if (!middleBracketStack.isEmpty() && token.getType() != TokenType.RIGHTMIDDLEBRACKET) {
                middleBracketStack.push(node);
                continue;
            }
            switch (token.getType()) {
                case LEFTBRACKET: {
                    bracketStack.push(node);
                    break;
                }
                case RIGHTBRACKET: {
                    TokenNode top = (TokenNode)bracketStack.pop();
                    ArrayList<IToken> subTokens = new ArrayList();
                    if (top.isSingleTokenNode()) {
                        subTokens.add(0, top.getFirst());
                    } else {
                        subTokens.add(0, new PlaceHoldToken(top));
                    }
                    while (true) {
                        if ((top = (TokenNode)bracketStack.pop()).isBracketNode()) {
                            subTokens.add(0, new PlaceHoldToken(top));
                            continue;
                        }
                        if (top.getFirst().getType() == TokenType.LEFTBRACKET) break;
                        if (top.isSingleTokenNode()) {
                            subTokens.add(0, top.getFirst());
                            continue;
                        }
                        subTokens.add(0, new PlaceHoldToken(top));
                    }
                    node = new TokenNode(this.parseTokens(subTokens));
                    if (ifNode != null) {
                        ((IFTokenNode)ifNode).setLogicNode(node);
                        break;
                    }
                    if (methodNode != null) {
                        for (IToken t : subTokens) {
                            methodNode.addOperand(t);
                        }
                        continue block16;
                    }
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        break;
                    }
                    if (operatorNode != null && !operatorNode.isFull()) {
                        operatorNode.setChild(node);
                        break;
                    }
                    if (connectNode != null) {
                        connectNode.setRight(node);
                        break;
                    }
                    if (operandNode != null) continue block16;
                    operandNode = node;
                    break;
                }
                case ATTRIBUTEFETCHER: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block16;
                    }
                    operandNode = node;
                    break;
                }
                case OPERATOR: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block16;
                    }
                    if (operatorNode == null) {
                        operatorNode = node;
                    }
                    if (!operatorNode.isFull()) {
                        operatorNode.setChild(operandNode);
                        operandNode = null;
                        break;
                    }
                    if (((OperatorToken)node.getFirst()).getOperatorType().ordinal() <= ((OperatorToken)operatorNode.getFirst()).getOperatorType().ordinal()) continue block16;
                    node.setLeft(operatorNode.getRight());
                    operatorNode.setRight(node);
                    operatorNode = node;
                    break;
                }
                case LEFTMIDDLEBRACKET: {
                    if (!middleBracketStack.isEmpty()) continue block16;
                    middleBracketStack.push(node);
                    break;
                }
                case RIGHTMIDDLEBRACKET: {
                    TokenNode top;
                    ArrayList<IToken> subTokens = new ArrayList<IToken>();
                    while (true) {
                        if ((top = (TokenNode)middleBracketStack.pop()).isBracketNode()) {
                            subTokens.add(0, new PlaceHoldToken(top));
                            continue;
                        }
                        if (top.getFirst().getType() == TokenType.LEFTMIDDLEBRACKET) break;
                        if (top.isSingleTokenNode()) {
                            subTokens.add(0, top.getFirst());
                            continue;
                        }
                        subTokens.add(0, new PlaceHoldToken(top));
                    }
                    operandNode = this.parseTokens(subTokens);
                    operandNode.setMiddleBracketNode(true);
                    if (middleBracketStack.isEmpty()) continue block16;
                    middleBracketStack.push(operandNode);
                    break;
                }
                case CONNECT: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block16;
                    }
                    if (connectNode == null) {
                        connectNode = node;
                    }
                    if (!connectNode.isFull() && operatorNode != null) {
                        connectNode.setChild(operatorNode.getRoot());
                    }
                    if (connectNode.isFull()) {
                        node.setLeft(connectNode);
                        connectNode = node;
                    }
                    operatorNode = null;
                    operandNode = null;
                    break;
                }
                case CONST: 
                case NUMBER: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block16;
                    }
                    if (operandNode == null) {
                        operandNode = node;
                    } else if (operandNode.getLast().getType() == TokenType.COMMA) {
                        operandNode.addOperand(node.getFirst());
                    } else {
                        operandNode = node;
                    }
                    if (operatorNode == null || operatorNode.isFull()) continue block16;
                    operatorNode.setChild(operandNode);
                    break;
                }
                case COMMA: {
                    if (!bracketStack.isEmpty()) {
                        if (token.getType() == TokenType.COMMA && operandNode != null) {
                            bracketStack.push(operandNode);
                            operandNode = null;
                        }
                        bracketStack.push(node);
                        continue block16;
                    }
                    if (operandNode == null) {
                        operandNode = node;
                        break;
                    }
                    operandNode.addOperand(node.getFirst());
                    break;
                }
                case PLACEHOLD: {
                    PlaceHoldToken tmp = (PlaceHoldToken)node.getFirst();
                    node = tmp.getNode();
                    if (operatorNode != null && !operatorNode.isFull()) {
                        operatorNode.setChild(node);
                        break;
                    }
                    if (connectNode != null && !connectNode.isFull()) {
                        connectNode.setChild(node);
                        break;
                    }
                    if (operandNode == null) {
                        operandNode = node;
                        break;
                    }
                    if (operandNode.getLast().getType() != TokenType.COMMA) continue block16;
                    operandNode.addOperand(tmp);
                    break;
                }
                case IF: {
                    if (ifNode == null) {
                        ifNode = new IFTokenNode(token);
                        break;
                    }
                    logicStack.push(ifNode);
                    TokenNode tokenNode = ifNode;
                    ifNode = new IFTokenNode(token);
                    tokenNode.setChild(ifNode);
                    break;
                }
                case ELSE: {
                    if (ifNode == null || !ifNode.isFull() || logicStack.isEmpty()) continue block16;
                    ifNode = (IFTokenNode)logicStack.pop();
                    break;
                }
                case METHOD: {
                    methodNode = new MethodTokenNode(token);
                    break;
                }
                case RETURN: {
                    returnNode = node;
                    if (returnSubTokens != null) {
                        returnSubTokens.clear();
                    }
                    if (ifNode == null) continue block16;
                    ifNode.setChild(returnNode);
                    break;
                }
                default: {
                    throw new ParseException("unknown token type");
                }
            }
        }
        if (logicStack.isEmpty() && ifNode != null) {
            return ifNode;
        }
        if (!logicStack.isEmpty()) {
            return (TokenNode)logicStack.peek();
        }
        if (methodNode != null) {
            return methodNode;
        }
        if (connectNode != null && operatorNode != null) {
            connectNode.setRight(operatorNode.getRoot());
        }
        return connectNode == null ? (operatorNode == null ? operandNode : operatorNode.getRoot()) : connectNode.getRoot();
    }

    public Object execute(ExprContext ctx) {
        this.root.action(ctx);
        return ctx.getStack().pop();
    }

    public String toString() {
        return this.root.toString();
    }

    public static void main(String[] args) throws ParseException {
        Expr.testMethod();
    }

    protected static void testExpr() throws ParseException {
        String formula = "if (@requireData.#MaterialAttr = '10030' AND @requireData.#PlanStrategy = '1234') return '001'; else if (@requireData.#MaterialAttr = '10040') return '002'; else return ['003', '002', '001'];";
        Expr expr = new Expr(formula);
        System.out.println(expr);
        ExprContext ctx = new ExprContext();
        HashMap<String, String> requireData = new HashMap<String, String>();
        requireData.put("MATERIALATTR", "10030");
        requireData.put("PLANSTRATEGY", "1234");
        ctx.addPreDefinedParam("requireData", requireData);
        System.out.println("require data: " + JSON.toJSONString(requireData) + ", result: " + JSON.toJSONString((Object)expr.execute(ctx)));
        requireData.put("MATERIALATTR", "10040");
        requireData.put("PLANSTRATEGY", "1234");
        ctx.addPreDefinedParam("requireData", requireData);
        System.out.println("require data: " + JSON.toJSONString(requireData) + ", result: " + JSON.toJSONString((Object)expr.execute(ctx)));
        requireData.put("MATERIALATTR", "10050");
        requireData.put("PLANSTRATEGY", "1234");
        ctx.addPreDefinedParam("requireData", requireData);
        System.out.println("require data: " + JSON.toJSONString(requireData) + ", result: " + JSON.toJSONString((Object)expr.execute(ctx)));
        String formula1 = "if (@requireData.#MaterialAttr = '10030' AND @requireData.#PlanStrategy = '1234') return '001'; else if (@requireData.#MaterialAttr = '10040') return '002'; else return [['003', '004'], '002', '001'];";
        Expr expr1 = new Expr(formula1);
        System.out.println(expr1);
        expr = new Expr("(@supplyData.#ISSTORAGEDATA = 1 or @requireData.#MATERIALATTR = 10040) <> 1");
        ctx = new ExprContext();
        HashMap<String, String> supplyData = new HashMap<String, String>();
        supplyData.put("ISSTORAGEDATA", "1");
        ctx.addPreDefinedParam("supplyData", supplyData);
        requireData = new HashMap();
        requireData.put("MATERIALATTR", "10030");
        ctx.addPreDefinedParam("requireData", requireData);
        System.out.println(expr.execute(ctx));
    }

    protected static void testMethod() throws ParseException {
        ExprContext ctx = new ExprContext();
        HashMap<String, String> supplyData = new HashMap<String, String>();
        supplyData.put("ISSTORAGEDATA", "1");
        ctx.addPreDefinedParam("supplyData", supplyData);
        HashMap<String, String> requireData = new HashMap<String, String>();
        requireData.put("MATERIALATTR", "10030");
        ctx.addPreDefinedParam("requireData", requireData);
        ctx.addPreDefinedParam("__MRP_CYCLE_CNT__", "1");
        Expr expr = new Expr("ElasticMetricCmp(@supplyData.#ISSTORAGEDATA, @requireData.#MATERIALATTR, ['ProductTypeLevel', 'ThicknessLevel', 'PackageLevel', 'QualityLevel'], '-')");
        System.out.println(expr.execute(ctx));
    }
}

