/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.fomula.token;

import java.util.List;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.framework.fomula.IToken;
import kd.mmc.mrp.framework.fomula.enums.ConnectType;
import kd.mmc.mrp.framework.fomula.enums.TokenType;
import kd.mmc.mrp.utils.MRPUtil;

public class ConnectToken
implements IToken {
    private ConnectType type;

    public ConnectToken(ConnectType type) {
        this.type = type;
    }

    @Override
    public void action(ExprContext ctx) {
        Object left = ctx.getStack().pop();
        Object right = ctx.getStack().pop();
        if (left instanceof Boolean) {
            switch (this.type) {
                case AND: {
                    ctx.getStack().push((Boolean)left != false && (Boolean)right != false);
                    break;
                }
                case OR: {
                    ctx.getStack().push((Boolean)left != false || (Boolean)right != false);
                    break;
                }
            }
        } else {
            switch (this.type) {
                case AND: {
                    ctx.getStack().push(MRPUtil.and((List)left, (List)right));
                    break;
                }
                case OR: {
                    ctx.getStack().push(MRPUtil.or((List)left, (List)right));
                    break;
                }
            }
        }
    }

    public ConnectType getConnectType() {
        return this.type;
    }

    @Override
    public TokenType getType() {
        TokenType en = TokenType.CONNECT;
        return en;
    }

    public String toString() {
        switch (this.type) {
            case AND: {
                return " AND ";
            }
            case OR: {
                return " OR ";
            }
        }
        return "";
    }
}

