/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.fomula.token;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.framework.fomula.IToken;
import kd.mmc.mrp.framework.fomula.enums.TokenType;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.wrapper.FieldMapping;

public class MethodToken
implements IToken {
    private String methodName;
    private static Map<String, List<String>> EMPTY_MAP = new HashMap<String, List<String>>(3);

    public MethodToken(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public void action(ExprContext ctx) {
        MethodToken.elasticMetricCmp(ctx);
    }

    @Override
    public TokenType getType() {
        return TokenType.METHOD;
    }

    public String toString() {
        return this.methodName;
    }

    public static void sortSupplys(final IMRPEnvProvider env, final FieldMapping flexMetricRelation, RowData requireData, List<Integer> supplys, final Object[] levelTypes, final String flexSeparator) {
        String reqVal = String.valueOf(requireData.get(flexMetricRelation.getFrom()));
        final String[] reqVals = reqVal.split(flexSeparator);
        if (reqVals.length != levelTypes.length) {
            return;
        }
        supplys.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                String supVal1 = String.valueOf(env.supplyDatas().getValue(flexMetricRelation.getTo(), o1));
                String[] supVals1 = supVal1.split(flexSeparator);
                String supVal2 = String.valueOf(env.supplyDatas().getValue(flexMetricRelation.getTo(), o2));
                String[] supVals2 = supVal2.split(flexSeparator);
                if (levelTypes.length > 0) {
                    for (int idx = 0; idx < levelTypes.length; ++idx) {
                        ArrayList sorter;
                        String part2;
                        String reqPart = reqVals.length > idx ? reqVals[idx] : null;
                        String part1 = supVals1.length > idx ? supVals1[idx] : null;
                        String string = part2 = supVals2.length > idx ? supVals2[idx] : null;
                        if (part1 != null && part1.equals(part2)) continue;
                        Map<String, List<String>> relations = MethodToken.getRelations(env, String.valueOf(levelTypes[idx]));
                        List list = sorter = relations == null ? new ArrayList(0) : (List)relations.getOrDefault(reqPart, new ArrayList(0));
                        if (sorter.indexOf(part2) == sorter.indexOf(part1)) continue;
                        return sorter.indexOf(part2) - sorter.indexOf(part1);
                    }
                }
                return 0;
            }
        });
    }

    private static void elasticMetricCmp(ExprContext ctx) {
        Object[] params = (Object[])ctx.pop();
        String reqVal = String.valueOf(params[0]);
        String supVal = String.valueOf(params[1]);
        Object[] levelTypes = params[2] instanceof String ? new Object[]{params[2]} : (Object[])params[2];
        String separator = String.valueOf(params[3]);
        ctx.push(new Object[]{MethodToken.flexMetricMatch(ctx, levelTypes, reqVal, supVal, separator, MethodToken::isMatch), separator, levelTypes});
    }

    private static boolean flexMetricMatch(ExprContext ctx, Object[] levelTypes, String reqVal, String supVal, String separator, IMatcher matcher) {
        String[] supVals;
        IMRPEnvProvider env = (IMRPEnvProvider)ctx.getPreDefinedParam("__MRP_CTX_ID__");
        boolean flag = false;
        String[] reqVals = reqVal.split(separator);
        if (reqVals.length != (supVals = supVal.split(separator)).length) {
            return false;
        }
        if (reqVals.length != levelTypes.length) {
            return false;
        }
        int idx = 0;
        for (Object levelType : levelTypes) {
            String reqPart = reqVals[idx];
            String supPart = supVals[idx];
            flag = matcher.isMatch(env, String.valueOf(levelType), reqPart, supPart);
            ++idx;
            if (!flag) break;
        }
        return flag;
    }

    private static boolean isFirstMatch(IMRPEnvProvider ctx, String levelType, String reqVal, String supVal) {
        if (reqVal.equals(supVal)) {
            return true;
        }
        List<String> allows = MethodToken.getRelations(ctx, levelType).get(reqVal);
        return allows == null || allows.isEmpty() ? false : allows.get(0).equals(supVal);
    }

    private static boolean isMatch(IMRPEnvProvider ctx, String levelType, String reqVal, String supVal) {
        if (reqVal.equals(supVal)) {
            return true;
        }
        List<String> allows = MethodToken.getRelations(ctx, levelType).get(reqVal);
        return allows == null ? false : allows.contains(supVal);
    }

    public static Map<String, List<String>> getRelations(IMRPEnvProvider env, String levelType) {
        String typeKey = "__Flex_Metric_Define__" + levelType;
        if (env == null) {
            return new HashMap<String, List<String>>();
        }
        Map<String, List<String>> relations = (Map<String, List<String>>)env.getLocalParams(typeKey);
        if (relations != null) {
            return relations;
        }
        String json = env.getCustomParams(typeKey);
        if (json == null) {
            MRPRedisStore store = MRPCacheManager.getDStore(env.getMRPContextId());
            relations = store.mapGetAll(typeKey);
            if (relations == null || relations.isEmpty()) {
                relations = MethodToken.loadFromDB(levelType);
                store.mapMSet(typeKey, relations);
                env.putCustomParams(typeKey, JSON.toJSONString(relations));
            }
        } else if (!StringUtils.isEmpty((CharSequence)json)) {
            Map vals = (Map)JSON.parseObject((String)json, Map.class);
            relations = new HashMap(vals.size());
            for (Map.Entry entry : vals.entrySet()) {
                ArrayList<String> list = new ArrayList<String>(10);
                relations.put(String.valueOf(entry.getKey()), list);
                Collection c = (Collection)entry.getValue();
                for (Object item : c) {
                    list.add(String.valueOf(item));
                }
            }
        } else {
            relations = EMPTY_MAP;
        }
        env.putLocalParam(typeKey, relations);
        return relations;
    }

    public static Set<String> loadSourceEntityTypes(Set<String> materialFlexNos, String ... levelTypes) {
        DynamicObject[] metrics;
        HashSet<String> ret = new HashSet<String>(levelTypes.length);
        if (levelTypes == null || levelTypes.length == 0) {
            return ret;
        }
        HashSet<Long> idSet = new HashSet<Long>(16);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MethodToken.class.getName(), (String)"msplan_flexmetricdefine", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)levelTypes)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                idSet.add(row.getLong("id"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        for (DynamicObject metric : metrics = BusinessDataServiceHelper.load((Object[])idSet.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msplan_flexmetricdefine"))) {
            DynamicObject sourceEntity = null;
            DynamicObject destEntity = null;
            String sourceEntityNum = "";
            String destEntityNum = "";
            if (metric.get("sourceentity") != null) {
                sourceEntity = (DynamicObject)metric.get("sourceentity");
                sourceEntityNum = sourceEntity.getString("number");
                ret.add(sourceEntityNum);
            }
            if (metric.get("targetentity") != null) {
                destEntity = (DynamicObject)metric.get("targetentity");
                destEntityNum = destEntity.getString("number");
            }
            if (!"bd_material".equals(sourceEntityNum) || !"bd_material".equals(destEntityNum)) continue;
            materialFlexNos.add(metric.getString("number"));
        }
        return ret;
    }

    private static Map<String, List<String>> loadFromDB(String levelType) {
        HashMap<String, List<String>> relations = new HashMap<String, List<String>>();
        Long flexId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MethodToken.class.getName(), (String)"msplan_flexmetricdefine", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)levelType)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                flexId = row.getLong("id");
            }
        }
        if (flexId == 0L) {
            return relations;
        }
        DynamicObject metric = BusinessDataServiceHelper.loadSingle((Object)flexId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msplan_flexmetricdefine"));
        if (metric == null) {
            return relations;
        }
        DynamicObjectCollection entrys = metric.getDynamicObjectCollection("entryentity");
        for (DynamicObject e : entrys) {
            ArrayList<String> subIds = new ArrayList<String>();
            relations.put(String.valueOf(e.getLong("source_bd_id")), subIds);
            DynamicObjectCollection replaces = e.getDynamicObjectCollection("subentryentity");
            replaces.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    if (o1 == null) {
                        return o2 == null ? 0 : -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.getInt("priority") - o2.getInt("priority");
                }
            });
            for (DynamicObject s : replaces) {
                Long refId = s.getLong("target_bd_id");
                subIds.add(String.valueOf(refId));
            }
        }
        return relations;
    }

    private static interface IMatcher {
        public boolean isMatch(IMRPEnvProvider var1, String var2, String var3, String var4);
    }
}

