/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.fomula.token;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.framework.fomula.IToken;
import kd.mmc.mrp.framework.fomula.enums.OperatorType;
import kd.mmc.mrp.framework.fomula.enums.TokenType;
import kd.mmc.mrp.utils.MRPUtil;

public class OperatorToken
implements IToken {
    private OperatorType type;
    private final Log log = LogFactory.getLog(OperatorToken.class);

    public OperatorToken(OperatorType type) {
        this.type = type;
    }

    @Override
    public void action(ExprContext ctx) {
        Object rightOperand = ctx.getStack().pop();
        Object leftOperand = null;
        if (this.type != OperatorType.ISNULL && this.type != OperatorType.ISNOTNULL) {
            leftOperand = ctx.getStack().pop();
        }
        Object compareValue = false;
        if (rightOperand == null) {
            if (this.type == OperatorType.ISNULL) {
                compareValue = true;
            }
        } else if (this.type == OperatorType.ISNOTNULL) {
            compareValue = true;
        }
        switch (this.type) {
            case EQUALS: {
                compareValue = this.isEquals(rightOperand, leftOperand);
                break;
            }
            case NOTEQUALS: {
                compareValue = !this.isEquals(rightOperand, leftOperand);
                break;
            }
            case LESS: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = false;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = false;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = true;
                    break;
                }
                compareValue = leftOperand.toString().compareTo(rightOperand.toString()) < 0;
                break;
            }
            case EQUALSLESS: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = true;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = false;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = true;
                    break;
                }
                compareValue = leftOperand.toString().compareTo(rightOperand.toString()) <= 0;
                break;
            }
            case OVER: {
                BigDecimal right;
                BigDecimal left;
                if (rightOperand == null && leftOperand == null) {
                    compareValue = false;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = true;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = false;
                    break;
                }
                try {
                    left = new BigDecimal(leftOperand.toString());
                    right = new BigDecimal(rightOperand.toString());
                }
                catch (NumberFormatException e) {
                    this.log.error("mmc-mrprunner:failed to parse digit", (Throwable)e);
                    compareValue = leftOperand.toString().compareTo(rightOperand.toString()) > 0;
                    break;
                }
                compareValue = left.compareTo(right) > 0;
                break;
            }
            case EQUALSOVER: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = true;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = true;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = false;
                    break;
                }
                compareValue = leftOperand.toString().compareTo(rightOperand.toString()) >= 0;
                break;
            }
            case IN: {
                compareValue = this.in(rightOperand, leftOperand);
                break;
            }
            case NOTIN: {
                compareValue = !this.in(rightOperand, leftOperand);
                break;
            }
            case LIKE: {
                compareValue = this.like(rightOperand, leftOperand);
                break;
            }
            case NOTLIKE: {
                compareValue = !this.like(rightOperand, leftOperand);
                break;
            }
            case PLUS: {
                if (leftOperand != null && leftOperand.getClass().isArray()) {
                    leftOperand = Array.get(leftOperand, 0);
                }
                if (rightOperand != null && rightOperand.getClass().isArray()) {
                    rightOperand = Array.get(rightOperand, 0);
                }
                if (leftOperand instanceof BigDecimal || rightOperand instanceof BigDecimal) {
                    if (!(leftOperand instanceof BigDecimal)) {
                        try {
                            compareValue = new BigDecimal(leftOperand == null ? "0" : leftOperand.toString()).add((BigDecimal)rightOperand);
                        }
                        catch (NumberFormatException e) {
                            this.log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                            compareValue = String.valueOf(leftOperand) + String.valueOf(rightOperand);
                        }
                        break;
                    }
                    try {
                        compareValue = ((BigDecimal)leftOperand).add(new BigDecimal(rightOperand == null ? "0" : rightOperand.toString()));
                    }
                    catch (NumberFormatException e) {
                        compareValue = String.valueOf(leftOperand) + String.valueOf(rightOperand);
                    }
                    break;
                }
                compareValue = String.valueOf(leftOperand) + String.valueOf(rightOperand);
                break;
            }
            case MINUS: {
                compareValue = this.getBigDecimal(leftOperand).add(this.getBigDecimal(rightOperand).negate());
                break;
            }
            case MULTIPLE: {
                BigDecimal qty = this.getBigDecimal(leftOperand);
                compareValue = MRPUtil.multiply(this.getBigDecimal(rightOperand), qty);
                break;
            }
            case DIVIDE: {
                BigDecimal rightBigDecimal = this.getBigDecimal(rightOperand);
                compareValue = this.getBigDecimal(leftOperand).divide(rightBigDecimal, 10, RoundingMode.UP);
                break;
            }
            case REMAINDER: {
                int left = this.getBigDecimal(leftOperand).intValue();
                int right = this.getBigDecimal(rightOperand).intValue();
                compareValue = new BigDecimal(left % right);
                break;
            }
        }
        ctx.getStack().push(compareValue);
    }

    private boolean isEquals(Object rightOperand, Object leftOperand) {
        boolean compareValue;
        if (rightOperand == null && leftOperand == null) {
            compareValue = true;
        } else if (rightOperand == null || leftOperand == null) {
            compareValue = false;
        } else {
            if (rightOperand instanceof Boolean) {
                rightOperand = (Boolean)rightOperand != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            if (leftOperand instanceof Boolean) {
                leftOperand = (Boolean)leftOperand != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            compareValue = rightOperand.toString().equals(leftOperand.toString());
        }
        return compareValue;
    }

    private boolean in(Object rightOperand, Object leftOperand) {
        boolean compareValue = false;
        int len = Array.getLength(rightOperand);
        for (int i = 0; i < len; ++i) {
            Object operand = Array.get(rightOperand, i);
            if (leftOperand == null || !leftOperand.equals(operand)) continue;
            compareValue = true;
            break;
        }
        return compareValue;
    }

    private boolean like(Object rightOperand, Object leftOperand) {
        String content = (String)leftOperand;
        String value = (String)rightOperand;
        boolean compareValue = value == null && content == null ? true : (value == null || content == null ? false : (value.startsWith("%") && value.endsWith("%") ? content.contains(value) : (value.startsWith("%") ? content.endsWith(value) : (value.endsWith("%") ? content.startsWith(value) : content.equals(value)))));
        return compareValue;
    }

    private BigDecimal getBigDecimal(Object operand) {
        if (operand == null) {
            return new BigDecimal("0");
        }
        if (operand.getClass().isArray()) {
            Object first = Array.get(operand, 0);
            return new BigDecimal(first.toString());
        }
        return new BigDecimal(operand.toString());
    }

    public OperatorType getOperatorType() {
        return this.type;
    }

    @Override
    public TokenType getType() {
        TokenType en = TokenType.OPERATOR;
        return en;
    }

    public String toString() {
        switch (this.type) {
            case BETWEEN: {
                return " BETWEEN ";
            }
            case NOTBETWEEN: {
                return " NOT BETWEEN ";
            }
            case EQUALS: {
                return " = ";
            }
            case EQUALSLESS: {
                return " <= ";
            }
            case EQUALSOVER: {
                return " >= ";
            }
            case IN: {
                return " IN ";
            }
            case LESS: {
                return " < ";
            }
            case LIKE: {
                return " LIKE ";
            }
            case NOTEQUALS: {
                return " <> ";
            }
            case NOTIN: {
                return " NOT IN ";
            }
            case NOTLIKE: {
                return " NOT LIKE ";
            }
            case OVER: {
                return " > ";
            }
            case PLUS: {
                return " + ";
            }
            case MINUS: {
                return " - ";
            }
            case MULTIPLE: {
                return " * ";
            }
            case DIVIDE: {
                return " / ";
            }
            case REMAINDER: {
                return " % ";
            }
            case ISNULL: {
                return " IS NULL";
            }
            case ISNOTNULL: {
                return " IS NOT NULL";
            }
        }
        return " __UNRESOLVED_OPERATOR_TYPE__";
    }
}

