/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.fomula.token;

import java.util.Map;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.framework.fomula.IToken;
import kd.mmc.mrp.framework.fomula.enums.TokenType;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;

public class ParamToken
implements IToken {
    private String paramName;
    private boolean isReverse;

    public ParamToken(String paramName, boolean isReverse) {
        this.paramName = paramName;
        this.isReverse = isReverse;
    }

    @Override
    public void action(ExprContext ctx) {
        String attrName = this.paramName.substring(1).toUpperCase();
        Object row = ctx.pop();
        if (row instanceof RowData) {
            Object val = ((RowData)row).getValue(attrName);
            if (val == null) {
                val = ((RowData)row).getValue("ENTRYENTITY." + attrName);
            }
            ctx.push(val);
        } else if (row instanceof AbstractResModelDataTable) {
            ctx.push(((AbstractResModelDataTable)row).getCol(attrName));
        } else if (row instanceof Map) {
            Object val = ((Map)row).get(attrName);
            if (val == null) {
                val = ((Map)row).get("ENTRYENTITY." + attrName);
            }
            ctx.push(val);
        }
    }

    @Override
    public TokenType getType() {
        return TokenType.FILTERPARAM;
    }

    public String toString() {
        return (this.isReverse ? "-" : "") + this.paramName;
    }
}

