/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.mq;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.dynamic.DynamicQueueManager;
import kd.bos.mq.support.dynamic.DynamicQueueManagerFactory;
import kd.bos.redis.JedisClient;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.exception.MRPManuStopException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.DefaultOnResponse;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.OnResponse;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.runner.MRPCalcManager;
import kd.mmc.mrp.integrate.KDCloudLogRecorder;
import kd.mmc.mrp.integrate.KDCloudSysConfigProvider;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;

public class MRPMQManager
implements IMRPEventManager {
    private static Log logger = LogFactory.getLog(MRPMQManager.class);
    protected CalEnv ctx;
    private final Set<Thread> waiters = new HashSet<Thread>(1);
    private volatile boolean failed = false;
    private String id;
    private volatile StackTraceElement[] errStack;
    private volatile String errMsg;
    private final Map<Long, Map<String, MRPEvent>> calEvents;
    private Map<Long, CountDownLatch> thread2Latch = new ConcurrentHashMap<Long, CountDownLatch>();
    private Map<Long, OnResponse> resps = new ConcurrentHashMap<Long, OnResponse>();
    private Map<String, KDCloudLogRecorder.Wrapper> wrappers = new ConcurrentHashMap<String, KDCloudLogRecorder.Wrapper>();
    private Map<String, Long> evt2Thread = new ConcurrentHashMap<String, Long>();
    private Long lastResponseTime = -1L;
    private String typeName;
    private MessagePublisher publisher;
    private Map<String, MessagePublisher> controlPublisher;
    public static MessageAcker REDIS_EMPTY_ACKER = new MessageAcker(){

        public void ack(String paramString) {
        }

        public void deny(String paramString) {
        }

        public void discard(String paramString) {
        }
    };
    private String redis_control_queue_name;
    private String redis_calc_queue_name;
    private AtomicBoolean isStarted = new AtomicBoolean();

    public MRPMQManager(CalEnv env, OnResponse resolver) {
        this.ctx = env;
        this.calEvents = new ConcurrentHashMap<Long, Map<String, MRPEvent>>();
        this.id = UUID.randomUUID().toString();
        env.addService(IMRPEventManager.class, this);
        KDCloudSysConfigProvider sysConfigManager = new KDCloudSysConfigProvider();
        sysConfigManager.load();
        this.typeName = (String)sysConfigManager.getCfgValue(EnvCfgItem.MRP_CTRL_QUEUE_TYPE);
        String isRegisterRedis = System.getProperty("mmc.mrp.redisConsumer.register");
        if (!"true".equals(isRegisterRedis)) {
            this.typeName = "BY_MQ";
        }
        if ("BY_MQ".equals(this.typeName)) {
            this.publisher = MQFactory.get().createSimplePublisher("mmc", "kd.mmc.mrp.calcnode.mrp_queue");
            this.controlPublisher = new ConcurrentHashMap<String, MessagePublisher>(2);
        } else if ("BY_REDIS".equals(this.typeName)) {
            RequestContext rCtx = RequestContext.getOrCreate();
            String accountId = rCtx.getAccountId();
            String tenantId = rCtx.getTenantId();
            String debugTag = System.getProperty("mq.debug.queue.tag");
            this.redis_control_queue_name = String.format("%s\u0001%s\u0001%s\u0001%s\u0001control_event_queue", accountId, tenantId, this.ctx.getMRPContextId(), debugTag);
            this.redis_calc_queue_name = String.format("%s\u0001%s\u0001%s\u0001calc_event_queue", accountId, tenantId, debugTag);
        }
    }

    private MessagePublisher getMessagePublisher() {
        return this.publisher;
    }

    private String getManuStop() {
        return ResManager.loadKDString((String)"\u624b\u5de5\u5173\u95ed\u4e86\u3002", (String)"MRPMQManager_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
    }

    private MessagePublisher getControlPublisher(MRPEvent event) {
        String queueName = this.getControllerQueueName(event);
        return this.controlPublisher.computeIfAbsent(queueName, k -> MQFactory.get().createSimplePublisher("mmc", queueName));
    }

    @Override
    public void registControlQueue(IMRPEnvProvider ctx, Class<? extends MessageConsumer> clazz) {
        if (Instance.isLightWeightDeploy()) {
            return;
        }
        if ("BY_MQ".equals(this.typeName)) {
            String mrpContextId = ctx.getMRPContextId();
            ArrayList<ConsumerDef> consumers = new ArrayList<ConsumerDef>();
            ConsumerDef consumer = new ConsumerDef();
            consumer.setClassName(clazz.getName());
            consumers.add(consumer);
            QueueDef queueDef = new QueueDef();
            queueDef.setAppid("mrp");
            String ctrlQueueName = "kd.mmc.mrp.calcnode.mrp_queue." + MRPRuntimeConsts.NODE_ID + "." + mrpContextId;
            queueDef.setName(ctrlQueueName);
            queueDef.setConsumers(consumers);
            DynamicQueueManager queueManager = DynamicQueueManagerFactory.get((String)"mmc");
            queueManager.add(queueDef, true);
        } else if ("BY_REDIS".equals(this.typeName)) {
            this.registControlQueueByRedis(ctx, clazz);
        }
    }

    @Override
    public void destroyMRPControllerMQ(String mrpContextId) {
        if (Instance.isLightWeightDeploy()) {
            return;
        }
        if ("BY_MQ".equals(this.typeName)) {
            Object v;
            String queueName = "kd.mmc.mrp.calcnode.mrp_queue." + MRPRuntimeConsts.NODE_ID + "." + mrpContextId;
            String key = "mmc" + QueueManager.getRealQueueName((String)"mmc", (String)queueName);
            Consumer consumer = null;
            if (QueueManager.getConsumers().containsKey(key) && (v = QueueManager.getConsumers().get(key)) instanceof Consumer) {
                consumer = (Consumer)v;
            }
            if (consumer != null) {
                consumer.$$stop();
            }
            this.destroyPublisher(mrpContextId);
            logger.warn("mrprunner-clear-mq-queue-data, mrpctx: " + mrpContextId);
            DynamicQueueManager queueManager = DynamicQueueManagerFactory.get((String)"mmc");
            boolean isOk = queueManager.deleteQueue(queueName);
            logger.warn(String.format("mrprunner-clear-mq-queue-data, mrpctx: %s, deleteQueue isOk: %s", mrpContextId, isOk));
        } else if ("BY_REDIS".equals(this.typeName)) {
            this.destroyMRPControllerMQByRedis(mrpContextId);
        }
    }

    @Override
    public void destroyPublisher(String mrpContextId) {
        if (this.publisher != null) {
            this.publisher.close();
            this.publisher = null;
        }
        if (this.controlPublisher != null) {
            for (MessagePublisher value : this.controlPublisher.values()) {
                value.close();
            }
            this.controlPublisher.clear();
        }
    }

    private String getControllerQueueName(MRPEvent event) {
        return "kd.mmc.mrp.calcnode.mrp_queue." + event.getNodeId() + "." + event.getMrpContextId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wait4Response() {
        CountDownLatch latch;
        Long tId = Thread.currentThread().getId();
        Map<String, MRPEvent> events = this.calEvents.get(tId);
        if (events == null) {
            return;
        }
        if (this.isFailed()) {
            this.throwError(new RuntimeException(this.errMsg));
        }
        Map<String, MRPEvent> map = events;
        synchronized (map) {
            if (events.size() > 0) {
                MRPEvent next = events.values().iterator().next();
                String nodeId = next.getNodeId();
                logger.info(String.format("PUB:MRPMQManager:nodeId:%s;wait:%d;eventName:%s;context:%s", nodeId, events.size(), next.getClass().getSimpleName(), next.getMrpContextId()));
            }
            latch = new CountDownLatch(events.size());
            this.thread2Latch.put(tId, latch);
        }
        try {
            Long cfgValue = (Long)this.ctx.getCfgValue(EnvCfgItem.MQ_TIMEOUT);
            this.waiters.add(Thread.currentThread());
            this.lastResponseTime = System.currentTimeMillis();
            boolean isWait = latch.await(cfgValue, TimeUnit.SECONDS);
            if (!isWait) {
                while (System.currentTimeMillis() - this.lastResponseTime < cfgValue * 1000L) {
                    isWait = latch.await(10L, TimeUnit.SECONDS);
                    if (latch.getCount() != 0L) continue;
                    isWait = true;
                    break;
                }
            }
            if (!isWait) {
                long remainEvtCnt = latch.getCount();
                logger.warn(String.format("MRPMQManager-wait-timeout-count:%s,context:%s", remainEvtCnt, this.ctx.getMRPContextId()));
                this.waiters.clear();
                throw new RuntimeException("MRPMQManager-wait-timeout");
            }
            this.waiters.clear();
        }
        catch (InterruptedException e) {
            this.throwError(e);
        }
        finally {
            this.destroyEvent(tId);
            this.resps.remove(tId);
        }
    }

    private void destroyEvent(Long tId) {
        this.calEvents.remove(tId);
        this.thread2Latch.remove(tId);
        this.failed = false;
        this.errMsg = null;
        this.errStack = null;
        if (this.calEvents.isEmpty()) {
            MRPCalcManager.destroyEventManager(this.id);
            this.evt2Thread.clear();
        }
    }

    @Override
    public void publishCalcEvent(MRPEvent event) {
        this.publishCalcEvent(event, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishCalcEvent(MRPEvent event, boolean isDoRegist) {
        Object object;
        event.setEventManagerId(this.id);
        event.setPublishTime(System.currentTimeMillis());
        MessagePublisher publisher = this.getMessagePublisher();
        boolean isDistribute = (Boolean)this.ctx.getCfgValue(EnvCfgItem.USE_DISTRIBUTION_MODE);
        if (isDoRegist) {
            Long tId = Thread.currentThread().getId();
            object = this.calEvents;
            synchronized (object) {
                Map events = this.calEvents.computeIfAbsent(tId, k -> new ConcurrentHashMap());
                events.put(event.getEventId(), event);
                this.evt2Thread.put(event.getEventId(), tId);
                this.wrappers.put(event.getEventId(), IMRPExecuteLogRecorder.LOCAL.get());
            }
            MRPCalcManager.registEventManager(this.ctx.getMRPContextId(), this);
        }
        if (isDistribute) {
            TraceSpan ts;
            if ("BY_MQ".equals(this.typeName)) {
                if (publisher != null) {
                    ts = Tracer.create((String)"MRPMQManager.publishCalcEventByMQ", (String)"publishCalcEventByMQ");
                    object = null;
                    try {
                        publisher.publish((Object)event);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ts != null) {
                            if (object != null) {
                                try {
                                    ts.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ts.close();
                            }
                        }
                    }
                }
            } else if ("BY_REDIS".equals(this.typeName)) {
                ts = Tracer.create((String)"MRPMQManager.publishCalcEventByRedis", (String)"publishCalcEventByRedis");
                object = null;
                try {
                    this.publishCalcEventByRedis(event);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ts != null) {
                        if (object != null) {
                            try {
                                ts.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ts.close();
                        }
                    }
                }
            }
        } else {
            try {
                this.waiters.add(Thread.currentThread());
                Class<?> wcls = Class.forName("kd.mmc.mrp.calcnode.framework.thread.MRPCalcWorker");
                wcls.getMethod("resolveAlone", MRPEvent.class).invoke(null, event);
                this.waiters.clear();
            }
            catch (Exception e) {
                this.throwError(e);
            }
        }
    }

    private void throwError(Exception e) {
        ThreadCache.put((Object)"exception", (Object)e);
        if (this.errMsg != null || this.isFailed()) {
            if (StringUtils.equals((CharSequence)this.errMsg, (CharSequence)this.getManuStop())) {
                throw new MRPManuStopException();
            }
            KDBizException error = new KDBizException(this.errMsg);
            if (this.errStack != null) {
                error.setStackTrace(this.errStack);
            }
            throw error;
        }
    }

    @Override
    public void publishControlEvent(MRPEvent event) {
        if ("BY_MQ".equals(this.typeName)) {
            String queueName = this.getControllerQueueName(event);
            String queueRealName = QueueManager.getRealQueueName((String)"mmc", (String)queueName);
            QueueDef def = QueueManager.getQueueDefWithRealQueueName((String)"mmc", (String)queueRealName);
            if (def == null) {
                QueueDef queueDef = new QueueDef();
                queueDef.setAppid("mrp");
                queueDef.setName(queueName);
                QueueManager.add((String)"mmc", (QueueDef)queueDef, (boolean)false);
            }
            MessagePublisher publisher = this.getControlPublisher(event);
            publisher.publish((Object)event);
        } else if ("BY_REDIS".equals(this.typeName)) {
            this.publishControlEventByRedis(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(MRPEvent event) {
        Map<String, MRPEvent> events;
        this.lastResponseTime = System.currentTimeMillis();
        Long tId = this.evt2Thread.get(event.getEventId());
        Map<Object, Object> map = this.calEvents;
        synchronized (map) {
            events = this.calEvents.get(tId);
        }
        map = events;
        synchronized (map) {
            MRPEvent mrpEvent = events.remove(event.getEventId());
            if (mrpEvent != null) {
                String nodeId = mrpEvent.getNodeId();
                String eventId = mrpEvent.getEventId();
                logger.info(String.format("REC:MRPMQManager:nodeId:%s;eventId:%s;failed:%s;eventSize:%d;eventName:%s;context:%s", nodeId, eventId, String.valueOf(this.failed), events.size(), mrpEvent.getClass().getSimpleName(), mrpEvent.getMrpContextId()));
                if (!this.failed) {
                    this.failed = "FALSE".equalsIgnoreCase(String.valueOf(event.getParam(MultiThreadCacheKey.KEY_SERVICE_OK)));
                    if (this.failed) {
                        this.errMsg = (String)((Object)event.getParam(MultiThreadCacheKey.KEY_SERVICE_EXCEPTION_DETAIL));
                        String exception = (String)((Object)event.getParam(MultiThreadCacheKey.KEY_SERVICE_EXCEPTION));
                        if (exception != null) {
                            this.errStack = JSON.parseArray((String)exception, StackTraceElement.class).toArray(new StackTraceElement[0]);
                        }
                        this.interrupt();
                    }
                    event.setFailed(this.failed);
                    event.setRemainEvtCnt(events.size());
                    event.setResponseResolver(mrpEvent.getResponseResolver());
                    event.setSubStepIdx(mrpEvent.getSubStepIdx());
                    OnResponse resp = this.getOnResponse(tId);
                    resp.setLogWrapper(this.wrappers.remove(event.getEventId()));
                    resp.response(event);
                    CountDownLatch latch = this.thread2Latch.get(tId);
                    if (latch != null && !this.failed) {
                        latch.countDown();
                    }
                }
            }
        }
    }

    private void interrupt() {
        for (Thread waiter : this.waiters) {
            waiter.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRemainEvtCount(String eventId) {
        Map<String, MRPEvent> events;
        Long tId = this.evt2Thread.get(eventId);
        Map<Object, Object> map = this.calEvents;
        synchronized (map) {
            events = this.calEvents.get(tId);
        }
        map = events;
        synchronized (map) {
            return events.size();
        }
    }

    @Override
    public void markFailed(StackTraceElement[] details, Object detailMsg) {
        logger.warn("mrprunner-failed-mark", new Throwable("mrprunner-failed-mark"));
        this.failed = true;
        if (details != null && details.length > 0) {
            this.errStack = details;
        }
        if (detailMsg != null) {
            this.errMsg = detailMsg.toString();
        }
        this.interrupt();
    }

    @Override
    public void markManuTerminated() {
        this.errMsg = this.getManuStop();
        this.ctx.setShutdown();
        this.interrupt();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setOnResponse(OnResponse response) {
        Long tId = Thread.currentThread().getId();
        this.resps.put(tId, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OnResponse getOnResponse() {
        Long tId = Thread.currentThread().getId();
        MRPMQManager mRPMQManager = this;
        synchronized (mRPMQManager) {
            return this.getOnResponse(tId);
        }
    }

    private OnResponse getOnResponse(Long tId) {
        OnResponse resolver = this.resps.get(tId);
        if (resolver == null) {
            resolver = new DefaultOnResponse((IMRPEnvProvider)this.ctx, this.ctx.createLogRecorder());
            this.resps.put(tId, resolver);
        }
        return resolver;
    }

    @Override
    public StackTraceElement[] getErrStack() {
        return this.errStack;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    private void publishCalcEventByRedis(MRPEvent event) {
        event.setCtx(RequestContext.getOrCreate());
        try (JedisClient client = MRPCacheManager.getDStore(this.ctx.getMRPContextId()).getJedis();){
            client.lpush(this.redis_calc_queue_name, new String[]{new String(MRPRedisStore.encode(event), "iso8859-1")});
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void publishControlEventByRedis(MRPEvent event) {
        event.setCtx(null);
        try (JedisClient client = MRPCacheManager.getDStore(this.ctx.getMRPContextId()).getJedis();){
            client.lpush(this.redis_control_queue_name, new String[]{new String(MRPRedisStore.encode(event), "iso8859-1")});
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void registControlQueueByRedis(final IMRPEnvProvider ctx, Class<? extends MessageConsumer> clazz) {
        if (this.isStarted.compareAndSet(false, true)) {
            MessageConsumer consumer;
            try {
                consumer = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error((Throwable)e);
                throw new RuntimeException(e);
            }
            ThreadPools.executeOnceIncludeRequestContext((String)"mrp-redis-control-event-manager", (Runnable)new Runnable(){

                @Override
                public void run() {
                    try (JedisClient client = MRPCacheManager.getDStore(ctx.getMRPContextId()).getJedis();){
                        while (MRPMQManager.this.isStarted.get()) {
                            MRPEvent event;
                            ctx.testEnvStatus();
                            List cmds = client.brpop(10, MRPMQManager.this.redis_control_queue_name);
                            if (cmds == null) continue;
                            try {
                                event = (MRPEvent)MRPRedisStore.decode(((String)cmds.get(1)).getBytes("iso8859-1"));
                            }
                            catch (UnsupportedEncodingException e) {
                                logger.error((Throwable)e);
                                continue;
                            }
                            consumer.onMessage((Object)event, event.getEventId(), true, REDIS_EMPTY_ACKER);
                        }
                    }
                }
            });
        }
    }

    private void destroyMRPControllerMQByRedis(String mrpContextId) {
        this.isStarted.set(false);
        try (JedisClient client = MRPCacheManager.getDStore(this.ctx.getMRPContextId()).getJedis();){
            client.del(this.redis_control_queue_name);
        }
    }
}

