/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.runner;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.runner.IMRPRunner;
import kd.mmc.mrp.framework.runner.MRPCalcManager;
import kd.mmc.mrp.framework.step.IMRPStep;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.utils.MRPCalcStateManager;
import kd.mmc.mrp.utils.MRPUtil;

public abstract class AbstractMRPRunner
implements IMRPRunner {
    private static final Log logger = LogFactory.getLog(AbstractMRPRunner.class);
    protected IMRPEnvProvider ctx;
    private static String ipAddress;
    public static final String RESPONSE_DATA_COUNT = "RESPONSE_DATA_COUNT";
    public static final String DETAIL_COUNT = "DETAIL_COUNT";
    public static final String DEPENDENT_COUNT = "DEPENDENT_COUNT";
    public static final String REQUIRE_COUNT = "REQUIRE_COUNT";
    public static final String SUPPLY_COUNT = "SUPPLY_COUNT";

    @Override
    public final void run(IMRPEnvProvider ctx) {
        logger.warn(String.format("runlog: %s, ctxid: %s, mrprunner-main-inst, ip: %s", ctx.getRunLogNumber(), ctx.getMRPContextId(), AbstractMRPRunner.getIP()));
        this.ctx = ctx;
        this.requireMutex();
        try {
            if (MRPUtil.isByMQ()) {
                this.initMRPControllerMQ();
            }
            MRPCalcManager.registRunner(ctx.getMRPContextId(), this);
            List<IMRPStep> steps = this.prepareCalcSteps();
            this.calc(steps);
        }
        catch (Throwable e) {
            this.releaseMutex();
            throw e;
        }
    }

    public static String getIP() {
        if (ipAddress != null) {
            return ipAddress;
        }
        ipAddress = NetAddressUtils.getLocalIpAddress();
        return ipAddress;
    }

    protected abstract List<IMRPStep> prepareCalcSteps();

    public abstract void initMRPControllerMQ();

    protected abstract void calc(List<IMRPStep> var1);

    protected void requireMutex() {
        String planId = this.ctx.getPlanId();
        if (!MutexFactory.createDataMutex().require(planId, "mmc.mrp", this.getPlanEntity(), "edit", true)) {
            this.ctx.createLogRecorder().deleteRunLog();
            throw new MRPBizException(Errors.getFailedRequestMutex(), this.ctx.getRunLogNumber());
        }
        MRPCalcManager.setContext(this.ctx);
    }

    public static void clearMutexByPlanId(String planId) {
        AbstractMRPRunner.clearMutexByPlanId(planId, "mrp_planprogram");
    }

    public static void clearMutexByPlanId(String planId, String entityName) {
        if (StringUtils.isEmpty((String)planId)) {
            return;
        }
        MutexFactory.createDataMutex().release(planId, entityName, "edit");
        DynamicObjectCollection logs = ORM.create().query("mrp_caculate_log", "id, mrpid", new QFilter[]{new QFilter("plangram", "=", (Object)Long.valueOf(planId)), new QFilter("calculatestatus", "=", (Object)MRPExecuteStatus.RUNNING.getValue())});
        for (DynamicObject log : logs) {
            String ctxId = log.getString("mrpid");
            MRPCalcStateManager.setManuTerminated(ctxId);
        }
    }

    public void releaseMutex() {
        MRPCalcManager.removeContext(this.ctx.getMRPContextId());
        String planId = this.ctx.getPlanId();
        String planNumber = this.getPlanEntity();
        MutexFactory.createDataMutex().release(planId, planNumber, "edit");
    }

    private String getPlanEntity() {
        RunLogModel runLogModel = (RunLogModel)this.ctx.getService(RunLogModel.class);
        return runLogModel.getPlanEntity();
    }
}

