/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.service;

import java.util.Iterator;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.appstart.AppStarter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.threads.ThreadPools;
import kd.mmc.mrp.framework.mq.rabbit.RabbitMQEnvProvider;
import kd.mmc.mrp.framework.service.MRPCalcEventListener;
import kd.mmc.mrp.integrate.KDCloudSysConfigProvider;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mpscmm.common.cache.PlanOrderCacheMrg;

public class MRPNodeAppServiceStarter
implements Service,
AppStarter {
    private static final Log logger = LogFactory.getLog(MRPNodeAppServiceStarter.class);
    private boolean isStarted;

    public String getName() {
        return "MRPService";
    }

    public void start() {
        logger.info("--------------inited---------------");
        ThreadPools.executeOnceIncludeRequestContext((String)"MRP-INIT-SERVICE", (Runnable)new MRPEnvPrepareWorker());
        String isRegisterRedis = System.getProperty("mmc.mrp.redisConsumer.register");
        if ("true".equals(isRegisterRedis)) {
            ThreadPools.executeOnceIncludeRequestContext((String)"MRP-CALC-EVENT-SERVICE", (Runnable)new MRPCalcEventListener());
        }
        this.isStarted = true;
    }

    public void stop() {
        logger.info("--------------stop---------------");
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    private static class MRPEnvPrepareWorker
    implements Runnable {
        private MRPEnvPrepareWorker() {
        }

        @Override
        public void run() {
            this.dbAccessDemo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dbAccessDemo() {
            List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
            Iterator var2 = accounts.iterator();
            PlanOrderCacheMrg.clearCache((String)PlanOrderCacheMrg.getType4PlanOrderDropStatus());
            while (var2.hasNext()) {
                Account account = (Account)var2.next();
                String tenantId = account.getTenantId();
                String accountId = account.getAccountId();
                logger.info("\u540e\u53f0\u4e8b\u52a1\u5f00\u59cb\u626b\u63cf\u5e10\u5957:" + account.getAccountName() + " \u521d\u59cb\u5316\u8ba1\u7b97\u6a21\u578b");
                RequestContextUtils.createRequestContext((String)tenantId, (String)accountId, (String)null);
                TXHandle h = TX.requiresNew((String)this.getClass().getName());
                try {
                    KDCloudSysConfigProvider loader = new KDCloudSysConfigProvider();
                    loader.load();
                    new RabbitMQEnvProvider().clearUnRelatedQueues((Integer)loader.getCfgValue(EnvCfgItem.MQ_CLEAR_DAY_SPAN), false);
                }
                catch (Throwable e) {
                    logger.error(String.format("---regist mrp calc node failed, Account(tId: %s, aId: %s)---", tenantId, accountId), e);
                }
                finally {
                    if (h == null) continue;
                    h.close();
                }
            }
        }
    }
}

