/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.framework.step;

import java.util.List;
import java.util.Locale;
import kd.mmc.mrp.exception.MRPManuStopException;
import kd.mmc.mrp.exception.PLSWarnException;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.step.IMRPStep;
import kd.mmc.mrp.framework.step.IMRPSubStep;
import kd.mmc.mrp.model.enums.status.PLSExecuteStatus;
import kd.mmc.mrp.utils.MRPUtil;

public abstract class AbstractPLSStep
implements IMRPStep {
    protected IMRPEnvProvider ctx;
    protected IMRPExecuteLogRecorder lr;
    protected int dataAmount = 0;
    protected int stepIdx = 0;
    private int percent = 0;
    protected String stepDesc = null;

    protected AbstractPLSStep(IMRPEnvProvider ctx) {
        this.ctx = ctx;
    }

    @Override
    public IMRPEnvProvider getMRPContext() {
        return this.ctx;
    }

    @Override
    public final void createStepLog(int stepIdx, int percent) {
        this.stepIdx = stepIdx;
        this.percent = percent;
        this.lr = this.ctx.createLogRecorder();
        this.lr.createStepLog(stepIdx, this.getStepDesc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute() {
        long start = System.currentTimeMillis();
        try {
            this.lr.updateStepLog("entryresult", PLSExecuteStatus.RUNNING.getAlias());
            try {
                this.innerExecute();
            }
            catch (Throwable e) {
                PLSExecuteStatus status = PLSExecuteStatus.ERROR_STOP;
                if (e instanceof MRPManuStopException) {
                    status = PLSExecuteStatus.MANU_STOP;
                }
                if (e instanceof PLSWarnException) {
                    this.lr.updateStepLog("entryresult", PLSExecuteStatus.WARN.getAlias());
                    this.lr.updateStepLog("entrydetailmsg", e.getMessage());
                    this.lr.updateStepLog("entrydetailmsg_tag", e.getMessage());
                }
                this.lr.updateStepLog("entryresult", status.getAlias());
                this.lr.updateStepLog("entrydetailmsg_tag", MRPUtil.getStackTrace(e));
                throw e;
            }
            String status = this.lr.getLogEntryStatus();
            if (status == null || status.isEmpty() || status.equalsIgnoreCase(PLSExecuteStatus.RUNNING.getAlias())) {
                this.lr.updateStepLog("entryresult", PLSExecuteStatus.FINISHED.getAlias());
            }
        }
        finally {
            this.lr.updateStepLog("entryprocessdata", this.dataAmount);
            double end = (double)(System.currentTimeMillis() - start) / 1000.0 / 60.0;
            this.lr.updateStepLog("entryoperatmin", end);
            this.lr.updateRunLog("calculatepro", this.percent);
            this.lr.saveStepLog(true);
            this.doFinally();
        }
    }

    protected abstract void innerExecute();

    @Override
    public List<IMRPSubStep> getSubSteps() {
        return null;
    }

    @Override
    public void setStepDescByNodeName(String nodeName) {
        this.stepDesc = nodeName;
    }

    @Override
    public String getStepDesc() {
        String fixedStepDesc = this.getStepDesc(Locale.CHINESE);
        return this.stepDesc == null ? fixedStepDesc : this.stepDesc;
    }
}

