/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate;

import kd.bos.dataentity.entity.DynamicObject;
import kd.mmc.mrp.integrate.KDCloudMRPEnv;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;

public class KDCloudCPSEnv
extends KDCloudMRPEnv {
    protected ResDataModelCollection tbls;
    protected Boolean isReplace;

    public KDCloudCPSEnv(DynamicObject runLog) {
        super(runLog);
    }

    @Override
    public int initRuntimeEnv() {
        int ret = super.initRuntimeEnv();
        this.tbls = (ResDataModelCollection)this.getService(ResDataModelCollection.class);
        RequirementDataTable rTbl = this.tbls.getRequire().getTable();
        rTbl.addIndexCol(DefaultField.RequireField.SUPPLYBILLID.getName());
        rTbl.addIndexCol(DefaultField.RequireField.BILLID.getName());
        rTbl.addIndexCol(DefaultField.RequireField.BILLENTRYID.getName());
        rTbl.getColIdx().put(DefaultField.RequireField.__UNUSED_REC_QTY__.getName(), rTbl.getColIdx().size());
        SupplymentDataTable sTbl = this.tbls.getSupply().getTable();
        sTbl.addIndexCol(DefaultField.RequireField.BILLID.getName());
        sTbl.addIndexCol(DefaultField.RequireField.BILLENTRYID.getName());
        return ret;
    }

    @Override
    public boolean isReplace() {
        boolean isReplace = super.isReplace();
        if (this.isReplace == null) {
            return isReplace;
        }
        return this.isReplace;
    }

    public boolean isLet() {
        PlanModel model = (PlanModel)this.getService(PlanModel.class);
        Boolean isLet = model.getPlan().getBoolean("islet");
        return isLet == null ? false : isLet;
    }

    public boolean isLotNum() {
        PlanModel model = (PlanModel)this.getService(PlanModel.class);
        Boolean isLotNum = model.getPlan().getBoolean("islotnum");
        return isLotNum == null ? false : isLotNum;
    }

    public boolean isBatch() {
        PlanModel model = (PlanModel)this.getService(PlanModel.class);
        Boolean isBatch = model.getPlan().getBoolean("isbatch");
        return isBatch == null ? false : isBatch;
    }

    public boolean isAdvTime() {
        PlanModel model = (PlanModel)this.getService(PlanModel.class);
        Boolean isAdvTime = model.getPlan().getBoolean("isadvtime");
        return isAdvTime == null ? false : isAdvTime;
    }

    public String getCPSType() {
        PlanModel model = (PlanModel)this.getService(PlanModel.class);
        String cpsType = model.getPlan().getString("cpstype");
        return cpsType == null ? "B" : cpsType;
    }

    public boolean isKeyPart() {
        PlanModel model = (PlanModel)this.getService(PlanModel.class);
        Boolean isKetPart = model.getPlan().getBoolean("iskeypart");
        return isKetPart;
    }

    public void forceChangeReplace(Boolean flag) {
        this.isReplace = flag;
    }

    public void resetReplace() {
        this.isReplace = null;
    }

    public RequirementDataTable reInitRequireTbl() {
        this.tbls = (ResDataModelCollection)this.getService(ResDataModelCollection.class);
        this.tbls.getRequire().reInitRequireTbl();
        return this.tbls.getRequire().getTable();
    }

    public void restoreRequireTbl(RequirementDataTable requireTbl) {
        this.tbls = (ResDataModelCollection)this.getService(ResDataModelCollection.class);
        this.tbls.getRequire().restoreRequireTbl(requireTbl);
    }

    @Override
    public boolean isSpecialPlan() {
        return true;
    }
}

