/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.integrate.AbstractKDCloudDataSaver;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.enums.replace.ReplaceStrategy;
import kd.mmc.mrp.model.enums.select.PlanOrderGenType;
import kd.mmc.mrp.model.enums.status.PlanOrderStatus;
import kd.mmc.mrp.model.enums.strategy.BillSupplyStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.model.wrapper.SimplePlanOrder;
import kd.mmc.mrp.utils.MRPUtil;
import kd.sdk.mmc.mrp.extpoint.IMRPCalcNetDemandPlugin;
import kd.sdk.mmc.mrp.framework.res.IRowData;
import org.apache.commons.lang.math.NumberUtils;

public class KDCloudDataSaver
extends AbstractKDCloudDataSaver {
    private boolean isSwap = false;
    private IMRPEnvProvider ctx;

    public KDCloudDataSaver(IMRPEnvProvider ctx) {
        this.ctx = ctx;
    }

    @Deprecated
    public KDCloudDataSaver() {
    }

    @Override
    protected Map<String, Object> resolveMapping(IMRPEnvProvider provider, DataBalanceTable.RSMapping mapping, List<FieldMapping> outputMappings) {
        MaterialAttribute materialAttr = MaterialAttribute.valueOf(MRPUtil.convert(mapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), 10040));
        HashMap<String, Object> poHeader = null;
        RequireDataModel require = (RequireDataModel)provider.getService(RequireDataModel.class);
        String outputType = require.getOutputType();
        boolean bool = require.isPlanOrderExtendEntity();
        if (bool) {
            switch (materialAttr) {
                case FABRICATEDPART: 
                case PHANTOMPART: {
                    poHeader = this.toFabPO(provider, mapping);
                    poHeader.put("ordertype", MaterialAttribute.FABRICATEDPART.getValue());
                    if ("mrp_simulateorder".equals(outputType)) {
                        poHeader.put("billtype", 1452156224815511552L);
                        break;
                    }
                    poHeader.put("billtype", 1226619024197025792L);
                    break;
                }
                case PURCHASEDPART: {
                    poHeader = this.createPurPO(provider, mapping);
                    mapping.addPo(this.toSimplePO(poHeader));
                    if ("mrp_simulateorder".equals(outputType)) {
                        poHeader.put("billtype", 1452156224815511552L);
                        break;
                    }
                    poHeader.put("billtype", 1226619024197025792L);
                    break;
                }
                case EXTERNALPROCESSINPART: {
                    poHeader = this.toFabPO(provider, mapping);
                    poHeader.put("ordertype", MaterialAttribute.EXTERNALPROCESSINPART.getValue());
                    if ("mrp_simulateorder".equals(outputType)) {
                        poHeader.put("billtype", 1452156224815511552L);
                        break;
                    }
                    poHeader.put("billtype", 1226619024197025792L);
                    break;
                }
                case STORAGEPART: {
                    poHeader = this.toFabPO(provider, mapping);
                    poHeader.put("ordertype", MaterialAttribute.STORAGEPART.getValue());
                    if ("mrp_simulateorder".equals(outputType)) {
                        poHeader.put("billtype", 1452156224815511552L);
                        break;
                    }
                    poHeader.put("billtype", 1226619024197025792L);
                    break;
                }
            }
        } else {
            poHeader = this.createModelHeader(provider, outputType, mapping);
            mapping.addPo(this.toSimplePO(poHeader));
        }
        boolean isSwapOriginRequireBill = false;
        if (poHeader != null) {
            if (mapping.getRequire().getValue(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName()) != null) {
                this.swapOriginRequireBill(mapping);
                isSwapOriginRequireBill = true;
            }
            this.printOrderModels(poHeader, provider, outputType, mapping, outputMappings);
            this.createCopSupplyData(poHeader, provider, mapping, outputType);
        }
        if (this.isSwap) {
            this.swapValue(mapping.getRequire(), DefaultField.RequireField.__ORIGIN_REQUIRE_ORG__.getName(), DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            this.isSwap = false;
        }
        if (isSwapOriginRequireBill) {
            this.swapOriginRequireBill(mapping);
        }
        mapping.setChildren(null);
        return poHeader;
    }

    private void swapOriginRequireBill(DataBalanceTable.RSMapping mapping) {
        this.swapValue(mapping.getRequire(), DefaultField.RequireField.ORIGIN_BILLENTITY.getName(), DefaultField.RequireField.BILL_ENTITY.getName());
        this.swapValue(mapping.getRequire(), DefaultField.RequireField.ORIGIN_BILLID.getName(), DefaultField.RequireField.BILLID.getName());
        this.swapValue(mapping.getRequire(), DefaultField.RequireField.ORIGIN_BILLNUMBER.getName(), DefaultField.RequireField.BILLNUMBER.getName());
        this.swapValue(mapping.getRequire(), DefaultField.RequireField.ORIGIN_BILLENTRYID.getName(), DefaultField.RequireField.BILLENTRYID.getName());
        this.swapValue(mapping.getRequire(), DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName(), DefaultField.RequireField.BILLENTRYSEQ.getName());
    }

    public void createCopSupplyData(Map<String, Object> poHeader, IMRPEnvProvider provider, DataBalanceTable.RSMapping mapping, String outputType) {
        List<RequireRowData> cops = mapping.getCops();
        if (cops == null) {
            return;
        }
        SupplymentDataTable supplyTbl = provider.supplyDatas();
        BigDecimal qty = MRPUtil.convert(poHeader.get("orderqty"), BigDecimal.ZERO);
        Long enableDate = MRPUtil.convert(poHeader.get("availabledate"), 0L);
        Object org = poHeader.get("proorpurorg");
        Object billNo = poHeader.get("billno");
        Object id = poHeader.get("id");
        int size = supplyTbl.getColIdx().size();
        ArrayList copEntrys = Lists.newArrayListWithCapacity((int)cops.size());
        poHeader.put("copentry", copEntrys);
        int seq = 1;
        for (RequireRowData cop : cops) {
            BigDecimal quota = MRPUtil.toBigDecimal(cop.getValue(DefaultField.RequireField.__REAL_QUATA__.name()));
            Object[] data = new Object[size];
            int mAttr = MRPUtil.convert(cop.getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue());
            String bt = provider.getRelatedSupplyBillType(mAttr);
            data[supplyTbl.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name()).intValue()] = bt == null ? ResManager.loadKDString((String)"\u65b0\u5efa\u8ba1\u5212\u8ba2\u5355", (String)"KDCloudDataSaver_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]) : bt;
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.SUPPLYORGUNIT.getName()).intValue()] = org;
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.DATE.getName()).intValue()] = enableDate;
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLNUMBER.getName()).intValue()] = billNo;
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLID.getName()).intValue()] = id;
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.QTY.getName()).intValue()] = MRPUtil.multiply(quota, qty);
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIAL.getName()).intValue()] = cop.getValue(DefaultField.RequireField.MATERIAL.getName());
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__IS_COP_SUPPLY__.getName()).intValue()] = Boolean.TRUE;
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__MANUAL_CREATE_COP__.getName()).intValue()] = Boolean.TRUE;
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILL_ENTITY.getName()).intValue()] = outputType;
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLENTRYSEQ.getName()).intValue()] = seq;
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.TRACKNUMBER.getName()).intValue()] = cop.getValue(DefaultField.RequireField.TRACKNUMBER.getName());
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.CONFIGUREDCODE.getName()).intValue()] = cop.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName());
            data[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIALFLEXPROPS.getName()).intValue()] = cop.getValue(DefaultField.RequireField.__ENTRYAUXPROPERTY__.getName());
            RowData supply = new RowData(supplyTbl.getSrcDatas(), supplyTbl.getColIdx(), data, -1, ResType.SUPPLY);
            supplyTbl.fill(supply);
            HashMap<String, Object> entry = new HashMap<String, Object>(10);
            entry.put("copentrytype", cop.getValue(DefaultField.RequireField.__COPTYPE__.getName()));
            entry.put("copentrymaterial", cop.getValue(DefaultField.RequireField.MATERIAL.getName()));
            entry.put("copentryversion", cop.getValue(DefaultField.RequireField.__BOM_VERSION__.getName()));
            entry.put("copentryunit", cop.getValue(DefaultField.RequireField.BASEUNIT.getName()));
            entry.put("copentryqty", quota);
            entry.put("copentryallqty", MRPUtil.multiply(quota, qty));
            entry.put("copentryoperation", cop.getValue(DefaultField.RequireField.__COPOPERATION__.getName()));
            entry.put("copentryvaliddate", cop.getValue(DefaultField.RequireField.__CHILDVALIDDATE__.getName()));
            entry.put("copentryinvaliddate", cop.getValue(DefaultField.RequireField.__CHILDINVALIDDATE__.getName()));
            entry.put("copentryauxproperty", cop.getValue(DefaultField.RequireField.__ENTRYAUXPROPERTY__.getName()));
            entry.put("copentryremark", cop.getValue(DefaultField.RequireField.__REMARK__.getName()));
            entry.put("seq", seq++);
            copEntrys.add(entry);
        }
    }

    public HashMap<String, Object> createModelHeader(IMRPEnvProvider provider, String outputType, DataBalanceTable.RSMapping mapping) {
        HashMap<String, Object> poHeader = new HashMap<String, Object>(16);
        String material = String.valueOf(mapping.getRequire().getValue(DefaultField.RequireField.MATERIAL.getName()));
        poHeader.put("material", material);
        poHeader.put("id", this.getPoId(mapping.getRequire()));
        poHeader.put("billno", this.getPoNum(provider, mapping.getRequire(), String.valueOf(mapping.getRequire().getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()))));
        poHeader.put("billstatus", Character.valueOf('A'));
        poHeader.put("orderqty", mapping.getrQty());
        poHeader.put("datasource", PlanOrderGenType.CALCCREATE.getValue());
        poHeader.put("planprogram", provider.getPlanId());
        poHeader.put("planoperatenum", provider.getRunLogNumber());
        poHeader.put("creator", RequestContext.get().getCurrUserId());
        poHeader.put("createtime", System.currentTimeMillis());
        poHeader.put("modifier", RequestContext.get().getCurrUserId());
        poHeader.put("modifytime", System.currentTimeMillis());
        return poHeader;
    }

    public void printOrderModels(Map<String, Object> poHeader, IMRPEnvProvider provider, String outputType, DataBalanceTable.RSMapping mapping, List<FieldMapping> outputMappings) {
        if (outputMappings != null && !outputMappings.isEmpty()) {
            RequireDataModel require = (RequireDataModel)provider.getService(RequireDataModel.class);
            MainEntityType requireBillEntityType = MetadataServiceHelper.getDataEntityType((String)require.getRequireBillModelEntity());
            Map allFields = requireBillEntityType.getAllFields();
            block0: for (FieldMapping fieldMapping : outputMappings) {
                if (fieldMapping.getTo().contains(".")) continue;
                if ("0".equals(fieldMapping.getConverttype())) {
                    Object v = this.getF7ReferPropertyValue(provider, fieldMapping.getFrom(), mapping.getRequire(), allFields);
                    poHeader.put(fieldMapping.getTo().toLowerCase(Locale.ENGLISH), v != null ? v : mapping.getRequire().getValue(fieldMapping.getFrom().toUpperCase(Locale.ENGLISH)));
                    continue;
                }
                if ("3".equals(fieldMapping.getConverttype())) {
                    poHeader.put(fieldMapping.getTo().toLowerCase(Locale.ENGLISH), fieldMapping.getFormulaValue());
                    continue;
                }
                if ("1".equals(fieldMapping.getConverttype()) && !StringUtils.isEmpty((CharSequence)fieldMapping.getFormulaValue())) {
                    poHeader.put(fieldMapping.getTo().toLowerCase(Locale.ENGLISH), this.getFormValue(mapping.getRequire(), fieldMapping.getFormulaValue(), provider, allFields));
                    continue;
                }
                if (!"2".equals(fieldMapping.getConverttype())) continue;
                String json = fieldMapping.getFormulaValue();
                CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)json, CRValByConditions.class);
                List conditionList = valByConditions.getItems();
                for (CRValByCondition condition : conditionList) {
                    FilterCondition filterCondition = condition.getCondition().getFilterCondition();
                    FilterBuilder filterBuilder = new FilterBuilder(requireBillEntityType, filterCondition);
                    UserService userService = new UserService();
                    filterBuilder.setUserService((IUserService)userService);
                    filterBuilder.buildFilter(false);
                    QFilter filterBuilderQFilter = filterBuilder.getQFilter();
                    String expression = null;
                    if (condition.getFormula() == null || StringUtils.isEmpty((CharSequence)condition.getFormula().getExpression())) continue;
                    expression = condition.getFormula().getExpression();
                    if (filterBuilderQFilter != null && !this.checkQFilter(filterBuilderQFilter, provider, mapping.getRequire(), allFields)) continue;
                    poHeader.put(fieldMapping.getTo().toLowerCase(Locale.ENGLISH), this.getFormValue(mapping.getRequire(), expression, provider, allFields));
                    continue block0;
                }
            }
        }
    }

    private boolean checkQFilter(QFilter qFilter, IMRPEnvProvider provider, RequireRowData require, Map<String, IDataEntityProperty> allFields) {
        List list = qFilter.getNests(false);
        String property = qFilter.getProperty();
        Object value = qFilter.getValue();
        if (value != null && value.toString().contains("entryentity.")) {
            value = this.getFormValue(require, value.toString(), provider, allFields);
        }
        if (value instanceof Timestamp) {
            value = ((Timestamp)value).getTime();
        } else if (value instanceof Date) {
            value = ((Date)value).getTime();
        }
        Object formValue = this.getFormValue(require, property, provider, allFields);
        boolean check = false;
        if (StringUtils.equals((CharSequence)"=", (CharSequence)qFilter.getCP())) {
            check = StringUtils.equals((CharSequence)this.objectValueToString(formValue), (CharSequence)this.objectValueToString(value));
        } else if (StringUtils.equals((CharSequence)"!=", (CharSequence)qFilter.getCP()) || StringUtils.equals((CharSequence)"<>", (CharSequence)qFilter.getCP())) {
            check = !StringUtils.equals((CharSequence)this.objectValueToString(formValue), (CharSequence)this.objectValueToString(value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"like", (CharSequence)qFilter.getCP()) || StringUtils.equalsIgnoreCase((CharSequence)"ftlike", (CharSequence)qFilter.getCP())) {
            check = StringUtils.contains((CharSequence)this.objectValueToString(formValue), (CharSequence)this.objectValueToString(value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"not like", (CharSequence)qFilter.getCP())) {
            check = !StringUtils.contains((CharSequence)this.objectValueToString(formValue), (CharSequence)this.objectValueToString(value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"is null", (CharSequence)qFilter.getCP())) {
            check = StringUtils.isBlank((Object)formValue);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"is not null", (CharSequence)qFilter.getCP())) {
            check = StringUtils.isNotBlank((Object)formValue);
        } else if (StringUtils.equals((CharSequence)">", (CharSequence)qFilter.getCP())) {
            check = this.objectValueToString(formValue).compareTo(this.objectValueToString(value)) > 0;
        } else if (StringUtils.equals((CharSequence)">=", (CharSequence)qFilter.getCP())) {
            check = this.objectValueToString(formValue).compareTo(this.objectValueToString(value)) >= 0;
        } else if (StringUtils.equals((CharSequence)"<", (CharSequence)qFilter.getCP())) {
            check = this.objectValueToString(formValue).compareTo(this.objectValueToString(value)) < 0;
        } else if (StringUtils.equals((CharSequence)"<=", (CharSequence)qFilter.getCP())) {
            check = this.objectValueToString(formValue).compareTo(this.objectValueToString(value)) <= 0;
        } else if ((StringUtils.equalsIgnoreCase((CharSequence)"in", (CharSequence)qFilter.getCP()) || StringUtils.equalsIgnoreCase((CharSequence)"not in", (CharSequence)qFilter.getCP())) && value instanceof Collection) {
            boolean isIn = StringUtils.equalsIgnoreCase((CharSequence)"in", (CharSequence)qFilter.getCP());
            boolean isContains = false;
            for (Object v : (Collection)value) {
                if (!StringUtils.equals((CharSequence)this.objectValueToString(formValue), (CharSequence)this.objectValueToString(v))) continue;
                isContains = true;
                break;
            }
            check = isIn == isContains;
        }
        for (QFilter.QFilterNest qFilterNest : list) {
            if (qFilterNest.isAnd()) {
                check = check && this.checkQFilter(qFilterNest.getFilter(), provider, require, allFields);
                continue;
            }
            if (check) continue;
            check = this.checkQFilter(qFilterNest.getFilter(), provider, require, allFields);
        }
        return check;
    }

    private String objectValueToString(Object value) {
        return value == null ? "" : value.toString();
    }

    private Object getFormValue(RequireRowData require, String expression, IMRPEnvProvider provider, Map<String, IDataEntityProperty> allFields) {
        if (expression == null) {
            return null;
        }
        Object v = this.getF7ReferPropertyValue(provider, expression, require, allFields);
        return v != null ? v : this.getExpressionValue(require, expression);
    }

    @Deprecated
    public void setFormValueByType(Map<String, Object> poHeader, FieldMapping fieldMapping, DataBalanceTable.RSMapping mapping, String expression) {
        Object value = this.getExpressionValue(mapping.getRequire(), expression);
        poHeader.put(fieldMapping.getTo().toLowerCase(Locale.ENGLISH), value);
    }

    private Object getExpressionValue(RequireRowData require, String expression) {
        if (expression.startsWith("entryentity.") || expression.startsWith("ENTRYENTITY.")) {
            return require.getValue(expression.toUpperCase(Locale.ENGLISH));
        }
        if (expression.matches("^['|\"](.*?)['|\"]$")) {
            String value = expression.substring(1, expression.length() - 1);
            Matcher m = DataMatchUtils.REQ_FIELD_SELECTOR.matcher(value);
            if (m.find()) {
                Object v;
                char c;
                StringBuilder field = new StringBuilder();
                int pos = m.end();
                while (pos < value.length() && (Character.isLetterOrDigit(c = value.charAt(pos++)) || c == '_')) {
                    field.append(c);
                }
                String f = field.toString().toUpperCase(Locale.ENGLISH);
                Object object = v = require.getValue(f) == null ? require.getValue("ENTRYENTITY." + f) : require.getValue(f);
                if (value.startsWith("!")) {
                    v = MRPUtil.convert(v, false) == false;
                }
                return v;
            }
            return value;
        }
        if (expression.matches("[0-9]*")) {
            if (expression.length() >= 10) {
                return MRPUtil.convert((Object)expression, 0L);
            }
            return MRPUtil.convert((Object)expression, 0);
        }
        if (expression.matches("[0-9]*\\.?[0-9]+")) {
            return new BigDecimal(expression);
        }
        return null;
    }

    private Object getF7ReferPropertyValue(IMRPEnvProvider provider, String scrFields, RequireRowData require, Map<String, IDataEntityProperty> allFields) {
        scrFields = scrFields.toLowerCase(Locale.ENGLISH);
        CacheDatas cacheDatas = (CacheDatas)provider.getService(CacheDatas.class);
        String[] splitField = scrFields.replaceAll("entryentity.", "").split("\\.");
        IDataEntityProperty pro = allFields.get(splitField[0]);
        String fieldName = "ENTRYENTITY." + splitField[0].toUpperCase(Locale.ENGLISH);
        Object realValue = null;
        Object F7Id = require.getValue(fieldName);
        if (splitField.length > 1 && pro instanceof BasedataProp && F7Id != null) {
            String F7key = ((BasedataProp)pro).getBaseEntityId();
            F7Id = NumberUtils.isNumber((String)F7Id.toString()) ? MRPUtil.convert(F7Id, 0L) : F7Id.toString();
            StringBuilder param = new StringBuilder();
            for (int i = 1; i < splitField.length; ++i) {
                if (param.length() > 0) {
                    param.append('.');
                }
                param.append(splitField[i]);
            }
            DynamicObject data = cacheDatas.reloadDataById(F7key, F7Id, param.toString());
            if (data != null) {
                realValue = data.get(param.toString());
            }
        }
        return realValue;
    }

    private HashMap<String, Object> toFabPO(IMRPEnvProvider provider, DataBalanceTable.RSMapping mapping) {
        HashMap<String, Object> poHeader = null;
        if (mapping.getBom() != null) {
            poHeader = this.createFabPO(provider, mapping);
            mapping.addPo(this.toSimplePO(poHeader));
        } else {
            mapping.setExceptionData(true);
            poHeader = this.createPurPO(provider, mapping);
            mapping.addPo(this.toSimplePO(poHeader));
        }
        poHeader.put("unfoldbomdate", MRPUtil.getExpendBomTime(provider, mapping.getRequire()));
        return poHeader;
    }

    private SimplePlanOrder toSimplePO(HashMap<String, Object> poHeader) {
        SimplePlanOrder poDetails = new SimplePlanOrder();
        poDetails.setId(String.valueOf(poHeader.get("id")));
        poDetails.setNumber(String.valueOf(poHeader.get("billno")));
        poDetails.setAuxProperty(poHeader.get("auxproperty"));
        Object org = poHeader.get("proorpurorg");
        if (BillSupplyStrategy.INVENTORY.getValue().equals(poHeader.get("supplyrule"))) {
            org = poHeader.get("org");
        }
        poDetails.setProductOrgUnit(org);
        poDetails.setTrackNumber(poHeader.get("tracknumber"));
        poDetails.setProject(poHeader.get("project"));
        poDetails.setSupplier(poHeader.get("supplier"));
        poDetails.setPlanScope(poHeader.get("planscope"));
        BigDecimal orderQty = (BigDecimal)poHeader.get("orderqty");
        poDetails.setQty(orderQty);
        return poDetails;
    }

    private void swapValue(RowData rowData, String fieldOne, String fieldTwo) {
        Object v1 = rowData.getValue(fieldOne);
        Object v2 = rowData.getValue(fieldTwo);
        rowData.update(fieldOne, v2);
        rowData.update(fieldTwo, v1);
    }

    private Long getPoId(RequireRowData require) {
        Long id = require.getLong(DefaultField.RequireField.__PO_ID__.getName());
        if (id == null) {
            id = ID.genLongId();
        }
        return id;
    }

    private String getPoNum(IMRPEnvProvider provider, RequireRowData require, String org) {
        String order = require.getString(DefaultField.RequireField.__INVLEVEL_BILLNUMBER__.getName());
        if (StringUtils.isBlank((CharSequence)order)) {
            order = require.getString(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName());
        }
        return StringUtils.isNotBlank((CharSequence)order) ? order : MRPUtil.genPONum(provider, org);
    }

    private HashMap<String, Object> createPurPO(IMRPEnvProvider provider, DataBalanceTable.RSMapping mapping) {
        List<FieldMapping> r2po;
        RequireRowData require = mapping.getRequire();
        HashMap<String, Object> po = new HashMap<String, Object>();
        Object originRequireOrg = require.getValue(DefaultField.RequireField.__ORIGIN_REQUIRE_ORG__.getName());
        if (originRequireOrg == null) {
            originRequireOrg = require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
        } else {
            this.swapValue(require, DefaultField.RequireField.__ORIGIN_REQUIRE_ORG__.getName(), DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            this.isSwap = true;
        }
        po.put("id", this.getPoId(require));
        po.put("billno", this.getPoNum(provider, require, String.valueOf(originRequireOrg)));
        po.put("org", originRequireOrg);
        po.put("ordertype", MaterialAttribute.PURCHASEDPART.getValue());
        if (require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()) == null) {
            po.put("proorpurorg", originRequireOrg);
        } else {
            po.put("proorpurorg", require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        }
        String material = String.valueOf(require.getValue(DefaultField.RequireField.MATERIAL.getName()));
        po.put("material", material);
        String materialAttr = String.valueOf(require.getValue(DefaultField.RequireField.MATERIALATTR.getName()));
        po.put("materialattr", materialAttr);
        po.put("billstatus", PlanOrderStatus.SAVED.getValue());
        po.put("unit", require.getValue(DefaultField.RequireField.BASEUNIT.getName()));
        po.put("plantags", require.getValue(DefaultField.RequireField.__PLAN_TAG__.getName()));
        po.put("materiallock", Boolean.TRUE);
        Object supplier = require.getValue(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName());
        supplier = supplier == null ? require.getValue(DefaultField.RequireField.SUPPLIER.getName()) : supplier;
        po.put("supplier", supplier);
        BigDecimal yield = BigDecimal.ONE;
        BigDecimal rQty = mapping.getrQty();
        if (provider.isYield()) {
            Object myield = require.getValue(DefaultField.RequireField.YIELD.getName());
            yield = MRPUtil.toBigDecimal(myield);
        }
        BigDecimal orderQty = MRPUtil.calcYield(yield, require.getValue(DefaultField.RequireField.BASEUNIT.getName()), rQty, provider, true);
        po.put("orderqty", rQty);
        po.put("dropqty", BigDecimal.ZERO);
        po.put("yield", yield);
        po.put("endproqty", orderQty);
        po.put("dropstatus", BillStatus.A.name());
        po.put("ecnversion", require.getValue(DefaultField.RequireField.ECN.getName()));
        po.put("planpersonid", require.getValue(DefaultField.RequireField.__PLAN_USER__.getName()));
        po.put("orderdate", require.getValue(DefaultField.RequireField.__ORDER_DATE__.getName()));
        po.put("startdate", require.getValue(DefaultField.RequireField.__START_DATE__.getName()));
        po.put("enddate", require.getValue(DefaultField.RequireField.__END_DATE__.getName()));
        po.put("demandbillentity", require.getValue(DefaultField.RequireField.ORIGIN_BILLENTITY.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLENTITY.getName()) : require.getValue(DefaultField.RequireField.BILL_ENTITY.getName()));
        po.put("demandbill", require.getValue(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName()) : require.getValue(DefaultField.RequireField.BILLNUMBER.getName()));
        po.put("demandbillid", require.getValue(DefaultField.RequireField.ORIGIN_BILLID.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLID.getName()) : require.getValue(DefaultField.RequireField.BILLID.getName()));
        po.put("demandseq", require.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName()) : require.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()));
        po.put("demandbillentryid", require.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYID.getName()) != null ? require.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYID.getName()) : require.getValue(DefaultField.RequireField.BILLENTRYID.getName()));
        if (!provider.isAllowPast()) {
            Long finish = 0L;
            if (require.getValue(DefaultField.RequireField.__END_DATE__.getName()) != null) {
                finish = (Long)require.getValue(DefaultField.RequireField.__END_DATE__.getName());
            }
            if (finish < provider.getPlanDate().getTime()) {
                po.put("orderdate", provider.getPlanDate().getTime());
                po.put("startdate", provider.getPlanDate().getTime());
                po.put("enddate", provider.getPlanDate().getTime());
            } else {
                Long start = (Long)require.getValue(DefaultField.RequireField.__START_DATE__.getName());
                if (start < provider.getPlanDate().getTime()) {
                    po.put("orderdate", provider.getPlanDate().getTime());
                    po.put("startdate", provider.getPlanDate().getTime());
                } else {
                    Long plan = (Long)require.getValue(DefaultField.RequireField.__ORDER_DATE__.getName());
                    if (plan == null) {
                        po.put("orderdate", require.getValue(DefaultField.RequireField.__START_DATE__.getName()));
                    } else if (plan < provider.getPlanDate().getTime()) {
                        po.put("orderdate", provider.getPlanDate().getTime());
                    }
                }
            }
        }
        Long date = (Long)require.getValue(DefaultField.RequireField.DATE.getName());
        po.put("availabledate", date);
        po.put("datasource", PlanOrderGenType.CALCCREATE.getValue());
        po.put("planprogram", provider.getPlanId());
        po.put("planoperatenum", provider.getRunLogNumber());
        po.put("creator", RequestContext.get().getCurrUserId());
        po.put("createtime", System.currentTimeMillis());
        po.put("modifier", RequestContext.get().getCurrUserId());
        po.put("modifytime", System.currentTimeMillis());
        po.put("materialplanid", require.getValue(DefaultField.RequireField.__MATERIALPLAN__.getName()));
        po.put("configuredcode", require.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()));
        Object isTrackMatch = require.getValue(DefaultField.RequireField.IS_TRACK_MATCH.getName());
        if (MRPUtil.convert(isTrackMatch, Boolean.FALSE).booleanValue()) {
            po.put("tracknumber", require.getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
        }
        po.put("project", require.getValue(DefaultField.RequireField.PROJECTNUMBER.getName()));
        po.put("auxproperty", require.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
        Long demandplanscope = MRPUtil.convert(require.getValue(DefaultField.RequireField.DEMANDPLANSCOPE.getName()), 0L);
        po.put("planscope", demandplanscope > 0L ? demandplanscope : require.getValue(DefaultField.RequireField.PLANSCOPE.getName()));
        po.put("inwarorg", require.getValue(DefaultField.RequireField.IN_STORAGE_ORG.getName()));
        po.put("inwarehouse", require.getValue(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName()));
        po.put("inwarelocation", require.getValue(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName()));
        po.put("manuversion", require.getValue(DefaultField.RequireField.MFTVERSION.getName()));
        String supply_strategy = MRPUtil.convert(require.getValue(DefaultField.RequireField.DEMAND_SUPPLY_STRATEGY.getName()), "");
        po.put("supplyrule", StringUtils.isNotBlank((CharSequence)supply_strategy) ? supply_strategy : require.getValue(DefaultField.RequireField.SUPPLY_STRATEGY.getName()));
        if (MRPUtil.convert(po.get("inwarorg"), 0L) <= 0L) {
            if (BillSupplyStrategy.INVENTORY.getValue().equals(po.get("supplyrule"))) {
                po.put("inwarorg", po.get("org"));
            } else {
                po.put("inwarorg", po.get("proorpurorg"));
            }
        }
        if ((r2po = provider.r2po()) != null) {
            for (FieldMapping m : r2po) {
                Object value = require.getValue(m.getFrom());
                if (m.getValueFormula() != null) {
                    ExprContext ctx = new ExprContext();
                    ctx.addPreDefinedParam("require", require);
                    ctx.addPreDefinedParam("bom", mapping.getBom());
                    value = m.getValueFormula().execute(ctx);
                }
                po.put(m.getTo(), value);
            }
        }
        this.updatePoHead(po, require);
        return po;
    }

    private HashMap<String, Object> createFabPO(IMRPEnvProvider provider, DataBalanceTable.RSMapping mapping) {
        HashMap<String, Object> poHeader = this.createPurPO(provider, mapping);
        ArrayList<Map<String, Object>> entrys = new ArrayList<Map<String, Object>>();
        poHeader.put("entryentity", entrys);
        Long superBomId = MRPUtil.convert(mapping.getBom().getValue(DefaultField.BOMField.__SUPER_BOMID__.getName()), 0L);
        if (superBomId == null || superBomId <= 0L) {
            superBomId = MRPUtil.convert(mapping.getBom().getValue(DefaultField.BOMField.BOMID.getName()), 0L);
        }
        poHeader.put("bom", superBomId);
        if (mapping.getRequire().getValue(DefaultField.RequireField.__REPLACE_KEY__.getName()) != null) {
            poHeader.put(DefaultField.RequireField.__REPLACE_KEY__.getName(), mapping.getRequire().getValue(DefaultField.RequireField.__REPLACE_KEY__.getName()));
        }
        this.createFabPOEntry(provider, poHeader, entrys, mapping.getChildrenIterator(), mapping.getChildrenSize());
        return poHeader;
    }

    @Override
    public void createFabPOEntry(IMRPEnvProvider provider, Map<String, Object> poHeader, List<Map<String, Object>> entrys, List<RequireRowData> childs) {
        Map replacepriorityQty;
        HashMap<Long, BigDecimal> replaceplanQty = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, Map> replaceplanReplacepriorityQty = new HashMap<Long, Map>(16);
        for (RequireRowData entry : childs) {
            BigDecimal priorityQty;
            Long replacePlan = MRPUtil.convert(entry.getValue(DefaultField.RequireField.REPLACEPLAN.getName()), 0L);
            boolean isreplaceplanmm = MRPUtil.convert(entry.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()), Boolean.FALSE);
            if (replacePlan <= 0L || !isreplaceplanmm) continue;
            String replacepriority = String.valueOf(entry.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
            replacepriorityQty = replaceplanReplacepriorityQty.computeIfAbsent(replacePlan, k -> new HashMap());
            BigDecimal qty = (BigDecimal)replaceplanQty.get(replacePlan);
            if (qty == null) {
                qty = BigDecimal.ZERO;
            }
            if ((priorityQty = (BigDecimal)replacepriorityQty.get(replacepriority)) == null) {
                priorityQty = BigDecimal.ZERO;
            }
            BigDecimal entryrequireqty = MRPUtil.convert(entry.getValue(DefaultField.RequireField.QTY.getName()), BigDecimal.ZERO);
            priorityQty = priorityQty.add(entryrequireqty);
            qty = qty.add(entryrequireqty);
            replaceplanQty.put(replacePlan, qty);
            replacepriorityQty.put(replacepriority, priorityQty);
        }
        HashMap<Long, Map<String, BigDecimal>> replaceplanReplacepriorityUseratio = new HashMap<Long, Map<String, BigDecimal>>();
        for (Map.Entry replaceplanReplacepriorityEnty : replaceplanReplacepriorityQty.entrySet()) {
            Long replaceplan = (Long)replaceplanReplacepriorityEnty.getKey();
            BigDecimal qtysum = replaceplanQty.getOrDefault(replaceplan, BigDecimal.ZERO);
            replacepriorityQty = (Map)replaceplanReplacepriorityEnty.getValue();
            Map replacepriorityUseratio = replaceplanReplacepriorityUseratio.computeIfAbsent(replaceplan, k -> new HashMap(16));
            for (Map.Entry replacepriorityEntry : replacepriorityQty.entrySet()) {
                String replacepriority = (String)replacepriorityEntry.getKey();
                BigDecimal qty = (BigDecimal)replacepriorityEntry.getValue();
                BigDecimal useratio = (BigDecimal)replacepriorityUseratio.get(replacepriority);
                useratio = qty == null || BigDecimal.ZERO.compareTo(qtysum) == 0 ? BigDecimal.valueOf(0L) : qty.multiply(BigDecimal.valueOf(100L)).divide(qtysum, 4, 4);
                replacepriorityUseratio.put(replacepriority, useratio);
            }
        }
        this.createFabPOEntry(provider, poHeader, entrys, childs.iterator(), childs.size(), replaceplanReplacepriorityUseratio);
    }

    @Override
    public void createFabPOEntry(IMRPEnvProvider provider, Map<String, Object> poHeader, List<Map<String, Object>> entrys, Iterator<RequireRowData> iter, int childrenSize) {
        this.createFabPOEntry(provider, poHeader, entrys, iter, childrenSize, new HashMap<Long, Map<String, BigDecimal>>(0));
    }

    public void createFabPOEntry(IMRPEnvProvider provider, Map<String, Object> poHeader, List<Map<String, Object>> entrys, Iterator<RequireRowData> iter, int childrenSize, Map<Long, Map<String, BigDecimal>> replaceplanReplacepriorityUseratio) {
        PlanModel planModel = (PlanModel)provider.getService(PlanModel.class);
        int seq = entrys.size() + 1;
        long[] entryIds = ID.genLongIds((int)childrenSize);
        int i = 0;
        while (iter.hasNext()) {
            RequireRowData entry = iter.next();
            HashMap<String, Object> poe = new HashMap<String, Object>();
            entrys.add(poe);
            long entryid = entryIds[i];
            poe.put("id", entryid);
            poe.put("seq", seq);
            poe.put("entrymode", "B");
            poe.put("entrymaterial", String.valueOf(entry.getValue(DefaultField.RequireField.MATERIAL.getName())));
            poe.put("entryversion", entry.getValue(DefaultField.RequireField.__BOM_VERSION__.getName()));
            poe.put("entryauxproperty", entry.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
            poe.put("entryunit", entry.getValue(DefaultField.RequireField.BASEUNIT.getName()));
            poe.put("entrytype", entry.getValue(DefaultField.RequireField.__CHILDTYPE__.getName()));
            poe.put("entryqtytype", entry.getValue(DefaultField.RequireField.__CHILDAMTTYPE__.getName()));
            poe.put("entryqtynumerator", entry.getValue(DefaultField.RequireField.__CHILDNUMERATOR__.getName()));
            poe.put("entryqtydenominator", entry.getValue(DefaultField.RequireField.__CHILDDENOMINATOR__.getName()));
            poe.put("entryrequireqty", entry.getValue(DefaultField.RequireField.QTY.getName()));
            poe.put("entryrequiredate", entry.getValue(DefaultField.RequireField.DATE.getName()));
            poe.put("entryfixscrap", entry.getValue(DefaultField.RequireField.__CHILDFIXSCRAP__.getName()));
            poe.put("entryscraprate", entry.getValue(DefaultField.RequireField.__DYNAMICSCRAPRATIO__.getName()));
            poe.put("entrystandqty", entry.getValue(DefaultField.RequireField.STAND_QTY.getName()));
            BigDecimal lossQty = MRPUtil.toBigDecimal(entry.getValue(DefaultField.RequireField.QTY.getName())).subtract(MRPUtil.toBigDecimal(entry.getValue(DefaultField.RequireField.STAND_QTY.getName())));
            poe.put("entrylossqty", lossQty);
            poe.put("entrysupplyorg", entry.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
            poe.put("entrybomid", entry.getValue(DefaultField.RequireField.__PARENT_BOMID__.getName()));
            poe.put("entrybomentryid", entry.getValue(DefaultField.RequireField.__BOM_ENTRYID__.getName()));
            poe.put("entrymaterialplanid", entry.getValue(DefaultField.RequireField.__CHILDMATERIALPLAN__.getName()));
            Long replacePlan = MRPUtil.convert(entry.getValue(DefaultField.RequireField.REPLACEPLAN.getName()), 0L);
            poe.put("entryreplaceplan", replacePlan);
            poe.put("entryreplacematerial", entry.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
            poe.put("entryisreplace", entry.getValue(DefaultField.RequireField.ISREPLACE.getName()));
            poe.put("entryreplacepriority", entry.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
            poe.put("entryreplacestra", entry.getValue(DefaultField.RequireField.REPLACESTRA.getName()));
            poe.put("entryreplacemethod", entry.getValue(DefaultField.RequireField.REPLACEMETHOD.getName()));
            poe.put("entryrepmaterials", entry.getValue(DefaultField.RequireField.__REPLACE_MATERIAL__.getName()));
            poe.put("entryrepqty", entry.getValue(DefaultField.RequireField.__REPLACE_QTY__.getName()));
            poe.put("wastagerateformula", entry.getValue(DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName()));
            poe.put("entryleadtime", entry.getValue(DefaultField.RequireField.__LEADTIME__.getName()));
            poe.put("entryconfiguredcode", entry.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()));
            poe.put("entrysupplyorgunitid", entry.getValue(DefaultField.RequireField.SUPPLIER_ORG.getName()));
            poe.put("entrywarehouse", entry.getValue(DefaultField.RequireField.SUPPLIER_WAREHOUSE.getName()));
            poe.put("entrylocation", entry.getValue(DefaultField.RequireField.SUPPLIER_SHIPPING.getName()));
            poe.put("entryisstockallot", entry.getValue(DefaultField.RequireField.ISSTOCKALLOT.getName()));
            poe.put("entryisjumplevel", entry.getValue(DefaultField.RequireField.IS_VIRTUAL_REQUIRE.getName()));
            poe.put("entryparentmaterial", entry.getValue(DefaultField.RequireField.__REAL_PARENT_MATERIAL__.getName()));
            poe.put("iskeypart", entry.getValue(DefaultField.RequireField.__IS_KEYPART__.getName()));
            if (replacePlan == null || replacePlan <= 0L) {
                poe.put("entryuseratio", BigDecimal.valueOf(100.0));
            } else {
                String replacestra = String.valueOf(entry.getValue(DefaultField.RequireField.REPLACESTRA.getName()));
                boolean isreplace = MRPUtil.convert(entry.getValue(DefaultField.RequireField.ISREPLACE.getName()), Boolean.FALSE);
                if (ReplaceStrategy.MANUAL.getValue().equals(replacestra) || !provider.isReplace()) {
                    poe.put("entryuseratio", isreplace ? BigDecimal.ZERO : BigDecimal.valueOf(100.0));
                } else {
                    Map<String, BigDecimal> replacepriorityUseratio = replaceplanReplacepriorityUseratio.get(replacePlan);
                    String replacepriority = String.valueOf(entry.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
                    if (replacepriorityUseratio == null) {
                        poe.put("entryuseratio", BigDecimal.ZERO);
                    } else {
                        BigDecimal useratio = replacepriorityUseratio.getOrDefault(replacepriority, BigDecimal.ZERO);
                        poe.put("entryuseratio", useratio);
                    }
                }
            }
            if (planModel.isReserve()) {
                entry.update(DefaultField.RequireField.RESERVE_BILLNO.getName(), poHeader.get("billno"));
                entry.update(DefaultField.RequireField.RESERVE_BILLID.getName(), poHeader.get("id"));
                entry.update(DefaultField.RequireField.RESERVE_BILLENTRYID.getName(), (Object)entryid);
                entry.update(DefaultField.RequireField.RESERVE_BILLENTRYSEQ.getName(), (Object)seq);
            }
            this.updateFabPOEntry(poe, entry);
            ++i;
            ++seq;
        }
    }

    protected void updateFabPOEntry(HashMap<String, Object> poe, RequireRowData entry) {
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin;
        if (this.ctx != null && (imrpCalcNetDemandPlugin = this.ctx.getMRPCalcNetDemandPlugin()) != null) {
            imrpCalcNetDemandPlugin.updateFabPOEntry(this.ctx.getMrpSdkEnv(), poe, (IRowData)entry);
        }
    }

    protected void updatePoHead(HashMap<String, Object> po, RequireRowData require) {
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin;
        if (this.ctx != null && (imrpCalcNetDemandPlugin = this.ctx.getMRPCalcNetDemandPlugin()) != null) {
            imrpCalcNetDemandPlugin.updatePoHead(this.ctx.getMrpSdkEnv(), po, (IRowData)require);
        }
    }
}

