/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.exception.MRPManuStopException;
import kd.mmc.mrp.framework.IMRPDataFetcher;
import kd.mmc.mrp.framework.IMRPDataSaveResolver;
import kd.mmc.mrp.framework.IMRPDataSourceResolver;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.mq.DefaultOnResponse;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.MRPMQManager;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.step.IMRPCallableConfigurator;
import kd.mmc.mrp.integrate.AbstractMRPEnv;
import kd.mmc.mrp.integrate.KDCloudDataFetcher;
import kd.mmc.mrp.integrate.KDCloudLogRecorder;
import kd.mmc.mrp.integrate.KDCloudSysConfigProvider;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.EqEassManger;
import kd.mmc.mrp.integrate.entity.EqNeedPlanEntryModel;
import kd.mmc.mrp.integrate.entity.EqNeedPlanManager;
import kd.mmc.mrp.integrate.entity.EqNeedPlanModel;
import kd.mmc.mrp.integrate.entity.EqToolNeedPlanManager;
import kd.mmc.mrp.integrate.entity.ResourcePlanScheme;
import kd.mmc.mrp.integrate.entity.ResourecPlanModel;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.res.RESErrorMessageUtil;

public class RESEnv
extends AbstractMRPEnv {
    private final ORM orm = ORM.create();
    private static final Log logger = LogFactory.getLog(RESEnv.class);
    private String mrpContextId = UUID.randomUUID().toString();
    private KDCloudLogRecorder logRecorder;
    private IMRPEventManager mqManager;
    private volatile boolean isShutdown = false;
    private final KDCloudSysConfigProvider sysConfigManager = new KDCloudSysConfigProvider();
    private String fStepname = "";
    ResourcePlanScheme resourcePlanScheme;
    private CacheDatas cacheDatas;
    private RunLogModel runLogModel;
    private final String runLogNumber;
    private Map<Class<?>, Object> services = new HashMap(8);

    public RESEnv(DynamicObject runLog) {
        String mrpContextId = runLog.getString("mrpid");
        if (StringUtils.isEmpty((String)mrpContextId)) {
            runLog.set("mrpid", (Object)this.mrpContextId);
            String dbKey = runLog.getDataEntityType().getDBRouteKey();
            DB.execute((DBRoute)new DBRoute(dbKey), (String)"update t_mrp_caculatelog set fmrpid = ? where fid = ? ", (Object[])new Object[]{this.mrpContextId, runLog.get("id")});
        } else {
            this.mrpContextId = mrpContextId;
        }
        this.logRecorder = new KDCloudLogRecorder(this.orm, runLog);
        this.mqManager = new MRPMQManager(this, new DefaultOnResponse(this, this.logRecorder));
        this.runLogNumber = runLog.getString("number");
        this.runLogModel = new RunLogModel(this, runLog);
        this.cacheDatas = new CacheDatas(this);
        this.resourcePlanScheme = new ResourcePlanScheme(this);
    }

    @Override
    public int initRuntimeEnv() {
        DynamicObjectCollection entrys;
        this.runLogModel.checkSnap();
        this.cacheDatas.init();
        this.loadSysConfiguration();
        this.resourcePlanScheme.init();
        DynamicObject runLog = this.runLogModel.getRunLog();
        if (runLog != null && !(entrys = runLog.getDynamicObjectCollection("entryentity")).isEmpty()) {
            if ("1".equals(this.resourcePlanScheme.getFchkgroupplantype())) {
                ((DynamicObject)entrys.get(0)).set("entrystepname", (Object)RESErrorMessageUtil.getStepStartName());
            } else {
                ((DynamicObject)entrys.get(0)).set("entrystepname", (Object)RESErrorMessageUtil.getStepPGStartName());
            }
        }
        return 0;
    }

    @Override
    public IMRPDataSourceResolver getDataSourceResolver() {
        return null;
    }

    @Override
    public void replaceService(Object service) {
        Class<?> aClass = service.getClass();
        this.services.put(aClass, service);
        if (service instanceof ResourcePlanScheme) {
            this.resourcePlanScheme = (ResourcePlanScheme)service;
        } else if (service instanceof IMRPEventManager) {
            this.mqManager = (IMRPEventManager)service;
        } else if (service instanceof CacheDatas) {
            this.cacheDatas = (CacheDatas)service;
        }
    }

    @Override
    public void onMasterLost() {
        DynamicObject runlog = this.orm.queryOne("mrp_caculate_log", "id", new QFilter[]{new QFilter("mrpid", "=", (Object)this.mrpContextId)});
        runlog = BusinessDataServiceHelper.loadSingle((Object)runlog.get("id"), (String)"mrp_caculate_log");
        String currentStatus = runlog.getString("calculatestatus");
        if (MRPExecuteStatus.RUNNING.getValue().equals(currentStatus)) {
            KDCloudLogRecorder logRecorder = new KDCloudLogRecorder(this.orm, runlog);
            logRecorder.createStepLog(runlog.getDynamicObjectCollection("entryentity").size() + 1, Tips.getCalcEnd());
            logRecorder.updateStepLog("entryresult", MRPExecuteStatus.ERROR_STOP.getAlias());
            logRecorder.updateStepLog("entrydetailmsg", "MRPCalcMaster lost");
            logRecorder.updateStepLog("entrydetailmsg_tag", "MRPCalcMaster lost");
            logRecorder.updateRunLog("calculatestatus", MRPExecuteStatus.ERROR_STOP.getValue());
            logRecorder.saveStepLog(true);
        }
    }

    @Override
    public int createRequireDatas(IMRPExecuteLogRecorder lr) {
        Long resid = 0L;
        HashSet<Long> collect = new HashSet(10);
        if ("1".equals(this.resourcePlanScheme.getFchkgroupplantype())) {
            resid = this.resourcePlanScheme.getplanResId();
            collect = this.resourcePlanScheme.getEnabledPlan();
            lr.updateStepLog("entrystepname", RESErrorMessageUtil.getstep1());
        } else {
            resid = this.resourcePlanScheme.getRequireResId();
            collect = this.resourcePlanScheme.getEnabledRequires();
            lr.updateStepLog("entrystepname", RESErrorMessageUtil.getstep4());
        }
        ResourecPlanModel require = new ResourecPlanModel(resid, Boolean.FALSE, this);
        this.resourcePlanScheme.setRequireData(require);
        long start = System.currentTimeMillis();
        int ret = require.fetchDatas(collect, lr, this);
        logger.warn(String.format("ctxid: %s, resrunner-requireRequireDatas, timecost: %s(ms)", this.getMRPContextId(), System.currentTimeMillis() - start));
        return ret;
    }

    @Override
    public int createSupplyDatas(IMRPExecuteLogRecorder lr) {
        Long resid = 0L;
        HashSet<Long> collect = new HashSet(10);
        if ("1".equals(this.resourcePlanScheme.getFchkgroupplantype())) {
            resid = this.resourcePlanScheme.getlistResId();
            collect = this.resourcePlanScheme.getEnabledList();
            lr.updateStepLog("entrystepname", RESErrorMessageUtil.getstep2());
        } else {
            resid = this.resourcePlanScheme.getSupplyResId();
            collect = this.resourcePlanScheme.getEnabledSupplys();
            lr.updateStepLog("entrystepname", RESErrorMessageUtil.getstep5());
        }
        ResourecPlanModel require = new ResourecPlanModel(resid, Boolean.TRUE, this);
        this.resourcePlanScheme.setSupplyData(require);
        long start = System.currentTimeMillis();
        int ret = require.fetchDatas(collect, lr, this);
        logger.warn(String.format("ctxid: %s, resrunner-SupplyDatas, timecost: %s(ms)", this.getMRPContextId(), System.currentTimeMillis() - start));
        return ret;
    }

    @Override
    public BOMStructDataTable createBOMDatas(IMRPExecuteLogRecorder lr) {
        ResourecPlanModel requireData = this.resourcePlanScheme.getRequireData();
        AbstractResModelDataTable reqtable = requireData.getTable();
        ResourecPlanModel SupplyData = this.resourcePlanScheme.getSupplyData();
        AbstractResModelDataTable suptable = SupplyData.getTable();
        if ("1".equals(this.resourcePlanScheme.getFchkgroupplantype())) {
            EqNeedPlanManager eqmanager = new EqNeedPlanManager();
            Map<Long, EqNeedPlanModel> reqmap = eqmanager.getReqMap(reqtable, lr);
            eqmanager.setMaxAndMinDate(reqmap);
            Map<String, List<EqNeedPlanEntryModel>> supmap = eqmanager.getSupMap(suptable, lr);
            if (supmap != null && !supmap.isEmpty()) {
                eqmanager.saveBill(reqmap, supmap, lr, this.getRunLog().getLong("id"));
            }
            EqToolNeedPlanManager tma = new EqToolNeedPlanManager();
            tma.saveBill(reqmap, suptable, lr, this.getRunLog().getLong("id"));
            lr.updateStepLog("entrystepname", RESErrorMessageUtil.getstep3());
        } else {
            EqEassManger eqem = new EqEassManger();
            eqem.saveBill(reqtable, suptable, this.resourcePlanScheme, lr, this.getRunLog().getLong("id"));
            lr.updateStepLog("entrystepname", RESErrorMessageUtil.getstep6());
        }
        return null;
    }

    @Override
    public void setCurrentResolveMaterial(String materialId) {
        this.fStepname = materialId;
    }

    @Override
    public String getCurrentResolveMaterial() {
        return this.fStepname;
    }

    @Override
    public DynamicObject getRunLog() {
        return this.runLogModel.getRunLog();
    }

    @Override
    public <T> T getService(Class<?> clazz) {
        return (T)this.services.get(clazz);
    }

    @Override
    public void addService(Class<?> clazz, Object service) {
        this.services.put(clazz, service);
    }

    public long getResSchemeId() {
        return this.resourcePlanScheme.getSchemeId() == null ? 0L : this.resourcePlanScheme.getSchemeId();
    }

    @Override
    public String getRunLogNumber() {
        return this.runLogNumber;
    }

    @Override
    public String getPlanOrgId() {
        return null;
    }

    @Override
    public String getPlanId() {
        return String.valueOf(this.runLogModel.getPlanId());
    }

    @Override
    public <T> T getCfgValue(EnvCfgItem item) {
        return this.sysConfigManager.getCfgValue(item);
    }

    @Override
    public String getMRPContextId() {
        return this.mrpContextId;
    }

    @Override
    public void setShutdown() {
        this.isShutdown = true;
    }

    @Override
    public int initWorkCalendars() {
        return 0;
    }

    @Override
    public int saveCalcDetails() {
        return 0;
    }

    @Override
    public void testEnvStatus() {
        if (this.isShutdown()) {
            throw new MRPManuStopException();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public void runTask(MRPEvent event) {
        this.mqManager.publishCalcEvent(event);
    }

    @Override
    public void wait4Response() {
        this.mqManager.wait4Response();
    }

    @Override
    public IMRPEventManager getMQManager() {
        return this.mqManager;
    }

    @Override
    public IMRPDataFetcher createDataFetcher() {
        return new KDCloudDataFetcher(this);
    }

    @Override
    public IMRPCallableConfigurator createCallableConfigurator() {
        return new IMRPCallableConfigurator(){
            private RequestContext bosCtx;

            @Override
            public void restore() {
                RequestContext.set((RequestContext)this.bosCtx);
            }

            @Override
            public void init() {
                this.bosCtx = RequestContext.get();
            }
        };
    }

    @Override
    public IMRPExecuteLogRecorder createLogRecorder() {
        return this.logRecorder;
    }

    @Override
    public String getRunModeName() {
        return this.runLogModel.getRunModeName();
    }

    @Override
    public String getRunMode() {
        return this.runLogModel.getRunMode();
    }

    @Override
    public String getRunLogPlanOrgId() {
        return this.runLogModel.getRunLogPlanOrgId();
    }

    @Override
    public void clearRuntimeEnv() {
    }

    @Override
    public Date getPlanDate() {
        return this.runLogModel.getPlanDate();
    }

    @Override
    public Long getPlanTs() {
        return this.runLogModel.getPlanTs();
    }

    @Override
    public String getRunLogPlanOrgName() {
        return this.runLogModel.getRunLogPlanOrgName();
    }

    @Override
    public void tearDown() {
        BaseDataServiceHelper.clearCache((DynamicObject)this.runLogModel.getRunLog());
    }

    private void loadSysConfiguration() {
        this.sysConfigManager.load();
    }

    @Override
    public int getOrderModelData() {
        return 0;
    }

    @Override
    public int initSchemeModel() {
        return 0;
    }

    @Override
    public int getCycle() {
        return 0;
    }

    @Override
    public void setFilter(QFilter qFilter) {
    }

    @Override
    public long getPlsSchemeId() {
        return this.resourcePlanScheme.getSchemeId() == null ? 0L : this.resourcePlanScheme.getSchemeId();
    }

    @Override
    public IMRPDataSaveResolver createMappingSaver() {
        return null;
    }
}

