/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.crud.read.SelectFieldBuilder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.integrate.DataTranslator;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.ResDataModel;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.integrate.utils.SnapshotDataIntegrateUtils;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.mservice.service.datasync.MMCSnapDataVisitor;

public class CacheDatas {
    private static final Log logger = LogFactory.getLog(CacheDatas.class);
    private Long versionId;
    private final Map<String, IDataEntityType> entityTypeCache = new HashMap<String, IDataEntityType>();
    private static final String REDIS_UNIT = "unit";
    private String runLogNumber;
    private final CalEnv env;
    private final Map<String, DynamicObject> planTags = new HashMap<String, DynamicObject>();
    private final Map<String, QFilter> invInfoOrgFilter = new HashMap<String, QFilter>();
    private final Map<String, String> mConfigPropertiesCache = new HashMap<String, String>();
    private final Map<String, Long> manuStrategyCache = new HashMap<String, Long>();
    private final Map<String, Long> trackStrategyCache = new HashMap<String, Long>();
    private Map<String, HashMap<String, Object>> id2ObjCache = new HashMap<String, HashMap<String, Object>>();
    private Map<String, DynamicObject> id2DynamicObjectCache = new HashMap<String, DynamicObject>();
    private Map<String, DynamicObject> nullFieldsObjectCache = new HashMap<String, DynamicObject>();
    private static final String REDIS_META = "meta-id";
    private DataTranslator dt = new DataTranslator();
    private ORM orm = ORM.create();
    private final Map<Long, Long> supplyOrg2PurOrg = new HashMap<Long, Long>(16);
    private final Map<String, Long> orgAndWarehouse2PlanScope = new HashMap<String, Long>(16);
    private final Map<String, Long[]> orgAndPlanScope2InWarehouse = new HashMap<String, Long[]>(16);
    private final Map<String, QFilter> org2MftFilter = new HashMap<String, QFilter>(16);
    private final Map<String, Object[]> orgAndMaterial2MftData = new HashMap<String, Object[]>(16);
    private final Map<String, Object[]> id2MftData = new HashMap<String, Object[]>(16);
    private final Map<String, Long[]> id2MftVersionData = new HashMap<String, Long[]>(16);
    private final Map<String, Long[]> orgAndMftInfo2MftVersionData = new HashMap<String, Long[]>(16);
    private final Map<String, Boolean> havValidPlanScopeByOrg = new HashMap<String, Boolean>(16);
    private final Map<Long, Set<Long>> warehouse2org = new HashMap<Long, Set<Long>>(16);
    private final Map<String, Map<String, String>> planScopeCache = new HashMap<String, Map<String, String>>();
    private Map<String, Set<String>> orgAndMid2scope = null;
    private Set<String> selectMaterialOrg = null;
    private Boolean isSelectMaterialPlan4PlanScope = null;
    private final Map<String, Set<Long>> llcToDeleteBills = new HashMap<String, Set<Long>>(16);
    private Map<Long, Set<Long>> childByFeatureTypeCache = new HashMap<Long, Set<Long>>(16);
    private Set<String> dependDataSourceIds;
    private Map<String, Set<Long>> selectBillMap = new HashMap<String, Set<Long>>(2);

    public CacheDatas(CalEnv env) {
        this.env = env;
        env.addService(CacheDatas.class, this);
    }

    public void init() {
        RunLogModel runLogModel = (RunLogModel)this.env.getService(RunLogModel.class);
        this.runLogNumber = runLogModel.getRunLogNumber();
    }

    public DataSet loadCacheDatas(String etStr, String selectFields, QFilter[] filters) {
        return this.loadCacheDatas(etStr, selectFields, filters, null);
    }

    public DataSet loadCacheDatas(String etStr, String selectFields, QFilter[] filters, String orderBys) {
        if (this.versionId == null) {
            this.versionId = SnapshotDataIntegrateUtils.getVersionIdByRunLogNumber(this.runLogNumber);
        }
        if (this.versionId == null || this.versionId == 0L) {
            return null;
        }
        if (selectFields == null) {
            selectFields = new SelectFieldBuilder(etStr, this.entityTypeCache).buildSelectFields(true);
        }
        return new MMCSnapDataVisitor().localFastDataVisit(this.versionId, null, etStr, selectFields, filters, orderBys);
    }

    public Map<String, IDataEntityType> getEntityTypeCache() {
        return this.entityTypeCache;
    }

    public Map<String, QFilter> getInvInfoOrgFilter() {
        return this.invInfoOrgFilter;
    }

    public Map<String, String> getmConfigPropertiesCache() {
        return this.mConfigPropertiesCache;
    }

    public Map<String, Object[]> getOrgAndMaterial2MftData() {
        return this.orgAndMaterial2MftData;
    }

    public Map<String, Long> getTrackStrategyCache() {
        return this.trackStrategyCache;
    }

    public String getConfigProperties(String materialId) {
        String configProperties = null;
        if (!this.getmConfigPropertiesCache().containsKey(materialId)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(materialId))};
            try (DataSet dataSet = this.orm.queryDataSet(this.getClass().getSimpleName(), "bd_material", "id,configproperties", filters, null, 1);){
                if (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    configProperties = row.getString("configProperties");
                }
            }
            this.getmConfigPropertiesCache().put(materialId, configProperties);
        } else {
            configProperties = this.getmConfigPropertiesCache().get(materialId);
        }
        return configProperties;
    }

    public Map<String, Long> getManuStrategyCache() {
        return this.manuStrategyCache;
    }

    public String[] getPlanTagInfo(String id) {
        String[] str = new String[]{"", ""};
        if (kd.bos.util.StringUtils.isBlank((String)id) || "null".equals(id) || "0".equals(id)) {
            return str;
        }
        DynamicObject tag = this.planTags.get(id);
        if (tag == null) {
            tag = this.reloadDataById("mpdm_plantag", Long.valueOf(id));
            this.planTags.put(id, tag);
        }
        str[0] = tag.getString("number");
        str[1] = tag.getString("name");
        return str;
    }

    public DynamicObject reloadDataById(String metaKey, Object id) {
        return this.reloadDataById(metaKey, id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject reloadDataById(String metaKey, Object id, String fields) {
        HashMap map;
        Object ret = null;
        StringBuilder sb = new StringBuilder();
        sb.append(metaKey).append("\u0001").append(id).append("\u0001").append(fields);
        String key = sb.toString();
        if (this.id2ObjCache.containsKey(key)) {
            return this.id2DynamicObjectCache.get(key);
        }
        if (fields == null && this.nullFieldsObjectCache.containsKey(String.valueOf(id))) {
            return this.nullFieldsObjectCache.get(String.valueOf(id));
        }
        String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(this.env.getMRPContextId(), key);
        String cacheVal = MRPCacheManager.getInst().getSubData(this.env, REDIS_META, cacheKey);
        if (cacheVal != null) {
            map = this.dt.deserialize(cacheVal, HashMap.class);
            ret = this.orm.newDynamicObject(metaKey);
            for (Map.Entry e : map.entrySet()) {
                ret.set((String)e.getKey(), e.getValue());
            }
        } else {
            if (fields == null) {
                key = String.valueOf(id);
                if (this.nullFieldsObjectCache.containsKey(key)) {
                    return this.nullFieldsObjectCache.get(key);
                }
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(id.toString()))};
                DataSet cds = this.loadCacheDatas(metaKey, null, filters);
                if (cds != null) {
                    try {
                        DynamicObjectCollection c = SnapshotDataIntegrateUtils.wrap(SnapshotDataIntegrateUtils.wrap(cds), metaKey, this.getEntityTypeCache(), 1);
                        ret = c.size() > 0 ? (DynamicObject)c.get(0) : null;
                        this.nullFieldsObjectCache.put(key, (DynamicObject)ret);
                        DynamicObject dynamicObject = ret;
                        return dynamicObject;
                    }
                    finally {
                        cds.close();
                    }
                }
                DynamicObject obj = null;
                if (this.orm.exists(metaKey, (Object)Long.valueOf(id.toString()))) {
                    obj = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(id.toString()), (String)metaKey);
                }
                this.nullFieldsObjectCache.put(key, obj);
                return obj;
            }
            map = new HashMap();
            if (this.orm.exists(metaKey, (Object)Long.valueOf(id.toString()))) {
                ret = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(id.toString()), (String)metaKey, (String)fields);
            }
            if (ret == null) {
                ret = this.orm.newDynamicObject(metaKey);
                logger.warn(String.format("mrprunner-mrpenv-loaddatafailed: metaKey: %s, id: %s, fields: %s", metaKey, id, fields));
                logger.warn("mrprunner-mrpenv-loaddatafailed-stacktrace", new RuntimeException().fillInStackTrace());
            } else {
                String[] cols = fields.split(",");
                for (int i = 0; i < cols.length; ++i) {
                    String field = cols[i].trim();
                    map.put(field, ret.get(field));
                }
            }
            MRPCacheManager.getInst().putSubData(this.env, REDIS_META, cacheKey, this.dt.serialize(map));
        }
        this.id2ObjCache.put(key, map);
        this.id2DynamicObjectCache.put(key, (DynamicObject)ret);
        return ret;
    }

    public void batchRelodDataPutCache(String metaKey, Set<Object> ids, String fields) {
        String key;
        DynamicObject[] load = fields == null ? BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)metaKey).getDynamicObjectType()) : BusinessDataServiceHelper.load((String)metaKey, (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DynamicObject obj : load) {
            sb.setLength(0);
            sb.append(metaKey).append("\u0001").append(obj.getPkValue()).append("\u0001").append(fields);
            key = sb.toString();
            if (fields != null) {
                String[] cols = fields.split(",");
                map = new HashMap();
                for (int i = 0; i < cols.length; ++i) {
                    String field = cols[i].trim();
                    map.put(field, obj.get(field));
                }
            }
            this.id2ObjCache.put(key, map);
            this.id2DynamicObjectCache.put(key, obj);
            ids.remove(obj.getPkValue());
        }
        for (Object e : ids) {
            sb.setLength(0);
            sb.append(metaKey).append("\u0001").append(e).append("\u0001").append(fields);
            key = sb.toString();
            this.id2ObjCache.put(key, map);
            this.id2DynamicObjectCache.put(key, BusinessDataServiceHelper.newDynamicObject((String)metaKey));
        }
    }

    public Map<String, HashMap<String, Object>> getId2ObjCache() {
        return this.id2ObjCache;
    }

    public Map<String, DynamicObject> getId2DynamicObjectCache() {
        return this.id2DynamicObjectCache;
    }

    public String[] getOrgById(String orgId) {
        DynamicObject org;
        String[] str = new String[]{"", ""};
        DynamicObject dynamicObject = org = kd.bos.util.StringUtils.isEmpty((String)orgId) || orgId.equalsIgnoreCase("null") ? null : this.reloadDataById("bos_org", orgId, "number,name,id");
        if (org != null) {
            str[0] = org.getString("name");
        }
        return str;
    }

    public HashMap<Integer, String> getUnit(Object unitId) {
        HashMap<String, Object> unit;
        HashMap<Integer, String> unitMap = new HashMap<Integer, String>();
        unitMap.put(1, "4");
        unitMap.put(2, "1");
        if (unitId == null) {
            return unitMap;
        }
        Map<String, HashMap<String, Object>> id2ObjCache = this.getId2ObjCache();
        if (id2ObjCache.containsKey(String.valueOf(unitId))) {
            unit = id2ObjCache.get(String.valueOf(unitId));
        } else {
            String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(this.env.getMRPContextId(), unitId.toString());
            String cacheVal = MRPCacheManager.getInst().getSubData(this.env, REDIS_UNIT, cacheKey);
            if (cacheVal != null) {
                unit = this.dt.deserialize(cacheVal, HashMap.class);
                id2ObjCache.put(String.valueOf(unitId), unit);
            } else {
                String selectFields = "id,precisionaccount,precision";
                DynamicObject dUnit = this.reloadDataById("bd_measureunits", unitId, selectFields);
                unit = new HashMap<String, Object>();
                if (dUnit != null) {
                    String[] fields;
                    for (String field : fields = selectFields.split(",")) {
                        unit.put(field.trim(), dUnit.get(field));
                    }
                }
                cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(this.env.getMRPContextId(), String.valueOf(unitId));
                MRPCacheManager.getInst().putSubData(this.env, REDIS_UNIT, cacheKey, this.dt.serialize(unit));
            }
            id2ObjCache.put(String.valueOf(unitId), unit);
        }
        if (unit != null) {
            Object obj = unit.get("precision");
            unitMap.put(1, obj == null ? "4" : obj.toString());
            obj = unit.get("precisionaccount");
            unitMap.put(2, obj == null ? "1" : obj.toString());
        }
        return unitMap;
    }

    public Long getPurOrgBySupplyOrg(Long orgId) {
        boolean fispurchase;
        if (this.supplyOrg2PurOrg.containsKey(orgId)) {
            return this.supplyOrg2PurOrg.get(orgId);
        }
        QFilter idFilter = new QFilter("id", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"fispurchase", (QFilter[])filters);
        boolean bl = fispurchase = orgObj != null && orgObj.getBoolean("fispurchase");
        if (fispurchase) {
            this.supplyOrg2PurOrg.put(orgId, orgId);
            return orgId;
        }
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setToViewType("02");
        param.setDirectViewType("toorg");
        Map map = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
        Long purOrg = 0L;
        List data = (List)map.get("data");
        if (data != null) {
            for (Map res : data) {
                Long org = MRPUtil.convert(res.get("orgId"), 0L);
                Boolean isDefault = MRPUtil.convert(res.get("isDefault"), Boolean.FALSE);
                if (purOrg == 0L) {
                    purOrg = org;
                }
                if (!isDefault.booleanValue()) continue;
                purOrg = org;
                break;
            }
        }
        this.supplyOrg2PurOrg.put(orgId, purOrg);
        return purOrg;
    }

    public Long getPlanScope4orgAndWarehouse(Long org, Long warehouse) {
        String key = org.toString() + '\u0001' + warehouse.toString();
        if (this.orgAndWarehouse2PlanScope.containsKey(key)) {
            return this.orgAndWarehouse2PlanScope.get(key);
        }
        Long planScope = 0L;
        if (warehouse > 0L) {
            QFilter qFilterOrg = new QFilter("createorg", "=", (Object)org);
            QFilter qFilterWareHouse = new QFilter("warehouse", "=", (Object)warehouse);
            QFilter qFilter = new QFilter("effectuate_type", "=", (Object)"A");
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"msplan_planscope_whs", (String)"planscope", (QFilter[])new QFilter[]{qFilterOrg, qFilterWareHouse, qFilter}, null, (int)1);){
                if (dataSet.hasNext()) {
                    planScope = dataSet.next().getLong(0);
                }
            }
            this.orgAndWarehouse2PlanScope.put(key, planScope);
        }
        return planScope;
    }

    public Long[] getInWarehouse4orgAndPlanScope(Long org, Long planScope) {
        String key = org.toString() + '\u0001' + planScope.toString();
        if (this.orgAndPlanScope2InWarehouse.containsKey(key)) {
            return this.orgAndPlanScope2InWarehouse.get(key);
        }
        Long warehouse = 0L;
        Long invorg = 0L;
        QFilter qFilterOrg = new QFilter("createorg", "=", (Object)org);
        QFilter qFilterPlanscope = new QFilter("planscope", "=", (Object)planScope);
        QFilter qFilter = new QFilter("effectuate_type", "=", (Object)"A");
        qFilter.and(new QFilter("is_ininv_whs", "=", (Object)true));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"msplan_planscope_whs", (String)"warehouse,invorg", (QFilter[])new QFilter[]{qFilterOrg, qFilter, qFilterPlanscope}, null, (int)1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                warehouse = row.getLong(0);
                invorg = row.getLong(1);
            }
        }
        Long[] longs = new Long[]{warehouse, invorg};
        this.orgAndPlanScope2InWarehouse.put(key, longs);
        return longs;
    }

    public Object[] getMftData4OrgAndMaterial(Long org, Long material) {
        String key = org.toString() + '\u0001' + material.toString();
        Object[] datas = this.orgAndMaterial2MftData.get(key);
        if (datas == null) {
            PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
            QFilter qFilter = this.org2MftFilter.get(org.toString());
            if (qFilter == null) {
                qFilter = planModel.isEnablePlanScope() ? new QFilter("createorg", "=", (Object)org) : BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)org);
                this.org2MftFilter.put(org.toString(), qFilter);
            }
            QFilter maFilter = new QFilter("masterid", "=", (Object)material);
            QFilter dataFilter = new QFilter("status", "=", (Object)"C");
            dataFilter.and(new QFilter("enable", "=", (Object)"1"));
            if (!"IGNORE".equals(this.env.getCfgValue(EnvCfgItem.MATERIAL_PLAN_INFO_SETTINGS))) {
                maFilter.and(dataFilter);
            }
            datas = new Object[10];
            Long id = 0L;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"bd_materialmftinfo", (String)this.getMftSelect(), (QFilter[])new QFilter[]{maFilter, qFilter}, (String)"id desc");){
                for (Row row : dataSet) {
                    Long createorg = row.getLong("createorg");
                    id = row.getLong("id");
                    this.putMftData(datas, row);
                    if (!org.equals(createorg)) continue;
                    break;
                }
            }
            this.orgAndMaterial2MftData.put(key, datas);
            if (id > 0L) {
                this.id2MftData.put(id.toString(), datas);
            }
        }
        return datas;
    }

    public Object[] getMftData4Id(Long id) {
        Object[] datas = this.id2MftData.get(id.toString());
        if (datas == null) {
            QFilter qFilter = new QFilter("id", "=", (Object)id);
            datas = new Object[10];
            String key = "";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"bd_materialmftinfo", (String)this.getMftSelect(), (QFilter[])new QFilter[]{qFilter}, null, (int)1);){
                if (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long createorg = row.getLong("createorg");
                    Long material = row.getLong("masterid");
                    this.putMftData(datas, row);
                    key = createorg.toString() + '\u0001' + material.toString();
                }
            }
            this.id2MftData.put(id.toString(), datas);
            if (kd.bos.util.StringUtils.isNotEmpty((String)key)) {
                this.orgAndMaterial2MftData.put(key, datas);
            }
        }
        return datas;
    }

    private void putMftData(Object[] datas, Row row) {
        datas[0] = row.get("supplyorgunitid");
        datas[1] = row.get("warehouse");
        datas[2] = row.get("location");
        datas[3] = row.get("inwarorg");
        datas[4] = row.get("inwarehouse");
        datas[5] = row.get("inwarelocation");
        datas[6] = row.get("invinfosrc");
        datas[7] = row.get("id");
        datas[8] = row.get("createorg");
        datas[9] = row.get("isstockallot");
    }

    private String getMftSelect() {
        return "createorg,masterid,supplyorgunitid,warehouse,location,inwarorg,inwarehouse,inwarelocation,invinfosrc,isstockallot,id";
    }

    public Long[] getMftVersion4orgAndMftInfo(MftVersionQueryParam mftVersionQueryParam, Long expendBomTime, BigDecimal rQty) {
        String key = mftVersionQueryParam.toString() + '\u0001' + expendBomTime.toString() + '\u0001' + rQty.stripTrailingZeros().toPlainString();
        if (this.orgAndMftInfo2MftVersionData.containsKey(key)) {
            return this.orgAndMftInfo2MftVersionData.get(key);
        }
        Date date = new Date(expendBomTime);
        ArrayList params = new ArrayList(1);
        HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>(16);
        map.put("bizorg", mftVersionQueryParam.getBizorg());
        map.put("material", mftVersionQueryParam.getMaterial());
        map.put("materialInfo", mftVersionQueryParam.getMaterialMftInfo());
        map.put("bomdate", date);
        map.put("qty", rQty);
        if (mftVersionQueryParam.getConfigure() != null) {
            map.put("configure", mftVersionQueryParam.getConfigure());
        }
        if (mftVersionQueryParam.getAuxproperty() != null) {
            map.put("auxproperty", mftVersionQueryParam.getAuxproperty());
        }
        params.add(map);
        if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-getMftVersion4orgAndMftInfo-getBatchManuVersion: params: %s", map));
        }
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IAutoSetManuVersionService", (String)"getBatchManuVersion", (Object[])new Object[]{params});
        Set versionDyns = (Set)((Map)resMap.getOrDefault(mftVersionQueryParam.getBizorg(), new HashMap(0))).get(mftVersionQueryParam.getMaterial());
        if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-getMftVersion4orgAndMftInfo-getBatchManuVersion: result: %s", versionDyns));
        }
        DynamicObject versionDyn = null;
        if (versionDyns != null) {
            for (DynamicObject v : versionDyns) {
                if (v == null) continue;
                versionDyn = v;
                break;
            }
        }
        Long[] longs = new Long[6];
        this.orgAndMftInfo2MftVersionData.put(key, longs);
        if (versionDyn != null && versionDyn.getLong("id") > 0L) {
            longs[0] = versionDyn.containsProperty("supstockorgid") ? versionDyn.getLong("supstockorgid") : 0L;
            longs[1] = versionDyn.containsProperty("supwarehouseid") ? versionDyn.getLong("supwarehouseid") : 0L;
            longs[2] = versionDyn.containsProperty("suplocationid") ? versionDyn.getLong("suplocationid") : 0L;
            longs[3] = versionDyn.containsProperty("id") ? versionDyn.getLong("id") : 0L;
            longs[4] = versionDyn.containsProperty("workcenter") ? versionDyn.getLong("workcenter") : 0L;
            longs[5] = versionDyn.containsProperty("bom") ? versionDyn.getLong("bom") : 0L;
            this.id2MftVersionData.put(versionDyn.getString("id"), longs);
        }
        return longs;
    }

    public Long[] getMftVersion4Id(Long id) {
        Long[] longs = this.id2MftVersionData.get(id.toString());
        if (longs == null) {
            longs = new Long[6];
            if (id > 0L) {
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"pdm_manuversion", (String)this.getMftVersionSelect(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}, null, (int)1);){
                    if (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        this.putMftVersionData(longs, row);
                    }
                }
                this.id2MftVersionData.put(id.toString(), longs);
            }
        }
        return longs;
    }

    private void putMftVersionData(Long[] longs, Row row) {
        longs[0] = row.getLong("supstockorgid");
        longs[1] = row.getLong("supwarehouseid");
        longs[2] = row.getLong("suplocationid");
        longs[3] = row.getLong("id");
        longs[4] = row.getLong("workcenter");
        longs[5] = row.getLong("bom");
    }

    private String getMftVersionSelect() {
        return "supstockorgid,supwarehouseid,suplocationid,id,createorg,workcenter,bom";
    }

    public boolean isValidPlanScopeByOrg(Long org, Long planScope) {
        String key = org.toString() + '\u0001' + planScope.toString();
        if (this.havValidPlanScopeByOrg.containsKey(key)) {
            return this.havValidPlanScopeByOrg.get(key);
        }
        boolean hav = false;
        QFilter qFilterOrg = new QFilter("createorg", "=", (Object)org);
        QFilter qFilterPlanscope = new QFilter("planscope", "=", (Object)planScope);
        QFilter qFilter = new QFilter("effectuate_type", "=", (Object)"A");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"msplan_planscope_whs", (String)"id", (QFilter[])new QFilter[]{qFilterOrg, qFilterPlanscope, qFilter}, null, (int)1);){
            if (dataSet.hasNext()) {
                hav = true;
            }
        }
        this.havValidPlanScopeByOrg.put(key, hav);
        return hav;
    }

    public Set<Long> getOrgByWarehouse(Long warehouse) {
        if (this.warehouse2org.containsKey(warehouse)) {
            return this.warehouse2org.get(warehouse);
        }
        HashSet<Long> orgs = new HashSet<Long>(2);
        QFilter qFilterwarehouse = new QFilter("warehouse", "=", (Object)warehouse);
        QFilter qFilterinitstatus = new QFilter("initstatus", "=", (Object)"B");
        QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"im_warehousesetup", (String)"org", (QFilter[])new QFilter[]{qFilterwarehouse, qFilter, qFilterinitstatus}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                orgs.add(row.getLong(0));
            }
        }
        this.warehouse2org.put(warehouse, orgs);
        return orgs;
    }

    public void batchQueryOrgByWarehouse(Set<Object> warehouseIds) {
        QFilter qFilterwarehouse = new QFilter("warehouse", "in", warehouseIds);
        QFilter qFilterinitstatus = new QFilter("initstatus", "=", (Object)"B");
        QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"im_warehousesetup", (String)"org,warehouse", (QFilter[])new QFilter[]{qFilterwarehouse, qFilter, qFilterinitstatus}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Set orgs = this.warehouse2org.computeIfAbsent(row.getLong("warehouse"), k -> new HashSet());
                orgs.add(row.getLong("org"));
            }
        }
    }

    public String getPlanScopeCache(String cacheKey, String planScope) {
        Map map = this.planScopeCache.computeIfAbsent(cacheKey, k -> new HashMap());
        if (map.containsKey(planScope)) {
            return (String)map.get(planScope);
        }
        MRPRedisStore dstore = MRPCacheManager.getDStore(this.env.getMRPContextId());
        Map info = (Map)dstore.mapGet("mpList_scope", cacheKey);
        String cacheValue = info != null ? (String)info.get(planScope) : null;
        map.put(planScope, cacheValue);
        return cacheValue;
    }

    public String getPlanScopeCache(String cacheKey, String planScope, boolean filterDisableData) {
        String cacheValue = this.getPlanScopeCache(cacheKey, planScope);
        boolean isEnable = filterDisableData && DataBalanceUtil.materialPlanScopeIsEnable(cacheValue);
        return isEnable ? cacheValue : null;
    }

    public boolean isSelectBillPlan() {
        RunLogModel runLogModel = (RunLogModel)this.env.getService(RunLogModel.class);
        return runLogModel.getRunMode().equals("mrp_selectbillplan");
    }

    public boolean isSelectMaterialPlan() {
        RunLogModel runLogModel = (RunLogModel)this.env.getService(RunLogModel.class);
        return runLogModel.getRunMode().equals("mrp_selectmaterialplan");
    }

    public boolean isSelectMaterialPlan4PlanScope() {
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        if (this.isSelectMaterialPlan4PlanScope == null) {
            String json = MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getSelectMaterialOrgKey(this.env.getMRPContextId()));
            this.isSelectMaterialPlan4PlanScope = planModel.isEnablePlanScope() && json != null;
        }
        return this.isSelectMaterialPlan4PlanScope;
    }

    public Set<String> getSelectMaterialPlanScope(CalEnv env, String org, String material) {
        if (!this.getSelectMaterialOrg().contains(org)) {
            return null;
        }
        String key = org + '\u0001' + material;
        if (this.getOrgAndMid2scope().containsKey(key)) {
            return this.getOrgAndMid2scope().get(key);
        }
        String value = MRPCacheManager.getInst().getSubData(env, "materialscope_relation\u0001" + org, MRPRuntimeConsts.getSelectMaterialPlanScopeKey(env.getMRPContextId(), material));
        this.getOrgAndMid2scope().put(key, value == null ? null : new HashSet(JSON.parseArray((String)value, String.class)));
        return this.getOrgAndMid2scope().get(key);
    }

    public Map<String, Set<String>> getOrgAndMid2scope() {
        if (this.orgAndMid2scope == null) {
            this.orgAndMid2scope = new HashMap<String, Set<String>>(4);
        }
        return this.orgAndMid2scope;
    }

    public Set<String> getSelectMaterialOrg() {
        if (this.selectMaterialOrg == null) {
            this.selectMaterialOrg = new HashSet<String>(0);
            String json = MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getSelectMaterialOrgKey(this.env.getMRPContextId()));
            if (json != null) {
                this.selectMaterialOrg = new HashSet<String>(JSON.parseArray((String)json, String.class));
            }
            PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
            this.selectMaterialOrg.retainAll(planModel.getRequirorgs());
        }
        return this.selectMaterialOrg;
    }

    public Set<Long> getDeleteBillsByLlc(Integer llc, String billEntity) {
        RequireDataModel requireDataModel = (RequireDataModel)this.env.getService(RequireDataModel.class);
        String outputType = requireDataModel.getOutputType();
        String outputCollaborativeorder = requireDataModel.getOutputCollaborativeorder();
        if (!StringUtils.equals((CharSequence)outputType, (CharSequence)billEntity) && !StringUtils.equals((CharSequence)outputCollaborativeorder, (CharSequence)billEntity)) {
            return new HashSet<Long>(0);
        }
        String key = llc.toString() + '\u0001' + billEntity;
        if (this.llcToDeleteBills.containsKey(key)) {
            return this.llcToDeleteBills.get(key);
        }
        HashSet<Long> bills = new HashSet<Long>(2);
        String value = MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getDynamicDeleteDataKey(this.env.getMRPContextId(), llc, billEntity));
        if (StringUtils.isNotBlank((CharSequence)value)) {
            bills.addAll(JSON.parseArray((String)value, Long.class));
        }
        this.llcToDeleteBills.put(key, bills);
        return bills;
    }

    public void setDeleteBillsByLlc(Integer llc, String billEntity, Set<Long> bills) {
        String key = llc.toString() + '\u0001' + billEntity;
        this.llcToDeleteBills.put(key, bills);
    }

    public void batchQueryMftInfo(Map<String, Set<Long>> mftInfoMap) {
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        if (!mftInfoMap.isEmpty()) {
            for (Map.Entry<String, Set<Long>> entry : mftInfoMap.entrySet()) {
                QFilter qFilterUseOrg = this.org2MftFilter.get(entry.getKey());
                if (qFilterUseOrg == null) {
                    qFilterUseOrg = planModel.isEnablePlanScope() ? new QFilter("createorg", "=", (Object)Long.valueOf(entry.getKey())) : BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.valueOf(entry.getKey()));
                    this.org2MftFilter.put(entry.getKey(), qFilterUseOrg);
                }
                QFilter maFilter = new QFilter("masterid", "in", entry.getValue());
                QFilter dataFilter = new QFilter("status", "=", (Object)"C");
                dataFilter.and(new QFilter("enable", "=", (Object)"1"));
                if (!"IGNORE".equals(this.env.getCfgValue(EnvCfgItem.MATERIAL_PLAN_INFO_SETTINGS))) {
                    maFilter.and(dataFilter);
                }
                QFilter[] filters = new QFilter[]{maFilter, qFilterUseOrg, dataFilter};
                DataSet dataSet = this.orm.queryDataSet(ResDataModel.class.getSimpleName(), "bd_materialmftinfo", this.getMftSelect(), filters, "id desc");
                Throwable throwable = null;
                try {
                    String key;
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        Long createorg = row.getLong("createorg");
                        Long id = row.getLong("id");
                        key = String.format("%s\u0001%s", entry.getKey(), row.getLong("masterid"));
                        Object[] datas = new Object[10];
                        this.putMftData(datas, row);
                        if (createorg == Long.parseLong(entry.getKey())) {
                            this.orgAndMaterial2MftData.put(key, datas);
                        } else if (!this.orgAndMaterial2MftData.containsKey(key)) {
                            this.orgAndMaterial2MftData.put(key, datas);
                        }
                        this.id2MftData.put(id.toString(), datas);
                        entry.getValue().remove(row.getLong("masterid"));
                    }
                    for (Long masterid : entry.getValue()) {
                        key = String.format("%s\u0001%s", entry.getKey(), masterid);
                        this.orgAndMaterial2MftData.putIfAbsent(key, new Object[10]);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataSet == null) continue;
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataSet.close();
                }
            }
        }
    }

    public void batchQueryTrackStrategy(Set<Long> trackNumberIds) {
        if (!trackNumberIds.isEmpty()) {
            QFilter dataFilter = new QFilter("id", "in", trackNumberIds);
            QFilter[] filters = new QFilter[]{dataFilter};
            String select = "id,manustrategy";
            HashSet<Long> manuSet = new HashSet<Long>();
            try (DataSet dataSet = this.orm.queryDataSet(ResDataModel.class.getSimpleName(), "bd_tracknumber", select, filters, "id desc");){
                String key;
                while (dataSet.hasNext()) {
                    Row row2 = dataSet.next();
                    Long trackNumberId = row2.getLong("id");
                    Long manustrategy = row2.getLong("manustrategy");
                    key = trackNumberId.toString();
                    if (!this.trackStrategyCache.containsKey(key)) {
                        this.trackStrategyCache.put(key, manustrategy);
                    }
                    manuSet.add(manustrategy);
                    trackNumberIds.remove(trackNumberId);
                }
                for (Long trackNumberId : trackNumberIds) {
                    key = trackNumberId.toString();
                    this.trackStrategyCache.putIfAbsent(key, 0L);
                }
                String selectField = "id,traceway,invisolation,allowdrop";
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_manustrategy", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", manuSet)});
                StringBuilder sb = new StringBuilder();
                HashMap m = new HashMap(load.length);
                for (DynamicObject ret : load) {
                    sb.setLength(0);
                    sb.append("bd_manustrategy").append("\u0001").append(ret.getPkValue()).append("\u0001").append(selectField);
                    key = sb.toString();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String[] cols = selectField.split(",");
                    for (int i = 0; i < cols.length; ++i) {
                        String field = cols[i].trim();
                        map.put(field, ret.get(field));
                    }
                    String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(this.env.getMRPContextId(), key);
                    m.put(cacheKey, map);
                    this.id2ObjCache.put(key, map);
                    this.id2DynamicObjectCache.put(key, ret);
                }
                m.entrySet().forEach(row -> MRPCacheManager.getInst().putSubData(this.env, REDIS_META, (String)row.getKey(), this.dt.serialize(row.getValue())));
            }
        }
    }

    public void batchQueryManuStrategy(Map<String, Set<Long>> manuStrategyMap) {
        if (!manuStrategyMap.isEmpty()) {
            HashSet<Long> manuSet = new HashSet<Long>();
            for (Map.Entry<String, Set<Long>> entry : manuStrategyMap.entrySet()) {
                QFilter qFilterUseOrg = this.invInfoOrgFilter.get(entry.getKey());
                if (qFilterUseOrg == null) {
                    qFilterUseOrg = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)Long.valueOf(entry.getKey()));
                    this.invInfoOrgFilter.put(entry.getKey(), qFilterUseOrg);
                }
                QFilter dataFilter = new QFilter("status", "=", (Object)"C");
                dataFilter.and(new QFilter("enable", "=", (Object)"1"));
                QFilter mFilter = new QFilter("masterid", "in", entry.getValue());
                QFilter[] filters = new QFilter[]{mFilter, qFilterUseOrg, dataFilter};
                String select = "id,createorg,masterid,manustrategy";
                DataSet dataSet = this.orm.queryDataSet(ResDataModel.class.getSimpleName(), "bd_materialinventoryinfo", select, filters, "id desc");
                Throwable throwable = null;
                try {
                    String key;
                    while (dataSet.hasNext()) {
                        Row row2 = dataSet.next();
                        long createorg = row2.getLong("createorg");
                        key = String.format("%s\u0001%s", row2.getLong("masterid"), entry.getKey());
                        Long manustrategy = row2.getLong("manustrategy");
                        if (createorg == Long.parseLong(entry.getKey())) {
                            this.manuStrategyCache.put(key, manustrategy);
                        } else if (!this.manuStrategyCache.containsKey(key)) {
                            this.manuStrategyCache.put(key, manustrategy);
                        }
                        manuSet.add(manustrategy);
                        entry.getValue().remove(row2.getLong("masterid"));
                    }
                    for (Long masterid : entry.getValue()) {
                        key = String.format("%s\u0001%s", masterid, entry.getKey());
                        this.manuStrategyCache.putIfAbsent(key, 0L);
                    }
                    String selectField = "id,traceway,invisolation,allowdrop";
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_manustrategy", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", manuSet)});
                    StringBuilder sb = new StringBuilder();
                    HashMap m = new HashMap(load.length);
                    for (DynamicObject ret : load) {
                        sb.setLength(0);
                        sb.append("bd_manustrategy").append("\u0001").append(ret.getPkValue()).append("\u0001").append(selectField);
                        key = sb.toString();
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        String[] cols = selectField.split(",");
                        for (int i = 0; i < cols.length; ++i) {
                            String field = cols[i].trim();
                            map.put(field, ret.get(field));
                        }
                        String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(this.env.getMRPContextId(), key);
                        m.put(cacheKey, map);
                        this.id2ObjCache.put(key, map);
                        this.id2DynamicObjectCache.put(key, ret);
                    }
                    m.entrySet().forEach(row -> MRPCacheManager.getInst().putSubData(this.env, REDIS_META, (String)row.getKey(), this.dt.serialize(row.getValue())));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataSet == null) continue;
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataSet.close();
                }
            }
        }
    }

    public Set<Long> getChildByFeatureType(Long featuretype) {
        return this.getChildByFeatureTypes(Collections.singleton(featuretype));
    }

    public Set<Long> getChildByFeatureTypes(Set<Long> featuretypes) {
        HashSet<Long> childs = new HashSet<Long>(4);
        featuretypes = new HashSet<Long>(featuretypes);
        Iterator<Long> ites = featuretypes.iterator();
        while (ites.hasNext()) {
            Long featuretype = ites.next();
            if (this.childByFeatureTypeCache.containsKey(featuretype)) {
                childs.addAll((Collection<Long>)this.childByFeatureTypeCache.get(featuretype));
                ites.remove();
                continue;
            }
            this.childByFeatureTypeCache.put(featuretype, new HashSet(2));
        }
        if (!featuretypes.isEmpty()) {
            QFilter filter = new QFilter("featureinfo.featuretype", "in", featuretypes);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"pdm_proconfigscheme", (String)"id,materielnum,featureinfo.featuretype featuretype", (QFilter[])new QFilter[]{filter}, null);){
                for (Row row : dataSet) {
                    Long materielnum = row.getLong("materielnum");
                    Long featuretype = row.getLong("featuretype");
                    if (materielnum <= 0L) continue;
                    childs.add(materielnum);
                    Set newChilds = this.childByFeatureTypeCache.computeIfAbsent(featuretype, k -> new HashSet(2));
                    newChilds.add(materielnum);
                }
            }
        }
        return childs;
    }

    public Set<String> getDependDataSourceIds() {
        if (this.dependDataSourceIds == null) {
            String json = MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getIsDependRequireDataSourceKey(this.env.getMRPContextId()));
            this.dependDataSourceIds = json != null ? new HashSet(JSON.parseArray((String)json, String.class)) : new HashSet(0);
        }
        return this.dependDataSourceIds;
    }

    public boolean isSelectBillRequire(String resId, Long id, Long entryId) {
        Set bills = this.selectBillMap.computeIfAbsent(resId, k -> {
            String jsonStr = MRPCacheManager.getInst().getSubData(this.env, "selectbills", MRPRuntimeConsts.getSelectBillDataKey(this.env.getMRPContextId(), resId));
            if (jsonStr == null) {
                return new HashSet(0);
            }
            List list = JSON.parseArray((String)jsonStr, Object[].class);
            String billEntryKey = null;
            HashSet<Long> ids = new HashSet<Long>(list.size());
            for (Object[] obj : list) {
                Long billId = MRPUtil.convert(obj[0], 0L);
                Long billEntryId = MRPUtil.convert(obj[1], 0L);
                if (kd.bos.util.StringUtils.isEmpty(billEntryKey)) {
                    billEntryKey = MRPUtil.convert(obj[2], "");
                }
                if (kd.bos.util.StringUtils.isNotEmpty(billEntryKey) && billEntryId > 0L) {
                    ids.add(billEntryId);
                    continue;
                }
                if (billId <= 0L) continue;
                ids.add(billId);
            }
            return ids;
        });
        return bills.contains(entryId > 0L ? entryId : id);
    }

    public static class MftVersionQueryParam {
        private final Long bizorg;
        private final Long material;
        private Long materialMftInfo = 0L;
        private Long configure = null;
        private Long auxproperty = null;

        public MftVersionQueryParam(Long bizorg, Long material) {
            this.bizorg = bizorg;
            this.material = material;
        }

        public Long getBizorg() {
            return this.bizorg;
        }

        public Long getMaterialMftInfo() {
            return this.materialMftInfo;
        }

        public void setMaterialMftInfo(Long materialMftInfo) {
            this.materialMftInfo = materialMftInfo;
        }

        public Long getMaterial() {
            return this.material;
        }

        public Long getConfigure() {
            return this.configure;
        }

        public void setConfigure(Long configure) {
            this.configure = configure;
        }

        public Long getAuxproperty() {
            return this.auxproperty;
        }

        public void setAuxproperty(Long auxproperty) {
            this.auxproperty = auxproperty;
        }

        public String toString() {
            return this.bizorg.toString() + '\u0001' + this.material.toString() + '\u0001' + (this.configure == null ? "0" : this.configure.toString()) + '\u0001' + (this.auxproperty == null ? "0" : this.auxproperty.toString());
        }
    }
}

