/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.integrate.entity.EqNeedPlanEntryModel;
import kd.mmc.mrp.integrate.entity.EqNeedPlanModel;
import kd.mmc.mrp.integrate.entity.EqToolModel;
import kd.mmc.mrp.integrate.entity.EqToolNeedPlanModel;
import kd.mmc.mrp.integrate.entity.billtask;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.res.RESErrorMessageUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class EqToolNeedPlanManager {
    ORM orm = ORM.create();
    private static final Log LOG = LogFactory.getLog(EqToolNeedPlanManager.class);
    private HashMap<Long, String> ordernumber = new HashMap();

    public void saveBill(Map<Long, EqNeedPlanModel> reqdata, AbstractResModelDataTable SupplyData, IMRPExecuteLogRecorder lr, Long logid) {
        Map<Long, EqToolNeedPlanModel> gkinfo = this.getGkinfo(SupplyData, lr);
        HashMap<Long, Set<Long>> projectAllWorkCard = new HashMap<Long, Set<Long>>(10);
        HashMap<Long, HashMap<Long, Set<Long>>> projectCardAllOrder = new HashMap<Long, HashMap<Long, Set<Long>>>(50);
        HashSet<Long> setorder = new HashSet<Long>(200);
        if (!reqdata.keySet().isEmpty()) {
            HashMap<Long, List<Map<String, Object>>> prjcardorder = this.getProjectAllWorkCard2(reqdata.keySet());
            for (Map.Entry<Long, List<Map<String, Object>>> itemprj : prjcardorder.entrySet()) {
                Long prjid = itemprj.getKey();
                HashMap<Long, Set<Long>> cardandorder = projectCardAllOrder.get(prjid);
                HashSet<Long> cardidset = new HashSet<Long>(20);
                for (Map<String, Object> xitem : itemprj.getValue()) {
                    Long cardid = (Long)xitem.get("workCardId");
                    cardidset.add(cardid);
                    Long orderid = (Long)xitem.get("workOrderId");
                    Set<Object> orderidset = new HashSet<Long>(20);
                    setorder.add(orderid);
                    if (cardandorder == null) {
                        cardandorder = new HashMap();
                        orderidset.add(orderid);
                        cardandorder.put(cardid, orderidset);
                        projectCardAllOrder.put(prjid, cardandorder);
                        continue;
                    }
                    orderidset = cardandorder.get(cardid);
                    if (orderidset == null) {
                        orderidset = new HashSet(20);
                        cardandorder.put(cardid, orderidset);
                    }
                    orderidset.add(orderid);
                }
                projectAllWorkCard.put(prjid, cardidset);
            }
        }
        if (setorder != null) {
            this.getOrderNumber(setorder);
        }
        if (projectAllWorkCard != null && !projectAllWorkCard.isEmpty() && gkinfo != null) {
            this.MergerToolAndTask(gkinfo, reqdata, projectAllWorkCard, projectCardAllOrder, lr);
        }
    }

    private void getOrderNumber(Set<Long> orderlst) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pom_mroorder", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", orderlst)});
        if (query != null) {
            for (DynamicObject item : query) {
                Long id = item.getLong("id");
                String no = item.getString("billno");
                this.ordernumber.put(id, no);
            }
        }
    }

    private String getNumberByorderid(Long orderid) {
        String number = this.ordernumber.get(orderid);
        if (number == null) {
            number = "";
        }
        return number;
    }

    private HashMap<Long, List<Map<String, Object>>> getProjectAllWorkCard2(Set<Long> projectids) {
        HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(2);
        customParams.put("includeWorkPackWorkCard", true);
        customParams.put("includeInternalWorkCard", true);
        HashSet<Long> setid = new HashSet<Long>(20);
        setid.addAll(projectids);
        Object obj = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmpd", (String)"WorkPackageService", (String)"getWorkCardAndWorkOrderByProject", (Object[])new Object[]{setid, customParams});
        HashMap rdata = new HashMap(2);
        if (obj instanceof HashMap) {
            rdata = (HashMap)obj;
            Object xdata = rdata.get("data");
            Object suc = rdata.get("success");
            if (suc == null || xdata == null || !"true".equalsIgnoreCase(suc.toString())) {
                return new HashMap<Long, List<Map<String, Object>>>();
            }
            if (xdata instanceof HashMap) {
                return (HashMap)xdata;
            }
        }
        return new HashMap<Long, List<Map<String, Object>>>();
    }

    private void MergerToolAndTask(Map<Long, EqToolNeedPlanModel> gkinfo, Map<Long, EqNeedPlanModel> taskinfo, HashMap<Long, Set<Long>> projectAllWorkCard, HashMap<Long, HashMap<Long, Set<Long>>> projectCardAllOrder, IMRPExecuteLogRecorder lr) {
        Long billtype = this.getBilltype();
        if (billtype == 0L) {
            lr.updateSubStepLog(lr.getLogIdx(), "entrydetailmsg", RESErrorMessageUtil.getToolbilltypeError());
            return;
        }
        ArrayList<DynamicObject> lstob = new ArrayList<DynamicObject>();
        for (Map.Entry<Long, EqNeedPlanModel> item : taskinfo.entrySet()) {
            Set<Long> cardset = projectAllWorkCard.get(item.getKey());
            HashMap<Long, Set<Long>> cardandorderid = projectCardAllOrder.get(item.getKey());
            if (cardset == null) continue;
            DynamicObject toolobject = null;
            Set<Long> keySet = gkinfo.keySet();
            for (Map.Entry<Long, EqToolNeedPlanModel> itemtool : gkinfo.entrySet()) {
                if (!cardset.contains(itemtool.getKey()) || itemtool.getValue().getFlsttools().isEmpty()) continue;
                HashSet<Long> setStaskid = new HashSet<Long>(100);
                setStaskid.addAll(itemtool.getValue().getFlststone());
                setStaskid.retainAll(item.getValue().getFlststandtaskid());
                HashSet<Long> setEtaskid = new HashSet<Long>(100);
                setEtaskid.addAll(itemtool.getValue().getFlststoneend());
                setEtaskid.retainAll(item.getValue().getFlststandtaskid());
                if (setStaskid.isEmpty() && setEtaskid.isEmpty()) continue;
                toolobject = this.getNewBill(toolobject, itemtool.getValue(), item.getValue(), billtype, cardandorderid, setStaskid, setEtaskid);
            }
            if (toolobject == null) continue;
            lstob.add(toolobject);
        }
        int i = 0;
        int logindex = 0;
        if (lstob.size() > 0) {
            DynamicObject obj2 = this.orm.newDynamicObject("msplan_toolneedplan");
            String[] codelst = CodeRuleServiceHelper.getBatchNumber((String)"msplan_toolneedplan", (DynamicObject)obj2, (String)((DynamicObject)lstob.get(0)).getString("org"), (int)lstob.size());
            for (DynamicObject itemobj : lstob) {
                if (codelst == null || codelst.length <= 0) {
                    itemobj.set("billno", (Object)itemobj.getPkValue().toString());
                } else {
                    itemobj.set("billno", (Object)codelst[i]);
                }
                ++i;
            }
            lr.createSubStepLog(++logindex, String.format(RESErrorMessageUtil.gettoolbillCount(), lstob.size()), lr.getLogIdx());
            lr.updateSubStepLog(logindex - 1, "entryresult", MRPExecuteStatus.FINISHED.getAlias());
            lr.saveStepLog(false);
            this.orm.insert(lstob);
        }
    }

    private Long getBilltype() {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)"select fid from T_BAS_BILLTYPE where fbillformid ='msplan_toolneedplan' and fisdefault ='1'", rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    private DynamicObject getNewBill(DynamicObject obj, EqToolNeedPlanModel toolitem, EqNeedPlanModel tasklst, Long billtype, HashMap<Long, Set<Long>> cardandorderid, Set<Long> setStaskid, Set<Long> setEtaskid) {
        if (obj == null) {
            obj = this.orm.newDynamicObject("msplan_toolneedplan");
            obj.set("model", (Object)tasklst.getFmodel());
            obj.set("project", (Object)tasklst.getFproject());
            obj.set("workcenter", (Object)tasklst.getFworkcenter());
            obj.set("org", (Object)tasklst.getForgid());
            obj.set("billtype", (Object)billtype);
            obj.set("datasource", (Object)"B");
            obj.set("billstatus", (Object)"A");
            obj.set("workstatus", (Object)"C");
            obj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            obj.set("createtime", (Object)new Date());
            obj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            obj.set("modifytime", (Object)new Date());
        }
        DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
        DynamicObjectType sType = entrys.getDynamicObjectType();
        List<EqToolModel> flsttools = toolitem.getFlsttools();
        int indexseq = 0;
        for (EqToolModel item : flsttools) {
            if (item.getFmaterial() <= 0L) continue;
            Set<Object> setorderid = new HashSet(10);
            if (cardandorderid != null) {
                setorderid = cardandorderid.get(item.getFgkid());
            }
            ArrayList<Object> lstorder = new ArrayList<Object>(20);
            if (setorderid == null || setorderid.isEmpty()) {
                lstorder.add(0L);
            } else {
                lstorder.addAll(setorderid);
            }
            for (Long l : lstorder) {
                billtask billTask = this.getBillTask(tasklst, setStaskid, setEtaskid);
                DynamicObject entry = new DynamicObject(sType);
                entry.set("seq", (Object)(++indexseq));
                entry.set("start", (Object)billTask.getStaskname());
                entry.set("starttaskid", (Object)billTask.getStaskid());
                entry.set("end", (Object)billTask.getEtaskname());
                entry.set("endtaskid", (Object)billTask.getEtaskid());
                entry.set("uselevel", (Object)"A");
                entry.set("cardno", (Object)item.getFgkid());
                entry.set("resource", (Object)item.getFmaterial());
                entry.set("checkgbill", (Object)this.getNumberByorderid(l));
                entry.set("checkgbillid", (Object)l);
                entry.set("suppyidtype", (Object)item.getFownertype());
                entry.set("suppy", (Object)item.getFowner());
                entry.set("qty", (Object)item.getFqty());
                entry.set("unit", (Object)item.getFunit());
                entry.set("stime", (Object)billTask.getStime());
                entry.set("ftime", (Object)billTask.getEtime());
                entry.set("toolsub", (Object)item.getFtoolgroup());
                entry.set("key", (Object)"true");
                entry.set("choose", (Object)"false");
                entry.set("result", (Object)"A");
                entrys.add((Object)entry);
            }
        }
        return obj;
    }

    private billtask getBillTask(EqNeedPlanModel tasklst, Set<Long> setStaskid, Set<Long> setEtaskid) {
        billtask bt = new billtask();
        HashSet<Long> allSid = new HashSet<Long>();
        HashSet<Long> allEid = new HashSet<Long>();
        for (EqNeedPlanEntryModel item : tasklst.getfEntryModels()) {
            if (setStaskid.contains(item.getFstandardtask())) {
                allSid.add(item.getFstarttaskid());
            }
            if (!setEtaskid.contains(item.getFstandardtask())) continue;
            allEid.add(item.getFstarttaskid());
        }
        Boolean findvala = false;
        Boolean findvalb = false;
        for (EqNeedPlanEntryModel item : tasklst.getfEntryModels()) {
            for (Long sid : allSid) {
                if (!item.getFstarttaskid().equals(sid) || findvala.booleanValue() && bt.getStime() != null && bt.getStime().compareTo(item.getFstime()) <= 0) continue;
                bt.setStaskname(item.getFstart());
                bt.setStaskid(item.getFstarttaskid());
                bt.setStime(item.getFstime());
                findvala = true;
            }
            for (Long eid : allEid) {
                if (!item.getFstarttaskid().equals(eid) || findvalb.booleanValue() && bt.getEtime() != null && bt.getEtime().compareTo(item.getFftime()) >= 0) continue;
                bt.setEtaskname(item.getFstart());
                bt.setEtaskid(item.getFstarttaskid());
                bt.setEtime(item.getFftime());
                findvalb = true;
            }
        }
        if (allSid.isEmpty()) {
            for (EqNeedPlanEntryModel item : tasklst.getfEntryModels()) {
                if (findvala.booleanValue() && bt.getStime() != null && bt.getStime().compareTo(item.getFstime()) <= 0) continue;
                bt.setStaskname(item.getFstart());
                bt.setStaskid(item.getFstarttaskid());
                bt.setStime(item.getFstime());
                findvala = true;
            }
        }
        if (allEid.isEmpty()) {
            for (EqNeedPlanEntryModel item : tasklst.getfEntryModels()) {
                if (findvalb.booleanValue() && bt.getEtime() != null && bt.getEtime().compareTo(item.getFftime()) >= 0) continue;
                bt.setEtaskname(item.getFstart());
                bt.setEtaskid(item.getFstarttaskid());
                bt.setEtime(item.getFftime());
                findvalb = true;
            }
        }
        return bt;
    }

    private DataSet QueryStoneAndProcess() {
        StringBuilder sbsql = new StringBuilder();
        sbsql.append(" select a.fpremilepostnodeid,a.fpostmilepostnodeid,c.fprocessgroupid ");
        sbsql.append(" from t_fmm_mile_phas a inner join ");
        sbsql.append(" t_fmm_propggroup b on b.fprojectphaseid=a.fprojectphaseid ");
        sbsql.append("inner join t_fmm_optgroupd c on b.fid =c.fid ");
        sbsql.append(" where a.fstatus='C' and a.fenable ='1' and b.fstatus ='C' and b.fenable ='1' ");
        return DB.queryDataSet((String)"Mrp-Res-QuerytaskProcess", (DBRoute)DBRoute.of((String)"scm"), (String)sbsql.toString());
    }

    private Map<Long, EqToolNeedPlanModel> getGkinfo(AbstractResModelDataTable SupplyData, IMRPExecuteLogRecorder lr) {
        GridData reqgd = SupplyData.getSrcDatas();
        Map<String, Integer> reqcolIdx = SupplyData.getColIdx();
        GridData.Grid datasreq = reqgd.getDatas();
        HashSet<Long> lstresgkid = new HashSet<Long>(1000);
        for (Object[] data : datasreq) {
            try {
                Long gkid = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.BILLID")], 0L);
                if (gkid <= 0L) continue;
                lstresgkid.add(gkid);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
                return null;
            }
        }
        if (lstresgkid.isEmpty()) {
            return null;
        }
        Map<Long, EqToolNeedPlanModel> gkProcessAndTool = this.getGkProcessAndTool(lstresgkid);
        try (DataSet dSet = this.QueryStoneAndProcess();){
            while (dSet.hasNext()) {
                Row srcData = dSet.next();
                Long processid = srcData.getLong("fprocessgroupid");
                Long startid = srcData.getLong("fpremilepostnodeid");
                Long endid = srcData.getLong("fpostmilepostnodeid");
                for (Map.Entry<Long, EqToolNeedPlanModel> item : gkProcessAndTool.entrySet()) {
                    if (!item.getValue().getFlstproces().contains(processid)) continue;
                    if (startid > 0L) {
                        item.getValue().getFlststone().add(startid);
                    }
                    if (endid <= 0L) continue;
                    item.getValue().getFlststoneend().add(endid);
                }
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
        return gkProcessAndTool;
    }

    private Map<Long, EqToolNeedPlanModel> getGkProcessAndTool(Set<Long> lstresgkid) {
        Map<Long, EqToolNeedPlanModel> gkProcessAndtool = new HashMap<Long, EqToolNeedPlanModel>(1000);
        HashSet<Long> ids = new HashSet<Long>(400);
        for (Long id : lstresgkid) {
            ids.add(id);
            if (ids.size() <= 400) continue;
            gkProcessAndtool.putAll(this.dbQueryProcessGroup(ids));
            ids = new HashSet(400);
        }
        gkProcessAndtool.putAll(this.dbQueryProcessGroup(ids));
        ArrayList lstnewgkid = new ArrayList(1000);
        for (Map.Entry item : gkProcessAndtool.entrySet()) {
            lstnewgkid.add(item.getKey());
        }
        ids = new HashSet(400);
        for (Long id : lstnewgkid) {
            ids.add(id);
            if (ids.size() <= 400) continue;
            gkProcessAndtool = this.dbQueryTool(ids, gkProcessAndtool);
            ids = new HashSet(400);
        }
        gkProcessAndtool = this.dbQueryTool(ids, gkProcessAndtool);
        return gkProcessAndtool;
    }

    private Map<Long, EqToolNeedPlanModel> dbQueryProcessGroup(Set<Long> lstgkid) {
        QFilter qFilter = new QFilter("id", "in", lstgkid);
        qFilter.and(new QFilter("processentry.processgroup", ">", (Object)0));
        DynamicObjectCollection Processlst = QueryServiceHelper.query((String)"mpdm_mrocardroute", (String)"id,processentry.processgroup", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, EqToolNeedPlanModel> res = new HashMap<Long, EqToolNeedPlanModel>(1000);
        for (DynamicObject item : Processlst) {
            Long gkid = item.getLong("id");
            EqToolNeedPlanModel ids = (EqToolNeedPlanModel)res.get(gkid);
            if (ids == null) {
                ids = new EqToolNeedPlanModel();
            }
            ids.getFlstproces().add(item.getLong("processentry.processgroup"));
            res.put(gkid, ids);
        }
        return res;
    }

    private Map<Long, EqToolNeedPlanModel> dbQueryTool(Set<Long> lstgkid, Map<Long, EqToolNeedPlanModel> res) {
        StringBuilder selectfield = new StringBuilder();
        selectfield.append("id,");
        selectfield.append("workcard,");
        selectfield.append("entryentity.entrymaterial,");
        selectfield.append("entryentity.enrtyunit,");
        selectfield.append("entryentity.entryqty,");
        selectfield.append("entryentity.entryownertype,");
        selectfield.append("entryentity.entryowner,");
        selectfield.append("entryentity.toolsubgroup");
        DynamicObjectCollection Processlst = QueryServiceHelper.query((String)"mpdm_cardtooldemand", (String)selectfield.toString(), (QFilter[])new QFilter[]{new QFilter("workcard", "in", lstgkid)});
        for (DynamicObject item : Processlst) {
            Long gkid = item.getLong("workcard");
            EqToolNeedPlanModel ids = res.get(gkid);
            if (ids == null) {
                ids = new EqToolNeedPlanModel();
                ids.setFgkid(gkid);
            }
            EqToolModel eqitem = new EqToolModel();
            eqitem.setFgkid(gkid);
            eqitem.setFmaterial(item.getLong("entryentity.entrymaterial"));
            eqitem.setFowner(item.getLong("entryentity.entryowner"));
            eqitem.setFownertype(item.getString("entryentity.entryownertype"));
            eqitem.setFqty(item.getBigDecimal("entryentity.entryqty"));
            eqitem.setFtoolgroup(item.getLong("entryentity.toolsubgroup"));
            eqitem.setFunit(item.getLong("entryentity.enrtyunit"));
            ids.getFlsttools().add(eqitem);
            res.put(gkid, ids);
        }
        return res;
    }
}

