/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.mpscmm.msplan.business.inventory.InvLevelConst;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;
import kd.mpscmm.msplan.business.inventory.InventoryDimension;
import kd.mpscmm.msplan.business.inventory.InventoryUtil;

public class InventoryModel {
    private IMRPEnvProvider env;
    private InvLevel invLevel;
    private boolean init;
    private String type;
    private static final String REDIS_INV = "mrp_redis_inv";
    private InvLevel invLevelAll;
    private Map<Long, Set<Long>> mtOrgs;
    private Map<Long, List<Map<String, Long>>> mtToDimVals;

    public InventoryModel(IMRPEnvProvider env) {
        this.env = env;
        this.env.addService(InventoryModel.class, this);
    }

    private void init() {
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        Long invLevelId = planModel.getInvLevel();
        if (invLevelId != null) {
            Date planDate = this.env.getPlanDate();
            String order = planModel.isReorderPoint() ? InvLevelConst.PlanType.REORDER.getValue() : "";
            String min = planModel.isMaxMinInventory() ? InvLevelConst.PlanType.MAXMIN.getValue() : "";
            this.type = String.format("%s/%s", order, min);
            this.invLevel = InventoryUtil.getInvLevel((Object)invLevelId, (Date)planDate, (String)this.type);
        }
        this.init = true;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        String order = planModel.isReorderPoint() ? InvLevelConst.PlanType.REORDER.getValue() : "";
        String min = planModel.isMaxMinInventory() ? InvLevelConst.PlanType.MAXMIN.getValue() : "";
        this.type = String.format("%s/%s", order, min);
        return this.type;
    }

    public InvLevel getInvLevel() {
        if (!this.init) {
            this.init();
        }
        return this.invLevel;
    }

    public InvLevel getInvLevelAll() {
        if (this.invLevelAll != null) {
            return this.invLevelAll;
        }
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        Long invLevelId = planModel.getInvLevel();
        if (invLevelId != null) {
            Date planDate = this.env.getPlanDate();
            this.invLevelAll = InventoryUtil.getInvLevel((Object)invLevelId, (Date)planDate);
        }
        return this.invLevelAll;
    }

    public void cacheMt(MRPRedisStore dstore, Map<String, Boolean> map) {
        dstore.mapMSet(REDIS_INV, map);
        this.mtOrgs = null;
    }

    public String getCacheKey(String org, String mt, InvLevelEntry entry) {
        ResDataModelCollection resDataModel = (ResDataModelCollection)this.env.getService(ResDataModelCollection.class);
        return this.getMetaDynamicInfoKey(resDataModel.getMaterialPlanKeys(mt, org, entry));
    }

    private String getMetaDynamicInfoKey(String key) {
        return this.env.getMRPContextId() + "\u0001" + key + "\u0001invKey";
    }

    public Map<Long, Set<Long>> getMtOrgsFromCache() {
        if (this.mtOrgs != null) {
            return this.mtOrgs;
        }
        this.initMtFromCache();
        return this.mtOrgs;
    }

    public Map<Long, List<Map<String, Long>>> getMtToDimValsFromCache() {
        if (this.mtToDimVals != null) {
            return this.mtToDimVals;
        }
        this.initMtFromCache();
        return this.mtToDimVals;
    }

    private void initMtFromCache() {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(32);
        HashMap<Long, List<Map<String, Long>>> dimVals = new HashMap<Long, List<Map<String, Long>>>(32);
        if (MRPCacheManager.getInst().getData(this.env, "IS_MP_CACHED") == null) {
            RequireDataModel requireDataModel = (RequireDataModel)this.env.getService(RequireDataModel.class);
            requireDataModel.initMaterialPlanInfos();
        }
        MRPRedisStore store = MRPCacheManager.getDStore(this.env.getMRPContextId());
        Map map = store.mapGetAll(REDIS_INV);
        List<String> extendDimensions = this.getExtendDimensions();
        if (map != null) {
            for (String s : map.keySet()) {
                String[] split = s.split("\u0001");
                Long mt = Long.parseLong(split[1]);
                Long org = Long.parseLong(split[2]);
                List list = dimVals.computeIfAbsent(mt, k -> new ArrayList(8));
                HashMap<String, Long> m = new HashMap<String, Long>(2);
                list.add(m);
                m.put("bos_org", org);
                ListIterator<String> its = extendDimensions.listIterator();
                for (int i = 3; i < split.length - 1 && its.hasNext(); ++i) {
                    m.put((String)its.next(), Long.parseLong(split[i]));
                }
                result.computeIfAbsent(mt, k -> new HashSet(8)).add(org);
            }
        }
        this.mtToDimVals = dimVals;
        this.mtOrgs = result;
    }

    public static HashMap<String, Object> invToMap(InvLevelEntry entry, Long org, Long mt) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("masterid", mt);
        result.put("createorg", org);
        DynamicObject dyn = entry.getEntry();
        DynamicObject ptg = dyn.getDynamicObject("plantag");
        result.put("plantags", ptg == null ? Long.valueOf(0L) : ptg.getPkValue());
        result.put("materialattr", dyn.getString("materialattr"));
        result.put("planmode", dyn.getString("plantype"));
        result.put("leadtimetype", "A");
        result.put("fixedleadtime", dyn.getLong("leadtime"));
        result.put("changeleadtime", 0);
        result.put("inspectionleadtime", dyn.getLong("inspectionleadtime"));
        result.put("preprocessingtime", dyn.getLong("preprocessingtime"));
        result.put("postprocessingtime", dyn.getLong("postprocessingtime"));
        result.put("changebatch", 0);
        result.put("reservedtype", dyn.getString("reservedtype"));
        result.put("yield", dyn.getBigDecimal("yield"));
        result.put("wastagerate", dyn.getBigDecimal("wastagerate"));
        result.put("wastagerateformula", dyn.getString("wastagerateformula"));
        DynamicObject op = dyn.getDynamicObject("operator");
        result.put("operator", op == null ? Long.valueOf(0L) : op.getPkValue());
        result.put("lotpolicy", "");
        result.put("batchqty", 0);
        result.put("batchincrement", 0);
        result.put("minlotsize", 0);
        result.put("maxlotsize", 0);
        result.put("separatorsymbol", "A");
        result.put("intervalperiod", 0);
        result.put("partitionbase", 0);
        result.put("dynamiccycle", 0);
        result.put("fixedperiod", 0);
        result.put("specifiedperiod", 0L);
        result.put("isincluderequire", true);
        result.put("inv_not_allow_strategy", true);
        return result;
    }

    public boolean matchType(InvLevelEntry entry) {
        String value = entry.getPlanType().getValue();
        return this.getType().contains(value);
    }

    public List<String> getExtendDimensions() {
        this.invLevel = this.getInvLevel();
        LinkedList<String> dims = new LinkedList<String>();
        if (this.invLevel == null) {
            return dims;
        }
        InventoryDimension inventoryDimension = this.invLevel.getInvDim();
        Iterator iterator = inventoryDimension.getEntityNames().iterator();
        block10: while (iterator.hasNext()) {
            String dim;
            switch (dim = (String)iterator.next()) {
                case "bos_org": 
                case "bd_material": 
                case "bd_materialgroup": 
                case "bd_materialgroupstandard": 
                case "bd_materialgroupdetail": {
                    continue block10;
                }
            }
            dims.add(dim);
        }
        return dims;
    }
}

