/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.InventoryModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.PlanScopeModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.model.ArrayBasedHashMap;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.MaterialPlanMode;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.business.inventory.InvLevel;

public class MtPlanInfoModel {
    private static final Log logger = LogFactory.getLog(MtPlanInfoModel.class);
    public static final String materialPlanFields = "id,number,ctrlstrategy, masterid, createorg, materialattr, leadtimetype, fixedleadtime, changeleadtime, inspectionleadtime, preprocessingtime, postprocessingtime, changebatch, yield, plantag, wastagerate, operator, planmode, plantags, manufacturegroup, allowleadtime, allowdelayperiod, leadadvance, delaytolerance, wastagerateformula, demandmergerule, lotpolicy, batchqty, batchincrement, minlotsize, maxlotsize, separatorsymbol, intervalperiod, partitionbase, dynamiccycle, fixedperiod, specifiedperiod, reservedtype, supplynetwork, reorderpoint, max, min, isincluderequire, isentrymanustrategy";
    public static final String REDIS_MP = "mpList";
    public static final String REDIS_MP_SHARE = "mpList_share";
    public static final String REDIS_MP_CTRL_SHARE = "mpList_ctrl_share";
    public static final String REDIS_SCOPE = "mpList_scope";
    protected static final List<String> mpFieldList = Arrays.stream("id,number,ctrlstrategy, masterid, createorg, materialattr, leadtimetype, fixedleadtime, changeleadtime, inspectionleadtime, preprocessingtime, postprocessingtime, changebatch, yield, plantag, wastagerate, operator, planmode, plantags, manufacturegroup, allowleadtime, allowdelayperiod, leadadvance, delaytolerance, wastagerateformula, demandmergerule, lotpolicy, batchqty, batchincrement, minlotsize, maxlotsize, separatorsymbol, intervalperiod, partitionbase, dynamiccycle, fixedperiod, specifiedperiod, reservedtype, supplynetwork, reorderpoint, max, min, isincluderequire, isentrymanustrategy".split(",")).map(String::trim).collect(Collectors.toList());
    private Set<String> enabledMaterialPlanIds;
    private Set<String> enabledMaterialIds;
    private Set<String> oriEnabledMaterialIds;
    private Map<String, Map<String, Object>> materialPlanInfos = new HashMap<String, Map<String, Object>>(8);
    private Map<String, String> sharePlanInfoCache = new HashMap<String, String>(8);
    private Map<String, Map<Long, Set<Long>>> controlScopeSharePlanInfoCache = new HashMap<String, Map<Long, Set<Long>>>(8);
    private CalEnv env;
    private Map<String, Integer> indexes;
    private Map<String, Integer> invIndexes;

    public MtPlanInfoModel(CalEnv env) {
        this.env = env;
        env.addService(MtPlanInfoModel.class, this);
    }

    public int createMaterialTableDatas() {
        return this.createMaterialTableDatas(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createMaterialTableDatas(QFilter outFilter) {
        long startTime = System.currentTimeMillis();
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        HashSet<String> materialIds = new HashSet<String>();
        HashSet<String> materialPlanIds = new HashSet<String>();
        QFilter[] filters = this.getMaterialPlanFilter();
        StringBuilder sb = new StringBuilder();
        for (QFilter filter : filters) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(filter.toString());
        }
        if (outFilter == null) {
            ArrayList<Long> orgIds = new ArrayList<Long>(planModel.getRequirorgs().size());
            for (String org : planModel.getRequirorgs()) {
                orgIds.add(Long.parseLong(org));
            }
            outFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", orgIds, (boolean)false);
        }
        if (outFilter != null) {
            QFilter[] newFilters = new QFilter[filters.length + 1];
            System.arraycopy(filters, 0, newFilters, 1, filters.length);
            newFilters[0] = outFilter;
            filters = newFilters;
        }
        HashSet<String> existMaterialPlans = new HashSet<String>(16);
        try (DataSet set = null;){
            set = cacheDatas.loadCacheDatas("mpdm_materialplan", "id, masterid, createorg", filters, null);
            if (set == null) {
                set = ORM.create().queryDataSet(this.getClass().getName(), "mpdm_materialplan", "id, masterid, createorg", filters, null);
            }
            int rc = 0;
            while (set.hasNext()) {
                ++rc;
                Row row = set.next();
                materialIds.add(row.getString("masterid"));
                materialPlanIds.add(row.getString("id"));
                existMaterialPlans.add(row.getString("createorg") + '\u0001' + row.getString("masterid"));
            }
            if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mrprunner-init-material-range-by-snap, filter: %s, rc: %s", sb.toString(), rc));
            }
        }
        if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-init-material-query-planinfo, time: %s MS", System.currentTimeMillis() - startTime));
        }
        startTime = System.currentTimeMillis();
        PlanScopeModel planScopeModel = (PlanScopeModel)this.env.getService(PlanScopeModel.class);
        planScopeModel.addMaterByPlanScopeRelation(materialIds, materialPlanIds, existMaterialPlans, outFilter);
        if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-init-material-planscope-relation, time: %s MS", System.currentTimeMillis() - startTime));
        }
        startTime = System.currentTimeMillis();
        this.oriEnabledMaterialIds = new HashSet<String>(materialIds);
        this.addInvLevelMaterial(materialIds);
        this.enabledMaterialIds = materialIds;
        this.enabledMaterialPlanIds = materialPlanIds;
        MRPCacheManager.getInst().putData(this.env, MRPRuntimeConsts.getOriMaterialTableKey(this.env.getMRPContextId()), JSON.toJSONString(this.oriEnabledMaterialIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        MRPCacheManager.getInst().putData(this.env, MRPRuntimeConsts.getMaterialTableKey(this.env.getMRPContextId()), JSON.toJSONString(this.enabledMaterialIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        MRPCacheManager.getInst().putData(this.env, MRPRuntimeConsts.getMaterialPlanTableKey(this.env.getMRPContextId()), JSON.toJSONString(this.enabledMaterialPlanIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-init-material-write-redis, time: %s MS", System.currentTimeMillis() - startTime));
        }
        return materialIds.size();
    }

    public void createMaterialTableByMid(Set<String> mIds) {
        Set<String> enabledMaterialIds = this.getEnabledMaterialIds();
        if (enabledMaterialIds.isEmpty()) {
            this.createMaterialTableDatas(new QFilter("masterid", "in", MRPUtil.setStringParseLong(mIds)));
            enabledMaterialIds = this.getEnabledMaterialIds();
        }
        mIds.retainAll(enabledMaterialIds);
        if (mIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u5355/\u9009\u6599\u7269\u6599\u4e0d\u5728\u8ba1\u7b97\u8303\u56f4\u5185\u3002", (String)"MtPlanInfoModel_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
        }
        this.setEnabledMaterialIds(mIds);
        MRPCacheManager.getInst().putData(this.env, MRPRuntimeConsts.getMaterialTableKey(this.env.getMRPContextId()), JSON.toJSONString(mIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }

    private void addInvLevelMaterial(Set<String> materialIds) {
        InventoryModel service;
        InvLevel invLevel;
        Boolean cfgValue = (Boolean)this.env.getCfgValue(EnvCfgItem.INV_LEVEL_CALC);
        if (cfgValue.booleanValue() && (invLevel = (service = (InventoryModel)this.env.getService(InventoryModel.class)).getInvLevel()) != null) {
            Set allMaterials = invLevel.getAllMaterials();
            materialIds.addAll(allMaterials.stream().map(Object::toString).collect(Collectors.toSet()));
        }
    }

    private QFilter[] getMaterialPlanFilter() {
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        qFilterStatus.and(new QFilter("enable", "=", (Object)"1"));
        QFilter qFilterMode = new QFilter("planmode", "in", this.getPlanType());
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        if (!"IGNORE".equals(this.env.getCfgValue(EnvCfgItem.MATERIAL_PLAN_INFO_SETTINGS))) {
            qFilterList.add(qFilterStatus);
        }
        if (!this.env.isSpecialPlan()) {
            qFilterList.add(qFilterMode);
        }
        return qFilterList.toArray(new QFilter[0]);
    }

    public List<String> getPlanType() {
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        ArrayList<String> planType = new ArrayList<String>(3);
        if (planModel.isMPS()) {
            planType.add(MaterialPlanMode.MPS.getValue());
        }
        if (planModel.isMRP()) {
            planType.add(MaterialPlanMode.MRP.getValue());
        }
        if (planModel.isReorderPoint()) {
            planType.add(MaterialPlanMode.REORDERPOINT.getValue());
        }
        if (planModel.isMaxMinInventory()) {
            planType.add(MaterialPlanMode.MAXANDMININV.getValue());
        }
        return planType;
    }

    public Set<String> getEnabledMaterialPlanIds() {
        if (this.enabledMaterialPlanIds == null) {
            List materialPlanIds = JSON.parseArray((String)MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getMaterialPlanTableKey(this.env.getMRPContextId())), String.class);
            if (materialPlanIds == null) {
                this.setEnabledMaterialPlanIds(new HashSet<String>(0));
            } else {
                this.setEnabledMaterialPlanIds(new HashSet<String>(materialPlanIds));
            }
        }
        return this.enabledMaterialPlanIds;
    }

    public void setEnabledMaterialPlanIds(Set<String> enabledMaterialPlanIds) {
        this.enabledMaterialPlanIds = enabledMaterialPlanIds;
    }

    public Set<String> getEnabledMaterialIds() {
        if (this.enabledMaterialIds == null) {
            List ids = JSON.parseArray((String)MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getMaterialTableKey(this.env.getMRPContextId())), String.class);
            if (ids == null) {
                this.setEnabledMaterialIds(new HashSet<String>(0));
            } else {
                this.setEnabledMaterialIds(MRPUtil.array2Set(ids));
            }
        }
        return this.enabledMaterialIds;
    }

    public Set<String> getOriEnabledMaterialIds() {
        if (this.oriEnabledMaterialIds == null) {
            List materialIds = JSON.parseArray((String)MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getOriMaterialTableKey(this.env.getMRPContextId())), String.class);
            this.oriEnabledMaterialIds = materialIds == null ? new HashSet<String>(0) : new HashSet<String>(materialIds);
        }
        return this.oriEnabledMaterialIds;
    }

    public void setEnabledMaterialIds(Set<String> enabledMaterialIds) {
        this.enabledMaterialIds = enabledMaterialIds;
    }

    public Map<String, Map<String, Object>> getMaterialPlanInfos() {
        return this.materialPlanInfos;
    }

    public Map<String, String> getSharePlanInfoCache() {
        return this.sharePlanInfoCache;
    }

    public Map<String, Map<Long, Set<Long>>> getControlScopeSharePlanInfoCache() {
        return this.controlScopeSharePlanInfoCache;
    }

    public String getMaterialAttr(String id, String orgId) {
        Set<String> enabledMaterialIds = this.getEnabledMaterialIds();
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        if (!enabledMaterialIds.contains(id)) {
            return null;
        }
        return this.getMaterialAttrNoCheckEnable(id, orgId);
    }

    private String getMaterialAttrNoCheckEnable(String id, String orgId) {
        Map<String, Object> info = this.getMaterialPlanInfo(id, orgId);
        return info == null ? null : String.valueOf(info.get("materialattr"));
    }

    public Map<String, Object> getMaterialPlanInfo(String materialId, String orgId, Map<String, Object> extendDimVals) {
        return this.getMaterialPlanInfo(materialId, orgId, extendDimVals, false);
    }

    public Map<String, Object> getMaterialPlanInfo(String materialId, String orgId, Map<String, Object> extendDimVals, boolean ignoreSharePlanInfo) {
        Map info;
        String key;
        ResDataModelCollection resDataModel = (ResDataModelCollection)this.env.getService(ResDataModelCollection.class);
        Map<String, Map<String, Object>> materialPlanInfos = this.getMaterialPlanInfos();
        if (materialPlanInfos.containsKey(key = resDataModel.getMaterialPlanKeys(materialId, orgId))) {
            info = materialPlanInfos.get(key);
        } else {
            String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(this.env.getMRPContextId(), key);
            MRPRedisStore dstore = MRPCacheManager.getDStore(this.env.getMRPContextId());
            info = (Map)dstore.mapGet(REDIS_MP, cacheKey);
            if (info == null && extendDimVals != null && !extendDimVals.isEmpty()) {
                key = resDataModel.getMaterialPlanKeys(materialId, orgId, extendDimVals);
                cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(this.env.getMRPContextId(), key);
                info = (Map)dstore.mapGet(REDIS_MP, cacheKey);
            }
            if (info == null) {
                if (ignoreSharePlanInfo) {
                    return info;
                }
                info = resDataModel.loadShareMaterialPlanInfo(materialId, orgId, dstore);
            } else {
                info = this.zipPlanInfoMap(info);
            }
            materialPlanInfos.put(key, info);
            if (info == null) {
                logger.warn(String.format("mrprunner-put-null-material-planinfo-getMaterialPlanInfo, ctxid: %s, cacheKey: %s, mid: %s", this.env.getMRPContextId(), cacheKey, materialId));
            }
        }
        return info;
    }

    @Deprecated
    public Map<String, Object> getMaterialPlanInfo(String materialId, String orgId) {
        return this.getMaterialPlanInfo(materialId, orgId, new HashMap<String, Object>(0), false);
    }

    public Map<String, Object> getMaterialPlanInfo(String materialId, String orgId, boolean ignoreSharePlanInfo) {
        return this.getMaterialPlanInfo(materialId, orgId, new HashMap<String, Object>(0), ignoreSharePlanInfo);
    }

    public String[] getMaterialDataById(String id) {
        String[] str = new String[]{"", ""};
        if (id == null || id.trim().isEmpty()) {
            return str;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(id));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"number,name", (QFilter[])new QFilter[]{qFilter}, null, (int)1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                str[0] = row.getString(0);
                str[1] = row.getString(1);
            }
        }
        return str;
    }

    public Map<String, Object> zipPlanInfoMap(Map<String, Object> info) {
        if (this.indexes == null) {
            this.indexes = ArrayBasedHashMap.parseHeader(info);
        } else if (this.invIndexes == null && info.size() != this.indexes.size()) {
            this.invIndexes = ArrayBasedHashMap.parseHeader(info);
        }
        info = this.indexes != null && this.indexes.size() == info.size() ? ArrayBasedHashMap.wrap(this.indexes, info) : (this.invIndexes != null && this.invIndexes.size() == info.size() ? ArrayBasedHashMap.wrap(this.invIndexes, info) : ArrayBasedHashMap.wrap(ArrayBasedHashMap.parseHeader(info), info));
        return info;
    }
}

