/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mmc.mrp.exception.PLSWarnException;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.PLSErrors;
import kd.mmc.mrp.integrate.PLSEnv;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.pls.model.AbilityItemCalcResult;
import kd.mmc.mrp.pls.model.Category;
import kd.mmc.mrp.pls.model.DowntimePlan;
import kd.mmc.mrp.pls.model.OrderMaterialMananger;
import kd.mmc.mrp.pls.model.SchedulingScheme;
import kd.mmc.mrp.pls.model.WorkCalendarManager;
import kd.mmc.mrp.pls.model.WorkCenter;
import kd.mmc.mrp.pls.model.WorkCenterManager;
import kd.mmc.mrp.pls.model.WorkShift;
import kd.mmc.mrp.pls.model.WorkShiftManager;
import kd.mmc.mrp.pls.model.WorkUnit;
import kd.mmc.mrp.pls.util.QueryUtils;
import kd.mmc.mrp.pls.util.SaveUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class PlsSaveDetailSetpImpl {
    private static final Log LOG = LogFactory.getLog(PLSEnv.class);
    private IMRPEnvProvider env;
    private java.util.Date plsDate;

    public PlsSaveDetailSetpImpl(IMRPEnvProvider env) {
        this.env = env;
    }

    public int savePLSCalcDetail() {
        WorkShiftManager defaultWorkShiftManager = (WorkShiftManager)this.env.getService(WorkShiftManager.class);
        WorkCalendarManager workCalendarManager = (WorkCalendarManager)this.env.getService(WorkCalendarManager.class);
        WorkCenterManager workCenterManager = (WorkCenterManager)this.env.getService(WorkCenterManager.class);
        OrderMaterialMananger orderMaterialMananger = (OrderMaterialMananger)this.env.getService(OrderMaterialMananger.class);
        SchedulingScheme schedulingScheme = (SchedulingScheme)this.env.getService(SchedulingScheme.class);
        Map<Long, Map<Long, Map<String, BigDecimal>>> workcenterMatToDateNumMap = this.getInstransitOrder(orderMaterialMananger, workCenterManager);
        Map<Long, Map<String, BigDecimal>> workCenterMatCalcResult = this.getWorkCenterMatCalcResult(workcenterMatToDateNumMap);
        LOG.info("workcenterMatToDateNumMap", (Object)workcenterMatToDateNumMap.toString());
        DynamicObject runLog = this.env.getRunLog();
        String runLogNumber = runLog.getString("number");
        String formId = "mrp_pls_result";
        Boolean intransit = (Boolean)SystemParamServiceHelper.getBillParameter((String)formId, (String)"intransit");
        LOG.info("intransit", (Object)intransit.toString());
        LOG.info(ResManager.loadKDString((String)"\u201c\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1\u201d\u5de5\u4f5c\u4e2d\u5fc3\u521d\u59cb\u5316\u5b8c\u6210\u3002\u5de5\u4f5c\u4e2d\u5fc3\u7ba1\u7406\u5668\uff1a{}\uff0c\u8fd0\u884c\u65e5\u5fd7\u7f16\u53f7\uff1a{}\u3002", (String)"PlsSaveDetailSetpImpl_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), (Object)workCenterManager.toString(), (Object)runLogNumber);
        LOG.info(ResManager.loadKDString((String)"\u201c\u4ea7\u7ebf\u6392\u7a0b\u8ba1\u7b97\u670d\u52a1\u201d\u8ba2\u5355\u7269\u6599\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0corderMaterialMananger: {}\uff0crunLogNumber: {}", (String)"PlsSaveDetailSetpImpl_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), (Object)orderMaterialMananger.toString(), (Object)runLogNumber);
        StringBuilder sb = new StringBuilder(40);
        java.util.Date planDate = this.env.getPlanDate();
        java.util.Date startDate = runLog.getDate("startdate");
        int workShiftSize = defaultWorkShiftManager.getAll().size();
        int rowCount = schedulingScheme.getPlsOrderSize();
        int initSize = rowCount * workShiftSize;
        ArrayList values = Lists.newArrayListWithExpectedSize((int)initSize);
        ArrayList resultValues = Lists.newArrayListWithExpectedSize((int)initSize);
        CachedDataSet plsOrderDataSet = null;
        try {
            plsOrderDataSet = Algo.getCacheDataSet((String)this.env.getMRPContextId());
        }
        catch (Exception e) {
            return 0;
        }
        List plsOrders = plsOrderDataSet.getList(0, rowCount);
        String settingValue = EnvCfgItem.MATERIAL_PLAN_INFO_SETTINGS.getDefaultValue().toString();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mrp_runconfig", (String)"id,number,name,paramtype,param", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"MATERIAL_PLAN_INFO_SETTINGS")});
        if (dynamicObject != null) {
            settingValue = dynamicObject.getString("param");
        }
        QFilter dataFilter = new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1"));
        HashMap<String, Tuple<Long, Long>> matPlanMap = new HashMap<String, Tuple<Long, Long>>(plsOrders.size());
        HashMap<Long, Tuple<Long, Long>> matPlanGlobalMap = new HashMap<Long, Tuple<Long, Long>>(plsOrders.size());
        if (!CollectionUtils.isEmpty((Collection)plsOrders)) {
            this.queryMaterialPlanInfo(plsOrders, settingValue, dataFilter, matPlanMap, matPlanGlobalMap);
        }
        HashSet<Long> noCalcMatList = new HashSet<Long>();
        boolean hasPlanOrder = false;
        block2: for (Row plsOrder : plsOrders) {
            BigDecimal orderQty = plsOrder.getBigDecimal("order_num");
            java.util.Date planStartDate = plsOrder.getDate("plan_start_date");
            java.util.Date planFinishDate = plsOrder.getDate("plan_finish_date");
            Long orderModelKey = this.getOrderModelKey(sb, plsOrder, orderMaterialMananger, workCenterManager);
            List workCenters = orderMaterialMananger.get(orderModelKey);
            if (workCenters.isEmpty()) continue;
            if (!noCalcMatList.contains(plsOrder.getLong("materiel_code"))) {
                long count = workCenters.stream().filter(workCenter -> workCenter.getCalcResult(orderModelKey) == null).count();
                if ((long)workCenters.size() == count) {
                    noCalcMatList.add(plsOrder.getLong("materiel_code"));
                }
            }
            java.util.Date firstDate = planStartDate.compareTo(planDate) >= 0 ? planStartDate : planDate;
            ArrayList<Object> prototypeValue = this.initValue(plsOrder, matPlanMap, matPlanGlobalMap);
            for (WorkCenter workCenter2 : workCenters) {
                List workDates;
                AbilityItemCalcResult calcResult = workCenter2.getCalcResult(orderModelKey);
                if (calcResult == null) continue;
                BigDecimal ability = calcResult.getResult();
                String workUnit = calcResult.getWorkUnit();
                int precision = calcResult.getPrecision();
                long workCenterId = workCenter2.getId();
                WorkShiftManager workShiftManager = this.getWorkShif(defaultWorkShiftManager, workCenterManager, workCenterId);
                Map<Integer, WorkShift> workShiftMap = this.getworkShiftMap(schedulingScheme, workShiftManager);
                List list = workDates = workCalendarManager.isFromWorkCenter(Long.valueOf(workCenterId)) ? workCalendarManager.getWorkCenterWorkDates(Long.valueOf(workCenterId)) : workCalendarManager.getProdOrgWorkDates(plsOrder.getLong("production_org"));
                if (CollectionUtils.isEmpty((Collection)workDates)) continue;
                Map date2Seq2RemainingTime = workCenter2.getDate2Seq2RemainingTime();
                Map workDateAndShift2Seq = workCenter2.getWorkDateAndShift2Seq();
                block4: for (java.util.Date workDate : workDates) {
                    boolean isPlanDate = planDate.compareTo(workDate) == 0;
                    String format = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(workDate);
                    LOG.info("format", (Object)format);
                    Map seq2RemainingTime = date2Seq2RemainingTime.computeIfAbsent(workDate, k -> Maps.newHashMapWithExpectedSize((int)workShiftSize));
                    for (Map.Entry<Integer, WorkShift> shiftEntry : workShiftMap.entrySet()) {
                        BigDecimal shiftOutputQty;
                        boolean isLessThanZero;
                        List downtimePlans;
                        long shiftDValue;
                        WorkShift workShift = shiftEntry.getValue();
                        this.plsDate = workDate;
                        Integer shiftSeq = shiftEntry.getKey();
                        boolean joinCal = workShift.isJoinCal();
                        if (!joinCal || isPlanDate && !workShiftManager.currentWorkShiftCanWork(shiftSeq.intValue()) || schedulingScheme.getConsiderPlanDate().booleanValue() && !this.isInPlanDate(workDate, planStartDate, planFinishDate)) continue;
                        hasPlanOrder = true;
                        if (schedulingScheme.getAcrossDayShift().booleanValue() && workShift.isAcrossDay() && this.getBoolean(workDate, firstDate, startDate, workShiftManager, shiftSeq)) continue;
                        java.util.Date shiftStartDateTime = DateUtils.addSeconds((java.util.Date)this.plsDate, (int)workShift.getStartTime().intValue());
                        java.util.Date shiftEndDateTime = DateUtils.addSeconds((java.util.Date)this.plsDate, (int)workShift.getEndTime().intValue());
                        if (workShift.isAcrossDay()) {
                            shiftEndDateTime = DateUtils.addDays((java.util.Date)shiftEndDateTime, (int)1);
                        }
                        if ((shiftDValue = this.getShiftDValue(workShift, shiftStartDateTime, shiftEndDateTime, downtimePlans = workCenter2.getDowntimePlans())) < 0L) continue block4;
                        BigDecimal judgeTime = this.isJudgeTime(intransit, workCenterMatCalcResult, workCenterId, format, shiftDValue);
                        shiftDValue = judgeTime == null ? 0L : new BigDecimal(shiftDValue).subtract(judgeTime).longValue();
                        ArrayList value = (ArrayList)prototypeValue.clone();
                        BigDecimal dValue = new BigDecimal(String.valueOf(shiftDValue / 1000L));
                        value.add(workCenterId);
                        value.add(new Date(this.plsDate.getTime()));
                        value.add(workShift.getStartTime());
                        value.add(workShift.getEndTime());
                        BigDecimal orderCalcQty = orderQty;
                        value.add(orderCalcQty);
                        BigDecimal shiftAbilityQty = dValue.divide(ability, 0, 1);
                        value.add(shiftAbilityQty);
                        BigDecimal remainingTime = seq2RemainingTime.computeIfAbsent(shiftSeq, k -> dValue);
                        BigDecimal shiftAllowanceQty = remainingTime.divide(ability, 0, 1);
                        orderQty = orderQty.subtract(shiftAllowanceQty);
                        boolean bl = isLessThanZero = orderQty.compareTo(BigDecimal.ZERO) <= 0;
                        if (isLessThanZero) {
                            orderQty = BigDecimal.ZERO;
                            shiftOutputQty = orderCalcQty;
                        } else {
                            shiftOutputQty = shiftAllowanceQty;
                        }
                        shiftAllowanceQty = shiftAllowanceQty.subtract(shiftOutputQty);
                        remainingTime = remainingTime.subtract(shiftOutputQty.multiply(ability));
                        value.add(shiftOutputQty);
                        value.add(shiftAllowanceQty);
                        value.add(workCenter2.getWorkShopId());
                        value.add(workShift.getId());
                        value.add(workUnit);
                        sb.setLength(0);
                        sb.append(format).append('_').append(shiftSeq);
                        String workDateAndShift = sb.toString();
                        Integer prodSeq = workDateAndShift2Seq.computeIfAbsent(workDateAndShift, k -> 1);
                        value.add(prodSeq);
                        workDateAndShift2Seq.put(workDateAndShift, prodSeq + 1);
                        seq2RemainingTime.put(shiftSeq, remainingTime);
                        value.add(orderQty);
                        ArrayList resultValue = (ArrayList)value.clone();
                        BigDecimal useTime = shiftOutputQty.multiply(ability);
                        useTime = WorkUnit.MINUTE.getValue().equals(workUnit) ? useTime.divide(WorkUnit.Constants.MINUTE, precision, 4) : (WorkUnit.HOUR.getValue().equals(workUnit) ? useTime.divide(WorkUnit.Constants.HOUR, precision, 4) : (WorkUnit.DAY.getValue().equals(workUnit) ? useTime.divide(WorkUnit.Constants.DAY, precision, 4) : useTime));
                        value.add(useTime);
                        values.add(value);
                        if (shiftOutputQty.compareTo(BigDecimal.ZERO) > 0) {
                            resultValue.add("A");
                            resultValues.add(resultValue);
                        }
                        if (!isLessThanZero) continue;
                        continue block2;
                    }
                }
            }
        }
        plsOrderDataSet.close();
        if (schedulingScheme.getConsiderPlanDate().booleanValue() && !hasPlanOrder) {
            throw new PLSWarnException(PLSErrors.getNoOrderInDate());
        }
        if (!CollectionUtils.isEmpty(noCalcMatList)) {
            List matNumberList = QueryUtils.getPropertyValuesForSingle((String)"bd_material", noCalcMatList, (String)"number");
            throw new PLSWarnException(PLSErrors.getNoCalcablitity(), StringUtils.join((Iterable)matNumberList, (String)","));
        }
        this.saveDetailDataToDB(values, schedulingScheme);
        this.saveResultDataToDB(resultValues, schedulingScheme, runLogNumber);
        return values.size();
    }

    private Map<Long, Map<String, BigDecimal>> getWorkCenterMatCalcResult(Map<Long, Map<Long, Map<String, BigDecimal>>> workcenterMatToDateNumMap) {
        HashMap workcenterMatToTimeMap = new HashMap();
        if (workcenterMatToDateNumMap != null && workcenterMatToDateNumMap.size() != 0) {
            String selectFields = "id,entryproduct.producttype producttype,entryproduct.materielf7,entryproduct.materialgroup,entryproduct.subentryentitycal.workunits,entryproduct.subentryentitycal.completeresult,entryproduct.subentryentitycal.precision";
            Set<Long> longs = workcenterMatToDateNumMap.keySet();
            DynamicObjectCollection query = QueryServiceHelper.query((String)"mpdm_workcentre", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", longs)});
            for (DynamicObject dynamicObject : query) {
                long workCenterId = dynamicObject.getLong("id");
                HashMap<Long, BigDecimal> matToTimeMap = (HashMap<Long, BigDecimal>)workcenterMatToTimeMap.get(workCenterId);
                if (matToTimeMap == null) {
                    matToTimeMap = new HashMap<Long, BigDecimal>(8);
                }
                BigDecimal result = new BigDecimal(dynamicObject.getString("entryproduct.subentryentitycal.completeresult"));
                String workUnit = dynamicObject.getString("entryproduct.subentryentitycal.workunits");
                result = WorkUnit.MINUTE.getValue().equals(workUnit) ? result.multiply(WorkUnit.Constants.MINUTE) : (WorkUnit.HOUR.getValue().equals(workUnit) ? (result = result.multiply(WorkUnit.Constants.HOUR)) : (WorkUnit.DAY.getValue().equals(workUnit) ? (result = result.multiply(WorkUnit.Constants.DAY)) : result));
                Long materialId = 0L;
                materialId = Category.MATERIAL.getValue().equals(dynamicObject.getString("producttype")) ? Long.valueOf(dynamicObject.getLong("entryproduct.materielf7")) : Long.valueOf(dynamicObject.getLong("entryproduct.materialgroup"));
                matToTimeMap.put(materialId, result);
                workcenterMatToTimeMap.put(workCenterId, matToTimeMap);
            }
        }
        HashMap<Long, Map<String, BigDecimal>> workDateToTimes = new HashMap<Long, Map<String, BigDecimal>>();
        if (workcenterMatToDateNumMap != null) {
            for (Map.Entry<Long, Map<Long, Map<String, BigDecimal>>> mapEntry : workcenterMatToDateNumMap.entrySet()) {
                Map matToTimeMap;
                Long workCenterId = mapEntry.getKey();
                Map<Long, Map<String, BigDecimal>> value = mapEntry.getValue();
                if (!workcenterMatToTimeMap.containsKey(workCenterId) || (matToTimeMap = (Map)workcenterMatToTimeMap.get(workCenterId)) == null || matToTimeMap.size() == 0) continue;
                for (Map.Entry map : matToTimeMap.entrySet()) {
                    Long mat = (Long)map.getKey();
                    BigDecimal time = (BigDecimal)map.getValue();
                    if (!value.containsKey(mat)) continue;
                    Map<String, BigDecimal> dateToNumMap = value.get(mat);
                    for (Map.Entry<String, BigDecimal> dateToNumEntry : dateToNumMap.entrySet()) {
                        String date = dateToNumEntry.getKey();
                        BigDecimal num = dateToNumEntry.getValue();
                        HashMap<String, BigDecimal> decimalMap = (HashMap<String, BigDecimal>)workDateToTimes.get(workCenterId);
                        if (decimalMap == null) {
                            decimalMap = new HashMap<String, BigDecimal>(8);
                        }
                        BigDecimal multiply = num.multiply(time);
                        if (decimalMap.containsKey(date)) {
                            BigDecimal bigDecimal = ((BigDecimal)decimalMap.get(date)).add(multiply);
                            decimalMap.put(date, bigDecimal);
                        } else {
                            decimalMap.put(date, multiply);
                        }
                        workDateToTimes.put(workCenterId, decimalMap);
                    }
                }
            }
        }
        return workDateToTimes;
    }

    private BigDecimal isJudgeTime(Boolean intransit, Map<Long, Map<String, BigDecimal>> workcenterMatToDateNumMap, long workCenterId, String format, Long shiftDValue) {
        Map<String, BigDecimal> dateTimeMap;
        if (intransit.booleanValue() && workcenterMatToDateNumMap.containsKey(workCenterId) && (dateTimeMap = workcenterMatToDateNumMap.get(workCenterId)).containsKey(format)) {
            BigDecimal time_begin;
            BigDecimal time = dateTimeMap.get(format).multiply(new BigDecimal(1000));
            if (time.compareTo(time_begin = new BigDecimal(shiftDValue)) > 0) {
                BigDecimal subtract_end = time.subtract(time_begin);
                dateTimeMap.put(format, subtract_end.divide(new BigDecimal(1000), 0, RoundingMode.DOWN));
                return null;
            }
            dateTimeMap.put(format, BigDecimal.ZERO);
            return time;
        }
        return BigDecimal.ZERO;
    }

    private Map<Long, Map<Long, Long>> getWorkCenterMatOrGroup(Set<Long> workcenterIds) {
        HashMap<Long, Map<Long, Long>> workCenterMat = new HashMap<Long, Map<Long, Long>>(8);
        String selectFields = "id,entryproduct.producttype producttype,entryproduct.materielf7,entryproduct.materialgroup,entryproduct.subentryentitycal.workunits,entryproduct.subentryentitycal.completeresult,entryproduct.subentryentitycal.precision";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mpdm_workcentre", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", workcenterIds)}, (String)"entryproduct.materielf7 desc");
        for (DynamicObject dynamicObject : query) {
            long workCenterId = dynamicObject.getLong("id");
            HashMap<Long, Long> mat = (HashMap<Long, Long>)workCenterMat.get(workCenterId);
            if (mat == null) {
                mat = new HashMap<Long, Long>(8);
            }
            Long materialId = 0L;
            if (Category.MATERIAL.getValue().equals(dynamicObject.getString("producttype"))) {
                materialId = dynamicObject.getLong("entryproduct.materielf7");
                mat.put(materialId, materialId);
            } else {
                DynamicObject[] materialmftinfo;
                materialId = dynamicObject.getLong("entryproduct.materialgroup");
                QFilter filter = new QFilter("mftcontrolentry.materialcontrol.id", "=", (Object)materialId);
                QFilter status = new QFilter("status", "=", (Object)"C");
                QFilter enable = new QFilter("enable", "=", (Object)"1");
                for (DynamicObject materialInfo : materialmftinfo = BusinessDataServiceHelper.load((String)"bd_materialmftinfo", (String)"id,masterid,materialattr", (QFilter[])new QFilter[]{filter, status, enable})) {
                    DynamicObject material = (DynamicObject)materialInfo.get("masterid");
                    if (mat.containsKey(material.getLong("id"))) continue;
                    mat.put(material.getLong("id"), materialId);
                }
            }
            workCenterMat.put(workCenterId, mat);
        }
        return workCenterMat;
    }

    public Map<Long, Map<Long, Map<String, BigDecimal>>> getInstransitOrder(OrderMaterialMananger orderMaterialMananger, WorkCenterManager workCenterManager) {
        HashMap<Long, Map<Long, Map<String, BigDecimal>>> workcenterMatToDateNumMap = new HashMap<Long, Map<Long, Map<String, BigDecimal>>>(8);
        List<QFilter> mftorderQfilter = this.getMftorderQfilter();
        Map id2WorkCenter = workCenterManager.getId2WorkCenter();
        Map<Long, Map<Long, Long>> workCenterMatOrGroup = this.getWorkCenterMatOrGroup(id2WorkCenter.keySet());
        DynamicObjectCollection pom_mftorder = QueryServiceHelper.query((String)"pom_mftorder", (String)"org,treeentryentity.material,treeentryentity.material.masterid,treeentryentity.baseqty,treeentryentity.workcenter,treeentryentity.planbegintime", (QFilter[])mftorderQfilter.toArray(new QFilter[mftorderQfilter.size()]));
        StringBuilder orderSb = new StringBuilder();
        Calendar instance = Calendar.getInstance();
        for (DynamicObject dynamicObject : pom_mftorder) {
            Map<String, BigDecimal> dateNumMap;
            HashMap<Long, Map<String, BigDecimal>> matToDateNumMap;
            java.util.Date date_w = dynamicObject.getDate("treeentryentity.planbegintime");
            instance.setTime(date_w);
            instance.set(11, 0);
            instance.set(12, 0);
            instance.set(13, 0);
            instance.set(14, 0);
            String date = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(instance.getTime());
            Long workcenterId = dynamicObject.getLong("treeentryentity.workcenter");
            Map<Long, Long> longLongMap = workCenterMatOrGroup.get(workcenterId);
            Long orderModelKey = this.getOrderModelKeyByQuery(dynamicObject, longLongMap);
            BigDecimal baseqty = dynamicObject.getBigDecimal("treeentryentity.baseqty");
            if (workcenterId == 0L || orderModelKey == null) continue;
            if (workcenterMatToDateNumMap.containsKey(workcenterId)) {
                matToDateNumMap = (HashMap<Long, Map<String, BigDecimal>>)workcenterMatToDateNumMap.get(workcenterId);
                if (matToDateNumMap.containsKey(orderModelKey)) {
                    dateNumMap = (Map)matToDateNumMap.get(orderModelKey);
                    if (dateNumMap.containsKey(date)) {
                        BigDecimal num = (BigDecimal)dateNumMap.get(date);
                        num = num.add(baseqty);
                        dateNumMap.put(date, num);
                        continue;
                    }
                    dateNumMap.put(date, baseqty);
                    continue;
                }
                dateNumMap = new HashMap(8);
                dateNumMap.put(date, baseqty);
                matToDateNumMap.put(orderModelKey, dateNumMap);
                continue;
            }
            matToDateNumMap = new HashMap<Long, Map<String, BigDecimal>>(8);
            dateNumMap = new HashMap<String, BigDecimal>(8);
            dateNumMap.put(date, baseqty);
            matToDateNumMap.put(orderModelKey, dateNumMap);
            workcenterMatToDateNumMap.put(workcenterId, matToDateNumMap);
        }
        return workcenterMatToDateNumMap;
    }

    private Long getOrderModelKeyByQuery(DynamicObject dynamicObject, Map<Long, Long> matOrGroup) {
        Long materielId = dynamicObject.getLong("treeentryentity.material");
        if (matOrGroup == null) {
            return null;
        }
        Long aLong = matOrGroup.get(materielId);
        return aLong;
    }

    private Long getOrderModelKeyByQuery(OrderMaterialMananger orderMaterialMananger, WorkCenterManager workCenterManager, DynamicObject dynamicObject, StringBuilder orderSb) {
        Long materielId = dynamicObject.getLong("treeentryentity.material.masterid");
        Long productionOrgId = dynamicObject.getLong("org");
        orderSb.setLength(0);
        orderSb.append(materielId).append('_').append(productionOrgId);
        String midAndProdOrgId = orderSb.toString();
        return orderMaterialMananger.getOrderModelKey(workCenterManager, midAndProdOrgId, materielId.longValue());
    }

    public List<QFilter> getMftorderQfilter() {
        ArrayList<QFilter> list_qf = new ArrayList<QFilter>(8);
        QFilter billstatus_qf = new QFilter("billstatus", "=", (Object)"C");
        QFilter taskstatus_qf = new QFilter("treeentryentity.taskstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B", "D"}));
        QFilter bizstatus_qf = new QFilter("treeentryentity.bizstatus", "=", (Object)"A");
        QFilter billstatus_workcenter = new QFilter("treeentryentity.workcenter", "is not null", (Object)"");
        list_qf.add(billstatus_qf);
        list_qf.add(taskstatus_qf);
        list_qf.add(bizstatus_qf);
        list_qf.add(billstatus_workcenter);
        return list_qf;
    }

    private long getShiftDValue(WorkShift workShift, java.util.Date shiftStartDateTime, java.util.Date shiftEndDateTime, List<DowntimePlan> downtimePlans) {
        long shiftDValue = workShift.getDValue() * 1000L;
        boolean first = true;
        for (DowntimePlan downtimePlan : downtimePlans) {
            boolean containsEnd;
            java.util.Date downtimePlanStartDateTime = downtimePlan.getStartDateTime();
            java.util.Date downtimePlanEndDateTime = downtimePlan.getEndDateTime();
            boolean containsStartLeft = downtimePlanStartDateTime.compareTo(shiftStartDateTime) >= 0;
            boolean containsStartRight = downtimePlanStartDateTime.compareTo(shiftEndDateTime) <= 0;
            boolean containsEndLeft = downtimePlanEndDateTime.compareTo(shiftStartDateTime) >= 0;
            boolean containsEndRight = downtimePlanEndDateTime.compareTo(shiftEndDateTime) <= 0;
            boolean containsStart = containsStartLeft && containsStartRight;
            boolean bl = containsEnd = containsEndLeft && containsEndRight;
            if (!containsStartLeft && !containsEndRight) {
                shiftDValue = 0L;
                break;
            }
            if (containsStart && containsEnd) {
                shiftDValue -= downtimePlan.getdValue().longValue();
                first = false;
                continue;
            }
            if ((containsStart || containsEnd) && first) {
                java.util.Date minStartDateTime = shiftStartDateTime.compareTo(downtimePlanStartDateTime) <= 0 ? shiftStartDateTime : downtimePlanStartDateTime;
                java.util.Date maxEndDateTime = shiftEndDateTime.compareTo(downtimePlanEndDateTime) <= 0 ? downtimePlanEndDateTime : shiftEndDateTime;
                shiftDValue = maxEndDateTime.getTime() - minStartDateTime.getTime() - downtimePlan.getdValue();
                first = false;
                continue;
            }
            if (!containsStart) continue;
            shiftDValue -= shiftEndDateTime.getTime() - downtimePlanStartDateTime.getTime();
        }
        return shiftDValue;
    }

    private Map<Integer, WorkShift> getworkShiftMap(SchedulingScheme schedulingScheme, WorkShiftManager workShiftManager) {
        Map<Integer, WorkShift> workShiftMap = workShiftManager.getAll();
        if (schedulingScheme.getAcrossDayShift().booleanValue()) {
            workShiftMap = PlsSaveDetailSetpImpl.workShiftSort(workShiftMap);
        }
        return workShiftMap;
    }

    private WorkShiftManager getWorkShif(WorkShiftManager defaultWorkShiftManager, WorkCenterManager workCenterManager, long workCenterId) {
        WorkShiftManager workShiftManager = workCenterManager.getWorkShift(Long.valueOf(workCenterId));
        if (workShiftManager == null) {
            workShiftManager = defaultWorkShiftManager;
        }
        return workShiftManager;
    }

    private void queryMaterialPlanInfo(List<Row> plsOrders, String settingValue, QFilter dataFilter, Map<String, Tuple<Long, Long>> matPlanMap, Map<Long, Tuple<Long, Long>> matPlanGlobalMap) {
        Serializable materielId;
        HashSet<Long> materielIds = new HashSet<Long>(plsOrders.size());
        QFilter matQfilter = null;
        for (int i = 0; i < plsOrders.size(); ++i) {
            Row plsOrder = plsOrders.get(i);
            materielId = (Long)ObjectConverter.convert((Object)plsOrder.get("materiel_code"), Long.class, (boolean)false);
            materielIds.add((Long)materielId);
            Long orgId = (Long)ObjectConverter.convert((Object)plsOrder.get("production_org"), Long.class, (boolean)false);
            if (matQfilter == null) {
                matQfilter = new QFilter("createorg", "=", (Object)orgId).and(new QFilter("masterid", "=", (Object)materielId));
                continue;
            }
            matQfilter.or(new QFilter("createorg", "=", (Object)orgId).and(new QFilter("masterid", "=", (Object)materielId)));
        }
        QFilter[] filters = "IGNORE".equals(settingValue) ? new QFilter[]{matQfilter} : new QFilter[]{dataFilter, matQfilter};
        DataSet dataSet = ORM.create().queryDataSet("query_materialplan", "mpdm_materialplan", "id, createorg, masterid, plantags", filters);
        materielId = null;
        try {
            for (Row row : dataSet) {
                matPlanMap.put(Long.toString(row.getLong("createorg")).concat("_").concat(Long.toString(row.getLong("masterid"))), (Tuple<Long, Long>)new Tuple((Object)row.getLong("id"), (Object)row.getLong("plantags")));
            }
        }
        catch (Throwable orgId) {
            materielId = orgId;
            throw orgId;
        }
        finally {
            if (dataSet != null) {
                if (materielId != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable orgId) {
                        ((Throwable)materielId).addSuppressed(orgId);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        QFilter ctrlStrategyFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
        QFilter materielIdFilter = new QFilter("masterid", "in", materielIds);
        filters = "IGNORE".equals(settingValue) ? new QFilter[]{ctrlStrategyFilter, materielIdFilter} : new QFilter[]{dataFilter, ctrlStrategyFilter, materielIdFilter};
        try (DataSet dataSet2 = ORM.create().queryDataSet("query_materialplanglobal", "mpdm_materialplan", "id, masterid, plantags", filters, "id desc");){
            for (Row row : dataSet2) {
                matPlanGlobalMap.put(row.getLong("masterid"), (Tuple<Long, Long>)new Tuple((Object)row.getLong("id"), (Object)row.getLong("plantags")));
            }
        }
    }

    private ArrayList<Object> initValue(Row plsOrder, Map<String, Tuple<Long, Long>> matPlanMap, Map<Long, Tuple<Long, Long>> matPlanGlobalMap) {
        ArrayList value = Lists.newArrayListWithExpectedSize((int)30);
        String orderNo = (String)ObjectConverter.convert((Object)plsOrder.get("plan_order_billno"), String.class, (boolean)false);
        if (orderNo == null) {
            orderNo = " ";
        }
        value.add(orderNo);
        String type = (String)ObjectConverter.convert((Object)plsOrder.get("sourceentity"), String.class, (boolean)false);
        if (type == null) {
            type = " ";
        }
        value.add(type);
        Long matId = (Long)ObjectConverter.convert((Object)plsOrder.get("materiel_code"), Long.class, (boolean)false);
        value.add(matId);
        value.add(ObjectConverter.convert((Object)plsOrder.get("unit"), Long.class, (boolean)false));
        value.add(ObjectConverter.convert((Object)plsOrder.get("ecn_version"), Long.class, (boolean)false));
        value.add(plsOrder.getDate("plan_prepare_date"));
        value.add(ObjectConverter.convert((Object)plsOrder.get("bom"), Long.class, (boolean)false));
        value.add(ObjectConverter.convert((Object)plsOrder.get("product_yield_rate"), BigDecimal.class, (boolean)false));
        value.add(ObjectConverter.convert((Object)plsOrder.get("product_yield_num"), BigDecimal.class, (boolean)false));
        value.add(ObjectConverter.convert((Object)plsOrder.get("planner"), Long.class, (boolean)false));
        Long orgId = (Long)ObjectConverter.convert((Object)plsOrder.get("production_org"), Long.class, (boolean)false);
        value.add(orgId);
        value.add(plsOrder.getDate("available_date"));
        value.add(ObjectConverter.convert((Object)plsOrder.get("order_num"), BigDecimal.class, (boolean)false));
        Tuple<Long, Long> matPlanTuple = matPlanMap.get(Long.toString(orgId).concat("_").concat(Long.toString(matId)));
        if (matPlanTuple == null) {
            matPlanTuple = matPlanGlobalMap.get(matId);
        }
        if (matPlanTuple == null) {
            value.add(0L);
            value.add(0L);
        } else {
            value.add(matPlanTuple.item1);
            value.add(matPlanTuple.item2);
        }
        return value;
    }

    private void saveResultDataToDB(List<List<Object>> resultValues, SchedulingScheme schedulingScheme, String runLogNumber) {
        if (resultValues.isEmpty()) {
            return;
        }
        int size = resultValues.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)size);
        long currUserId = RequestContext.get().getCurrUserId();
        java.util.Date now = new java.util.Date();
        int i = 0;
        while (i < size) {
            List<Object> value = resultValues.get(i);
            value.add(ids[i++]);
            value.add(schedulingScheme.getSchemeId());
            value.add(runLogNumber);
            value.add(currUserId);
            value.add(now);
            result.add(value.toArray());
        }
        String insertSql = this.getResultInsertSql();
        SaveUtils.batchSave((String)"scm", (String)insertSql, (List)result);
    }

    private void saveDetailDataToDB(List<List<Object>> values, SchedulingScheme schedulingScheme) {
        if (values.isEmpty()) {
            return;
        }
        int size = values.size();
        long headId = ID.genLongId();
        long[] entryIds = ID.genLongIds((int)size);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)size);
        int i = 0;
        while (i < size) {
            List<Object> value = values.get(i);
            value.add(headId);
            value.add(entryIds[i++]);
            value.add(i);
            result.add(value.toArray());
        }
        this.saveDetailHead(headId, schedulingScheme);
        String insertSql = this.getInsertSql();
        SaveUtils.batchSave((String)"scm", (String)insertSql, (List)result);
    }

    private Long getOrderModelKey(StringBuilder orderSb, Row plsOrder, OrderMaterialMananger orderMaterialMananger, WorkCenterManager workCenterManager) {
        Long materielId = plsOrder.getLong("materiel_code");
        Long productionOrgId = plsOrder.getLong("production_org");
        orderSb.setLength(0);
        orderSb.append(materielId).append('_').append(productionOrgId);
        String midAndProdOrgId = orderSb.toString();
        return orderMaterialMananger.getOrderModelKey(workCenterManager, midAndProdOrgId, materielId.longValue());
    }

    private void saveDetailHead(long headId, SchedulingScheme schedulingScheme) {
        DynamicObject plsDetails = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"mrp_pls_detail"), (Object)headId);
        plsDetails.set("pls_scheme_id", (Object)schedulingScheme.getSchemeId());
        plsDetails.set("pls_operationno", (Object)this.env.getRunLogNumber());
        plsDetails.set("createtime", (Object)new java.util.Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plsDetails});
    }

    private String getInsertSql() {
        return "INSERT INTO T_MRP_PLS_DETAIL_ENTRY (FSOURCEORDERBILLNO, FSOURCEORDERTYPE, FMATERIELCODE, FUNIT, FECNVERSION, FPLANPREPAREDATE, FBOM, FYIELDRATE, FYIELDQTY, FPLSPLANNERID, FPRODUCTIONORGID, FAVAILABLEDATE, FORDERINITIALQTY, FMATERIALPLANID, FPLANTAGSID, FWORKCENTRE, FPLSDATE, FWORKSTARTTIME, FWORKENDTIME, FORDERCALCULATEQTY, FWORKPOWERQTY, FWORKPLSQTY, FWORKREMAININGQTY, FWORKSHOPID, FWORKSHIFTID, FDATEUNIT, FPRODUCTIONORDER, FORDERREMAININGQTY, FWCTIMECONSUMING, FID, FENTRYID, FSEQ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    private String getResultInsertSql() {
        return "INSERT INTO T_MRP_PLS_RESULT (FSOURCEORDERBILLNO, FSOURCEORDERTYPE, FMATERIELCODE, FUNIT, FECNVERSION, FPLANPREPAREDATE, FBOM, FYIELDRATE, FYIELDQTY, FPLSPLANNERID, FPRODUCTIONORGID, FAVAILABLEDATE, FORDERINITIALQTY, FMATERIALPLANID, FPLANTAGSID, FWORKCENTRE, FPLSDATE, FWORKSTARTTIME, FWORKENDTIME, FORDERCALCULATEQTY, FWORKPOWERQTY, FWORKPLSQTY, FWORKREMAININGQTY, FWORKSHOPID, FWORKSHIFTID, FDATEUNIT, FPRODUCTIONORDER, FORDERREMAININGQTY, FSTATUS, FID, FPLSSCHEMEID, FPLSOPERATIONNO, FCREATER, FCREATETIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    private boolean isInPlanDate(java.util.Date workDate, java.util.Date planStartDate, java.util.Date planFinishDate) {
        boolean containsStartRight = DateUtils.truncatedCompareTo((java.util.Date)planStartDate, (java.util.Date)workDate, (int)5) <= 0;
        boolean containsEndLeft = DateUtils.truncatedCompareTo((java.util.Date)planFinishDate, (java.util.Date)workDate, (int)5) >= 0;
        return containsStartRight && containsEndLeft;
    }

    public static Map<Integer, WorkShift> workShiftSort(Map<Integer, WorkShift> workShiftMap) {
        LinkedHashMap<Integer, WorkShift> newWorkShiftMap = new LinkedHashMap<Integer, WorkShift>(workShiftMap.size());
        for (Map.Entry<Integer, WorkShift> workShiftEntry : workShiftMap.entrySet()) {
            if (!workShiftEntry.getValue().isAcrossDay()) continue;
            newWorkShiftMap.put(workShiftEntry.getKey(), workShiftEntry.getValue());
        }
        for (Map.Entry<Integer, WorkShift> workShiftEntry : workShiftMap.entrySet()) {
            if (workShiftEntry.getValue().isAcrossDay()) continue;
            newWorkShiftMap.put(workShiftEntry.getKey(), workShiftEntry.getValue());
        }
        return newWorkShiftMap;
    }

    private boolean getBoolean(java.util.Date workDate, java.util.Date firstDate, java.util.Date startDate, WorkShiftManager workShiftManager, Integer shiftSeq) {
        this.plsDate = DateUtils.addDays((java.util.Date)workDate, (int)-1);
        return DateUtils.isSameDay((java.util.Date)workDate, (java.util.Date)firstDate) && (DateUtils.isSameDay((java.util.Date)this.plsDate, (java.util.Date)startDate) ? !workShiftManager.currentWorkShiftCanWork(shiftSeq.intValue()) : this.plsDate.compareTo(startDate) < 0);
    }
}

