/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.integrate.InvTransRatio;
import kd.mmc.mrp.integrate.PriorityComparator;
import kd.mmc.mrp.integrate.entity.BomDataModel;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.IResDataInfo;
import kd.mmc.mrp.integrate.entity.InventoryModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.SupplyDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.StockSetUpEnum;
import kd.mmc.mrp.model.enums.status.MRPPlanModelStatus;
import kd.mmc.mrp.model.struct.InvRealBalanceStruct;
import kd.mmc.mrp.model.struct.InvSupplyStruct;
import kd.mmc.mrp.model.struct.InvWareHouseStruct;
import kd.mmc.mrp.model.struct.MaterialStruct;
import kd.mmc.mrp.model.struct.PriorityStruct;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.InvPlanUtil;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;

public class ResDataModelCollection {
    private static Log logger = LogFactory.getLog(ResDataModelCollection.class);
    private static final ORM orm = ORM.create();
    private BomDataModel bom;
    private RequireDataModel require;
    private SupplyDataModel supply;
    private CalEnv env;
    private Map<String, DynamicObject[]> dataQueryCache = new HashMap<String, DynamicObject[]>();
    private HashMap<String, InvTransRatio> materialWasteRatios = new HashMap();
    private DynamicObject runLog;

    public ResDataModelCollection(CalEnv env, IResDataInfo resDataInfo, DynamicObject runLog) {
        this.env = env;
        env.addService(ResDataModelCollection.class, this);
        this.runLog = runLog;
    }

    public void init() {
        IResDataInfo resDataInfo = (IResDataInfo)this.env.getService(PlanModel.class);
        this.require = new RequireDataModel(resDataInfo.getRequireResId(), resDataInfo.getR2STransId(), this.env);
        this.supply = new SupplyDataModel(resDataInfo.getSupplyResId(), resDataInfo.getR2STransId(), this.env);
        this.bom = this.require.getR2b() != null ? new BomDataModel(resDataInfo.getBomResId(), this.require.getR2b(), this.env) : new BomDataModel(0L, null, this.env);
        this.checkResData();
        this.initMaterialWaster();
    }

    private void checkResData() {
        List<FieldMapping> r2s;
        DynamicObject requirementModel;
        DynamicObject supplymentModel = this.getSupply().getModel();
        if (supplymentModel == null) {
            throw new MRPBizException(Errors.getNoSupplyModel(), Tips.getNosupplymodel());
        }
        String runType = this.runLog.getString("runtype");
        if (!MRPPlanModelStatus.APPROVED.getValue().equals(supplymentModel.getString("status"))) {
            throw new MRPBizException(new ErrorCode("UNAPPROVED_SUPPLY_MODEL", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u8d44\u6e90\u6a21\u578b\uff08\u4f9b\u5e94\uff09\u672a\u5ba1\u6838\u3002", (String)"ResDataModelCollection_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), supplymentModel.get("number"))), '\u3010' + supplymentModel.getString("number") + '\u3011' + Tips.getModelDisabled());
        }
        if (!"C".equals(runType) && !"B".equals(runType) && supplymentModel.get("outtosupply") == null) {
            throw new MRPBizException(new ErrorCode("EMPTTY_OUTTOSUPPLY", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u8d44\u6e90\u6a21\u578b\uff08\u4f9b\u5e94\uff09\u672a\u8bbe\u7f6e\u8f93\u51fa\u8f6c\u4f9b\u5e94\u6620\u5c04\u3002", (String)"ResDataModelCollection_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), supplymentModel.get("number"))), '\u3010' + supplymentModel.getString("number") + '\u3011' + Tips.getEmptyOuttosupply());
        }
        String supplySrcBill = "";
        DynamicObject outToSupply = (DynamicObject)supplymentModel.get("outtosupply");
        if (outToSupply != null && outToSupply.get("srcbill.id") != null) {
            supplySrcBill = outToSupply.getString("srcbill.id");
        }
        if ((requirementModel = this.getRequire().getModel()) == null) {
            throw new MRPBizException(Errors.getNoRequireModel(), Tips.getNorequiremodel());
        }
        if (!MRPPlanModelStatus.APPROVED.getValue().equals(requirementModel.getString("status"))) {
            throw new MRPBizException(new ErrorCode("UNAPPROVED_REQUIRE_MODEL", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u8d44\u6e90\u6a21\u578b\uff08\u9700\u6c42\uff09\u672a\u5ba1\u6838\u3002", (String)"ResDataModelCollection_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]), requirementModel.get("number"))), '\u3010' + requirementModel.getString("number") + '\u3011' + Tips.getModelDisabled());
        }
        String outPutType = "";
        if (requirementModel.get("outputtype.id") != null) {
            outPutType = requirementModel.getString("outputtype.id");
        }
        if (!"C".equals(runType) && !supplySrcBill.equals(outPutType)) {
            throw new MRPBizException(new ErrorCode("EMPTTY_OUTTOSUPPLY", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u8d44\u6e90\u6a21\u578b\uff08\u4f9b\u5e94\uff09\u5bf9\u5e94\u7684\u8f93\u51fa\u8f6c\u4f9b\u5e94\u6620\u5c04\u7684\u6e90\u5b9e\u4f53\u4e0e\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u8d44\u6e90\u6a21\u578b\uff08\u9700\u6c42\uff09\u7684\u8f93\u51fa\u7ed3\u679c\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"ResDataModelCollection_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]), supplymentModel.get("number"), requirementModel.get("number"))), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u8d44\u6e90\u6a21\u578b\uff08\u4f9b\u5e94\uff09\u5bf9\u5e94\u7684\u8f93\u51fa\u8f6c\u4f9b\u5e94\u6620\u5c04\u7684\u6e90\u5b9e\u4f53\u4e0e\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u8d44\u6e90\u6a21\u578b\uff08\u9700\u6c42\uff09\u7684\u8f93\u51fa\u7ed3\u679c\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"ResDataModelCollection_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]), supplymentModel.get("number"), requirementModel.get("number")));
        }
        if (!this.getBom().isFake()) {
            DynamicObject bomModel = this.getBom().getModel();
            if (bomModel == null) {
                throw new MRPBizException(Errors.getNoBomModel(), Tips.getNobommodel());
            }
            if (!MRPPlanModelStatus.APPROVED.getValue().equals(bomModel.getString("status"))) {
                throw new MRPBizException(new ErrorCode("UNAPPROVED_BOM_MODEL", String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\u8d44\u6e90\u6a21\u578b(BOM)\u672a\u5ba1\u6838", (String)"ResDataModelCollection_4", (String)"mmc-mrp-mservice", (Object[])new Object[0]), bomModel.get("number"))), '\u3010' + bomModel.getString("number") + '\u3011' + Tips.getModelDisabled());
            }
            List<FieldMapping> b2r = this.getRequire().getR2b();
            if (MRPUtil.isEmpty(b2r)) {
                throw new MRPBizException(Errors.getEmptyB2rRelation());
            }
        }
        if ((r2s = this.getRequire().getR2s()) == null || MRPUtil.isEmpty(r2s)) {
            throw new MRPBizException(Errors.getEmptyR2sRelation());
        }
    }

    public BomDataModel getBom() {
        return this.bom;
    }

    public RequireDataModel getRequire() {
        return this.require;
    }

    public SupplyDataModel getSupply() {
        return this.supply;
    }

    public Map<String, DynamicObject[]> getDataQueryCache() {
        return this.dataQueryCache;
    }

    public void restoreTableDatas(String evtId, String id, String groupKey, List<Object[]> datas, boolean isRequire) {
        if ("null".equals(id)) {
            AbstractResModelDataTable table = isRequire ? this.getRequire().getTable() : this.getSupply().getTable();
            String modelNumber = isRequire ? ResManager.loadKDString((String)"\u76f8\u5173\u9700\u6c42", (String)"ResDataModelCollection_5", (String)"mmc-mrp-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65b0\u5efa\u8ba1\u5212\u8ba2\u5355\uff08\u8054\u526f\u4ea7\u54c1\uff09", (String)"ResDataModelCollection_6", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            table.getFieldsMap().clear();
            ArrayList<String> metas = new ArrayList<String>(table.getColIdx().keySet());
            for (String key : table.getColIdx().keySet()) {
                ArrayList<String> labels = new ArrayList<String>();
                labels.add(key);
                table.getFieldsMap().put(key, labels);
                metas.set(table.getColIdx().get(key), key);
            }
            StringBuilder message = new StringBuilder();
            StringBuilder fill = table.fill(metas, datas, null, null, modelNumber, modelNumber);
            message.append((CharSequence)fill);
            if (message.length() > 0) {
                message = new StringBuilder(modelNumber).append(":\r\n").append((CharSequence)message).append(ResManager.loadKDString((String)"\u503c\u4e3a\u7a7a\u3002", (String)"ResDataModelCollection_7", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
                logger.warn(String.format("ctxid: %s, mrprunner-restoreTableDatas-error,message:%s", this.env.getMRPContextId(), message.toString()));
                if (isRequire) {
                    this.getRequire().writeMRPExceptionInfo(message.toString());
                } else {
                    this.getSupply().writeMRPExceptionInfo(message.toString());
                }
            }
        } else if (isRequire) {
            this.getRequire().restoreTableDatas(evtId, id, groupKey, datas);
        } else {
            this.getSupply().restoreTableDatas(evtId, id, groupKey, datas);
        }
    }

    public List<Integer> sortByPriority(SupplymentDataTable table, String orgId, List<Integer> rows, String strategyId) {
        return this.sortByPriority(table, orgId, rows, strategyId, false);
    }

    public List<Integer> sortByPriority(SupplymentDataTable supplyTbl, String orgId, List<Integer> rows, String strategyId, boolean checkCenterWarehouse) {
        return ResDataModelCollection.sortByPriority(this.env, supplyTbl, orgId, rows, strategyId, checkCenterWarehouse, this.materialWasteRatios);
    }

    public static List<Integer> sortByPriority(CalEnv env, SupplymentDataTable supplyTbl, String orgId, List<Integer> rows, String strategyId, boolean checkCenterWarehouse, HashMap<String, InvTransRatio> materialWasteRatios) {
        Object strategy;
        PlanModel planModel = (PlanModel)env.getService(PlanModel.class);
        CacheDatas cacheDatas = (CacheDatas)env.getService(CacheDatas.class);
        SupplyStruct struct = planModel.getPriorityRelations().get(orgId);
        if (struct == null) {
            return new ArrayList<Integer>();
        }
        boolean isCurrentStock = true;
        boolean inway = true;
        try (TraceSpan ts = Tracer.create((String)"ResDataModelCollection.sortByPriority-loadManuStrategy", (String)"sortByPriority-tmp_safe_inv");){
            if (!DynamicObjDataUtil.isNullStringOr0Long((String)strategyId)) {
                strategy = cacheDatas.reloadDataById("bd_manustrategy", strategyId, "id,currentstock,inway");
                if (strategy == null || strategy.getLong("id") <= 0L) {
                    strategy = cacheDatas.reloadDataById("mpdm_manustrategy", strategyId, "id,currentstock,inway");
                }
                isCurrentStock = strategy == null || strategy.getBoolean("currentstock");
                inway = strategy == null ? true : strategy.getBoolean("inway");
            }
        }
        HashMap<String, ArrayList<PriorityStruct>> priorityMap = new HashMap<String, ArrayList<PriorityStruct>>(rows.size());
        TraceSpan ts = Tracer.create((String)"ResDataModelCollection.sortByPriority-group", (String)"sortByPriority-group");
        strategy = null;
        try {
            for (Integer next : rows) {
                ArrayList<PriorityStruct> prioritys;
                Object[] values = supplyTbl.getSrcDatas().getDatas().get(next);
                Object moduleId = values[supplyTbl.getColIdx().get(DefaultField.CommonField.__MODEL_ID__.name())];
                if (moduleId == null) {
                    moduleId = 0L;
                }
                if ((prioritys = (ArrayList<PriorityStruct>)priorityMap.get(String.valueOf(moduleId))) == null) {
                    prioritys = new ArrayList<PriorityStruct>();
                }
                priorityMap.put(String.valueOf(moduleId), prioritys);
                Object requireKey = values[supplyTbl.getColIdx().get(DefaultField.SupplyField.__RESERVE_REQUIRE_KEY_.getName())];
                Object isReserveRequire = values[supplyTbl.getColIdx().get(DefaultField.SupplyField._IS_RESERVE_SUPPLY_.getName())];
                if (MRPUtil.convert(isReserveRequire, Boolean.FALSE).booleanValue() && StringUtils.isNotBlank((Object)requireKey)) {
                    PriorityStruct invAccStruct = new PriorityStruct(false, next, BigDecimal.ZERO);
                    prioritys.add(invAccStruct);
                    continue;
                }
                Object isInv = values[supplyTbl.getColIdx().get(DefaultField.SupplyField.ISSTORAGEDATA.getName())];
                if (MRPUtil.convert(isInv, Boolean.FALSE).booleanValue()) {
                    if (!isCurrentStock) continue;
                    InvRealBalanceStruct invacc = new InvRealBalanceStruct(env, supplyTbl.getColIdx(), values);
                    if (!invacc.isInvalidInv()) {
                        PriorityStruct invAccStruct = new PriorityStruct(false, next, BigDecimal.ZERO);
                        prioritys.add(invAccStruct);
                        continue;
                    }
                    ResDataModelCollection.isStorageSupplyMatch(supplyTbl, struct, invacc, values, checkCenterWarehouse, planModel, next, prioritys, materialWasteRatios);
                    continue;
                }
                if (!inway) continue;
                PriorityStruct invAccStruct = new PriorityStruct(false, next, BigDecimal.ZERO);
                prioritys.add(invAccStruct);
            }
        }
        catch (Throwable throwable) {
            strategy = throwable;
            throw throwable;
        }
        finally {
            if (ts != null) {
                if (strategy != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)strategy).addSuppressed(throwable);
                    }
                } else {
                    ts.close();
                }
            }
        }
        ArrayList<Integer> newRows = new ArrayList<Integer>();
        TraceSpan ts2 = Tracer.create((String)"ResDataModelCollection.sortByPriority-tmp_safe_inv", (String)"sortByPriority-tmp_safe_inv");
        Object object = null;
        try {
            if (priorityMap.containsKey("tmp_safe_inv")) {
                newRows.addAll(ResDataModelCollection.getSortList(supplyTbl, (List)priorityMap.remove("tmp_safe_inv"), null, false));
            }
        }
        catch (Throwable next) {
            object = next;
            throw next;
        }
        finally {
            if (ts2 != null) {
                if (object != null) {
                    try {
                        ts2.close();
                    }
                    catch (Throwable next) {
                        ((Throwable)object).addSuppressed(next);
                    }
                } else {
                    ts2.close();
                }
            }
        }
        ts2 = Tracer.create((String)"ResDataModelCollection.sortByPriority-byDataSource", (String)"sortByPriority-byDataSource");
        object = null;
        try {
            DynamicObjectCollection resPrioritys = planModel.getResPrioritys();
            if (!resPrioritys.isEmpty()) {
                for (int i = 0; i < resPrioritys.size(); ++i) {
                    DynamicObject res = (DynamicObject)resPrioritys.get(i);
                    String resDataId = res.getDynamicObject("resourceregisters").getString("id");
                    int priority = res.getInt("supplypriority");
                    List prioritys = (List)priorityMap.get(resDataId);
                    if (prioritys == null) continue;
                    newRows.addAll(ResDataModelCollection.getSortList(supplyTbl, prioritys, priority, true));
                }
            }
        }
        catch (Throwable resPrioritys) {
            object = resPrioritys;
            throw resPrioritys;
        }
        finally {
            if (ts2 != null) {
                if (object != null) {
                    try {
                        ts2.close();
                    }
                    catch (Throwable resPrioritys) {
                        ((Throwable)object).addSuppressed(resPrioritys);
                    }
                } else {
                    ts2.close();
                }
            }
        }
        ts2 = Tracer.create((String)"ResDataModelCollection.sortByPriority-default", (String)"sortByPriority-default");
        object = null;
        try {
            List prioritys = (List)priorityMap.get("0");
            if (prioritys != null) {
                newRows.addAll(ResDataModelCollection.getSortList(supplyTbl, prioritys, 0, true));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ts2 != null) {
                if (object != null) {
                    try {
                        ts2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ts2.close();
                }
            }
        }
        return newRows;
    }

    public boolean isStorageSupplyMatch(SupplymentDataTable supplyTbl, SupplyStruct struct, InvRealBalanceStruct invacc, Object[] values, boolean checkCenterWarehouse, PlanModel planModel, int supplyRowIdx, List<PriorityStruct> prioritys) {
        return ResDataModelCollection.isStorageSupplyMatch(supplyTbl, struct, invacc, values, checkCenterWarehouse, planModel, supplyRowIdx, prioritys, this.materialWasteRatios);
    }

    public static boolean isStorageSupplyMatch(SupplymentDataTable supplyTbl, SupplyStruct struct, InvRealBalanceStruct invacc, Object[] values, boolean checkCenterWarehouse, PlanModel planModel, int supplyRowIdx, List<PriorityStruct> prioritys, HashMap<String, InvTransRatio> materialWasteRatios) {
        if (struct == null) {
            return false;
        }
        checkCenterWarehouse = checkCenterWarehouse && planModel.isCenterWarehouse();
        int next = supplyRowIdx;
        if (!ResDataModelCollection.checkStockTypeAndStatus(supplyTbl, struct, invacc, values)) {
            return false;
        }
        Object stockOrg = values[supplyTbl.getColIdx().get(DefaultField.SupplyField.STOCKORG.getName())];
        Object supplyId = stockOrg == null ? values[supplyTbl.getColIdx().get(DefaultField.SupplyField.SUPPLYORGUNIT.getName())] : stockOrg;
        String wareHouseId = invacc.getWareHouseId();
        String locationId = invacc.getLocationId();
        if (values[supplyTbl.getColIdx().get(DefaultField.SupplyField.WAREHOUSE.getName())] == null && StringUtils.isNotBlank((CharSequence)wareHouseId)) {
            values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.WAREHOUSE.getName()).intValue()] = MRPUtil.convert((Object)wareHouseId, 0L);
        }
        if (values[supplyTbl.getColIdx().get(DefaultField.SupplyField.WAREHOUSENAME.getName())] == null && StringUtils.isNotBlank((CharSequence)invacc.getWareHouseName())) {
            values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.WAREHOUSENAME.getName()).intValue()] = invacc.getWareHouseName();
        }
        if (values[supplyTbl.getColIdx().get(DefaultField.SupplyField.STOCKLOT.getName())] == null && StringUtils.isNotBlank((CharSequence)locationId)) {
            values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.STOCKLOT.getName()).intValue()] = MRPUtil.convert((Object)locationId, 0L);
        }
        if (values[supplyTbl.getColIdx().get(DefaultField.SupplyField.LOCATIONNAME.getName())] == null && StringUtils.isNotBlank((CharSequence)invacc.getLocationName())) {
            values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.LOCATIONNAME.getName()).intValue()] = invacc.getLocationName();
        }
        BigDecimal reserveQty = BigDecimal.ZERO;
        InvSupplyStruct inv = struct.getInvSupplys().get(String.valueOf(supplyId));
        if (inv == null) {
            return false;
        }
        Object materialId = values[supplyTbl.getColIdx().get(DefaultField.SupplyField.MATERIAL.getName())];
        MaterialStruct materialStruct = inv.getMaterials().get(String.valueOf(materialId));
        boolean flag = ResDataModelCollection.isMaterialSetInv(supplyTbl, values, reserveQty, materialStruct, wareHouseId, locationId, next, prioritys);
        if (!flag) {
            if (StockSetUpEnum.ALL_WAREHOUSE.getValue().equalsIgnoreCase(struct.getStockSetUp())) {
                ResDataModelCollection.setSupplyQty(supplyTbl, values, reserveQty, inv.getRatio(), next, inv.getPriority(), prioritys);
            } else if (StockSetUpEnum.IS_MRP_WAREHOUSE.getValue().equalsIgnoreCase(struct.getStockSetUp())) {
                ArrayList<InvWareHouseStruct> invWareHouses = new ArrayList<InvWareHouseStruct>(inv.getInvWareHouses());
                if (checkCenterWarehouse) {
                    String key = String.format("%s\u0001%s", inv.getCenterWarehouseId(), inv.getCenterLocationId() == null ? "" : inv.getCenterLocationId());
                    List centerWhs = planModel.getCenterWarehouse().getOrDefault(key, Collections.emptyList());
                    invWareHouses.addAll(centerWhs);
                }
                HashSet<String> checked = new HashSet<String>();
                for (InvWareHouseStruct wareHouseStruct : invWareHouses) {
                    String mWareHouseId = wareHouseStruct.getWarehouseId() == null ? "" : wareHouseStruct.getWarehouseId();
                    String mLocationId = wareHouseStruct.getLocationId() == null ? "" : wareHouseStruct.getLocationId();
                    String key = mWareHouseId + mLocationId;
                    if (checked.contains(key)) continue;
                    checked.add(key);
                    if (!wareHouseId.equalsIgnoreCase(mWareHouseId) || !"".equals(mLocationId) && !locationId.equalsIgnoreCase(mLocationId)) continue;
                    BigDecimal useQty = MRPUtil.convert(values[supplyTbl.getColIdx().get(DefaultField.SupplyField.QTY.getName())], BigDecimal.ZERO).subtract(reserveQty);
                    BigDecimal qty = ResDataModelCollection.calcSupplyRatio(useQty, inv.getRatio(), values, supplyTbl);
                    Object changed = values[supplyTbl.getColIdx().get(DefaultField.SupplyField.__WASTE_CHANGED__.getName())];
                    if (wareHouseStruct.isWasteWH() && changed == null) {
                        if (materialWasteRatios.containsKey(String.valueOf(materialId))) {
                            InvTransRatio itr = materialWasteRatios.get(String.valueOf(materialId));
                            qty = MRPUtil.multiply(itr.getRatio(), qty);
                            values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__WASTE_STORAGE_RATIO__.getName()).intValue()] = itr.getRatio();
                            values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__WASTE_STORAGE_DEAL_TIME__.getName()).intValue()] = itr.getDealTime();
                            logger.warn(String.format("mrprunner-have-materialWasteRatios mid: %s, wareHouseid: %s, locationid: %s, iswaste: %s", materialId, wareHouseStruct.getWarehouseId(), wareHouseStruct.getLocationId(), wareHouseStruct.isWasteWH()));
                        } else {
                            values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()).intValue()] = "93";
                            values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName()).intValue()] = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8f6c\u6362\u7387\u7684\u4e09\u54c1\u4ed3\u5e93\u7269\u6599\u3002", (String)"ResDataModelCollection_8", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
                        }
                        values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__WASTE_CHANGED__.getName()).intValue()] = 1;
                    }
                    values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.QTY.getName()).intValue()] = qty;
                    values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.USABLESTOQTY.getName()).intValue()] = useQty;
                    values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__SUPPLY_PRIORITY__.getName()).intValue()] = wareHouseStruct.getPriority().intValue();
                    PriorityStruct invAccStruct = new PriorityStruct(true, next, wareHouseStruct.getPriority());
                    prioritys.add(invAccStruct);
                    break;
                }
            } else if (StockSetUpEnum.IS_NOT_MRP_WAREHOUSE.getValue().equalsIgnoreCase(struct.getStockSetUp())) {
                ResDataModelCollection.isNotMrpSetInv(supplyTbl, values, reserveQty, inv, wareHouseId, locationId, next, prioritys);
            }
        }
        return !prioritys.isEmpty();
    }

    public static boolean checkStockTypeAndStatus(SupplymentDataTable supplyTbl, SupplyStruct struct, InvRealBalanceStruct invacc, Object[] values) {
        Set<String> stockType = struct.getStockTypes();
        Set<String> stockStatus = struct.getStockStatus();
        String typeId = invacc.getTypeId();
        String statusId = invacc.getStatusId();
        boolean isTypeEnabled = stockType.contains(typeId);
        boolean isStatusEnabled = stockStatus.contains(statusId);
        return isTypeEnabled && isStatusEnabled;
    }

    public boolean isWarehouseDataHavScope(SupplyStruct struct, Long wareHouseId, String materialId, boolean checkCenterWarehouse) {
        if (struct != null) {
            CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
            PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
            checkCenterWarehouse = checkCenterWarehouse && planModel.isCenterWarehouse();
            HashSet<String> checked = new HashSet<String>();
            Set<Long> orgs = cacheDatas.getOrgByWarehouse(wareHouseId);
            for (Long org : orgs) {
                InvSupplyStruct inv = struct.getInvSupplys().get(org.toString());
                if (!this.isWarehouseDataHavScope(struct, inv, wareHouseId, materialId, checkCenterWarehouse, checked)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isWarehouseDataHavScope(SupplyStruct struct, InvSupplyStruct inv, Long wareHouseId, String materialId, boolean checkCenterWarehouse, Set<String> checked) {
        String mWareHouseId;
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        if (inv == null) {
            return false;
        }
        MaterialStruct materialStruct = inv.getMaterials().get(materialId);
        if (materialStruct != null && (mWareHouseId = materialStruct.getWarehouseId()) != null && mWareHouseId.equalsIgnoreCase(wareHouseId.toString())) {
            return true;
        }
        if (StockSetUpEnum.ALL_WAREHOUSE.getValue().equalsIgnoreCase(struct.getStockSetUp())) {
            return true;
        }
        if (StockSetUpEnum.IS_MRP_WAREHOUSE.getValue().equalsIgnoreCase(struct.getStockSetUp())) {
            ArrayList<InvWareHouseStruct> invWareHouses = new ArrayList<InvWareHouseStruct>(inv.getInvWareHouses());
            if (checkCenterWarehouse) {
                String key = String.format("%s\u0001%s", inv.getCenterWarehouseId(), inv.getCenterLocationId() == null ? "" : inv.getCenterLocationId());
                List centerWhs = planModel.getCenterWarehouse().getOrDefault(key, Collections.emptyList());
                invWareHouses.addAll(centerWhs);
            }
            for (InvWareHouseStruct wareHouseStruct : invWareHouses) {
                String mWareHouseId2;
                String string = mWareHouseId2 = wareHouseStruct.getWarehouseId() == null ? "" : wareHouseStruct.getWarehouseId();
                if (checked.contains(mWareHouseId2)) continue;
                checked.add(mWareHouseId2);
                if (!mWareHouseId2.equalsIgnoreCase(wareHouseId.toString())) continue;
                return true;
            }
        } else if (StockSetUpEnum.IS_NOT_MRP_WAREHOUSE.getValue().equalsIgnoreCase(struct.getStockSetUp())) {
            boolean flag = true;
            List<InvWareHouseStruct> invWareHouses = inv.getInvWareHouses();
            for (InvWareHouseStruct wareHouseStruct : invWareHouses) {
                String mWareHouseId3 = wareHouseStruct.getWarehouseId() == null ? "" : wareHouseStruct.getWarehouseId();
                if (!mWareHouseId3.equalsIgnoreCase(wareHouseId.toString())) continue;
                flag = false;
                break;
            }
            return flag;
        }
        return false;
    }

    private static void isNotMrpSetInv(SupplymentDataTable supplyTbl, Object[] values, BigDecimal reserveQty, InvSupplyStruct inv, String wareHouseId, String locationId, Integer next, List<PriorityStruct> prioritys) {
        boolean isMrp = true;
        List<InvWareHouseStruct> invWareHouses = inv.getInvWareHouses();
        for (InvWareHouseStruct wareHouseStruct : invWareHouses) {
            String mLocationId;
            String mWareHouseId = wareHouseStruct.getWarehouseId() == null ? "" : wareHouseStruct.getWarehouseId();
            String string = mLocationId = wareHouseStruct.getLocationId() == null ? "" : wareHouseStruct.getLocationId();
            if (!wareHouseId.equalsIgnoreCase(mWareHouseId) || !"".equals(mLocationId) && !locationId.equalsIgnoreCase(mLocationId)) continue;
            isMrp = false;
            break;
        }
        if (isMrp) {
            ResDataModelCollection.setSupplyQty(supplyTbl, values, reserveQty, inv.getRatio(), next, inv.getPriority(), prioritys);
        }
    }

    private static boolean isMaterialSetInv(SupplymentDataTable supplyTbl, Object[] values, BigDecimal reserveQty, MaterialStruct materialStruct, String wareHouseId, String locationId, Integer next, List<PriorityStruct> prioritys) {
        boolean flag = false;
        if (materialStruct != null) {
            String mLocationId;
            String mWareHouseId = materialStruct.getWarehouseId();
            String string = mLocationId = materialStruct.getLocationId() == null ? "" : materialStruct.getLocationId();
            if (mWareHouseId != null && mWareHouseId.equalsIgnoreCase(wareHouseId) && mLocationId.equalsIgnoreCase(locationId)) {
                ResDataModelCollection.setSupplyQty(supplyTbl, values, reserveQty, materialStruct.getRatio(), next, materialStruct.getPriority(), prioritys);
                flag = true;
            }
        }
        return flag;
    }

    private static void setSupplyQty(SupplymentDataTable supplyTbl, Object[] values, BigDecimal reserveQty, BigDecimal ratio, Integer next, BigDecimal priority, List<PriorityStruct> prioritys) {
        BigDecimal useQty = MRPUtil.convert(values[supplyTbl.getColIdx().get(DefaultField.SupplyField.QTY.getName())], BigDecimal.ZERO).subtract(reserveQty);
        BigDecimal qty = ResDataModelCollection.calcSupplyRatio(useQty, ratio, values, supplyTbl);
        values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.QTY.getName()).intValue()] = qty;
        values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.USABLESTOQTY.getName()).intValue()] = useQty;
        PriorityStruct invAccStruct = new PriorityStruct(true, next, priority);
        prioritys.add(invAccStruct);
    }

    private static BigDecimal calcSupplyRatio(BigDecimal useQty, BigDecimal ratio, Object[] values, SupplymentDataTable supplyTbl) {
        Object changed = values[supplyTbl.getColIdx().get(DefaultField.SupplyField.__INV_CHANGED__.getName())];
        BigDecimal qty = useQty;
        if (changed == null) {
            qty = MRPUtil.multiply(ratio, useQty);
            values[supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__INV_CHANGED__.getName()).intValue()] = 1;
        }
        return qty;
    }

    private static List<Integer> getSortList(SupplymentDataTable table, List<PriorityStruct> prioritys, Integer supplypriority, boolean isUsePriority) {
        if (prioritys == null || prioritys.isEmpty()) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> newRows = new ArrayList<Integer>(prioritys.size());
        boolean isInvData = prioritys.get(0).getInvData();
        if (isInvData) {
            prioritys.sort(new PriorityComparator());
        }
        for (PriorityStruct struct : prioritys) {
            newRows.add(struct.getRow());
            if (isUsePriority) {
                table.updateValue(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName(), struct.getRow(), supplypriority);
                continue;
            }
            table.updateValue(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName(), struct.getRow(), struct.getPriority() == null ? -1 : struct.getPriority().intValue());
        }
        return newRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMaterialWaster() {
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        HashMap<String, InvTransRatio> tmp = new HashMap<String, InvTransRatio>();
        QFilter filter = null;
        String etStr = "mrp_wasteratio";
        String selectFields = "id, materialstandard, materialtype, wastertime, ratio";
        QFilter[] wasteRatioFilters = new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(planModel.getPlanOrgId()))};
        DataSet cds = cacheDatas.loadCacheDatas(etStr, selectFields, wasteRatioFilters);
        if (cds == null) {
            cds = orm.queryDataSet(this.getClass().getName(), etStr, selectFields, wasteRatioFilters, null);
        }
        try {
            for (Row ratio : cds) {
                Long ms = ratio.getLong("materialstandard");
                Long mt = ratio.getLong("materialtype");
                if (mt == null || mt <= 0L) continue;
                if (filter == null) {
                    filter = new QFilter("standard", "=", (Object)ms);
                    filter.and(new QFilter("group", "=", (Object)mt));
                } else {
                    QFilter sub = new QFilter("standard", "=", (Object)ms);
                    sub.and(new QFilter("group", "=", (Object)mt));
                    filter.or(sub);
                }
                BigDecimal t = ratio.getBigDecimal("wastertime");
                BigDecimal r = ratio.getBigDecimal("ratio");
                InvTransRatio itr = new InvTransRatio();
                itr.setDealTime(t);
                itr.setRatio(r);
                String key = String.format("%s\u0001%s", ms, mt);
                tmp.put(key, itr);
                logger.warn(String.format("mrprunner-query-materialWasteRatios key: %s", key));
            }
        }
        finally {
            if (cds != null) {
                cds.close();
            }
        }
        if (filter != null) {
            etStr = "bd_materialgroupdetail";
            selectFields = "id,standard,group,material";
            QFilter[] filters = new QFilter[]{filter};
            try {
                cds = cacheDatas.loadCacheDatas(etStr, selectFields, filters);
                if (cds == null) {
                    cds = ORM.create().queryDataSet(this.getClass().getName(), etStr, selectFields, filters);
                }
                while (cds.hasNext()) {
                    Row row = cds.next();
                    String key = row.getString("standard") + "\u0001" + row.getString("group");
                    this.materialWasteRatios.put(row.getString("material"), (InvTransRatio)tmp.get(key));
                }
            }
            finally {
                if (cds != null) {
                    cds.close();
                }
            }
        }
    }

    public Map<String, Object> loadShareMaterialPlanInfo(String materialId, String orgId, MRPRedisStore dstore) {
        return this.require.loadShareMaterialPlanInfo(materialId, orgId, dstore);
    }

    public String getMaterialPlanKeys(String material, String org) {
        return this.getMaterialPlanKeys(material, org, (InvLevelEntry)null);
    }

    public String getMaterialPlanKeys(String material, String org, RowData rowData, int type) {
        InventoryModel invModel = (InventoryModel)this.env.getService(InventoryModel.class);
        InvLevel invLevel = invModel.getInvLevel();
        InvLevelEntry entry = invLevel == null ? null : invLevel.getEntry((Object)org, (Object)material, new HashMap<String, Long>(InvPlanUtil.getExtendValMap(this.env, rowData, type)));
        return this.getMaterialPlanKeys(material, org, entry);
    }

    public String getMaterialPlanKeys(String material, String org, Map<String, Object> entityValMap) {
        InventoryModel invModel = (InventoryModel)this.env.getService(InventoryModel.class);
        InvLevel invLevel = invModel.getInvLevel();
        InvLevelEntry entry = invLevel == null ? null : invLevel.getEntry((Object)org, (Object)material, entityValMap);
        return this.getMaterialPlanKeys(material, org, entry);
    }

    public String getMaterialPlanKeys(String material, String org, InvLevelEntry entry) {
        InventoryModel invModel = (InventoryModel)this.env.getService(InventoryModel.class);
        List<String> extendDimensions = invModel.getExtendDimensions();
        StringBuilder sb = new StringBuilder();
        sb.append(material).append('\u0001').append(org);
        for (String type : extendDimensions) {
            sb.append('\u0001');
            if (entry != null && entry.isExistDimension(type)) {
                sb.append(entry.getDimensionValue(type));
                continue;
            }
            sb.append("null");
        }
        return sb.toString();
    }
}

