/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.integrate.DispatchMRPSaveProcessDataEvent;
import kd.mmc.mrp.integrate.KDCloudMRPSDKEnv;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.utils.SnapshotDataIntegrateUtils;
import kd.mmc.mrp.utils.MRPUtil;
import kd.sdk.mmc.mrp.IMRPSDKEnv;

public class RunLogModel {
    private DynamicObject runLog;
    private CalEnv env;
    private IMRPSDKEnv mrpSdkEnv;
    private Date planDate;
    private Long startTs;
    private Long detailId;

    public RunLogModel(CalEnv env, DynamicObject runLog) {
        this.runLog = runLog;
        this.runLog.set("mrpid", (Object)env.getMRPContextId());
        this.runLog.set("machineid", (Object)MRPRuntimeConsts.NODE_ID);
        this.env = env;
        this.mrpSdkEnv = new KDCloudMRPSDKEnv(env);
        env.addService(RunLogModel.class, this);
    }

    public IMRPSDKEnv getMrpSdkEnv() {
        return this.mrpSdkEnv;
    }

    public DynamicObject getRunLog() {
        return this.runLog;
    }

    public Long getPlanId() {
        return this.runLog.getLong("plangram");
    }

    public String getPlanNumber() {
        return this.runLog.getString("programnumber");
    }

    public String getPlanEntity() {
        String str = this.runLog.getString("plangramentity");
        return StringUtils.isEmpty((CharSequence)str) ? "mrp_planprogram" : str;
    }

    public boolean isAllowPast() {
        return this.runLog.getBoolean("isallowdateinpast");
    }

    public String getRunLogNumber() {
        return this.runLog.getString("number");
    }

    public boolean isCalcNetDemand() {
        return false;
    }

    public boolean isRelaceFirst() {
        return false;
    }

    public String getNumber() {
        return this.runLog.getString("number");
    }

    public String getRunType() {
        return this.runLog.getString("runtype");
    }

    public Object getPkValue() {
        return this.runLog.getPkValue();
    }

    public String getRunModeName() {
        return this.runLog.getString("operatmode");
    }

    public String getRunMode() {
        return this.runLog.getString("operatmodekey");
    }

    public String getRunLogPlanOrgId() {
        return this.runLog.getDynamicObject("createorg").getString("id");
    }

    public Date getPlanDate() {
        if (this.planDate == null) {
            this.planDate = MRPUtil.normalize(this.runLog.getDate("plandate"));
        }
        return this.planDate;
    }

    public Long getPlanTs() {
        if (this.startTs == null) {
            Date pd = this.runLog.getDate("startdate");
            this.startTs = pd.getTime() - this.planDate.getTime();
        }
        return this.startTs;
    }

    public String getRunLogPlanOrgName() {
        return this.runLog.getDynamicObject("createorg").getString("name");
    }

    public void checkSnap() {
        DynamicObject ver;
        DynamicObjectCollection syncHisEntrys;
        Long versionId = SnapshotDataIntegrateUtils.getVersionIdByRunLogNumber(this.getRunLogNumber());
        if (versionId != null && ((syncHisEntrys = (ver = ORM.create().queryOne("msplan_ds_version", "id, hisentity.id, hisentity.syncstatus", new QFilter[]{new QFilter("id", "=", (Object)versionId)})).getDynamicObjectCollection("hisentity")) == null || syncHisEntrys.isEmpty())) {
            throw new MRPBizException(new ErrorCode("UNSYNC_DATA_VERSION", ResManager.loadKDString((String)"\u6307\u5b9a\u6570\u636e\u7248\u672c\u672a\u8fdb\u884c\u8fc7\u6570\u636e\u540c\u6b65\uff0c\u65e0\u6cd5\u4f7f\u7528\u5feb\u7167\u53d6\u6570\u3002", (String)"RunLogModel_0", (String)"mmc-mrp-mservice", (Object[])new Object[0])));
        }
    }

    public Long getDetailId() {
        if (this.detailId == null) {
            DynamicObject detail = this.env.getORM().queryOne("mrp_calcdetail", "id", new QFilter[]{new QFilter("caculatelog", "=", (Object)this.getRunLogNumber())});
            this.detailId = detail.getLong("id");
        }
        return this.detailId;
    }

    public int saveCalcDetails() {
        return this.saveCalcDetails(null, null);
    }

    public int saveCalcDetails(String detailEntityKey, String modelId) {
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        DynamicObject calcDetails = this.genNewDynamicObject(detailEntityKey == null ? "mrp_calcdetail" : detailEntityKey);
        calcDetails.set("caculatelog", (Object)this.getNumber());
        String planType = planModel.getPlanType();
        if ("pom_planprogram".equals(planType)) {
            calcDetails.set("plantype", (Object)planModel.getPlanNumber());
            calcDetails.set("planvalue", (Object)planModel.getPlanId());
        } else {
            calcDetails.set("mrpplan", (Object)planModel.getPlanId());
        }
        calcDetails.set("createtime", (Object)System.currentTimeMillis());
        calcDetails.set("runtype", (Object)this.getRunType());
        this.env.getORM().insert(calcDetails);
        this.detailId = calcDetails.getLong("id");
        DispatchMRPSaveProcessDataEvent iDispatchEvent = new DispatchMRPSaveProcessDataEvent(this.env, this.detailId, modelId == null ? "detail" : modelId);
        return iDispatchEvent.dispatchEvent();
    }

    private DynamicObject genNewDynamicObject(String entityId) {
        return this.env.getORM().newDynamicObject(entityId);
    }

    public Long getRunLogPlanScope() {
        return this.runLog.getLong("planscope_id");
    }
}

