/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.mq.event.MRPDataFetchEvent4Supply;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.integrate.KDCloudMRPEnv;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.ResDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.InvPlanUtil;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.utils.MRPUtil;

public class SupplyDataModel
extends ResDataModel {
    private String mrpContextId;
    private long resRegId;
    private Long r2sTransId;
    private DynamicObject supplyModel;
    private SupplymentDataTable supplyDatas;
    private List<FieldMapping> r2s;
    private Set<String> supplyFields;
    private List<FieldMapping> po2s;

    public SupplyDataModel(long resRegId, Long r2sTransId, CalEnv env) {
        super(env);
        this.resRegId = resRegId;
        this.mrpContextId = env.getMRPContextId();
        this.r2sTransId = r2sTransId;
        this.init();
        this.initTableCols();
        env.addService(SupplyDataModel.class, this);
    }

    private void init() {
        this.supplyModel = BusinessDataServiceHelper.loadSingle((Object)this.resRegId, (String)"mrp_resourceregister_cf");
        this.supplyFields = this.buildFields(this.supplyModel);
        this.po2s = this.checkPo2SRelation();
    }

    @Override
    public MRPEvent getEvent() {
        MRPDataFetchEvent4Supply event = new MRPDataFetchEvent4Supply();
        event.setMrpContextId(this.mrpContextId);
        return event;
    }

    @Override
    public String getCacheKey() {
        return "SUPPLY_MODELS";
    }

    @Override
    public DynamicObject getModel() {
        return this.supplyModel;
    }

    @Override
    public SupplymentDataTable getTable() {
        return this.supplyDatas;
    }

    @Override
    public Set<String> getFields() {
        return this.supplyFields;
    }

    private void initTableCols() {
        HashSet<String> cols = new HashSet<String>();
        if (this.r2sTransId != null) {
            DynamicObject r2sTrans = BusinessDataServiceHelper.loadSingle((Object)this.r2sTransId, (String)"mrp_billfieldtransfer");
            DynamicObjectCollection entry = r2sTrans.getDynamicObjectCollection("entryentity");
            this.r2s = SupplyDataModel.buildModelRelation(entry, this.supplyFields, false);
            for (FieldMapping r : this.r2s) {
                cols.add(r.getTo());
            }
        }
        cols.add(DefaultField.SupplyField.DATE.getName());
        cols.add(DefaultField.SupplyField.__RESERVE_REQUIRE_KEY_.getName());
        this.supplyDatas = new SupplymentDataTable(this.env, cols);
        Iterator<String> its = this.supplyFields.iterator();
        int index = 0;
        while (its.hasNext()) {
            this.supplyDatas.getColIdx().put(its.next().toUpperCase(), index++);
        }
        int size = this.supplyDatas.getColIdx().size();
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.USABLESTOQTY.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.USABLESTOQTY.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.ISSTORAGEDATA.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.ISSTORAGEDATA.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.WAREHOUSE.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.WAREHOUSE.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.STOCKLOT.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.STOCKLOT.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.STOCKTYPE.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.STOCKTYPE.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.STOCKSTATUS.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.STOCKSTATUS.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.SUPPLYORGNAME.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.SUPPLYORGNAME.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.WAREHOUSENAME.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.WAREHOUSENAME.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.LOCATIONNAME.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.LOCATIONNAME.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.SUPPLYOPERATOR.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.SUPPLYOPERATOR.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.WAREHOUSENUMBER.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.WAREHOUSENUMBER.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.POSTPROCESSTIME.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.POSTPROCESSTIME.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.SUPPLANTAG.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.SUPPLANTAG.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.CONFIGPROPERTIES.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.CONFIGPROPERTIES.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.MATERIALFLEXPROPS.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.MATERIALFLEXPROPS.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.ORIGINQTY.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.ORIGINQTY.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.FLEXMETRICID.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.FLEXMETRICID.getName(), size++);
        }
        if (!this.supplyDatas.getColIdx().containsKey(DefaultField.SupplyField.FLEXMETRICVALUE.getName())) {
            this.supplyDatas.getColIdx().put(DefaultField.SupplyField.FLEXMETRICVALUE.getName(), size++);
        }
        this.supplyDatas.getColIdx().put(DefaultField.CommonField.ID.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__INV_TAG__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__IS_NEW_PLANORDER__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__IS_ADJUST__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__ADJUST_FLAG__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__ADJUST_QTY__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__SUPPLY_PRIORITY__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__SPLIT_SRC_ID__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__IS_SPLITED__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField._IS_INV_LEVEL_OCCUPIED_.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__INV_REQUIRE_KEY_.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__HAS_WHOLE_ADJUST__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__IS_OCCUPIED__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.CommonField.__MODEL_NUMBER__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.CommonField.__MODEL_ID__.name(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.BILL_ENTITY.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__IS_REPLACE__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__WASTE_STORAGE_RATIO__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__WASTE_STORAGE_DEAL_TIME__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__WASTE_CHANGED__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__ISCENTERTRANS__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__RESERVE_REQUIRE_KEY_.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__REQUIRE_IDX__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__INV_CHANGED__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__IS_COP_SUPPLY__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__MANUAL_CREATE_COP__.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.INV_IS_TRACK_MATCH.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.IS_TRACK_MATCH.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField._IS_RESERVE_SUPPLY_.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField._IS_WEAK_RESERVE_SUPPLY_.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName(), size++);
        this.supplyDatas.getColIdx().put(DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName(), size++);
        this.supplyDatas.getNotNullableColMap().put(DefaultField.SupplyField.MATERIAL.getName(), Long.class);
        this.supplyDatas.getNotNullableColMap().put(DefaultField.SupplyField.BILLID.getName(), Long.class);
        this.supplyDatas.getNotNullableColMap().put(DefaultField.SupplyField.QTY.getName(), BigDecimal.class);
        this.supplyDatas.getNotNullableColMap().put(DefaultField.SupplyField.SUPPLYORGUNIT.getName(), Long.class);
        this.supplyDatas.getNotNullableColMap().put(DefaultField.SupplyField.DATE.getName(), Long.class);
    }

    public List<FieldMapping> getPo2s() {
        return this.po2s;
    }

    private List<FieldMapping> checkPo2SRelation() {
        if (this.supplyModel.get("outtosupply") == null) {
            return new ArrayList<FieldMapping>();
        }
        DynamicObject outToSupply = this.supplyModel.getDynamicObject("outtosupply");
        outToSupply = BusinessDataServiceHelper.loadSingle((Object)outToSupply.get("id"), (String)"mrp_billfieldtransfer");
        DynamicObjectCollection relations = outToSupply.getDynamicObjectCollection("entryentity");
        return SupplyDataModel.buildModelRelation(relations, this.supplyFields, true);
    }

    public List<FieldMapping> getR2s() {
        return this.r2s;
    }

    public void loadSupplyMaterialExtProps() {
        final SupplymentDataTable supplyDatas = this.getTable();
        this.initMaterialPlanInfos();
        KDCloudMRPEnv.IMaterialPlanInfoApply applier = new KDCloudMRPEnv.IMaterialPlanInfoApply(){

            public HashMap<String, Object> toMap(Map<String, Object> info) {
                return SupplyDataModel.this.infoToMap(info);
            }

            @Override
            public void apply(HashMap<Integer, Map<String, Object>> colVals) {
                supplyDatas.applyColValues(colVals);
            }
        };
        this.loadMaterialPlanInfo(supplyDatas, DefaultField.SupplyField.MATERIAL.getName(), DefaultField.SupplyField.SUPPLYORGUNIT.getName(), DefaultField.SupplyField.TRACKNUMBER.getName(), applier);
    }

    public HashMap<String, Object> infoToMap(Map<String, Object> info) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(DefaultField.SupplyField.MATERIALATTR.getName(), MRPUtil.getInt(info, "materialattr"));
        Long operator = MRPUtil.getLong(info, "operator");
        ret.put(DefaultField.SupplyField.SUPPLYOPERATOR.getName(), operator);
        ret.put(DefaultField.SupplyField.SUPPLANTAG.getName(), MRPUtil.getLong(info, "plantags"));
        ret.put(DefaultField.SupplyField.POSTPROCESSTIME.getName(), MRPUtil.getInt(info, "postprocessingtime"));
        return ret;
    }

    public void loadSupplyMaterialExtProps(RowData rowData) {
        MtPlanInfoModel planInfo = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
        this.initMaterialPlanInfos();
        String materialId = String.valueOf(rowData.getValue(DefaultField.SupplyField.MATERIAL.getName()));
        String orgId = String.valueOf(rowData.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        Map<String, Object> info = planInfo.getMaterialPlanInfo(materialId, orgId, new HashMap<String, Object>(InvPlanUtil.getExtendValMap(this.env, rowData, 1)));
        if (info != null) {
            rowData.update(DefaultField.SupplyField.MATERIALATTR.getName(), (Object)MRPUtil.getInt(info, "materialattr"));
            rowData.update(DefaultField.SupplyField.SUPPLYOPERATOR.getName(), (Object)MRPUtil.getLong(info, "operator"));
            rowData.update(DefaultField.SupplyField.SUPPLANTAG.getName(), (Object)MRPUtil.getLong(info, "plantags"));
            rowData.update(DefaultField.SupplyField.POSTPROCESSTIME.getName(), (Object)MRPUtil.getInt(info, "postprocessingtime"));
            boolean[] param = this.getManustrategyParam(materialId, orgId);
            boolean isTrackMatch = param[0];
            boolean isInvIsolation = param[1];
            rowData.update(DefaultField.SupplyField.IS_TRACK_MATCH.getName(), (Object)isTrackMatch);
            if (MRPUtil.convert(rowData.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), 0) != 0) {
                rowData.update(DefaultField.SupplyField.INV_IS_TRACK_MATCH.getName(), (Object)isInvIsolation);
            } else {
                rowData.update(DefaultField.SupplyField.INV_IS_TRACK_MATCH.getName(), (Object)true);
            }
        }
    }
}

