/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArrayBasedHashMap<K, V>
implements Map<K, V> {
    private Map<K, Integer> indexes;
    private Object[] values;
    private boolean containsNullVal = false;

    @Override
    public int size() {
        return this.indexes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.indexes.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullVal;
        }
        for (Object val : this.values) {
            if (!value.equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.values == null) {
            return null;
        }
        Integer idx = this.indexes.get(key);
        if (idx == null) {
            return null;
        }
        return (V)this.values[idx];
    }

    @Override
    public V put(K key, V value) {
        Object old = this.values[this.indexes.get(key)];
        this.values[this.indexes.get(key).intValue()] = value;
        return (V)old;
    }

    @Override
    public V remove(Object key) {
        Integer idx = null;
        if (this.indexes != null) {
            idx = this.indexes.remove(key);
        }
        if (idx != null) {
            Object old = this.values[idx];
            this.values[idx.intValue()] = null;
            return (V)old;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new RuntimeException("unsupport method.");
    }

    @Override
    public void clear() {
        this.indexes = new HashMap<K, Integer>();
        this.values = new Object[0];
    }

    @Override
    public Set<K> keySet() {
        return this.indexes.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new RuntimeException("unsupport method.");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        WrapSet ret = new WrapSet();
        ret.innerSet = this.indexes.entrySet();
        return ret;
    }

    public static <K, V> Map<K, Integer> parseHeader(Map<K, V> map) {
        HashMap<K, Integer> header = new HashMap<K, Integer>(map.size());
        int idx = 0;
        for (Map.Entry<K, V> e : map.entrySet()) {
            header.put(e.getKey(), idx++);
        }
        return header;
    }

    public static <K, V> ArrayBasedHashMap<K, V> wrap(Map<K, Integer> indexes, Map<K, V> map) {
        if (map == null) {
            return null;
        }
        ArrayBasedHashMap<K, V> wrap = new ArrayBasedHashMap<K, V>();
        Object[] values = new Object[map.size()];
        for (Map.Entry<K, V> e : map.entrySet()) {
            values[indexes.get(e.getKey()).intValue()] = e.getValue();
            if (wrap.containsNullVal || e.getValue() != null) continue;
            wrap.containsNullVal = true;
        }
        wrap.indexes = indexes;
        wrap.values = values;
        return wrap;
    }

    private class WrapSet
    implements Set<Map.Entry<K, V>> {
        private Set<Map.Entry<K, Integer>> innerSet;

        private WrapSet() {
        }

        @Override
        public int size() {
            return this.innerSet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.innerSet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException("unsupport method.");
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<K, Integer>> iter;
                {
                    this.iter = WrapSet.this.innerSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    final Map.Entry next = this.iter.next();
                    Map.Entry ret = new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return next.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ArrayBasedHashMap.this.values[(Integer)next.getValue()];
                        }

                        @Override
                        public V setValue(V value) {
                            throw new RuntimeException("unsupport method.");
                        }
                    };
                    return ret;
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.innerSet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.innerSet.toArray(a);
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            throw new RuntimeException("unsupport method.");
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException("unsupport method.");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new RuntimeException("unsupport method.");
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new RuntimeException("unsupport method.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new RuntimeException("unsupport method.");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new RuntimeException("unsupport method.");
        }

        @Override
        public void clear() {
            this.innerSet = null;
        }
    }
}

