/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.struct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class CycleMergeStruct {
    private final Map<Long, List<Integer>> specialRequires = new HashMap<Long, List<Integer>>(2);
    private final Map<Long, List<Integer>> fixedRequires = new HashMap<Long, List<Integer>>(2);
    private final Map<Long, List<Integer>> dynamicRequires = new HashMap<Long, List<Integer>>(2);
    private final Map<Long, Map<Integer, List<RequireRowData>>> mpId2Requires = new HashMap<Long, Map<Integer, List<RequireRowData>>>(2);
    private final Map<Long, Map<Integer, Map<Integer, BigDecimal>>> mpId2SupplyRemainQty = new HashMap<Long, Map<Integer, Map<Integer, BigDecimal>>>(2);
    private final Map<Integer, Boolean> cache = new HashMap<Integer, Boolean>(2);

    public Map<Long, List<Integer>> getSpecialRequires() {
        return this.specialRequires;
    }

    public Map<Long, List<Integer>> getFixedRequires() {
        return this.fixedRequires;
    }

    public Map<Long, List<Integer>> getDynamicRequires() {
        return this.dynamicRequires;
    }

    public Map<Integer, List<RequireRowData>> getRequireByMpId(Long mpId) {
        return this.mpId2Requires.get(mpId);
    }

    public Map<Integer, Map<Integer, BigDecimal>> getSupplyRemainQtyByMpId(Long mpId) {
        return this.mpId2SupplyRemainQty.getOrDefault(mpId, new HashMap(0));
    }

    public void addRequireByMpId(IMRPEnvProvider ctx, Long mpId, RequireRowData requireRowData, Map<Integer, BigDecimal> supplyIdx2remainQty) {
        Map map = this.mpId2Requires.computeIfAbsent(mpId, k -> new LinkedHashMap(2));
        Map supplyRemainMap = this.mpId2SupplyRemainQty.computeIfAbsent(mpId, k -> new HashMap(2));
        boolean isAdd = false;
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            for (RequireRowData require : list) {
                if (!MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue()).equals(MRPUtil.convert(requireRowData.getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue())) || !DataBalanceUtil.isMatch(ctx, requireRowData, require, true, this.cache) || !DataBalanceUtil.isMatch(ctx, require, requireRowData, true, this.cache)) continue;
                isAdd = true;
                supplyRemainMap.put(entry.getKey(), supplyIdx2remainQty);
                break;
            }
            if (!isAdd) continue;
            list.add(requireRowData);
            break;
        }
        if (!isAdd) {
            ArrayList<RequireRowData> list = new ArrayList<RequireRowData>(2);
            list.add(requireRowData);
            map.put(requireRowData.getRowIdx(), list);
            supplyRemainMap.put(requireRowData.getRowIdx(), supplyIdx2remainQty);
        }
    }

    public void clear() {
        this.specialRequires.clear();
        this.fixedRequires.clear();
        this.dynamicRequires.clear();
    }
}

