/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.struct;

import java.io.Serializable;
import java.math.BigDecimal;

public class ReserveData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private BigDecimal reserveQty = BigDecimal.ZERO;
    private BigDecimal weakReserveQty = BigDecimal.ZERO;
    private BigDecimal origReserveQty = BigDecimal.ZERO;
    private BigDecimal origWeakReserveQty = BigDecimal.ZERO;
    private BigDecimal supplySurplusQty = null;

    public void init(BigDecimal reserveQty, BigDecimal weakReserveQty) {
        this.reserveQty = reserveQty;
        this.weakReserveQty = weakReserveQty;
        this.origReserveQty = reserveQty;
        this.origWeakReserveQty = weakReserveQty;
    }

    public BigDecimal getReserveQty() {
        return this.reserveQty;
    }

    public BigDecimal getWeakReserveQty() {
        return this.weakReserveQty;
    }

    public BigDecimal getAllQty() {
        return this.reserveQty.add(this.weakReserveQty);
    }

    public BigDecimal getOrigWeakReserveQty() {
        return this.origWeakReserveQty;
    }

    public BigDecimal getAllOrigQty() {
        return this.origReserveQty.add(this.origWeakReserveQty);
    }

    public BigDecimal getOrigReserveQty() {
        return this.origReserveQty;
    }

    public BigDecimal subReserveQty(BigDecimal qty) {
        if (this.reserveQty.compareTo(qty) >= 0) {
            this.reserveQty = this.reserveQty.subtract(qty);
        } else {
            qty = qty.subtract(this.reserveQty);
            this.reserveQty = BigDecimal.ZERO;
            this.weakReserveQty = this.weakReserveQty.subtract(qty);
        }
        BigDecimal allQty = this.getAllQty();
        if (allQty.compareTo(BigDecimal.ZERO) < 0) {
            this.reserveQty = BigDecimal.ZERO;
            this.weakReserveQty = BigDecimal.ZERO;
        }
        return allQty;
    }

    public void addReserveQty(BigDecimal qty, boolean isWeak) {
        if (isWeak) {
            this.weakReserveQty = this.weakReserveQty.add(qty);
            if (qty.compareTo(BigDecimal.ZERO) > 0) {
                this.origWeakReserveQty = this.origWeakReserveQty.add(qty);
            }
        } else {
            this.reserveQty = this.reserveQty.add(qty);
            if (qty.compareTo(BigDecimal.ZERO) > 0) {
                this.origReserveQty = this.origReserveQty.add(qty);
            }
        }
    }

    public void calculateSupplySurplusQty() {
        if (this.supplySurplusQty == null) {
            this.supplySurplusQty = this.getAllOrigQty().subtract(this.getAllQty());
        }
    }

    public BigDecimal getSupplySurplusQty() {
        if (this.supplySurplusQty == null) {
            this.calculateSupplySurplusQty();
        }
        return this.supplySurplusQty;
    }
}

